/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.extension.generate.code;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.palette.Invokable;
import oracle.ide.wizard.Wizard;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.TransactionDescriptor;
import oracle.jdeveloper.model.JProjectUtil;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdevimpl.wizard.extension.ExtensionArb;
import oracle.jdevimpl.wizard.extension.generate.code.AddinGenerator;
import oracle.jdevimpl.wizard.extension.generate.code.ContextMenuListenerGenerator;
import oracle.jdevimpl.wizard.extension.generate.code.ControllerGenerator;
import oracle.jdevimpl.wizard.extension.generate.code.ExtensionAddinGenerator;
import oracle.jdevimpl.wizard.extension.generate.code.ExtensionGenerator;
import oracle.jdevimpl.wizard.extension.generate.code.Generator;
import oracle.jdevimpl.wizard.extension.generate.code.GeneratorUtils;
import oracle.jdevimpl.wizard.extension.generate.code.WizardGenerator;
import oracle.jdevimpl.wizard.extension.model.Model;
import oracle.jdevimpl.wizard.extension.ui.code.TypeDecoder;

public final class ExtensionJavaGenerator
extends ExtensionGenerator {
    private static final String LIB_EXTENSION_SDK = "JDeveloper Extension SDK";
    private static final String LIB_ORACLE_JEWT = "Oracle JEWT";
    private static HashMap _generators = new HashMap();

    static {
        GeneratorUtils generatorUtils = new ExtensionAddinGenerator();
        generatorUtils = new AddinGenerator();
        ExtensionJavaGenerator.registerInterfaceGenerator(Addin.class.getName(), generatorUtils);
        generatorUtils = new ContextMenuListenerGenerator();
        ExtensionJavaGenerator.registerInterfaceGenerator(ContextMenuListener.class.getName(), generatorUtils);
        generatorUtils = new ControllerGenerator();
        ExtensionJavaGenerator.registerInterfaceGenerator(Controller.class.getName(), generatorUtils);
        generatorUtils = new WizardGenerator();
        ExtensionJavaGenerator.registerInterfaceGenerator(Wizard.class.getName(), generatorUtils);
        ExtensionJavaGenerator.registerInterfaceGenerator(Invokable.class.getName(), generatorUtils);
    }

    static void registerInterfaceGenerator(String string, Generator generator) {
        _generators.put(string, generator);
    }

    public final boolean generate() {
        Node node = this._createNode();
        if (node == null) {
            this._showError(0);
            return false;
        }
        if (node.isReadOnly()) {
            this._showError(1);
            return false;
        }
        if (!(node instanceof JavaSourceNode)) {
            this._showError(2);
            return false;
        }
        this._clearFile(node);
        this.addLibrariesToProject();
        this.createSource(node);
        if (node != null) {
            this.addResourcesToProject(node);
            this.addNodeToProject(node);
            this._openFileInEditor(node);
        }
        this.saveNode(node);
        return true;
    }

    protected boolean createSource(Node node) {
        JavaManager javaManager = JavaManager.getJavaManager(this.getProject());
        URL uRL = node.getURL();
        SourceFile sourceFile = null;
        try {
            sourceFile = node.isNew() ? javaManager.createSourceFile(uRL) : javaManager.getSourceFile(uRL);
        }
        catch (IOException iOException) {
            sourceFile = null;
        }
        if (sourceFile == null) {
            return false;
        }
        SourceTransaction sourceTransaction = sourceFile.beginTransaction();
        sourceFile.setPackageName(this.getModel().getPackageName());
        SourceFactory sourceFactory = sourceFile.getFactory();
        SourceClass sourceClass = sourceFactory.createClass(0, this.getModel().getClassName());
        sourceClass.setModifiers(1);
        sourceFile.getSourceClasses().add(sourceClass);
        SourceMethod sourceMethod = sourceFactory.createConstructor(null, null, sourceFactory.createBlock());
        sourceMethod.setModifiers(1);
        sourceClass.getSourceConstructors().add(sourceMethod);
        TypeDecoder typeDecoder = ((Model)this.getModel()).getTypeDecoder();
        if (typeDecoder.implementsAddin() && !this.implementExtension(javaManager, sourceFile, sourceClass)) {
            return false;
        }
        if (typeDecoder.implementsWizard() && !this.implementWizard(javaManager, sourceFile, sourceClass)) {
            return false;
        }
        if (typeDecoder.implementsController() && !this.implementController(javaManager, sourceFile, sourceClass)) {
            return false;
        }
        if (typeDecoder.implementsContextMenuListener() && !this.implementContextMenuListener(javaManager, sourceFile, sourceClass)) {
            return false;
        }
        javaManager.commitTransaction(sourceTransaction, new TransactionDescriptor("Generate"));
        return true;
    }

    private void saveNode(Node node) {
        try {
            node.save();
        }
        catch (IOException iOException) {
            MessageDialog.information((Component)Ide.getMainWindow(), (Object)ExtensionArb.format(195, node.getURL()), (String)ExtensionArb.getString(190), null);
        }
    }

    protected String getFileExtension() {
        return ".java";
    }

    protected Generator getGenerator(String string) {
        return (Generator)_generators.get(string);
    }

    private void addLibrariesToProject() {
        Object[] objectArray = new String[]{LIB_ORACLE_JEWT, LIB_EXTENSION_SDK};
        JProjectUtil.addLibraries(this.getProject(), objectArray);
    }

    private boolean implementExtension(JavaManager javaManager, SourceFile sourceFile, SourceClass sourceClass) {
        String string = Addin.class.getName();
        JavaClass javaClass = javaManager.getClass(string);
        return this.implementInterface(javaManager, sourceFile, sourceClass, javaClass);
    }

    private boolean implementWizard(JavaManager javaManager, SourceFile sourceFile, SourceClass sourceClass) {
        String string = Wizard.class.getName();
        JavaClass javaClass = javaManager.getClass(string);
        return this.implementInterface(javaManager, sourceFile, sourceClass, javaClass);
    }

    private boolean implementController(JavaManager javaManager, SourceFile sourceFile, SourceClass sourceClass) {
        String string = Controller.class.getName();
        JavaClass javaClass = javaManager.getClass(string);
        return this.implementInterface(javaManager, sourceFile, sourceClass, javaClass);
    }

    private boolean implementContextMenuListener(JavaManager javaManager, SourceFile sourceFile, SourceClass sourceClass) {
        String string = ContextMenuListener.class.getName();
        JavaClass javaClass = javaManager.getClass(string);
        return this.implementInterface(javaManager, sourceFile, sourceClass, javaClass);
    }

    private void addResourcesToProject(Node node) {
        URL uRL = node.getURL();
        URL uRL2 = URLFileSystem.getParent((URL)uRL);
        Model model = (Model)this.getModel();
        if (model.isInvokeFromGallery()) {
            this.createImageNode(uRL2, model.getWizardIcon());
        }
        if (model.isInvokeFromMainMenu() || model.isInvokeFromContextMenu() || model.isInvokeFromToolbar()) {
            this.createImageNode(uRL2, model.getMainMenuIcon());
        }
    }
}

