/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.extension.generate.manifest;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.ide.extension.Extension;
import oracle.ide.ExtensionRegistry;
import oracle.javatools.marshal.xml.PropertyInfo;
import oracle.javatools.marshal.xml.PropertyInfoFactory;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.wizard.extension.generate.manifest.ImportElement;
import oracle.jdevimpl.wizard.extension.model.Model;

public class DependenciesElement
implements Copyable {
    private static Pattern pattern = Pattern.compile("\\p{Punct}");
    private List _imports;

    public void populate(Model model) {
        this.populateImpl(model);
    }

    public ImportElement[] getImport() {
        ImportElement[] importElementArray = new ImportElement[this._imports.size()];
        importElementArray = this._imports.toArray(importElementArray);
        return importElementArray;
    }

    public void setImport(ImportElement[] importElementArray) {
        this._imports = new ArrayList(importElementArray.length);
        int n = 0;
        while (n < importElementArray.length) {
            this._imports.add(importElementArray[n]);
            ++n;
        }
    }

    public Object copyTo(Object object) {
        DependenciesElement dependenciesElement = object != null ? (DependenciesElement)object : new DependenciesElement();
        this.copyToImpl(dependenciesElement);
        return dependenciesElement;
    }

    protected final void copyToImpl(DependenciesElement dependenciesElement) {
        if (this._imports != null) {
            ImportElement[] importElementArray = new ImportElement[this._imports.size()];
            this._imports.toArray(importElementArray);
            dependenciesElement.setImport(importElementArray);
        } else {
            dependenciesElement.setImport(null);
        }
    }

    private void populateImpl(Model model) {
        if (this._imports == null) {
            this._imports = new ArrayList();
            ImportElement importElement = new ImportElement();
            this._imports.add(importElement);
            Extension extension = this.getJDeveloperExtension();
            if (extension != null) {
                String string;
                String[] stringArray = pattern.split(extension.getVersion().toString());
                if (stringArray.length > 3) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append(stringArray[0]);
                    stringBuffer.append('.');
                    stringBuffer.append(stringArray[1]);
                    stringBuffer.append('.');
                    stringBuffer.append(stringArray[2]);
                    string = stringBuffer.toString();
                } else {
                    string = extension.getVersion().toString();
                }
                importElement.assignExtension(extension.getID(), string);
            }
        }
    }

    private Extension getJDeveloperExtension() {
        return ExtensionRegistry.getExtensionRegistry().findExtension("oracle.jdeveloper");
    }

    public static PropertyInfo[] getPropertyInfos() {
        PropertyInfoFactory propertyInfoFactory = new PropertyInfoFactory(DependenciesElement.class);
        return new PropertyInfo[]{propertyInfoFactory.newElem("ex:import", "Import")};
    }
}

