/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.extension.generate.manifest;

import java.util.Arrays;
import oracle.ide.util.ModelUtil;
import oracle.javatools.marshal.xml.PropertyInfo;
import oracle.javatools.marshal.xml.PropertyInfoFactory;
import oracle.javatools.util.Copyable;
import oracle.jdevimpl.wizard.extension.model.Model;
import oracle.jdevimpl.wizard.extension.ui.code.GalleryTechnology;

public class GalleryItemElement
implements Copyable {
    private String _name;
    private String _technology;
    private String _description;
    private String _help;
    private String _category;
    private String _folder;
    private String[] _parameters;
    private String _resClass;

    public void populate(Model model) {
        this.populateImpl(model);
    }

    public Object copyTo(Object object) {
        GalleryItemElement galleryItemElement = object != null ? (GalleryItemElement)object : new GalleryItemElement();
        this.copyToImpl(galleryItemElement);
        return galleryItemElement;
    }

    protected final void copyToImpl(GalleryItemElement galleryItemElement) {
        galleryItemElement._name = this._name;
        galleryItemElement._technology = this._technology;
        galleryItemElement._description = this._description;
        galleryItemElement._help = this._help;
        galleryItemElement._category = this._category;
        galleryItemElement._folder = this._folder;
        galleryItemElement._resClass = this._resClass;
        if (this._parameters != null) {
            System.arraycopy(galleryItemElement._parameters, 0, this._parameters, 0, this._parameters.length);
        } else {
            this._parameters = null;
        }
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((GalleryItemElement)object);
    }

    protected final boolean equalsImpl(GalleryItemElement galleryItemElement) {
        return ModelUtil.areEqual((Object)galleryItemElement._name, (Object)this._name) && ModelUtil.areEqual((Object)galleryItemElement._technology, (Object)this._technology) && ModelUtil.areEqual((Object)galleryItemElement._description, (Object)this._description) && ModelUtil.areEqual((Object)galleryItemElement._help, (Object)this._help) && ModelUtil.areEqual((Object)galleryItemElement._category, (Object)this._category) && ModelUtil.areEqual((Object)galleryItemElement._folder, (Object)this._folder) && ModelUtil.areEqual((Object)galleryItemElement._resClass, (Object)this._resClass) && Arrays.equals(this._parameters, galleryItemElement._parameters);
    }

    public static PropertyInfo[] getPropertyInfos() {
        PropertyInfoFactory propertyInfoFactory = new PropertyInfoFactory(GalleryItemElement.class);
        return new PropertyInfo[]{propertyInfoFactory.newElem("name", "Name"), propertyInfoFactory.newElem("resClass", "ResClass"), propertyInfoFactory.newElem("description", "Description"), propertyInfoFactory.newElem("help", "Help"), propertyInfoFactory.newElem("category", "Category"), propertyInfoFactory.newElem("folder", "Folder"), propertyInfoFactory.newElem("parameter", "Parameters"), propertyInfoFactory.newElem("technologyKey", "Technology")};
    }

    public void setName(String string) {
        this._name = string;
    }

    public String getName() {
        return this._name;
    }

    public void setDescription(String string) {
        this._description = string;
    }

    public String getDescription() {
        return this._description;
    }

    public void setHelp(String string) {
        this._help = string;
    }

    public String getHelp() {
        return this._help;
    }

    public void setCategory(String string) {
        this._category = string;
    }

    public String getCategory() {
        return this._category;
    }

    public void setFolder(String string) {
        this._folder = string;
    }

    public String getFolder() {
        return this._folder;
    }

    public void setParameters(String[] stringArray) {
        this._parameters = stringArray;
    }

    public String[] getParameters() {
        return this._parameters;
    }

    public void setTechnology(String string) {
        this._technology = string;
    }

    public String getTechnology() {
        return this._technology;
    }

    public void setResClass(String string) {
        this._resClass = string;
    }

    public String getResClass() {
        return this._resClass;
    }

    private void populateImpl(Model model) {
        this.setName(model.getQualifiedClassName());
        this.setTechnology(this.getTechnologyScope(model));
        this.setCategory(model.getGalleryCategoryName());
        this.setFolder(model.getGalleryFolderName());
        this.setDescription(model.getGalleryDescription());
    }

    private String getTechnologyScope(Model model) {
        GalleryTechnology galleryTechnology = model.getGalleryTechnology();
        if (galleryTechnology == null || galleryTechnology.getTechnology() == null) {
            return null;
        }
        return galleryTechnology.getTechnology().getKey();
    }
}

