/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.extension.model;

import java.net.URL;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Project;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.Pair;
import oracle.jdeveloper.model.JProjectUtil;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdevimpl.wizard.extension.ExtensionArb;
import oracle.jdevimpl.wizard.extension.ExtensionUtil;
import oracle.jdevimpl.wizard.extension.model.ContextMenuModel;
import oracle.jdevimpl.wizard.extension.model.ModelInfo;
import oracle.jdevimpl.wizard.extension.ui.code.ExtensionWizardUtils;
import oracle.jdevimpl.wizard.extension.ui.code.GalleryTechnology;
import oracle.jdevimpl.wizard.extension.ui.code.TypeDecoder;

public final class Model
implements ModelInfo {
    static final int ENABLED_ON_ALWAYS = 0;
    static final int ENABLED_ON_FILE_NODE = 1;
    static final int ENABLED_ON_JAVA_NODE = 2;
    static final int ENABLED_ON_JPR_NODE = 3;
    public static final int INVOCATION_NOACTION = 0;
    public static final int INVOCATION_LOGMESSAGE = 1;
    public static final int INVOCATION_DISPLAYMESSAGE = 2;
    public static final int INVOCATION_INVOKECOMMAND = 3;
    private Context _context;
    private Project _prj;
    private String _packageName;
    private String _className;
    private boolean _invokeFromGallery;
    private boolean _invokeFromMainMenu;
    private boolean _invokeFromContextMenu;
    private boolean _invokeFromToolbar;
    private GalleryTechnology _galleryTechnology;
    private int _galleryCategoryIndex;
    private int _galleryFolderIndex;
    private String _galleryDescription;
    private URL _wizardIcon;
    private int _mainMenuIndex;
    private String _mainMenuTitle;
    private URL _mainMenuIcon;
    private Character _menuMnemonic;
    private String _toolbarTipText;
    private String _mainMenuTitleNoMnemonic;
    private List _contextMenuIndexes;
    private int _invocationActionIndex;
    private List _enabledClass;
    private String _extensionName;
    private String _extensionId;
    private String _extensionVersion;
    private String _extensionOwner;

    void $init$() {
        this._invocationActionIndex = 0;
    }

    public Model() {
        this.$init$();
    }

    private String getDefaultClassName() {
        String string = "MyAddin";
        return this.getDefaultClassName(string);
    }

    public TypeDecoder getTypeDecoder() {
        return new TypeDecoder(this._invokeFromGallery, this._invokeFromMainMenu, this._invokeFromContextMenu, this._invokeFromToolbar);
    }

    public Context getContext() {
        return this._context;
    }

    public String getClassName() {
        if (this._className == null) {
            this._className = this.getDefaultClassName();
        }
        return this._className;
    }

    public void setClassName(String string) {
        this._className = string;
    }

    public String getExtensionName() {
        if (this._extensionName == null) {
            this._extensionName = ExtensionArb.getString(37);
        }
        return this._extensionName;
    }

    public void setExtensionName(String string) {
        this._extensionName = string;
    }

    public String getExtensionId() {
        if (this._extensionId == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(ExtensionArb.getString(38));
            stringBuffer.append('.');
            stringBuffer.append(ExtensionArb.getString(37));
            this._extensionId = stringBuffer.toString();
        }
        return this._extensionId;
    }

    public void setExtensionId(String string) {
        this._extensionId = string;
    }

    public String getExtensionVersion() {
        if (this._extensionVersion == null) {
            this._extensionVersion = "10.1.3";
        }
        return this._extensionVersion;
    }

    public void setExtensionVersion(String string) {
        this._extensionVersion = string;
    }

    public String getExtensionOwner() {
        if (this._extensionOwner == null) {
            this._extensionOwner = ExtensionArb.getString(38);
        }
        return this._extensionOwner;
    }

    public void setExtensionOwner(String string) {
        this._extensionOwner = string;
    }

    public void setGalleryTechnology(GalleryTechnology galleryTechnology) {
        this._galleryTechnology = galleryTechnology;
    }

    public GalleryTechnology getGalleryTechnology() {
        return this._galleryTechnology;
    }

    int getGalleryCategoryIndex() {
        return this._galleryCategoryIndex;
    }

    public String getGalleryCategoryName() {
        return ExtensionWizardUtils.getGalleryCategoryNames()[this._galleryCategoryIndex];
    }

    public void setGalleryCategoryIndex(int n) {
        this._galleryCategoryIndex = n;
    }

    int getGalleryFolderIndex() {
        return this._galleryFolderIndex;
    }

    public String getGalleryFolderName() {
        String string = this.getGalleryCategoryName();
        return ExtensionWizardUtils.getGalleryPageNames(string)[this._galleryFolderIndex];
    }

    public void setGalleryFolderIndex(int n) {
        this._galleryFolderIndex = n;
    }

    public URL getWizardIcon() {
        if (this._wizardIcon == null) {
            this._wizardIcon = ExtensionUtil.getDefaultGalleryIcon();
        }
        return this._wizardIcon;
    }

    public void setWizardIcon(URL uRL) {
        this._wizardIcon = uRL;
    }

    public Iterator getEnabledClass() {
        if (this._enabledClass != null) {
            return this._enabledClass.iterator();
        }
        return null;
    }

    public void setEnabledClass(List list) {
        this._enabledClass = list;
    }

    public String getPackageName() {
        if (this._packageName == null) {
            this._packageName = this.getDefaultPackageName();
        }
        return this._packageName;
    }

    public void setPackageName(String string) {
        this._packageName = string;
    }

    public void setContext(Context context) {
        this._context = context;
        this._prj = this._context.getProject();
    }

    public boolean isInvokeFromContextMenu() {
        return this._invokeFromContextMenu;
    }

    public void setInvokeFromContextMenu(boolean bl) {
        this._invokeFromContextMenu = bl;
    }

    public boolean isInvokeFromMainMenu() {
        return this._invokeFromMainMenu;
    }

    public void setInvokeFromMainMenu(boolean bl) {
        this._invokeFromMainMenu = bl;
    }

    public boolean isInvokeFromGallery() {
        return this._invokeFromGallery;
    }

    public void setInvokeFromGallery(boolean bl) {
        this._invokeFromGallery = bl;
    }

    public String getGalleryDescription() {
        return this._galleryDescription;
    }

    public void setGalleryDescription(String string) {
        this._galleryDescription = string;
    }

    public int getContextMenuIndex(String string) {
        Pair[] pairArray = ExtensionWizardUtils.getContextMenus();
        int n = 0;
        while (n < pairArray.length) {
            if (pairArray[n].getFirst().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public List getContextMenuIndexes() {
        return this._contextMenuIndexes;
    }

    public void setContextMenuIndexes(List list) {
        this._contextMenuIndexes = list;
    }

    public Character getMnemonicChar() {
        return this._menuMnemonic;
    }

    public int getMainMenuIndex() {
        return this._mainMenuIndex;
    }

    public void setMainMenuIndex(int n) {
        this._mainMenuIndex = n;
    }

    public String getMainMenuTitle() {
        if (this._mainMenuTitle == null) {
            this._mainMenuTitle = ExtensionArb.format(85, this.getClassName());
        }
        return this._mainMenuTitle;
    }

    public void setMainMenuTitle(String string) {
        this._mainMenuTitle = string;
        this._mainMenuTitleNoMnemonic = this.stripMnemonicSymbol(string);
        this._menuMnemonic = this.getMnemonicCharacter(string);
    }

    public String getMainMenuNoMnemonic() {
        return this._mainMenuTitleNoMnemonic;
    }

    public URL getMainMenuIcon() {
        if (this._mainMenuIcon == null) {
            this._mainMenuIcon = ExtensionUtil.getDefaultMenuIcon();
        }
        return this._mainMenuIcon;
    }

    public void setMainMenuIcon(URL uRL) {
        this._mainMenuIcon = uRL;
    }

    public String getSelectedMainMenuName() {
        Pair[] pairArray = ExtensionWizardUtils.getMainMenus();
        return (String)pairArray[this.getMainMenuIndex()].getFirst();
    }

    public String getSelectedMainMenuCodeName() {
        Pair[] pairArray = ExtensionWizardUtils.getMainMenus();
        return (String)pairArray[this.getMainMenuIndex()].getSecond();
    }

    public String getSelectedMainMenuCodeSectionName() {
        Pair[] pairArray = ExtensionWizardUtils.getMainMenuSections();
        return (String)pairArray[this.getMainMenuIndex()].getSecond();
    }

    private static final void dummyCodeOnly() {
    }

    public String getSelectedContextMenuName(ContextMenuModel contextMenuModel) {
        return contextMenuModel.getLocation();
    }

    public String getSelectedContextMenuListenerName(String string) {
        Pair[] pairArray = ExtensionWizardUtils.getContextMenus();
        return (String)pairArray[this.getContextMenuIndex(string)].getSecond();
    }

    public String getSelectedContextMenuImport(String string) {
        Pair[] pairArray = ExtensionWizardUtils.getContextMenuImports();
        return (String)pairArray[this.getContextMenuIndex(string)].getSecond();
    }

    public int getInvocationActionIndex() {
        return this._invocationActionIndex;
    }

    public void setInvocationActionIndex(int n) {
        this._invocationActionIndex = n;
    }

    public void setToolbarTipText(String string) {
        this._toolbarTipText = string;
    }

    public String getToolbarTipText() {
        if (this._toolbarTipText == null) {
            this._toolbarTipText = ExtensionArb.format(9, this.getClassName());
        }
        return this._toolbarTipText;
    }

    public boolean isInvokeFromToolbar() {
        return this._invokeFromToolbar;
    }

    public void setInvokeFromToolbar(boolean bl) {
        this._invokeFromToolbar = bl;
    }

    public String getCommandId() {
        return "MYCOMMAND_ID";
    }

    public String getQualifiedCommandId() {
        StringBuffer stringBuffer = new StringBuffer(this.getQualifiedClassName());
        stringBuffer.append('.');
        stringBuffer.append(this.getCommandId());
        return stringBuffer.toString();
    }

    public String getQualifiedClassName() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getPackageName() != null && this.getPackageName().length() > 0) {
            stringBuffer.append(this.getPackageName());
            stringBuffer.append('.');
        }
        stringBuffer.append(this.getClassName());
        return stringBuffer.toString();
    }

    private String getDefaultClassName(String string) {
        String string2 = JavaProject.getInstance(this._prj).getDefaultPackage();
        String string3 = string2 != null ? string2.replace('.', '/') : "";
        URL uRL = JProjectUtil.getProjectBasePath(this._prj);
        URL uRL2 = URLFactory.newDirURL((URL)uRL, (String)string3);
        DefaultNameGenerator defaultNameGenerator = new DefaultNameGenerator(string, ".java", 1);
        URL uRL3 = URLFactory.newUniqueURL((URL)uRL2, (NameGenerator)defaultNameGenerator);
        String string4 = URLFileSystem.getFileName((URL)uRL3);
        return string4.substring(0, string4.indexOf(46));
    }

    private String stripMnemonicSymbol(String string) {
        int n = string.indexOf(38);
        if (n >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.deleteCharAt(n);
            return stringBuffer.toString();
        }
        return string;
    }

    private Character getMnemonicCharacter(String string) {
        int n = string.indexOf(38);
        if (n >= 0 && n < string.length()) {
            return new Character(string.charAt(n + 1));
        }
        return null;
    }

    private String getDefaultPackageName() {
        if (this._prj != null) {
            return JavaProject.getInstance(this._prj).getDefaultPackage();
        }
        return "";
    }

    public class ContextMenuImpl
    implements ContextMenuModel {
        private String _menuLocation;
        private String _label;
        private String _icon;

        ContextMenuImpl(String string, String string2, String string3) {
            this._menuLocation = string;
            this._label = string2;
            this._icon = string3;
        }

        public String getLocation() {
            return this._menuLocation;
        }

        public String getLabel() {
            return this._label;
        }

        public String getIcon() {
            return this._icon;
        }
    }
}

