/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.extension.ui.code;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.Context;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;
import oracle.jdevimpl.wizard.extension.ExtensionArb;
import oracle.jdevimpl.wizard.extension.ExtensionUtil;
import oracle.jdevimpl.wizard.extension.ExtensionValidation;
import oracle.jdevimpl.wizard.extension.model.Model;
import oracle.jdevimpl.wizard.extension.ui.code.ExtensionWizardUtils;

public class DisplayPanel
extends DefaultTraversablePanel {
    private JLabel _lblChooseMenu;
    private JComboBox _cmbChooseMenu;
    private JLabel _lblMenuLabel;
    private JTextField _fldMenuLabel;
    private JLabel _lblMenuIcon;
    private JTextField _fldMenuIcon;
    private JButton _btnBrowse;
    private JButton _btnDefault;
    private ActionListener _browseListener;
    private GridBagLayout _layout;
    private JMultiLineLabel _hintText;
    private JLabel _lblToolTip;
    private JTextField _fldToolTip;
    private JLabel _lblMenuLocations;
    private JCheckBox[] _checkContextMenu;
    private boolean _menuModified;
    private boolean _toolTipModified;
    private boolean _contextMenuModified;

    void $init$() {
        this._lblChooseMenu = new JLabel();
        this._cmbChooseMenu = new JComboBox();
        this._lblMenuLabel = new JLabel();
        this._fldMenuLabel = new JTextField();
        this._lblMenuIcon = new JLabel();
        this._fldMenuIcon = new FileField();
        this._btnBrowse = new JButton();
        this._btnDefault = new JButton();
        this._browseListener = null;
        this._layout = new GridBagLayout();
        this._hintText = new JMultiLineLabel();
        this._lblToolTip = new JLabel();
        this._fldToolTip = new JTextField();
        this._lblMenuLocations = new JLabel();
        this._checkContextMenu = new JCheckBox[ExtensionWizardUtils.getContextMenuNames().size()];
        this._toolTipModified = false;
        this._contextMenuModified = false;
    }

    public DisplayPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        boolean bl = traversableContext.getDirection() == 2;
        Model model = (Model)traversableContext.find("ExtensionWizardDataModel");
        URL uRL = URLFactory.newURL((String)this._getMenuIconName());
        if (this._isValidMenuLabel(this._getMenuLabel()) && ExtensionValidation.fileExist((Component)((Object)this), uRL)) {
            model.setMainMenuIcon(uRL);
            model.setMainMenuIndex(this._getSelectedMenuIndex());
            model.setMainMenuTitle(this._getMenuLabel());
        } else if (!bl) {
            throw new TraversalException(null);
        }
        this._btnBrowse.removeActionListener(this._browseListener);
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this._checkContextMenu.length) {
            if (this._checkContextMenu[n].isSelected()) {
                arrayList.add(this._checkContextMenu[n].getText());
            }
            ++n;
        }
        model.setContextMenuIndexes(arrayList);
        traversableContext.getWizardCallbacks().wizardSetInitialFocus(this.getInitialFocus());
    }

    public void onEntry(TraversableContext traversableContext) {
        Model model = (Model)traversableContext.find("ExtensionWizardDataModel");
        if (!(model.isInvokeFromMainMenu() || model.isInvokeFromContextMenu() || model.isInvokeFromToolbar())) {
            traversableContext.getWizardCallbacks().wizardSkipCurrentStep();
        }
        Context context = (Context)traversableContext.find("Context");
        DisplayPanel displayPanel = this;
        if (traversableContext.getDirection() == 1) {
            if (!this.isMenuModified()) {
                this._fldMenuLabel.setText(model.getMainMenuTitle());
                this.setMenuModified(false);
            }
            if (!this.isToolTipModified()) {
                this._fldToolTip.setText(model.getToolbarTipText());
                this.setToolTipModified(false);
            }
            if (this._fldMenuIcon.getText().length() == 0) {
                this.setDefaultIcon();
            }
        }
        this._browseListener = new 2(this, context, (JComponent)((Object)displayPanel));
        this._btnBrowse.addActionListener(this._browseListener);
        traversableContext.getWizardCallbacks().wizardSetInitialFocus(this.getInitialFocus());
    }

    private void jbInit() throws Exception {
        String string = ExtensionArb.getString(83);
        this.assignText();
        String string2 = null;
        DefaultComboBoxModel<Object> defaultComboBoxModel = null;
        defaultComboBoxModel = new DefaultComboBoxModel<Object>(ExtensionWizardUtils.getMainMenuNames().toArray());
        string2 = ExtensionArb.getString(84);
        this.setDefaultTitle(string2);
        this._cmbChooseMenu.setModel(defaultComboBoxModel);
        this.setLayout(this._layout);
        this.componentLayout();
        this._btnDefault.addActionListener(new 1());
    }

    private void setDefaultIcon() {
        URL uRL = ExtensionUtil.getDefaultMenuIcon();
        if (uRL.getProtocol().equals("file")) {
            this._fldMenuIcon.setText(URLFileSystem.getPlatformPathName((URL)uRL));
        } else {
            this._fldMenuIcon.setText(uRL.toString());
        }
    }

    private void assignText() {
        ResourceUtils.resLabel((JLabel)this._lblChooseMenu, (Component)this._cmbChooseMenu, (String)ExtensionArb.getString(76));
        ResourceUtils.resLabel((JLabel)this._lblMenuLabel, (Component)this._fldMenuLabel, (String)ExtensionArb.getString(77));
        ResourceUtils.resLabel((JLabel)this._lblMenuIcon, (Component)this._fldMenuIcon, (String)ExtensionArb.getString(78));
        ResourceUtils.resButton((AbstractButton)this._btnBrowse, (String)ExtensionArb.getString(79));
        ResourceUtils.resButton((AbstractButton)this._btnDefault, (String)ExtensionArb.getString(80));
        ResourceUtils.resLabel((JLabel)this._lblToolTip, (Component)this._fldToolTip, (String)ExtensionArb.getString(81));
        ResourceUtils.resLabel((JLabel)this._lblMenuLocations, (Component)this._checkContextMenu[0], (String)ExtensionArb.getString(82));
        List list = ExtensionWizardUtils.getContextMenuNames();
        Collections.sort(list);
        String[] stringArray = ExtensionWizardUtils.getDefaultContextMenus();
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            arrayList.add(stringArray[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            String string = (String)list.get(n2);
            this._checkContextMenu[n2] = new JCheckBox();
            this._checkContextMenu[n2].setText(string);
            this._checkContextMenu[n2].setMnemonic(ExtensionWizardUtils.getContextMenuMnemonic(string).charAt(0));
            if (arrayList.contains((String)list.get(n2))) {
                this._checkContextMenu[n2].setSelected(true);
            }
            ++n2;
        }
        this._hintText.setText(ExtensionArb.getString(75));
    }

    private void componentLayout() {
        this.add((Component)this._hintText, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this._lblChooseMenu, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this._cmbChooseMenu, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this._lblMenuLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this._fldMenuLabel, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this._lblMenuIcon, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this._fldMenuIcon, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this._btnBrowse, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 12, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this._btnDefault, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this._lblMenuLocations, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        int n = 0;
        while (n < this._checkContextMenu.length) {
            this.add(this._checkContextMenu[n], new GridBagConstraints(1, 5 + n, 2, 1, 1.0, 0.0, 17, 2, new Insets(3, 5, 3, 5), 0, 0));
            ++n;
        }
        this.add(this._lblToolTip, new GridBagConstraints(0, 6 + n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this._fldToolTip, new GridBagConstraints(1, 6 + n, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(1, 7 + n, 2, 1, 1.0, 1.0, 17, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private int _getSelectedMenuIndex() {
        return this._cmbChooseMenu.getSelectedIndex();
    }

    private String _getSelectedMenuName() {
        return this._cmbChooseMenu.getSelectedItem().toString();
    }

    private String _getMenuIconName() {
        return this._fldMenuIcon.getText().trim();
    }

    private String _getMenuLabel() {
        return this._fldMenuLabel.getText().trim();
    }

    private final boolean _isValidMenuLabel(String string) {
        if (!ModelUtil.hasLength((String)string)) {
            MessageDialog.error((Component)((Object)this), (Object)ExtensionArb.getString(88), (String)ExtensionArb.getString(87), null);
            return false;
        }
        return true;
    }

    private void setMenuModified(boolean bl) {
        this._menuModified = bl;
    }

    private boolean isMenuModified() {
        return this._menuModified;
    }

    private void setToolTipModified(boolean bl) {
        this._toolTipModified = bl;
    }

    private String getToolbarTipText() {
        return this._fldToolTip.getText();
    }

    private boolean isToolTipModified() {
        return this._toolTipModified;
    }

    private void setContextMenuModified(boolean bl) {
        this._contextMenuModified = bl;
    }

    private boolean isContextMenuModified() {
        return this._contextMenuModified;
    }

    private Component getInitialFocus() {
        return this._cmbChooseMenu;
    }

    static String mav$_getMenuIconName(DisplayPanel displayPanel) {
        return displayPanel._getMenuIconName();
    }

    static JTextField ra$_fldMenuIcon(DisplayPanel displayPanel) {
        return displayPanel._fldMenuIcon;
    }

    static void mav$setDefaultIcon(DisplayPanel displayPanel) {
        displayPanel.setDefaultIcon();
    }

    public final class 2
    implements ActionListener {
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ JComponent v$parent;
        final /* synthetic */ DisplayPanel this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ExtensionWizardUtils.browseForIconName(this.v$context, this.v$parent, DisplayPanel.mav$_getMenuIconName(this.this$0));
            if (string != null) {
                DisplayPanel.ra$_fldMenuIcon(this.this$0).setText(string);
            }
        }

        public 2(DisplayPanel displayPanel, Context context, JComponent jComponent) {
            this.v$parent = jComponent;
            this.v$context = context;
            this.this$0 = displayPanel;
        }
    }

    public final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            DisplayPanel.mav$setDefaultIcon(DisplayPanel.this);
        }
    }
}

