/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.extension.ui.code;

import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.config.DocumentExtensions;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.gallery.GalleryFolder;
import oracle.ide.gallery.GalleryManager;
import oracle.ide.model.ImageNode;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Pair;
import oracle.jdevimpl.wizard.extension.ExtensionArb;
import oracle.jdevimpl.wizard.extension.ui.code.GalleryTechnology;

public final class ExtensionWizardUtils {
    private static String ORACLE_IDE = "oracle.ide";
    private static String ORACLE_JDEVELOPER = "oracle.jdeveloper";
    private static final Pair[] _mainMenus = new Pair[]{new Pair((Object)ExtensionArb.getString(139), (Object)"IdeMainWindow.MENU_FILE"), new Pair((Object)ExtensionArb.getString(140), (Object)"IdeMainWindow.MENU_EDIT"), new Pair((Object)ExtensionArb.getString(141), (Object)"IdeMainWindow.MENU_VIEW"), new Pair((Object)ExtensionArb.getString(142), (Object)"IdeMainWindow.MENU_SEARCH"), new Pair((Object)ExtensionArb.getString(143), (Object)"IdeMainWindow.MENU_NAVIGATE"), new Pair((Object)ExtensionArb.getString(144), (Object)"IdeMainWindow.MENU_RUN"), new Pair((Object)ExtensionArb.getString(145), (Object)"IdeMainWindow.MENU_TOOLS"), new Pair((Object)ExtensionArb.getString(146), (Object)"IdeMainWindow.MENU_HELP")};
    private static final Pair[] _mainSections = new Pair[]{new Pair((Object)ExtensionArb.getString(139), (Object)"MenuConstants.SECTION_FILE_ADDINS"), new Pair((Object)ExtensionArb.getString(140), (Object)"MenuConstants.SECTION_EDIT_ADDINS"), new Pair((Object)ExtensionArb.getString(141), (Object)"MenuConstants.SECTION_VIEW_ADDINS"), new Pair((Object)ExtensionArb.getString(142), (Object)"MenuConstants.SECTION_SEARCH_ADDINS"), new Pair((Object)ExtensionArb.getString(143), (Object)"MenuConstants.SECTION_NAVIGATE_ADDINS"), new Pair((Object)ExtensionArb.getString(144), (Object)"MenuConstants.SECTION_RUN_ADDINS"), new Pair((Object)ExtensionArb.getString(145), (Object)"MenuConstants.SECTION_TOOLS_ADDINS"), new Pair((Object)ExtensionArb.getString(146), (Object)"MenuConstants.SECTION_HELP_ADDINS")};
    private static final Pair[] _contextMenus = new Pair[]{new Pair((Object)ExtensionArb.getString(147), (Object)"NavigatorManager.getWorkspaceNavigatorManager().getContextMenu()"), new Pair((Object)ExtensionArb.getString(149), (Object)"EditorManager.getEditorManager().getContextMenu()"), new Pair((Object)ExtensionArb.getString(151), (Object)"ExplorerManager.getExplorerManager().getContextMenu()"), new Pair((Object)ExtensionArb.getString(153), (Object)"PaletteManager.getPaletteManager().getPaletteWindow().getContextMenu()")};
    private static final Pair[] _contextMenuImports = new Pair[]{new Pair((Object)ExtensionArb.getString(147), (Object)"oracle.ide.navigator.NavigatorManager"), new Pair((Object)ExtensionArb.getString(149), (Object)"oracle.ide.editor.EditorManager"), new Pair((Object)ExtensionArb.getString(151), (Object)"oracle.ide.explorer.ExplorerManager"), new Pair((Object)ExtensionArb.getString(153), (Object)"oracle.ide.palette.PaletteManager")};
    private static final Pair[] _contextMenuMnemonic = new Pair[]{new Pair((Object)ExtensionArb.getString(147), (Object)ExtensionArb.getString(148)), new Pair((Object)ExtensionArb.getString(149), (Object)ExtensionArb.getString(150)), new Pair((Object)ExtensionArb.getString(151), (Object)ExtensionArb.getString(152)), new Pair((Object)ExtensionArb.getString(153), (Object)ExtensionArb.getString(154))};
    private static final String[] _invocationActionStrings = new String[]{ExtensionArb.getString(155), ExtensionArb.getString(156), ExtensionArb.getString(157), ExtensionArb.getString(158)};
    private static final String[] _defaultContextMenus = new String[]{ExtensionArb.getString(147), ExtensionArb.getString(149)};
    public static final String WORKSPACE_NAVIGATOR_CONTEXTMENU = "NavigatorManager.getWorkspaceNavigatorManager()";
    public static final String APPLICATION_NAVIGATOR_CONTEXTMENU = "NavigatorManager.getApplicationNavigatorManager()";

    private ExtensionWizardUtils() {
    }

    public static Object[] getGalleryTechnologies() {
        TechnologyRegistry technologyRegistry = TechnologyRegistry.getInstance();
        TechId[] techIdArray = technologyRegistry.getVisibleTechIds();
        ArrayList<GalleryTechnology> arrayList = new ArrayList<GalleryTechnology>(techIdArray.length);
        GalleryTechnology galleryTechnology = new GalleryTechnology();
        galleryTechnology.setName(ExtensionArb.getString(71));
        arrayList.add(galleryTechnology);
        int n = 0;
        while (n < techIdArray.length) {
            galleryTechnology = new GalleryTechnology();
            galleryTechnology.setTechnology(techIdArray[n]);
            arrayList.add(galleryTechnology);
            ++n;
        }
        Collections.sort(arrayList);
        return arrayList.toArray(new Object[0]);
    }

    public static Collection getFileTypes() {
        DocumentExtensions documentExtensions = (DocumentExtensions)Ide.getSettings().getData("document-extensions-options");
        if (documentExtensions != null) {
            Collection collection = ExtensionWizardUtils.getFilteredCollection(documentExtensions.getDocuments());
            return collection;
        }
        return null;
    }

    public static String[] getGalleryCategoryNames() {
        GalleryManager galleryManager = GalleryManager.getGalleryManager();
        GalleryFolder galleryFolder = galleryManager.getGallery().getModel();
        ArrayList<String> arrayList = new ArrayList<String>(10);
        Iterator iterator = galleryFolder.getChildren();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof GalleryFolder)) continue;
            GalleryFolder galleryFolder2 = (GalleryFolder)e;
            arrayList.add(galleryFolder2.getName());
        }
        return arrayList.toArray(new String[0]);
    }

    public static String[] getGalleryPageNames(String string) {
        GalleryManager galleryManager = GalleryManager.getGalleryManager();
        GalleryFolder galleryFolder = galleryManager.getGallery().getModel();
        ArrayList<String> arrayList = new ArrayList<String>(10);
        GalleryFolder galleryFolder2 = galleryFolder.getGalleryFolder(string);
        if (galleryFolder2 == null) {
            return null;
        }
        Iterator iterator = galleryFolder2.getChildren();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof GalleryFolder)) continue;
            GalleryFolder galleryFolder3 = (GalleryFolder)e;
            arrayList.add(galleryFolder3.getName());
        }
        return arrayList.toArray(new String[0]);
    }

    public static final Pair[] getMainMenus() {
        return _mainMenus;
    }

    public static final Pair[] getMainMenuSections() {
        return _mainSections;
    }

    public static final Pair[] getContextMenus() {
        return _contextMenus;
    }

    public static final String getContextMenuMnemonic(String string) {
        int n = 0;
        while (n < _contextMenuMnemonic.length) {
            if (_contextMenuMnemonic[n].getFirst().equals(string)) {
                return (String)_contextMenuMnemonic[n].getSecond();
            }
            ++n;
        }
        return null;
    }

    public static final Pair[] getContextMenuImports() {
        return _contextMenuImports;
    }

    static final List getMainMenuNames() {
        return ExtensionWizardUtils.ComputJustNames(_mainMenus);
    }

    static final String[] getDefaultContextMenus() {
        return _defaultContextMenus;
    }

    static final List getContextMenuNames() {
        return ExtensionWizardUtils.ComputJustNames(_contextMenus);
    }

    static final String[] getInvokableActionStrings() {
        return _invocationActionStrings;
    }

    static List ComputJustNames(Pair[] pairArray) {
        int n = pairArray.length;
        ArrayList<String> arrayList = new ArrayList<String>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add((String)pairArray[n2].getFirst());
            ++n2;
        }
        return arrayList;
    }

    static final String browseForIconName(Context context, JComponent jComponent, String string) {
        URL uRL;
        URL uRL2;
        URLChooser uRLChooser = null;
        if (ModelUtil.hasLength((String)string) && URLFileSystem.exists((URL)(uRL2 = URLFactory.newFileURL((String)string)))) {
            uRLChooser = DialogUtil.newURLChooser((Context)context, (URL)uRL2);
        }
        if (uRLChooser == null) {
            uRLChooser = DialogUtil.newURLChooser((Context)context);
        }
        URLFilter uRLFilter = ImageNode.getImageURLFilter();
        uRLChooser.setURLFilter(uRLFilter);
        String string2 = ExtensionArb.getString(160);
        int n = uRLChooser.showOpenDialog((Component)jComponent, string2);
        if (n == 0 && (uRL = uRLChooser.getSelectedURL()) != null) {
            return URLFileSystem.getPlatformPathName((URL)uRL);
        }
        return null;
    }

    private static Collection getFilteredCollection(Collection collection) {
        Iterator iterator = collection.iterator();
        ArrayList<DocumentExtensions.DocRecord> arrayList = new ArrayList<DocumentExtensions.DocRecord>(collection.size());
        while (iterator.hasNext()) {
            DocumentExtensions.DocRecord docRecord = (DocumentExtensions.DocRecord)iterator.next();
            Class clazz = docRecord.getDocClass();
            String string = clazz.getPackage().getName();
            if (!string.startsWith(ORACLE_IDE) && !string.startsWith(ORACLE_JDEVELOPER)) continue;
            arrayList.add(docRecord);
        }
        return arrayList;
    }
}

