/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.extension.ui.code;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.Context;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;
import oracle.jdevimpl.wizard.extension.ExtensionArb;
import oracle.jdevimpl.wizard.extension.ExtensionUtil;
import oracle.jdevimpl.wizard.extension.ExtensionValidation;
import oracle.jdevimpl.wizard.extension.model.Model;
import oracle.jdevimpl.wizard.extension.ui.code.ExtensionWizardUtils;
import oracle.jdevimpl.wizard.extension.ui.code.GalleryTechnology;

public final class GalleryPanel
extends DefaultTraversablePanel {
    private JLabel _lblTechnology;
    private JLabel _lblGalleryCategory;
    private JLabel _lblGalleryPage;
    private JComboBox _cmbTechnology;
    private JComboBox _cmbGalleryCategory;
    private JComboBox _cmbGalleryPage;
    private JLabel _lblDesc;
    private JTextField _fldDesc;
    private JLabel _lblIcon;
    private JTextField _fldIcon;
    private ActionListener _browseListener;
    private ActionListener _defaultListener;
    private JButton _btnBrowse;
    private JButton _btnDefault;
    private GridBagLayout _layout;
    private JMultiLineLabel _hintText;

    void $init$() {
        this._lblTechnology = new JLabel();
        this._lblGalleryCategory = new JLabel();
        this._lblGalleryPage = new JLabel();
        this._cmbTechnology = new JComboBox();
        this._cmbGalleryCategory = new JComboBox();
        this._cmbGalleryPage = new JComboBox();
        this._lblDesc = new JLabel();
        this._fldDesc = new JTextField();
        this._lblIcon = new JLabel();
        this._fldIcon = new FileField();
        this._browseListener = null;
        this._defaultListener = null;
        this._btnBrowse = new JButton();
        this._btnDefault = new JButton();
        this._layout = new GridBagLayout();
        this._hintText = new JMultiLineLabel();
    }

    public GalleryPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void _updateCombo() {
        Object object = this._cmbGalleryCategory.getSelectedItem();
        String[] stringArray = object != null ? ExtensionWizardUtils.getGalleryPageNames(object.toString()) : null;
        this._cmbGalleryPage.setModel(new DefaultComboBoxModel<String>(stringArray));
    }

    private void jbInit() throws Exception {
        this.setLayout(this._layout);
        ResourceUtils.resLabel((JLabel)this._lblTechnology, (Component)this._cmbTechnology, (String)ExtensionArb.getString(63));
        ResourceUtils.resLabel((JLabel)this._lblGalleryCategory, (Component)this._cmbGalleryCategory, (String)ExtensionArb.getString(64));
        ResourceUtils.resLabel((JLabel)this._lblGalleryPage, (Component)this._cmbGalleryPage, (String)ExtensionArb.getString(65));
        ResourceUtils.resLabel((JLabel)this._lblDesc, (Component)this._fldDesc, (String)ExtensionArb.getString(66));
        this._fldDesc.setText(ExtensionArb.getString(67));
        ResourceUtils.resLabel((JLabel)this._lblIcon, (Component)this._fldIcon, (String)ExtensionArb.getString(68));
        this._hintText.setText(ExtensionArb.getString(62));
        this._cmbTechnology.setModel(new DefaultComboBoxModel<Object>(ExtensionWizardUtils.getGalleryTechnologies()));
        this._cmbGalleryCategory.setModel(new DefaultComboBoxModel<String>(ExtensionWizardUtils.getGalleryCategoryNames()));
        this.setDefaultTitle(ExtensionArb.getString(70));
        this._cmbGalleryCategory.addItemListener(new 3());
        this._updateCombo();
        this._defaultListener = new 2();
        this._btnDefault.addActionListener(this._defaultListener);
        this.setDefaultIcon();
        ResourceUtils.resButton((AbstractButton)this._btnBrowse, (String)ExtensionArb.getString(72));
        ResourceUtils.resButton((AbstractButton)this._btnDefault, (String)ExtensionArb.getString(73));
        this.add((Component)this._hintText, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 15, 5), 0, 0));
        this.add(this._lblTechnology, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this._cmbTechnology, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this._lblGalleryCategory, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this._cmbGalleryCategory, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this._lblGalleryPage, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this._cmbGalleryPage, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this._lblDesc, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this._fldDesc, new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this._lblIcon, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this._fldIcon, new GridBagConstraints(1, 5, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add(this._btnBrowse, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 12, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add(this._btnDefault, new GridBagConstraints(2, 6, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.add(new JPanel(), new GridBagConstraints(0, 7, 3, 1, 1.0, 1.0, 18, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void setDefaultIcon() {
        URL uRL = ExtensionUtil.getDefaultGalleryIcon();
        if (uRL.getProtocol().equals("file")) {
            this._fldIcon.setText(URLFileSystem.getPlatformPathName((URL)uRL));
        } else {
            this._fldIcon.setText(uRL.toString());
        }
    }

    private GalleryTechnology getGalleryTechnology() {
        ComboBoxModel comboBoxModel = this._cmbTechnology.getModel();
        return (GalleryTechnology)comboBoxModel.getSelectedItem();
    }

    private int getGalleryWizardCategoryIndex() {
        return this._cmbGalleryCategory.getSelectedIndex();
    }

    private int getGalleryWizardFolderIndex() {
        return this._cmbGalleryPage.getSelectedIndex();
    }

    private String getGalleryWizardCategoryName() {
        return this._cmbGalleryCategory.getSelectedItem().toString();
    }

    private String getGalleryWizardDescription() {
        return this._fldDesc.getText().trim();
    }

    private String getGalleryWizardIconName() {
        return this._fldIcon.getText().trim();
    }

    private final boolean isValidGalleryDesc(String string) {
        if (!ModelUtil.hasLength((String)string)) {
            MessageDialog.error((Component)((Object)this), (Object)ExtensionArb.getString(166), (String)ExtensionArb.getString(165), null);
            return false;
        }
        return true;
    }

    private final boolean isValidGalleryIcon(URL uRL) {
        if (uRL == null || !ModelUtil.hasLength((String)uRL.toString())) {
            MessageDialog.error((Component)((Object)this), (Object)ExtensionArb.getString(168), (String)ExtensionArb.getString(167), null);
            return false;
        }
        return ExtensionValidation.fileExist((Component)((Object)this), uRL);
    }

    public void onEntry(TraversableContext traversableContext) {
        Model model = (Model)traversableContext.find("ExtensionWizardDataModel");
        Context context = (Context)traversableContext.find("Context");
        GalleryPanel galleryPanel = this;
        if (!model.isInvokeFromGallery()) {
            traversableContext.getWizardCallbacks().wizardSkipCurrentStep();
        }
        this._fldDesc.setText(model.getClassName());
        this._browseListener = new 1(this, context, (JComponent)((Object)galleryPanel));
        this._btnBrowse.addActionListener(this._browseListener);
        traversableContext.getWizardCallbacks().wizardSetInitialFocus(this.getInitialFocus());
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        boolean bl = traversableContext.getDirection() == 2;
        Model model = (Model)traversableContext.find("ExtensionWizardDataModel");
        URL uRL = URLFactory.newURL((String)this.getGalleryWizardIconName());
        if (this.isValidGalleryDesc(this.getGalleryWizardDescription()) && this.isValidGalleryIcon(uRL)) {
            model.setGalleryTechnology(this.getGalleryTechnology());
            model.setGalleryCategoryIndex(this.getGalleryWizardCategoryIndex());
            model.setGalleryDescription(this.getGalleryWizardDescription());
            model.setGalleryFolderIndex(this.getGalleryWizardFolderIndex());
            model.setWizardIcon(uRL);
        } else if (!bl) {
            throw new TraversalException(null);
        }
        this._btnBrowse.removeActionListener(this._browseListener);
        this._browseListener = null;
    }

    private Component getInitialFocus() {
        return this._cmbTechnology;
    }

    static void mav$_updateCombo(GalleryPanel galleryPanel) {
        galleryPanel._updateCombo();
    }

    static void mav$setDefaultIcon(GalleryPanel galleryPanel) {
        galleryPanel.setDefaultIcon();
    }

    static String mav$getGalleryWizardIconName(GalleryPanel galleryPanel) {
        return galleryPanel.getGalleryWizardIconName();
    }

    static JTextField ra$_fldIcon(GalleryPanel galleryPanel) {
        return galleryPanel._fldIcon;
    }

    public final class 3
    implements ItemListener {
        public void itemStateChanged(ItemEvent itemEvent) {
            GalleryPanel.mav$_updateCombo(GalleryPanel.this);
        }
    }

    public final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            GalleryPanel.mav$setDefaultIcon(GalleryPanel.this);
        }
    }

    public final class 1
    implements ActionListener {
        private final /* synthetic */ Context v$context;
        private final /* synthetic */ JComponent v$parent;
        final /* synthetic */ GalleryPanel this$0;

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ExtensionWizardUtils.browseForIconName(this.v$context, this.v$parent, GalleryPanel.mav$getGalleryWizardIconName(this.this$0));
            if (string != null) {
                GalleryPanel.ra$_fldIcon(this.this$0).setText(string);
            }
        }

        public 1(GalleryPanel galleryPanel, Context context, JComponent jComponent) {
            this.v$parent = jComponent;
            this.v$context = context;
            this.this$0 = galleryPanel;
        }
    }
}

