/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.iface;

import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import oracle.ide.Context;
import oracle.ide.ceditor.OffsetNavigationPoint;
import oracle.ide.model.Node;
import oracle.ide.navigation.NavigationManager;
import oracle.ide.navigation.NavigationPoint;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceName;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.TransactionDescriptor;
import oracle.jdeveloper.wizard.common.BaliWizardState;
import oracle.jdeveloper.wizard.method.MethodUtils;
import oracle.jdevimpl.resource.WizardsArb;
import oracle.jdevimpl.wizard.iface.ImplementIfaceWizard;

public class ImplementIfaceModel
implements ClassPackageBrowserFilterV2,
BaliWizardState {
    private URL _url;
    private JavaManager _mgr;
    private Context _context;
    private String _pkg;
    private DefaultComboBoxModel _clsList;
    private ArrayList _cachedImports;
    private static boolean _copyJavadoc;
    private ArrayList _ifaceList;

    void $init$() {
        this._ifaceList = new ArrayList();
    }

    public ImplementIfaceModel(Context context) {
        this.$init$();
        Node node = ImplementIfaceWizard.getJavaNode(context);
        this._context = context;
        this._url = node.getURL();
        this._mgr = JavaManager.getJavaManager(context.getProject());
        this._cachedImports = new ArrayList();
    }

    ComboBoxModel getClassList() {
        this.loadData();
        return this._clsList;
    }

    boolean isCopyJavadoc() {
        return _copyJavadoc;
    }

    public void setCopyJavadoc(boolean bl) {
        _copyJavadoc = bl;
    }

    JavaManager getJavaManager() {
        return this._mgr;
    }

    String[] getInterfaceList() {
        String[] stringArray = new String[this._ifaceList.size()];
        int n = 0;
        while (n < stringArray.length) {
            JavaClass javaClass = (JavaClass)this._ifaceList.get(n);
            stringArray[n] = javaClass.getName();
            ++n;
        }
        return stringArray;
    }

    void setInterfaceList(String[] stringArray) {
        this._ifaceList.clear();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                JavaClass javaClass = this._mgr.getClass(stringArray[n]);
                this._ifaceList.add(javaClass);
                ++n;
            }
        }
    }

    public void commitWizardState() {
        block21: {
            if (!ImplementIfaceWizard.ensureAccessible(this._context)) {
                return;
            }
            this.loadData();
            SourceFile sourceFile = this._mgr.getSourceFile(this._url);
            String string = this._clsList.getSelectedItem().toString();
            JavaClass javaClass = this.findClass(sourceFile, string);
            if (javaClass == null || javaClass.getSourceElement() == null) {
                return;
            }
            SourceClass sourceClass = (SourceClass)javaClass.getSourceElement();
            SourceMethod sourceMethod = null;
            SourceTransaction sourceTransaction = sourceFile.getTransaction();
            if (sourceTransaction == null) {
                sourceTransaction = sourceFile.beginTransaction();
            }
            try {
                Iterator iterator = javaClass.getInterfaces().iterator();
                Iterator iterator2 = this._ifaceList.iterator();
                while (iterator2.hasNext()) {
                    boolean bl = false;
                    JavaClass javaClass2 = (JavaClass)iterator2.next();
                    JavaType javaType = javaClass2.getResolvedType();
                    while (iterator.hasNext()) {
                        if (!javaType.equals(iterator.next())) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        this.addSuperInterface(javaClass, javaType, sourceFile);
                    }
                    if (javaClass.isInterface()) continue;
                    for (JavaMethod javaMethod : this.getUnimplementedMethods(javaClass2)) {
                        JavaMethod javaMethod2 = javaClass.getMethod(javaMethod.getName(), javaMethod.getParameterTypes());
                        if (javaMethod2 != null && !Modifier.isAbstract(javaMethod2.getModifiers())) continue;
                        SourceMethod sourceMethod2 = MethodUtils.generateMethod(javaMethod, sourceClass, _copyJavadoc);
                        if (sourceMethod != null) continue;
                        sourceMethod = sourceMethod2;
                    }
                }
                sourceTransaction.savepoint();
                MethodUtils.narrowImports(sourceFile);
                String string2 = WizardsArb.getString(153);
                this.getJavaManager().commitTransaction(sourceTransaction, new TransactionDescriptor(string2));
                sourceTransaction = null;
            }
            finally {
                if (sourceTransaction != null) {
                    sourceTransaction.abort();
                    sourceTransaction = null;
                }
            }
            if (sourceMethod != null) {
                SourceName sourceName;
                int n = -1;
                int n2 = -1;
                JavaMethod javaMethod = javaClass.getDeclaredMethod(sourceMethod.getName(), sourceMethod.getParameterTypes());
                SourceMethod sourceMethod3 = javaMethod != null ? (SourceMethod)javaMethod.getSourceElement() : null;
                SourceName sourceName2 = sourceName = sourceMethod3 != null ? sourceMethod3.getNameElement() : null;
                if (sourceName != null) {
                    n = sourceName.getStartOffset();
                    n2 = sourceName.getEndOffset();
                } else if (sourceMethod3 != null) {
                    n = sourceMethod3.getStartOffset();
                    n2 = sourceMethod3.getEndOffset();
                }
                NavigationManager navigationManager = NavigationManager.getNavigationManager();
                OffsetNavigationPoint offsetNavigationPoint = new OffsetNavigationPoint(this._context, n, n2 - n);
                try {
                    if (navigationManager != null) {
                        navigationManager.navigateTo((NavigationPoint)offsetNavigationPoint, true);
                        break block21;
                    }
                    offsetNavigationPoint.navigate();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    private JavaClass findClass(SourceFile sourceFile, String string) {
        JavaClass javaClass = this._mgr.getClass(string);
        if (javaClass == null) {
            int n = string.indexOf(this._pkg);
            if (n != -1) {
                string = string.substring(n + (this._pkg.length() + 1));
            }
            javaClass = sourceFile.getClass(string);
        }
        return javaClass;
    }

    private void addSuperInterface(JavaClass javaClass, JavaType javaType, SourceFile sourceFile) {
        this.addImport(javaType, sourceFile);
        SourceFactory sourceFactory = sourceFile.getFactory();
        SourceTypeReference sourceTypeReference = sourceFactory.createType(javaType.getName());
        SourceClass sourceClass = (SourceClass)javaClass.getSourceElement();
        sourceClass.getSourceInterfaces().add(sourceTypeReference);
    }

    private SourceImport addImport(JavaType javaType, SourceFile sourceFile) {
        JavaType javaType2;
        if (!javaType.isArray()) {
            javaType2 = javaType;
        } else {
            JavaType javaType3 = javaType;
            while (javaType3.isArray()) {
                javaType3 = javaType3.getComponentType();
            }
            javaType2 = javaType3;
        }
        if (javaType2.isPrimitive()) {
            return null;
        }
        String string = "";
        String string2 = javaType2.getTypeErasure().getQualifiedName();
        int n = string2.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        if (n > 0 && (string = string2.substring(0, n)).equals("java.lang")) {
            return null;
        }
        if (string.equals(sourceFile.getPackageName())) {
            return null;
        }
        if (this._cachedImports.contains(string2)) {
            return null;
        }
        this._cachedImports.add(string2);
        int n2 = 0;
        List list = sourceFile.getSourceImports();
        if (!list.isEmpty()) {
            int n3 = 0;
            int n4 = list.size();
            while (n3 < n4) {
                SourceImport sourceImport = (SourceImport)list.get(n3);
                if (!sourceImport.isStatic()) {
                    String string3 = sourceImport.getName();
                    if (string3.endsWith(".*") ? (string3 = string3.substring(0, string3.length() - 2)).equals(string) : string3.equals(string2)) {
                        return null;
                    }
                    if (string2.compareTo(string3) > 0) {
                        n2 = n3 + 1;
                    }
                }
                ++n3;
            }
        }
        SourceImport sourceImport = sourceFile.getFactory().createImportDeclaration(string2);
        list.add(n2, sourceImport);
        return sourceImport;
    }

    private Collection getUnimplementedMethods(JavaClass javaClass) {
        HashSet<String> hashSet = new HashSet<String>();
        LinkedHashMap<String, JavaMethod> linkedHashMap = new LinkedHashMap<String, JavaMethod>();
        block0: for (JavaMethod javaMethod : javaClass.getMethods()) {
            String string;
            if (javaMethod.isPrivate()) continue;
            Collection collection = javaMethod.getParameters();
            if (collection.isEmpty()) {
                string = javaMethod.getName();
            } else {
                StringBuffer stringBuffer = new StringBuffer(javaMethod.getName());
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(',');
                    JavaVariable javaVariable = (JavaVariable)iterator.next();
                    JavaType javaType = javaVariable.getResolvedType();
                    if (javaType == null) continue block0;
                    JavaClass javaClass2 = javaType.getTypeErasure();
                    if (javaClass2 == null) {
                        stringBuffer.append("java.lang.Object");
                        continue;
                    }
                    String string2 = javaClass2.getQualifiedName();
                    stringBuffer.append(string2);
                }
                string = stringBuffer.toString();
            }
            if (hashSet.add(string)) {
                if (!javaMethod.isAbstract()) continue;
                linkedHashMap.put(string, javaMethod);
                continue;
            }
            if (javaMethod.isAbstract()) continue;
            linkedHashMap.remove(string);
        }
        return linkedHashMap.values();
    }

    private void loadData() {
        if (this._clsList == null) {
            this._clsList = new DefaultComboBoxModel();
            SourceFile sourceFile = this._mgr.getSourceFile(this._url);
            if (sourceFile != null) {
                this._pkg = sourceFile.getPackageName();
                String string = sourceFile.getPrimaryClass().getQualifiedName();
                String string2 = null;
                JavaClass[] javaClassArray = this.getAllClasses(sourceFile);
                int n = 0;
                while (n < javaClassArray.length) {
                    String string3 = javaClassArray[n].getQualifiedName();
                    this._clsList.addElement(string3);
                    if (string.equals(string3)) {
                        string2 = string3;
                    }
                    ++n;
                }
                if (string2 == null) {
                    if (this._clsList.getSize() > 0) {
                        this._clsList.setSelectedItem(this._clsList.getElementAt(0));
                    }
                } else {
                    this._clsList.setSelectedItem(string2);
                }
            }
        }
    }

    private JavaClass[] getAllClasses(SourceFile sourceFile) {
        if (sourceFile == null) {
            return new JavaClass[0];
        }
        ArrayList<JavaClass> arrayList = new ArrayList<JavaClass>();
        for (JavaClass javaClass : sourceFile.getClasses()) {
            arrayList.add(javaClass);
            this.getContainedClasses(javaClass, arrayList);
        }
        return arrayList.toArray(new JavaClass[arrayList.size()]);
    }

    private void getContainedClasses(JavaClass javaClass, ArrayList arrayList) {
        for (JavaClass javaClass2 : javaClass.getDeclaredClasses()) {
            arrayList.add(javaClass2);
            this.getContainedClasses(javaClass2, arrayList);
        }
    }

    public boolean acceptPackage(String string) {
        return true;
    }

    public boolean acceptClass(JavaClass javaClass) {
        if (javaClass.isInterface()) {
            if (Modifier.isPublic(javaClass.getModifiers())) {
                if (javaClass.getPackageName().length() == 0) {
                    return this._pkg.length() == 0;
                }
                return true;
            }
            return this._pkg.equals(javaClass.getPackageName());
        }
        return false;
    }
}

