/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.javabean;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.PackageClassChooser;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.palette.Palette;
import oracle.ide.palette.PaletteItem;
import oracle.ide.palette.PaletteManager;
import oracle.ide.palette.PalettePage;
import oracle.ide.util.GraphicsUtils;
import oracle.ide.util.ResourceUtils;
import oracle.ideimpl.palette.wizard.PaletteWizard;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdevimpl.resource.WizardsArb;
import oracle.jdevimpl.wizard.javabean.JavaBeanPath;

public class JavaBeanWizardPanel
extends JPanel
implements TreeSelectionListener,
ActionListener,
PaletteWizard {
    private JEWTDialog _dlg;
    private final ButtonGroup _buttonGroup;
    private PaletteManager pm;
    private Palette palette;
    private Vector _libraryModel;
    private String[] _filters;
    private JLabel _selectLbl;
    private JLabel _libraryLbl;
    private JComboBox _libraryBox;
    private JLabel _filterLbl;
    private JComboBox _filterBox;
    private JPanel _panel;
    private JButton _selectImageBtn;
    private JButton _defaultBtn;
    private JLabel _previewLbl;
    private JTextField _iconFld;
    private JLabel _iconLbl;
    private String _defaultIcon;
    private String _iconStr;
    private URLChooser _urlChooser;
    JLabel _previewFld;
    private JTree _tree;
    private String[] _selection;
    private PackageClassChooser _componentPanel;
    GridBagLayout gridBagLayout1;
    private ImageIcon _defaultImageIcon;

    void $init$() {
        this._buttonGroup = new ButtonGroup();
        this.pm = PaletteManager.getPaletteManager();
        this.palette = this.pm.getPalette();
        this._libraryModel = new Vector();
        this._filters = new String[]{WizardsArb.getString(87), WizardsArb.getString(86), WizardsArb.getString(85)};
        this._selectLbl = new JLabel();
        this._libraryLbl = new JLabel();
        this._libraryBox = new JComboBox(this._libraryModel);
        this._filterLbl = new JLabel();
        this._filterBox = new JComboBox<String>(this._filters);
        this._panel = new JPanel();
        this._selectImageBtn = new JButton();
        this._defaultBtn = new JButton();
        this._previewLbl = new JLabel();
        this._iconFld = new JTextField();
        this._iconLbl = new JLabel();
        this._defaultIcon = "/oracle/ideimpl/icons/images/palette/appwr.gif";
        this._iconStr = "oracle/ideimpl/icons/images/palette/appwr.gif";
        this._previewFld = new JLabel();
        this.gridBagLayout1 = new GridBagLayout();
    }

    public JavaBeanWizardPanel(Context context) {
        this.$init$();
        try {
            this.jbInit();
            this._urlChooser = DialogUtil.newURLChooser((Context)context);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this._defaultImageIcon = new ImageIcon(classLoader.getResource(this._iconStr));
        JLabel jLabel = new JLabel(WizardsArb.getString(104));
        ResourceUtils.resButton((AbstractButton)this._selectImageBtn, (String)WizardsArb.getString(96));
        ResourceUtils.resButton((AbstractButton)this._defaultBtn, (String)WizardsArb.getString(97));
        ResourceUtils.resLabel((JLabel)this._iconLbl, (Component)this._iconFld, (String)WizardsArb.getString(99));
        ResourceUtils.resLabel((JLabel)this._libraryLbl, (Component)this._libraryBox, (String)WizardsArb.getString(101));
        ResourceUtils.resLabel((JLabel)this._filterLbl, (Component)this._filterBox, (String)WizardsArb.getString(103));
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._componentPanel, (String)WizardsArb.getString(104));
        this.setLayout(this.gridBagLayout1);
        this.setPreferredSize(new Dimension(450, 400));
        this._panel.setLayout(new BorderLayout());
        this._selectImageBtn.addActionListener(this);
        this._defaultBtn.addActionListener(this);
        this._previewLbl.setText(WizardsArb.getString(98));
        this.add((Component)this._selectLbl, new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 8, 8), 0, 0));
        this.add((Component)this._libraryLbl, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 8, 8), 0, 0));
        this.add((Component)this._libraryBox, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 8, 0), 0, 0));
        this.add((Component)jLabel, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
        this.add((Component)this._panel, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 8, 0), 0, 0));
        this.add((Component)this._filterLbl, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 8, 8), 0, 0));
        this.add((Component)this._filterBox, new GridBagConstraints(1, 4, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 8, 0), 0, 0));
        this.add((Component)this._iconLbl, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
        this.add((Component)this._iconFld, new GridBagConstraints(1, 5, 3, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 8, 0), 0, 0));
        this.add((Component)this._previewLbl, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 8), 0, 0));
        this.add((Component)this._previewFld, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this._defaultBtn, new GridBagConstraints(2, 6, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 8), 0, 0));
        this.add((Component)this._selectImageBtn, new GridBagConstraints(3, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.populateLibraryList();
        this._defaultBtn.addActionListener(this);
        this._iconFld.setEditable(false);
    }

    private void populateLibraryList() {
        Iterator iterator = JLibraryManager.getLibraries().iterator();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (iterator.hasNext()) {
            String string = ((JLibrary)iterator.next()).getName();
            arrayList.add(string);
        }
        arrayList.add("Swing and AWT");
        Collections.sort(arrayList);
        Iterator iterator2 = arrayList.iterator();
        while (iterator2.hasNext()) {
            this._libraryModel.add((String)iterator2.next());
        }
        this._libraryBox.addActionListener(this);
        this._filterBox.addActionListener(this);
        this._libraryBox.setSelectedIndex(0);
        this._defaultBtn.setEnabled(false);
        this._selectImageBtn.setEnabled(false);
    }

    public Component getGUI() {
        return this;
    }

    public Icon getIcon() {
        return null;
    }

    public String getType() {
        return "java";
    }

    public String getTitle() {
        return WizardsArb.getString(88);
    }

    public String getSelectedLibrary() {
        return (String)this._libraryBox.getSelectedItem();
    }

    private void addItem(String string, String string2) {
        PalettePage palettePage = this.palette.getEditPage();
        String string3 = "";
        try {
            Class<?> clazz = Class.forName(string2);
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            ImageIcon imageIcon = new ImageIcon(beanInfo.getIcon(1));
            if (imageIcon != null) {
                string3 = "1";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = string2.lastIndexOf(".");
        String string4 = n > 0 ? string2.substring(n + 1) : string2;
        palettePage.addPaletteItem("/oracle/ideimpl/icons/images/palette/appwr.gif", "", true, string2, string4, "JavaBean", "", string);
        PaletteItem paletteItem = palettePage.getPaletteItem(string4);
        paletteItem.setItemBeanInfo(string3);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        if (jComponent == this._libraryBox || jComponent == this._filterBox) {
            this.showClassPanel();
        } else if (jComponent == this._defaultBtn) {
            this._iconFld.setText(this._defaultIcon);
            this._previewFld.setIcon(this._defaultImageIcon);
        } else if (jComponent == this._selectImageBtn) {
            this.changeImage();
        }
    }

    private void showClassPanel() {
        URLPath uRLPath = null;
        JLibrary jLibrary = null;
        if (this.getSelectedLibrary().equals("Swing and AWT")) {
            uRLPath = JLibraryManager.getDefaultJDK().getClassPath();
            URL uRL = URLFileSystem.getParent((URL)JLibraryManager.getDefaultJDK().getSDKBinDir());
            URL uRL2 = URLFactory.newURL((URL)uRL, (String)"lib/dt.jar");
            URL uRL3 = URLFactory.newJarURL((URL)uRL2, (String)"");
            uRLPath.add(uRL3);
        } else {
            jLibrary = JLibraryManager.findLibrary(this.getSelectedLibrary());
        }
        if (jLibrary != null) {
            uRLPath = jLibrary.getDefaultClassPath();
        }
        JavaBeanPath javaBeanPath = new JavaBeanPath(uRLPath);
        String string = (String)this._filterBox.getSelectedItem();
        if (string.equals(WizardsArb.getString(87))) {
            javaBeanPath.setFilter(JavaBeanPath.NO_FILTER);
        } else if (string.equals(WizardsArb.getString(85))) {
            javaBeanPath.setFilter(JavaBeanPath.USE_MANIFEST);
        } else {
            javaBeanPath.setFilter(JavaBeanPath.USE_BEANINFO);
        }
        this._componentPanel = new PackageClassChooser(1, (URLPath)javaBeanPath);
        this._tree = this._componentPanel.getTree();
        this._panel.removeAll();
        this._panel.add((Component)this._componentPanel, "Center");
        this._panel.validate();
        this._panel.repaint();
        this._tree.getSelectionModel().setSelectionMode(4);
        this._tree.addTreeSelectionListener(this);
        this._iconFld.setText("");
        this._previewFld.setIcon(null);
    }

    private void changeImage() {
        this._urlChooser.setURLFilter((URLFilter)new DefaultURLFilter("Image File", GraphicsUtils.getImageExtensions()));
        this._urlChooser.setSelectionScope(0);
        this._urlChooser.showOpenDialog((Component)Ide.getMainWindow());
        URL[] uRLArray = this._urlChooser.getSelectedURLs();
        if (uRLArray.length > 0) {
            URL uRL = this._urlChooser.getSelectedURL();
            this._iconFld.setText(uRL.getPath());
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.getImage(uRL);
            if (image != null) {
                this._previewFld.setIcon(new ImageIcon(image));
            }
        }
    }

    private void setImage(String string) {
        boolean bl = false;
        try {
            Class<?> clazz = Class.forName(string);
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            ImageIcon imageIcon = new ImageIcon(beanInfo.getIcon(1));
            if (imageIcon != null) {
                this._previewFld.setIcon(imageIcon);
                this._iconFld.setText("Use BeanInfo Image");
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            URL uRL = this.getClass().getResource(this._defaultIcon);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.getImage(uRL);
            if (image != null) {
                this._previewFld.setIcon(new ImageIcon(image));
                this._iconFld.setText(this._defaultIcon);
            }
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        Object object = defaultMutableTreeNode.getUserObject();
        if (defaultMutableTreeNode.isLeaf()) {
            if (!defaultMutableTreeNode.isRoot()) {
                String[] stringArray = this._componentPanel.getSelections();
                this.setSelection(stringArray);
                String string = stringArray[0];
                this.setImage(string);
                this._selectImageBtn.setEnabled(true);
                this._defaultBtn.setEnabled(true);
            }
        } else {
            this.setSelection(null);
            this._iconFld.setText("");
            this._previewFld.setIcon(null);
            this._defaultBtn.setEnabled(false);
            this._selectImageBtn.setEnabled(false);
        }
    }

    public void setSelection(String[] stringArray) {
        this._selection = stringArray;
    }

    public String[] getSelection() {
        return this._selection;
    }

    public String getImageName() {
        return this._iconFld.getText();
    }
}

