/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.project;

import java.awt.Component;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.NewWorkspaceCommand;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.dialogs.ProgressBar;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.NewWorkspacePanel;
import oracle.ide.resource.GalleryArb;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.PatternFilters;
import oracle.ide.wizard.Wizard;
import oracle.ideri.importexport.ImportWizard;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.resource.WizardsArb;
import oracle.jdevimpl.wizard.project.ProjectWizardLauncher;

public class ProjFromSource
extends Wizard
implements Runnable,
ImportWizard {
    private Icon _icon;
    public static final String COPY_FILES_KEY = "copy-files";
    public static final String PROJECT_PANEL_KEYS = "ProjFromSource.project-panel-key";
    private static final int COPY_FILES = 0;
    private static final int DELETE_FILES = 1;
    private static final String IMPORT_WIZARD_PROPERTY = "oracle.jdevimpl.wizard.project.ProjFromSource.importWizard";
    private ProgressBar _progressBar;
    private URL _copyLocation;
    private boolean _fileCopyError;
    private int _runAction;
    private Project _project;
    private ContentSet _javaContentSet;
    private URLPath _sourcePaths;

    public String getShortLabel() {
        return GalleryArb.getString((int)40);
    }

    public String getLongLabel() {
        return GalleryArb.getString((int)41);
    }

    public boolean invoke(Context context) {
        this.init();
        boolean bl = context.containsProperty(IMPORT_WIZARD_PROPERTY);
        if (context.getWorkspace() == null) {
            NewWorkspacePanel newWorkspacePanel = new NewWorkspacePanel(false, false, true);
            if (!newWorkspacePanel.runDialog()) {
                return false;
            }
            URL uRL = newWorkspacePanel.getFileURL();
            try {
                Workspace workspace = NewWorkspaceCommand.createEmptyWorkspace((Context)context, (URL)uRL);
                context.setWorkspace(workspace);
                Ide.setActiveWorkspace((Workspace)workspace);
            }
            catch (Exception exception) {
                boolean bl2 = false;
                return bl2;
            }
        }
        ProjectWizardLauncher projectWizardLauncher = new ProjectWizardLauncher(context, bl ? WizardsArb.getString(17) : WizardsArb.getString(20));
        String string = bl ? WizardsArb.getString(19) : WizardsArb.getString(24);
        projectWizardLauncher.addWelcomePage(string, WizardsArb.getString(25), "oracle.jdevimpl.wizard.project.ProjFromSource", "f1_idewnewprojwsourcewelcome_html");
        projectWizardLauncher.addPage("oracle.jdevimpl.wizard.project.ProjectLocationPanel", "f1_idewnewprojwsourcelocation_html");
        projectWizardLauncher.addPage("oracle.jdevimpl.wizard.project.AddSourcePanel", "f1_idewnewprojwsourceaddsource_html");
        projectWizardLauncher.addPage("oracle.jdevimpl.wizard.project.ProjFromSourceLibraryPanel", "f1_idewnewprojwsourcerunsettings_html");
        projectWizardLauncher.addFinishPage("oracle.jdevimpl.wizard.project.ProjFromSourceFinishPanel", "f1_idewnewprojwsourcesummary_html", WizardsArb.getString(356));
        projectWizardLauncher.setShowStepNumber(true);
        Project project = new Project();
        Project project2 = Ide.getDefaultProject();
        if (project2 != null) {
            project2.copyTo((Object)project);
        }
        PathsConfiguration.getInstance(project).setProjectSourcePath(null);
        Namespace namespace = projectWizardLauncher.getNamespace();
        namespace.put("Project", (Object)project);
        HashStructure hashStructure = project.getProperties();
        namespace.put("PropertyData", (Object)hashStructure);
        JProjectLibraries jProjectLibraries = JProjectLibraries.getInstance(null);
        JProjectLibraries jProjectLibraries2 = JProjectLibraries.getInstance((PropertyStorage)project);
        jProjectLibraries2.copyTo((Object)jProjectLibraries);
        namespace.put("oracle.jdevimpl.config.JProjectLibraries", (Object)jProjectLibraries);
        this._project = projectWizardLauncher.runWizard();
        if (this._project != null) {
            HashStructure hashStructure2 = this._project.getProperties();
            String[] stringArray = (String[])namespace.get(PROJECT_PANEL_KEYS);
            if (stringArray != null && hashStructure != null) {
                hashStructure.copyTo(hashStructure2, stringArray);
            }
            JavaProject javaProject = JavaProject.getInstance(this._project);
            javaProject.setRecentPackages(Collections.EMPTY_LIST);
            javaProject.setMostRecentPackage(javaProject.getDefaultPackage());
            Boolean bl3 = (Boolean)namespace.get(COPY_FILES_KEY);
            if (bl3.booleanValue()) {
                URL uRL = (URL)namespace.find("ProjectURL");
                String string2 = URLFileSystem.getPath((URL)uRL);
                string2 = string2.substring(0, string2.lastIndexOf("/") + 1);
                this._copyLocation = URLFactory.newDirURL((String)(string2 + "src/"));
                PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance(project, (PropertyStorage)project);
                this._javaContentSet = pathsConfiguration.getJavaContentSet();
                this._sourcePaths = new URLPath(this._javaContentSet.getURLPath());
                boolean bl4 = this.copyFilesToProject();
                if (bl4) {
                    return false;
                }
                URL uRL2 = URLFileSystem.canonicalize((URL)this._copyLocation);
                PathsConfiguration pathsConfiguration2 = PathsConfiguration.getInstance(this._project, (PropertyStorage)this._project);
                ContentSet contentSet = pathsConfiguration2.getJavaContentSet();
                contentSet.setContentFolderURL(uRL2);
                URLPath uRLPath = contentSet.getURLPath();
                uRLPath.setEntries(new URL[]{uRL2});
                contentSet.removeAllContentSets();
            } else {
                PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance(project, (PropertyStorage)project);
                ContentSet contentSet = pathsConfiguration.getJavaContentSet();
                PathsConfiguration pathsConfiguration3 = PathsConfiguration.getInstance(this._project, (PropertyStorage)this._project);
                ContentSet contentSet2 = pathsConfiguration3.getJavaContentSet();
                contentSet.copyTo((Object)contentSet2);
            }
            URL uRL = (URL)namespace.find("OutputDirectory");
            if (uRL != null) {
                javaProject.setOutputDirectory(URLFileSystem.canonicalize((URL)uRL));
            }
        } else {
            try {
                project.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            return false;
        }
        try {
            this._project.save();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    public boolean isAvailable(Context context) {
        if (context == null) {
            return false;
        }
        return context.getWorkspace() != null;
    }

    public Icon getIcon() {
        if (this._icon == null) {
            this._icon = IdeIcons.getIcon((int)5);
        }
        return this._icon;
    }

    private boolean copyFilesToProject() {
        this._progressBar = new ProgressBar((Component)Ide.getMainWindow(), WizardsArb.getString(35), (Runnable)this, true);
        this._progressBar.start(WizardsArb.getString(34), null);
        this._progressBar.waitUntilDone();
        boolean bl = false;
        if (this._progressBar.hasUserCancelled()) {
            int n = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), WizardsArb.getString(36), WizardsArb.getString(37), 0);
            if (n == 0) {
                this._runAction = 1;
                IdeUtil.runNow((Runnable)this);
            }
            bl = true;
        }
        if (this._fileCopyError && !bl) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), WizardsArb.getString(38), WizardsArb.getString(39), 0);
        }
        return bl;
    }

    private void deleteFile(URL uRL) {
        if (URLFileSystem.isDirectory((URL)uRL)) {
            URL[] uRLArray = URLFileSystem.list((URL)uRL);
            int n = 0;
            while (n < uRLArray.length) {
                this.deleteFile(uRLArray[n]);
                ++n;
            }
        }
        URLFileSystem.delete((URL)uRL);
    }

    private void copyFile(URL uRL) {
        block11: {
            if (this._progressBar.hasUserCancelled()) {
                return;
            }
            this._progressBar.sleepForUIToRepaint();
            this._progressBar.updateProgress(WizardsArb.getString(34), URLFileSystem.getPlatformPathName((URL)uRL));
            if (!this.shouldHandleFile(uRL)) break block11;
            if (URLFileSystem.isDirectory((URL)uRL)) {
                URL[] uRLArray = URLFileSystem.list((URL)uRL);
                int n = 0;
                while (n < uRLArray.length) {
                    this.copyFile(uRLArray[n]);
                    ++n;
                }
            } else {
                String string = this._javaContentSet.toRelativePath(uRL);
                URL uRL2 = null;
                if (string == null) {
                    String string2 = URLFileSystem.getFileName((URL)uRL);
                    uRL2 = URLFactory.newURL((URL)this._copyLocation, (String)string2);
                } else {
                    uRL2 = URLFactory.newURL((URL)this._copyLocation, (String)string);
                }
                if (URLFileSystem.equals((URL)uRL, (URL)uRL2)) {
                    return;
                }
                if (URLFileSystem.exists((URL)uRL2)) {
                    uRL2 = this.findNewLocationFor(uRL, uRL2);
                }
                if (uRL2 == null) {
                    return;
                }
                try {
                    URLFileSystem.copy((URL)uRL, (URL)uRL2);
                }
                catch (IOException iOException) {
                    this._fileCopyError = true;
                }
            }
        }
    }

    private URL findNewLocationFor(URL uRL, URL uRL2) {
        URL uRL3 = uRL;
        String string = null;
        URL uRL4 = uRL2;
        String string2 = null;
        boolean bl = true;
        String string3 = null;
        while (bl) {
            if ((uRL3 = URLFileSystem.getParent((URL)uRL3)) == null) {
                string3 = null;
                bl = false;
            }
            string = URLFileSystem.getFileName((URL)uRL3);
            if ((uRL4 = URLFileSystem.getParent((URL)uRL4)) == null) {
                string3 = null;
                bl = false;
            }
            if (string.equals(string2 = URLFileSystem.getFileName((URL)uRL4))) continue;
            string3 = string;
            bl = false;
        }
        if (string3 != null) {
            URL uRL5 = URLFileSystem.getParent((URL)uRL2);
            String string4 = URLFileSystem.getFileName((URL)uRL2);
            URL uRL6 = URLFactory.newURL((URL)uRL5, (String)(string3 + "/" + string4));
            if (URLFileSystem.exists((URL)uRL6)) {
                return null;
            }
            return uRL6;
        }
        return null;
    }

    private boolean shouldHandleFile(URL uRL) {
        PatternFilters patternFilters = GlobalIgnoreList.getPatternFilters();
        return patternFilters.isIncluded(uRL.getPath());
    }

    public void run() {
        if (this._runAction == 0) {
            Iterator iterator = this._javaContentSet.urlIterator(null);
            while (iterator.hasNext()) {
                this.copyFile((URL)iterator.next());
                if (!this._progressBar.hasUserCancelled()) {
                    continue;
                }
                break;
            }
        } else {
            URL[] uRLArray = URLFileSystem.list((URL)this._copyLocation);
            int n = 0;
            while (n < uRLArray.length) {
                this.deleteFile(uRLArray[n]);
                if (!this._progressBar.hasUserCancelled()) {
                    ++n;
                    continue;
                }
                break;
            }
        }
        this._progressBar.setDoneStatus();
    }

    private void init() {
        this._progressBar = null;
        this._javaContentSet = null;
        this._copyLocation = null;
        this._fileCopyError = false;
        this._sourcePaths = null;
        this._runAction = 0;
        this._project = null;
    }

    public String getImportWizardName(Context context) {
        return WizardsArb.getString(18);
    }

    public Icon getImportWizardIcon(Context context) {
        return IdeIcons.getIcon((int)5);
    }

    public String getImportWizardTooltipText(Context context) {
        return WizardsArb.getString(26);
    }

    public boolean invokeImportWizard(Context context, String[] stringArray) {
        Project project = context.getProject();
        Wizard.setLegacyParams((Context)context, (String[])stringArray);
        context.setProperty(IMPORT_WIZARD_PROPERTY, (Object)true);
        return this.invoke(context);
    }

    public boolean isAvailableAsImportWizard(Context context) {
        return true;
    }
}

