/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.project;

import java.awt.Component;
import java.net.URL;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import oracle.ide.dialogs.filter.DirectoryOptionsPanel;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ModelUtil;
import oracle.ide.wizard.FinishPanel;
import oracle.ide.wizard.WizardCallbacks;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JProjectLibraryList;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.resource.WizardsArb;

public class ProjFromSourceFinishPanel
extends FinishPanel {
    private transient WizardCallbacks _callbacks;
    private JTree _summaryTree;
    private DefaultMutableTreeNode _rootNode;
    private DefaultTreeModel _treeModel;
    private int _wizardType;

    public void onEntry(TraversableContext traversableContext) {
        if (this._summaryTree == null) {
            String string = WizardsArb.getString(30);
            String string2 = WizardsArb.getString(28);
            this.setFinishText(string);
            this._summaryTree = this.createSummaryTree(string2);
            this._treeModel = (DefaultTreeModel)this._summaryTree.getModel();
            this._rootNode = (DefaultMutableTreeNode)this._treeModel.getRoot();
        }
        this.populateSummaryTree(traversableContext);
        this.expandSummaryTree();
        traversableContext.getWizardCallbacks().wizardSetInitialFocus((Component)this._summaryTree);
    }

    private void populateSummaryTree(TraversableContext traversableContext) {
        this._rootNode.removeAllChildren();
        Project project = (Project)traversableContext.get("Project");
        URL uRL = (URL)traversableContext.get("ProjectURL");
        String string = WizardsArb.format(355, URLFileSystem.getName((URL)uRL));
        this.createAndAddNode(this._rootNode, string);
        string = null;
        URLPath uRLPath = PathsConfiguration.getInstance(project).getSourcePath();
        if (uRLPath != null) {
            string = WizardsArb.getString(33);
            DefaultMutableTreeNode defaultMutableTreeNode = this.createAndAddNode(this._rootNode, string);
            URL[] uRLArray = uRLPath.getEntries();
            int n = 0;
            while (n < uRLArray.length) {
                string = URLFileSystem.getPlatformPathName((URL)uRLArray[n]);
                this.createAndAddNode(defaultMutableTreeNode, string);
                ++n;
            }
        }
        Boolean bl = (Boolean)traversableContext.get("copy-files");
        string = WizardsArb.format(32, bl.toString());
        this.createAndAddNode(this._rootNode, string);
        string = null;
        uRL = JavaProject.getInstance(project).getOutputDirectory();
        string = WizardsArb.format(29, URLFileSystem.getPlatformPathName((URL)uRL));
        this.createAndAddNode(this._rootNode, string);
        JProjectLibraries jProjectLibraries = (JProjectLibraries)((Object)traversableContext.find("oracle.jdevimpl.config.JProjectLibraries"));
        if (jProjectLibraries != null) {
            string = WizardsArb.getString(40);
            DefaultMutableTreeNode defaultMutableTreeNode = this.createAndAddNode(this._rootNode, string);
            JLibrary[] jLibraryArray = jProjectLibraries.getLibraries();
            JProjectLibraryList jProjectLibraryList = jProjectLibraries.getProjectLibraryList();
            if (jLibraryArray != null && jLibraryArray.length > 0) {
                int n = 0;
                while (n < jLibraryArray.length) {
                    string = jLibraryArray[n].getName();
                    this.createAndAddNode(defaultMutableTreeNode, string);
                    ++n;
                }
            }
        }
        this._treeModel.reload();
    }

    private DefaultMutableTreeNode createAndAddNode(DefaultMutableTreeNode defaultMutableTreeNode, String string) {
        if (!ModelUtil.hasLength((String)string)) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        return defaultMutableTreeNode2;
    }

    private void createCopySourceNodes(DirectoryOptionsPanel directoryOptionsPanel) {
        if (directoryOptionsPanel == null) {
            return;
        }
        Boolean bl = new Boolean(directoryOptionsPanel.getCopyFiles());
        String string = WizardsArb.format(32, bl.toString());
        this.createAndAddNode(this._rootNode, string);
    }
}

