/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.ide.Ide;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.URLPathField;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.ide.wizard.WizardCallbacks;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.resource.ControlsArb;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdevimpl.resource.WizardsArb;
import oracle.jdevimpl.wizard.project.ProjectWizardUtils;

public class ProjectPathsPanel
extends DefaultTraversablePanel {
    GridBagLayout layBottom;
    JMultiLineLabel lblTop;
    JLabel lblDefaultPkg;
    URLPathField fldSourcePath;
    JButton btnSourcePath;
    JTextField fldDefaultPkg;
    JLabel lblSourcePath;
    JLabel lblOutputDirectory;
    URLTextField fldOutputDirectory;
    JButton btnOutputDirectory;
    JPanel pnlBottom;
    BorderLayout layMain;
    private URLPath _initSourcePath;
    private URL _initOutputDir;

    void $init$() {
        this.layBottom = new GridBagLayout();
        this.lblTop = new JMultiLineLabel();
        this.lblDefaultPkg = new JLabel();
        this.fldSourcePath = new URLPathField();
        this.btnSourcePath = new JButton();
        this.fldDefaultPkg = new JTextField();
        this.lblSourcePath = new JLabel();
        this.lblOutputDirectory = new JLabel();
        this.fldOutputDirectory = new URLTextField();
        this.btnOutputDirectory = new JButton();
        this.pnlBottom = new JPanel();
        this.layMain = new BorderLayout();
    }

    public ProjectPathsPanel() {
        this.$init$();
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        String string;
        WizardCallbacks wizardCallbacks = traversableContext.getWizardCallbacks();
        String string2 = (String)traversableContext.find("WizardName");
        if (ModelUtil.hasLength((String)string2) && string2.equals(WizardsArb.getString(6))) {
            wizardCallbacks.wizardEnableButtons(Boolean.TRUE, Boolean.TRUE, Boolean.TRUE);
        }
        if (!traversableContext.contains("DefaultPackage")) {
            if (traversableContext.contains("ProjectURL")) {
                try {
                    URL uRL = (URL)traversableContext.get("ProjectURL");
                    File file = new File(uRL.getPath());
                    string = JavaProject.generateDefaultPackageName(file.getName());
                }
                catch (Exception exception) {
                    string = "";
                }
            } else {
                string = "";
            }
        } else {
            string = (String)traversableContext.find("DefaultPackage");
        }
        if (string != null) {
            this.fldDefaultPkg.setText(string.trim());
        }
        URL uRL = (URL)traversableContext.find("ProjectURL");
        Project project = Ide.getDefaultProject();
        URL uRL2 = project.getURL();
        this._initSourcePath = (URLPath)traversableContext.find("ProjectSourcePath");
        if (this._initSourcePath == null) {
            URLPath uRLPath = PathsConfiguration.getInstance(project).getProjectSourcePath();
            this._initSourcePath = ProjectWizardUtils.updateURLPath(uRL2, uRL, uRLPath);
        }
        this.fldSourcePath.setURLPath(this._initSourcePath);
        this._initOutputDir = (URL)traversableContext.find("OutputDirectory");
        if (this._initOutputDir == null) {
            URL uRL3 = JavaProject.getInstance(project).getOutputDirectory();
            this._initOutputDir = ProjectWizardUtils.updateURL(uRL2, uRL, uRL3);
        }
        this.fldOutputDirectory.setURL(this._initOutputDir);
        wizardCallbacks.wizardSetInitialFocus((Component)this.fldDefaultPkg);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        String string;
        URLPath uRLPath = null;
        try {
            uRLPath = this.fldSourcePath.getURLPath();
            if (uRLPath.size() <= 0) {
                this.fldSourcePath.requestFocus();
                throw new TraversalException(JProjectArb.getString(127), JProjectArb.getString(126));
            }
            URL[] uRLArray = uRLPath.getEntries();
            int n = 0;
            while (n < uRLArray.length) {
                if (!URLFileSystem.isValid((URL)uRLArray[n])) {
                    this.fldSourcePath.requestFocus();
                    String string2 = URLFileSystem.getPlatformPathName((URL)uRLArray[n]);
                    throw new TraversalException(JProjectArb.format(128, JProjectArb.getString(47), string2), JProjectArb.getString(126));
                }
                ++n;
            }
            if (ModelUtil.areDifferent((Object)this._initSourcePath, (Object)uRLPath)) {
                traversableContext.put("ProjectSourcePath", (Object)uRLPath);
            }
        }
        catch (URLPathField.BadEntryException badEntryException) {
            this.fldSourcePath.requestFocus();
            throw new TraversalException(ControlsArb.format(55, badEntryException.getBadEntry()));
        }
        URL uRL = this.fldOutputDirectory.getURL();
        if (uRL == null || !URLFileSystem.isValid((URL)uRL)) {
            this.fldOutputDirectory.requestFocus();
            throw new TraversalException(JProjectArb.format(128, JProjectArb.getString(144), this.fldOutputDirectory.getText().trim()), JProjectArb.getString(143));
        }
        if (ModelUtil.areDifferent((Object)this._initOutputDir, (Object)uRL)) {
            traversableContext.put("OutputDirectory", (Object)uRL);
        }
        if (ModelUtil.hasLength((String)(string = this.fldDefaultPkg.getText().trim()))) {
            URL uRL2;
            if (!IdeUtil.isPackageIdentifier((String)string)) {
                this.fldDefaultPkg.requestFocus();
                throw new TraversalException(JProjectArb.format(125, string));
            }
            if (uRLPath != null && uRLPath.size() > 0 && !URLFileSystem.canCreate((URL)(uRL2 = URLFactory.newDirURL((URL)uRLPath.getEntries()[0], (String)string)))) {
                throw new TraversalException(JProjectArb.getString(129), JProjectArb.getString(124));
            }
        }
        traversableContext.put("DefaultPackage", (Object)string);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.layMain);
        this.setDefaultTitle(WizardsArb.getString(8));
        this.pnlBottom.setLayout(this.layBottom);
        this.lblTop.setText(JProjectArb.getString(63));
        ResourceUtils.resLabel((JLabel)this.lblDefaultPkg, (Component)this.fldDefaultPkg, (String)JProjectArb.getString(45));
        ResourceUtils.resLabel((JLabel)this.lblSourcePath, (Component)this.fldSourcePath, (String)JProjectArb.getString(46));
        this.fldSourcePath.setEditTitle(JProjectArb.getString(47));
        this.btnSourcePath.addActionListener((ActionListener)this.fldSourcePath);
        ResourceUtils.resButton((AbstractButton)this.btnSourcePath, (String)JProjectArb.getString(41));
        ResourceUtils.resLabel((JLabel)this.lblOutputDirectory, (Component)this.fldOutputDirectory, (String)JProjectArb.getString(140));
        this.btnOutputDirectory.addActionListener((ActionListener)this.fldOutputDirectory);
        ResourceUtils.resButton((AbstractButton)this.btnOutputDirectory, (String)JProjectArb.getString(60));
        this.add((Component)this.lblTop, "North");
        this.pnlBottom.add((Component)this.lblDefaultPkg, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.pnlBottom.add((Component)this.fldDefaultPkg, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 2, 0), 0, 0));
        this.pnlBottom.add((Component)this.lblSourcePath, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0));
        this.pnlBottom.add((Component)this.fldSourcePath, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlBottom.add((Component)this.btnSourcePath, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.pnlBottom.add((Component)this.lblOutputDirectory, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 2, 0), 0, 0));
        this.pnlBottom.add((Component)this.fldOutputDirectory, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.pnlBottom.add((Component)this.btnOutputDirectory, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 8, 0, 0), 0, 0));
        this.add(this.pnlBottom, "Center");
    }
}

