/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.wizard.project;

import java.awt.Window;
import java.net.URL;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.GenericWizardLauncher;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cmd.NewEmptyProjectCommand;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JProjectUtil;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;

public final class ProjectWizardLauncher
extends GenericWizardLauncher {
    public static final String PROJECT_URL_KEY = "ProjectURL";
    public static final String SOURCE_PATH_KEY = "ProjectSourcePath";
    public static final String OUTPUT_DIR_KEY = "OutputDirectory";
    public static final String HTML_SOURCE_DIR_KEY = "HtmlSourceDir";
    public static final String HTML_ROOT_DIR_KEY = "HtmlRootDir";
    public static final String DEFAULT_PACKAGE_KEY = "DefaultPackage";

    public ProjectWizardLauncher(Context context) {
        super(context);
    }

    public ProjectWizardLauncher(Context context, String string) {
        super(context, string);
    }

    public Project runWizard() {
        Project project = null;
        Namespace namespace = this.getNamespace();
        try {
            Context context = (Context)namespace.get("Context");
            Workspace workspace = context.getWorkspace();
            URL uRL = this._getProjectURL(workspace);
            namespace.put(PROJECT_URL_KEY, (Object)uRL);
            if (this.runGenericWizard() && (project = NewEmptyProjectCommand.createProjectInWorkspace(uRL = (URL)namespace.get(PROJECT_URL_KEY), workspace)) != null) {
                JProjectLibraries jProjectLibraries;
                JProjectLibraries jProjectLibraries2;
                URL uRL2;
                String string = !namespace.contains(DEFAULT_PACKAGE_KEY) ? JavaProject.generateDefaultPackageName(project) : (String)namespace.get(DEFAULT_PACKAGE_KEY);
                NewEmptyProjectCommand.setProjectPackage(string, project, workspace);
                URLPath uRLPath = (URLPath)namespace.get(SOURCE_PATH_KEY);
                if (uRLPath != null) {
                    PathsConfiguration.getInstance(project).setProjectSourcePath(uRLPath);
                }
                if ((uRL2 = (URL)namespace.get(HTML_ROOT_DIR_KEY)) != null) {
                    J2eeSettings.getInstance(project).setHtmlRootDirectory(uRL2);
                }
                if ((uRL2 = (URL)namespace.get(OUTPUT_DIR_KEY)) != null) {
                    uRL2 = URLFileSystem.canonicalize((URL)uRL2);
                    JProjectUtil.setOutputDirectory(project, uRL2);
                }
                if ((jProjectLibraries2 = (JProjectLibraries)((Object)namespace.get("oracle.jdevimpl.config.JProjectLibraries"))) != null && (jProjectLibraries = JProjectLibraries.getInstance((PropertyStorage)project)) != null) {
                    jProjectLibraries2.copyTo((Object)jProjectLibraries);
                }
                project.save();
            }
        }
        catch (Exception exception) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)exception);
        }
        return project;
    }

    private URL _getProjectURL(Workspace workspace) {
        DefaultNameGenerator defaultNameGenerator = new DefaultNameGenerator(Project.getDefaultName(), null, 1);
        URL uRL = workspace.getURL();
        URL uRL2 = URLFileSystem.getParent((URL)uRL);
        URL uRL3 = URLFactory.newUniqueURL((URL)uRL2, (NameGenerator)defaultNameGenerator);
        String string = URLFileSystem.getFileName((URL)uRL3);
        if (!URLFileSystem.isDirectoryPath((URL)uRL3)) {
            uRL3 = URLFactory.newDirURL((URL)uRL2, (String)string);
        }
        return URLFactory.newURL((URL)uRL3, (String)(string + ".jpr"));
    }
}

