/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.EventListenerList;
import oracle.javatools.xml.bind.ElementList;
import oracle.javatools.xml.bind.ElementListEvent;
import oracle.javatools.xml.bind.ElementListListener;

public class ArrayElementList
implements ElementList {
    private final Class _type;
    private Object[] _data;
    private final boolean _supportCreate;
    private boolean _bufferEvents;
    private ArrayList _bufferedEvents;
    private EventListenerList _listeners;
    private static final int ADD = 1;
    private static final int REMOVE = 2;
    private static final int CHANGE = 3;

    public ArrayElementList(Class clazz, Object[] objectArray) {
        this(clazz, objectArray, true);
    }

    public ArrayElementList(Class clazz, Object[] objectArray, boolean bl) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        this._type = clazz;
        this._data = objectArray != null ? objectArray : this.newArray(0);
        this._supportCreate = bl;
    }

    public void add(int n, Object object) {
        this.checkType(object);
        int n2 = this.size();
        if (n < 0 || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 + 1;
        Object[] objectArray = this.newArray(n3);
        System.arraycopy(this._data, 0, objectArray, 0, n);
        objectArray[n] = object;
        System.arraycopy(this._data, n, objectArray, n + 1, n2 - n);
        this._data = objectArray;
        this.fireElementsAdded(n, n);
    }

    public void add(Object object) {
        this.checkType(object);
        int n = this.size();
        int n2 = n + 1;
        Object[] objectArray = this.newArray(n2);
        System.arraycopy(this._data, 0, objectArray, 0, n);
        objectArray[n] = object;
        this._data = objectArray;
        if (this._listeners != null) {
            int n3 = this.size() - 1;
            this.fireElementsAdded(n3, n3);
        }
    }

    public void addElementListListener(ElementListListener elementListListener) {
        if (this._listeners == null) {
            this._listeners = new EventListenerList();
        }
        this._listeners.add(ElementListListener.class, elementListListener);
    }

    public void clear() {
        int n = this.size();
        this._data = this.newArray(0);
        if (n > 0) {
            this.fireElementsRemoved(0, n - 1);
        }
    }

    public Object createElement() {
        if (this._supportCreate) {
            try {
                Object t = this._type.newInstance();
                return t;
            }
            catch (Exception exception) {
                IllegalStateException illegalStateException = new IllegalStateException();
                illegalStateException.initCause(exception);
                throw illegalStateException;
            }
        }
        return new Object();
    }

    public Class elementType() {
        return this._type;
    }

    public Object get(int n) {
        return this._data[n];
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new 1();
    }

    public Object remove(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = this.size();
        int n3 = n2 - 1;
        Object[] objectArray = this.newArray(n3);
        System.arraycopy(this._data, 0, objectArray, 0, n);
        Object object = this._data[n];
        System.arraycopy(this._data, n + 1, objectArray, n, n3 - n);
        this._data = objectArray;
        this.fireElementsRemoved(n, n);
        return object;
    }

    public void removeElementListListener(ElementListListener elementListListener) {
        if (this._listeners != null) {
            this._listeners.remove(ElementListListener.class, elementListListener);
        }
    }

    public Object set(int n, Object object) {
        this.checkType(object);
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        Object object2 = this._data[n];
        this._data[n] = object;
        this.fireElementsChanged(n, n);
        return object2;
    }

    public int size() {
        return this._data.length;
    }

    public Object[] getData() {
        return this._data;
    }

    private void startBufferingEvents() {
        if (!this._bufferEvents) {
            this._bufferEvents = true;
            this._bufferedEvents = new ArrayList();
        }
    }

    private void stopBufferingEvents() {
        if (this._bufferEvents) {
            this.fireBufferedEvents();
            this._bufferedEvents = null;
            this._bufferEvents = false;
        }
    }

    private Object[] newArray(int n) {
        return (Object[])Array.newInstance(this._type, n);
    }

    private void checkType(Object object) {
        if (object != null && !this._type.isAssignableFrom(object.getClass())) {
            throw new IllegalArgumentException();
        }
    }

    private void fireBufferedEvents() {
        if (this._bufferedEvents != null) {
            for (int[] nArray : this._bufferedEvents) {
                int n = nArray[0];
                int n2 = nArray[1];
                int n3 = nArray[2];
                switch (n) {
                    case 1: {
                        this.fireElementsAdded0(n2, n3);
                        break;
                    }
                    case 2: {
                        this.fireElementsRemoved0(n2, n3);
                        break;
                    }
                    case 3: {
                        this.fireElementsChanged0(n2, n3);
                    }
                }
            }
        }
    }

    private void fireElementsAdded(int n, int n2) {
        if (this._bufferEvents) {
            this._bufferedEvents.add(new int[]{1, n, n2});
        } else {
            this.fireElementsAdded0(n, n2);
        }
    }

    private void fireElementsAdded0(int n, int n2) {
        if (this._listeners != null) {
            Object[] objectArray = this._listeners.getListenerList();
            ElementListEvent elementListEvent = null;
            int n3 = objectArray.length - 2;
            while (n3 >= 0) {
                if (objectArray[n3] == ElementListListener.class) {
                    if (elementListEvent == null) {
                        elementListEvent = new ElementListEvent((Object)this, n, n2);
                    }
                    ((ElementListListener)objectArray[n3 + 1]).elementsAdded(elementListEvent);
                }
                n3 -= 2;
            }
        }
    }

    private void fireElementsRemoved(int n, int n2) {
        if (this._bufferEvents) {
            this._bufferedEvents.add(new int[]{2, n, n2});
        } else {
            this.fireElementsRemoved0(n, n2);
        }
    }

    private void fireElementsRemoved0(int n, int n2) {
        if (this._listeners != null) {
            Object[] objectArray = this._listeners.getListenerList();
            ElementListEvent elementListEvent = null;
            int n3 = objectArray.length - 2;
            while (n3 >= 0) {
                if (objectArray[n3] == ElementListListener.class) {
                    if (elementListEvent == null) {
                        elementListEvent = new ElementListEvent((Object)this, n, n2);
                    }
                    ((ElementListListener)objectArray[n3 + 1]).elementsRemoved(elementListEvent);
                }
                n3 -= 2;
            }
        }
    }

    private void fireElementsChanged(int n, int n2) {
        if (this._bufferEvents) {
            this._bufferedEvents.add(new int[]{3, n, n2});
        } else {
            this.fireElementsChanged0(n, n2);
        }
    }

    private void fireElementsChanged0(int n, int n2) {
        if (this._listeners != null) {
            Object[] objectArray = this._listeners.getListenerList();
            ElementListEvent elementListEvent = null;
            int n3 = objectArray.length - 2;
            while (n3 >= 0) {
                if (objectArray[n3] == ElementListListener.class) {
                    if (elementListEvent == null) {
                        elementListEvent = new ElementListEvent((Object)this, n, n2);
                    }
                    ((ElementListListener)objectArray[n3 + 1]).elementsChanged(elementListEvent);
                }
                n3 -= 2;
            }
        }
    }

    static Object[] ra$_data(ArrayElementList arrayElementList) {
        return arrayElementList._data;
    }

    public final class 1
    implements Iterator {
        private int _cursor;
        private int _lastRet;

        void $init$() {
            this._cursor = 0;
            this._lastRet = -1;
        }

        public boolean hasNext() {
            return ArrayElementList.this.size() > this._cursor;
        }

        public Object next() {
            this._lastRet = this._cursor++;
            return ArrayElementList.ra$_data(ArrayElementList.this)[this._lastRet];
        }

        public void remove() {
            if (this._lastRet < 0) {
                throw new IllegalStateException();
            }
            ArrayElementList.this.remove(this._lastRet);
            --this._cursor;
            this._lastRet = -1;
        }

        public 1() {
            this.$init$();
        }
    }
}

