/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.awt.Component;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.Iterator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.buffer.DefaultParserConfiguration;
import oracle.bali.xml.dom.buffer.ParserConfiguration;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.MetadataRegistry;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlUsage;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.model.XmlViewFactory;
import oracle.bali.xml.model.view.SimpleTypeElementFilteredView;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.net.URLPath;
import oracle.ide.resource.ModelArb;
import oracle.ide.xml.StartElementPacket;
import oracle.ide.xml.XMLUtil;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.resource.CommonIconsUtils;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.xml.BindingIO;
import oracle.jdeveloper.xml.TextBufferDomIO;
import oracle.jdevimpl.deploy.res.DtArb;
import oracle.jdevimpl.xml.DescriptorNodeDomIO;
import oracle.jdevimpl.xml.DescriptorNodeDt;
import oracle.jdevimpl.xml.ElementDescriptor;
import oracle.xml.parser.v2.XMLDOMImplementation;
import org.w3c.dom.DOMImplementation;

public abstract class DescriptorNode
extends XMLSourceNode {
    public static final int MODULE_LEVEL_DESCRIPTOR = 0;
    public static final int EAR_LEVEL_DESCRIPTOR = 1;
    private final ThreadLocal _tlBindingIO;
    private final ThreadLocal _tlDomIO;
    private Icon _icon;
    private static final Integer INITIAL_CHANGE_ID = new Integer(-2);
    private final ThreadLocal _tlChangeId;

    void $init$() {
        this._tlBindingIO = new ThreadLocal();
        this._tlDomIO = new ThreadLocal();
        this._tlChangeId = new 1();
    }

    protected DescriptorNode() {
        this.$init$();
        Attributes attributes = this.getAttributes();
        attributes.clear();
        attributes.set(ElementAttributes.SAVEABLE | ElementAttributes.CLOSEABLE | ElementAttributes.BUILDABLE | ElementAttributes.DELETEABLE | ElementAttributes.PRINTABLE | ElementAttributes.DEPLOYABLE);
    }

    public Icon getIcon() {
        if (this._icon == null) {
            this._icon = this.getIconImpl();
        }
        return this._icon;
    }

    protected void closeImpl() throws IOException {
        this.reset();
        super.closeImpl();
    }

    public String getDescriptorVersion() {
        try {
            StartElementPacket startElementPacket = XMLUtil.getXMLRootElement((Reader)this.getReader());
            String string = startElementPacket != null ? startElementPacket.systemId : null;
            return string;
        }
        catch (IOException iOException) {
            String string = null;
            return string;
        }
    }

    public Object getDescriptor() throws IOException {
        int n = this.getChangeId();
        if (this.refreshCachedDescriptor(n)) {
            return this.getNewDescriptorImpl(n);
        }
        return ((BindingIO)this._tlBindingIO.get()).getRootProxy();
    }

    public int getPackagingLevel() {
        return 0;
    }

    public final boolean commit() throws IOException {
        return this.commitImpl();
    }

    protected boolean commitImpl() throws IOException {
        this.commitImpl(false);
        return true;
    }

    public final boolean rollback() {
        return this.rollbackImpl();
    }

    protected boolean rollbackImpl() {
        this.clearIO();
        return true;
    }

    public final ElementDescriptor getElementDescriptor(Object object) {
        BindingIO bindingIO = (BindingIO)this._tlBindingIO.get();
        if (bindingIO == null) {
            throw new IllegalStateException("No BindingIO is currently associated with the DescriptorNode.");
        }
        return bindingIO.getElementDescriptor(object);
    }

    public static final void registerDescriptorNode(Class clazz, String string, String string2, Class clazz2) {
        DescriptorNodeDt descriptorNodeDt = new DescriptorNodeDt(clazz, string, string2, clazz2);
        NavigatorManager.getWorkspaceNavigatorManager().addContextMenuListener((ContextMenuListener)descriptorNodeDt, clazz);
    }

    public static Object findInElement(Element element, Class clazz) {
        Iterator iterator;
        if (element != null && (iterator = element.getChildren()) != null) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (e == null || e.getClass() != clazz) continue;
                return e;
            }
        }
        return null;
    }

    public static DescriptorNode findInProject(Project project, Class clazz, String string) {
        URLPath uRLPath = PathsConfiguration.getInstance(project).getProjectSourcePath();
        URL uRL = uRLPath.toBoundURL(string);
        if (uRL != null) {
            try {
                DescriptorNode descriptorNode = (DescriptorNode)NodeFactory.findOrCreate((Class)clazz, (URL)uRL);
                if (descriptorNode != null) {
                    DescriptorNode descriptorNode2 = descriptorNode;
                    return descriptorNode2;
                }
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return (DescriptorNode)((Object)DescriptorNode.findInElement((Element)project, clazz));
    }

    final BindingIO getBindingIO() {
        this.maybeInitIO();
        return (BindingIO)this._tlBindingIO.get();
    }

    final DescriptorNodeDomIO getDomIO() {
        this.maybeInitIO();
        return (DescriptorNodeDomIO)this._tlDomIO.get();
    }

    protected abstract BindingIO newBindingIO();

    protected abstract boolean showDialog(Component var1, Object var2, Context var3);

    protected Icon getIconImpl() {
        return DescriptorNode.getXMLIcon();
    }

    protected String getMetadataID() {
        return null;
    }

    protected DOMImplementation createDOMImplementation() {
        return new XMLDOMImplementation();
    }

    public ParserConfiguration createDomModelCopyParserConfiguration() {
        return new DefaultParserConfiguration();
    }

    public WhitespaceHandler getWhitespaceHandler() {
        return this.getModel(null).getWhitespaceHandler();
    }

    protected MetadataProvider createMetadataProvider(JDevXmlContext jDevXmlContext, boolean bl) {
        MetadataProvider metadataProvider;
        String string;
        if (bl && (string = this.getMetadataID()) != null && (metadataProvider = MetadataRegistry.getInstance().getMetadataProvider(string)) != null) {
            return metadataProvider;
        }
        return super.createMetadataProvider(jDevXmlContext, bl);
    }

    protected void registerViewFactories(JDevXmlContext jDevXmlContext) {
        if (this.getMetadataID() != null) {
            jDevXmlContext.registerViewFactory((XmlViewFactory)new ViewFactory(null));
        }
    }

    private void maybeInitIO() {
        if (this._tlBindingIO.get() == null) {
            this._tlBindingIO.set(this.newBindingIO());
            this._tlDomIO.set(new DescriptorNodeDomIO(this));
        }
    }

    private void clearIO() {
        this._tlBindingIO.set(null);
        DescriptorNodeDomIO descriptorNodeDomIO = (DescriptorNodeDomIO)this._tlDomIO.get();
        if (descriptorNodeDomIO != null) {
            descriptorNodeDomIO.rollback();
            this._tlDomIO.set(null);
        }
    }

    private void reset() {
        this.clearIO();
        this._tlChangeId.set(INITIAL_CHANGE_ID);
    }

    private void commitImpl(boolean bl) throws IOException {
        BindingIO bindingIO = (BindingIO)this._tlBindingIO.get();
        if (bindingIO != null) {
            int n = (Integer)this._tlChangeId.get();
            if (n >= 0 && n != this.getChangeId()) {
                throw new IOException("ERROR: DescriptorNode buffer has been modified since the descriptor was last parsed!");
            }
            DescriptorNodeDomIO descriptorNodeDomIO = (DescriptorNodeDomIO)this._tlDomIO.get();
            if (bl) {
                bindingIO.saveAsynchronously(descriptorNodeDomIO, false);
            } else {
                bindingIO.save(descriptorNodeDomIO, false);
            }
            this.reset();
        }
    }

    void commitToBuffer(TextBuffer textBuffer, boolean bl) throws IOException {
        if (textBuffer == null) {
            throw new IllegalArgumentException();
        }
        BindingIO bindingIO = (BindingIO)this._tlBindingIO.get();
        if (bindingIO == null) {
            throw new IllegalStateException("No BindingIO associated with DescriptorNode.");
        }
        TextBufferDomIO textBufferDomIO = new TextBufferDomIO(textBuffer, this.getURL());
        bindingIO.save(textBufferDomIO, bl);
    }

    static Icon getXMLIcon() {
        ImageIcon imageIcon = (ImageIcon)CommonIconsUtils.getXMLIcon();
        return imageIcon != null ? new ImageIcon(imageIcon.getImage(), DtArb.getString((int)80)) : ModelArb.getIcon((int)15);
    }

    private int getChangeId() {
        TextBuffer textBuffer = this.acquireTextBuffer();
        try {
            int n = textBuffer.getChangeId();
            this.releaseTextBuffer();
            return n;
        }
        catch (Throwable throwable) {
            this.releaseTextBuffer();
            throw throwable;
        }
    }

    private boolean refreshCachedDescriptor(int n) {
        return n != (Integer)this._tlChangeId.get() || this._tlBindingIO.get() == null;
    }

    private Object getNewDescriptorImpl(int n) throws IOException {
        this.clearIO();
        BindingIO bindingIO = this.getBindingIO();
        bindingIO.load((DescriptorNodeDomIO)this._tlDomIO.get());
        this._tlChangeId.set(new Integer(n));
        return bindingIO.getRootProxy();
    }

    static Integer ra$INITIAL_CHANGE_ID() {
        return INITIAL_CHANGE_ID;
    }

    public final class 1
    extends ThreadLocal {
        protected Object initialValue() {
            return DescriptorNode.ra$INITIAL_CHANGE_ID();
        }
    }

    private class ViewFactory
    extends XmlViewFactory {
        public XmlView createView(XmlModel xmlModel, XmlUsage xmlUsage) {
            if (xmlUsage == XmlUsage.XML_CODE_EXPLORER) {
                return new SimpleTypeElementFilteredView();
            }
            return super.createView(xmlModel, xmlUsage);
        }

        private ViewFactory() {
        }

        ViewFactory(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

