/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;
import oracle.bali.xml.dom.DomModelContext;
import oracle.bali.xml.dom.buffer.BufferDomModel;
import oracle.bali.xml.dom.changes.DomChangeUtils;
import oracle.bali.xml.dom.whitespace.WhitespaceHandler;
import oracle.bali.xml.dom.whitespace.WhitespaceUtils;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.cmd.buffer.EditProcessor;
import oracle.ide.model.Node;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.util.SwingClosure;
import oracle.javatools.xml.bind.DOMBindingRuntime;
import oracle.javatools.xml.bind.IndentPrefs;
import oracle.jdeveloper.style.CodingStyleManager;
import oracle.jdeveloper.style.CodingStyleOptions;
import oracle.jdeveloper.xml.DomIO;
import oracle.jdeveloper.xml.TextBufferDomIO;
import oracle.jdevimpl.deploy.res.DtArb;
import oracle.jdevimpl.xml.DescriptorNode;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Document;

final class DescriptorNodeDomIO
extends DomIO {
    private final DescriptorNode _node;
    private static final boolean USE_FREAKY2 = true;
    private static final boolean USE_BALI_XML_MODEL = true;

    static {
        try {
            DOMBindingRuntime.setDefaultIndentPrefs((IndentPrefs)new 4());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    DescriptorNodeDomIO(DescriptorNode descriptorNode) {
        this._node = descriptorNode;
    }

    public Document create() throws IOException {
        XmlModel xmlModel = this.getModel();
        if (xmlModel != null) {
            xmlModel.acquireReadLock();
            try {
                Document document = DescriptorNodeDomIO.getDocument(xmlModel);
                if (document != null && document.getChildNodes().getLength() > 0) {
                    Document document2 = document;
                    xmlModel.releaseReadLock();
                    return document2;
                }
            }
            finally {
                xmlModel.releaseReadLock();
            }
        }
        return super.create();
    }

    public Document load() throws IOException {
        if (!"jar".equals(this._node.getURL().getProtocol())) {
            try {
                XMLDocument xMLDocument = this.getXMLDocument();
                return xMLDocument;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        TextBuffer textBuffer = this._node.acquireTextBuffer();
        try {
            URL uRL = this._node != null ? this._node.getURL() : null;
            TextBufferDomIO textBufferDomIO = new TextBufferDomIO(textBuffer, uRL);
            Document document = textBufferDomIO.load();
            WhitespaceUtils.applyWhitespaceRulesToSubtree((WhitespaceHandler)this._node.getWhitespaceHandler(), null, (org.w3c.dom.Node)document);
            Document document2 = document;
            this._node.releaseTextBuffer();
            return document2;
        }
        catch (Throwable throwable) {
            this._node.releaseTextBuffer();
            throw throwable;
        }
    }

    public void save(Document document) throws IOException {
        block17: {
            if (!"jar".equals(this._node.getURL().getProtocol())) {
                try {
                    ArrayList arrayList;
                    XMLDocument xMLDocument = (XMLDocument)document;
                    BufferDomModel bufferDomModel = (BufferDomModel)xMLDocument.getUserData("dom-model-copy");
                    if (bufferDomModel != null) {
                        try {
                            bufferDomModel.commitTransaction();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if ((arrayList = (ArrayList)xMLDocument.getUserData("undoable-edit-list")) != null && DomChangeUtils.canApplyChanges((List)arrayList)) {
                        XmlModel xmlModel = this.getModel();
                        boolean bl = false;
                        xmlModel.startTransaction("XML Edit");
                        try {
                            DomChangeUtils.applyChanges((List)arrayList, (Document)xmlModel.getDocument());
                            xmlModel.commitTransaction(false);
                            bl = true;
                        }
                        finally {
                            if (!bl) {
                                xmlModel.rollbackTransaction();
                            }
                        }
                        return;
                    }
                    TextBuffer textBuffer = (TextBuffer)xMLDocument.getUserData("text-buffer-copy");
                    if (textBuffer == null) break block17;
                    char[] cArray = null;
                    textBuffer.readLock();
                    try {
                        cArray = textBuffer.getChars(0, textBuffer.getLength());
                    }
                    finally {
                        textBuffer.readUnlock();
                    }
                    if (cArray != null) {
                        this.replaceEntireBuffer(cArray);
                        return;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    System.err.println("**** Warning: DescriptorNodeDomIO could not commit the XmlModel transaction.  Falling back on replacing the entire buffer.");
                }
                catch (XmlCommitException xmlCommitException) {
                    IOException iOException = new IOException();
                    iOException.initCause(xmlCommitException);
                    throw iOException;
                }
            }
        }
        CharArrayWriter charArrayWriter = this.getCharArrayWriter(document);
        this.replaceEntireBuffer(charArrayWriter.toCharArray());
    }

    private void replaceEntireBuffer(char[] cArray) throws IOException {
        DescriptorNodeDomIO.runSwingClosure(new 3(this, false, cArray));
    }

    private static CodingStyleOptions getStyleOptions() {
        CodingStyleManager codingStyleManager = CodingStyleManager.getCodingStyleManager();
        return codingStyleManager.getCodingStyleOptions();
    }

    protected int getIndentSize() {
        return DescriptorNodeDomIO.getStyleOptions().getIndentSize();
    }

    protected boolean getIndentReplaceWithTabs() {
        return DescriptorNodeDomIO.getStyleOptions().getIndentReplaceWithTabs();
    }

    protected int getTabSize() {
        return DescriptorNodeDomIO.getStyleOptions().getTabSize();
    }

    void rollback() {
    }

    private XmlModel getModel() {
        return this._node.getModel(null);
    }

    private XMLDocument getXMLDocument() {
        2 var1_1 = new 2();
        TextBuffer textBuffer = TextBufferFactory.createGapTextBuffer();
        try {
            TextBuffer textBuffer2 = this._node.acquireTextBuffer();
            textBuffer.append(textBuffer2.getChars(0, textBuffer2.getLength()));
        }
        finally {
            this._node.releaseTextBuffer();
        }
        BufferDomModel bufferDomModel = new BufferDomModel((DomModelContext)var1_1, textBuffer, this._node.getDOMImplementation(), this._node.createDomModelCopyParserConfiguration(), this._node.getModel(null).getWhitespaceHandler());
        bufferDomModel.acquireWriteLock();
        Document document = bufferDomModel.getDocument();
        DescriptorNodeDomIO.initDocument(document);
        XMLDocument xMLDocument = (XMLDocument)document;
        ArrayList arrayList = new ArrayList();
        xMLDocument.setUserData("undoable-edit-list", arrayList, null);
        xMLDocument.setUserData("text-buffer-copy", (Object)textBuffer, null);
        xMLDocument.setUserData("dom-model-copy", (Object)bufferDomModel, null);
        bufferDomModel.startTransaction("internal");
        bufferDomModel.addUndoableEditListener((UndoableEditListener)new 1(this, arrayList));
        return xMLDocument;
    }

    private static Document getDocument(XmlModel xmlModel) {
        Document document = xmlModel.getDocument();
        DescriptorNodeDomIO.initDocument(document);
        return document;
    }

    private static void initDocument(Document document) {
        if (document != null) {
            ((XMLDocument)document).setUserData("disable-whitespace-handling", (Object)Boolean.TRUE, null);
        }
    }

    static CodingStyleOptions maS$getStyleOptions() {
        return DescriptorNodeDomIO.getStyleOptions();
    }

    static DescriptorNode ra$_node(DescriptorNodeDomIO descriptorNodeDomIO) {
        return descriptorNodeDomIO._node;
    }

    static final class 4
    extends IndentPrefs {
        public int getWidth() {
            return DescriptorNodeDomIO.maS$getStyleOptions().getIndentSize();
        }

        public boolean getUseSpaces() {
            return DescriptorNodeDomIO.maS$getStyleOptions().getIndentReplaceWithTabs() ^ true;
        }

        public int getTabSize() {
            return DescriptorNodeDomIO.maS$getStyleOptions().getTabSize();
        }
    }

    final class 3
    extends SwingClosure {
        private final /* synthetic */ char[] v$data;
        final /* synthetic */ DescriptorNodeDomIO this$0;

        protected void runImpl() throws Exception {
            EditProcessor.doReplaceAll((char[])this.v$data, (Node)DescriptorNodeDomIO.ra$_node(this.this$0), (boolean)true, (String)DtArb.getString((int)81), (Object)((Object)DescriptorNodeDomIO.ra$_node(this.this$0)));
        }

        public 3(DescriptorNodeDomIO descriptorNodeDomIO, boolean bl, char[] cArray) {
            this.v$data = cArray;
            this.this$0 = descriptorNodeDomIO;
            super(bl);
        }
    }

    final class 2
    extends DomModelContext {
        public String getTranslatedString(String string) {
            return this._real().getTranslatedString(string);
        }

        public Locale getLocale() {
            return this._real().getLocale();
        }

        public org.w3c.dom.Node remapNode(Document document, org.w3c.dom.Node node) {
            return this._real().remapNode(document, node);
        }

        private XmlContext _real() {
            return DescriptorNodeDomIO.ra$_node(DescriptorNodeDomIO.this).getXmlContext(null);
        }
    }

    final class 1
    implements UndoableEditListener {
        private final /* synthetic */ ArrayList v$undoableEditList;
        final /* synthetic */ DescriptorNodeDomIO this$0;

        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            UndoableEdit undoableEdit = undoableEditEvent.getEdit();
            this.v$undoableEditList.add(undoableEdit);
        }

        public 1(DescriptorNodeDomIO descriptorNodeDomIO, ArrayList arrayList) {
            this.v$undoableEditList = arrayList;
            this.this$0 = descriptorNodeDomIO;
        }
    }
}

