/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.awt.Component;
import java.io.IOException;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.marshal.xml.Object2DomException;
import oracle.ide.model.Element;
import oracle.ide.util.IdeUtil;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.deploy.dt.DeployDesignTime;
import oracle.jdeveloper.deploy.dt.DeployMenuItem;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdevimpl.deploy.res.CommonArb;
import oracle.jdevimpl.xml.DescriptorNode;
import oracle.xml.parser.v2.XMLParseException;

final class DescriptorNodeDt
extends DeployDesignTime {
    private final Class _dataClass;
    private final String _settingsMenuItemText;
    private final String _createDeploymentProfileMenuItemText;
    private final Class _createDeploymentProfileDataClass;
    private boolean _initialized;
    private DeployMenuItem _ctxSettings;
    private DeployMenuItem _ctxCreateDeploymentProfile;

    DescriptorNodeDt(Class clazz, String string) {
        this(clazz, string, null, null);
    }

    DescriptorNodeDt(Class clazz, String string, String string2, Class clazz2) {
        if (clazz == null) {
            throw new IllegalArgumentException(CommonArb.getString((int)14));
        }
        if (!DescriptorNode.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException(CommonArb.getString((int)15));
        }
        this._dataClass = clazz;
        this._settingsMenuItemText = string;
        this._createDeploymentProfileMenuItemText = string2;
        if (string2 != null && clazz2 == null) {
            throw new IllegalArgumentException("Argument createDeploymentProfileDataClass must not be null, if createDeploymentProfileMenuItemText is not null.");
        }
        this._createDeploymentProfileDataClass = clazz2;
    }

    protected String getDefaultCommand() {
        return null;
    }

    protected String getLabelForCommand(String string) {
        return null;
    }

    public void menuWillShow(ContextMenu contextMenu) {
        if (DescriptorNodeDt.isInSupportedNavigator((ContextMenu)contextMenu)) {
            this.maybeInitializeContextMenuItems();
            float f = 0.01f;
            if (this._ctxSettings != null) {
                contextMenu.add((Component)this._ctxSettings.menuItem, JDeveloperMenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
            }
            if (this._ctxCreateDeploymentProfile != null) {
                f = JDeveloperMenuConstants.SECTION_ADDITIONAL_CTXT_MENU - 0.01f;
                contextMenu.add((Component)this._ctxCreateDeploymentProfile.menuItem, f);
            }
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (this._ctxSettings != null && n == this._ctxSettings.id) {
            this.showSettingsDialog(context);
            return true;
        }
        if (this._ctxCreateDeploymentProfile != null && n == this._ctxCreateDeploymentProfile.id) {
            Deployment.invokeNewDeploymentProfileWizard((Class)this._createDeploymentProfileDataClass, (Context)context);
            return true;
        }
        return false;
    }

    private boolean showSettingsDialog(Context context) {
        Element element = context.getElement();
        if (element != null && this._dataClass.isAssignableFrom(element.getClass())) {
            DescriptorNode descriptorNode = (DescriptorNode)element;
            Object object = null;
            try {
                object = descriptorNode.getDescriptor();
            }
            catch (Object2DomException object2DomException) {
                Exception exception = object2DomException.getChainedException();
                String string = descriptorNode.getShortLabel();
                if (exception instanceof XMLParseException) {
                    this.handleXMLParseException(string, (XMLParseException)((Object)exception));
                } else {
                    MessageDialog.error((Component)IdeUtil.getMainWindow(), (Object)CommonArb.format((int)20, (Object)string, (Object)("\n\n" + exception.getLocalizedMessage() + "\n\n")), (String)CommonArb.format((int)19, (Object)string), null);
                }
                boolean bl = true;
                return bl;
            }
            catch (IOException iOException) {
                Throwable throwable = iOException.getCause();
                String string = descriptorNode.getShortLabel();
                if (throwable instanceof XMLParseException) {
                    this.handleXMLParseException(string, (XMLParseException)throwable);
                } else {
                    MessageDialog.error((Component)IdeUtil.getMainWindow(), (Object)CommonArb.format((int)22, (Object)string), (String)CommonArb.format((int)21, (Object)string), null);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = descriptorNode.showDialog(IdeUtil.getMainWindow(), object, context);
            try {
                if (bl) {
                    descriptorNode.commit();
                } else {
                    descriptorNode.rollback();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return true;
        }
        return false;
    }

    private void maybeInitializeContextMenuItems() {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
        if (this._settingsMenuItemText != null) {
            String string = this._dataClass.getName() + ".";
            this._ctxSettings = new DeployMenuItem(string + "_ctxSettings", this._settingsMenuItemText, (Controller)this);
        }
        if (this._createDeploymentProfileMenuItemText != null) {
            this._ctxCreateDeploymentProfile = new DeployMenuItem(this._dataClass.getName() + "." + "_ctxCreateDeploymentProfile", this._createDeploymentProfileMenuItemText, (Controller)this);
        }
    }

    private void handleXMLParseException(String string, XMLParseException xMLParseException) {
        int n = xMLParseException.getNumMessages();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            int n3 = xMLParseException.getLineNumber(n2);
            String string2 = xMLParseException.getMessage(n2);
            stringBuffer.append(CommonArb.format((int)16, (Object)Integer.toString(n3), (Object)string2) + "\n");
            ++n2;
        }
        MessageDialog.error((Component)IdeUtil.getMainWindow(), (Object)CommonArb.format((int)18, (Object)string, (Object)("\n\n" + stringBuffer.toString() + "\n")), (String)CommonArb.format((int)17, (Object)string), null);
    }
}

