/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.io.IOException;
import java.net.URL;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.xml.BindingIO;
import oracle.jdevimpl.deploy.res.DtArb;
import oracle.jdevimpl.xml.DescriptorNode;

public class DescriptorNodeFactory {
    private final boolean _isForWebInf;
    private final String _relativePath;
    private final URL _descriptorURL;
    private final Class _nodeClass;

    public DescriptorNodeFactory(String string, Class clazz) {
        this(false, string, null, clazz);
    }

    public DescriptorNodeFactory(boolean bl, String string, Class clazz) {
        this(bl, string, null, clazz);
    }

    public DescriptorNodeFactory(URL uRL, Class clazz) {
        this(false, null, uRL, clazz);
    }

    private DescriptorNodeFactory(boolean bl, String string, URL uRL, Class clazz) {
        this._isForWebInf = bl;
        this._relativePath = string;
        this._descriptorURL = uRL;
        this._nodeClass = clazz;
    }

    public final DescriptorNode findOrCreateIn(Project project, String string, boolean bl, boolean bl2, boolean bl3) throws DeployException {
        try {
            URL uRL = this.getDescriptorURL(project);
            if (uRL != null) {
                Object object;
                DescriptorNode descriptorNode = (DescriptorNode)NodeFactory.findOrCreate((Class)this._nodeClass, (URL)uRL);
                Object object2 = object = descriptorNode.hasEmptyTextBuffer() ? this.newDescriptorImpl(descriptorNode, string) : this.autoUpdateDescriptor(descriptorNode);
                if (object != null) {
                    this.flushAndSave(descriptorNode);
                }
                if (bl) {
                    project.add((Node)descriptorNode, this.getContentSetKey());
                }
                if (bl2) {
                    EditorUtil.openExplicitDefaultEditorInFrame((URL)uRL);
                }
                DescriptorNode descriptorNode2 = descriptorNode;
                return descriptorNode2;
            }
            DescriptorNode descriptorNode = null;
            return descriptorNode;
        }
        catch (DeployException deployException) {
            throw deployException;
        }
        catch (Exception exception) {
            throw new DeployException((Throwable)exception);
        }
    }

    protected Object newDescriptor(DescriptorNode descriptorNode, String string) throws IOException {
        BindingIO bindingIO = descriptorNode.getBindingIO();
        return bindingIO.create(string, descriptorNode.getDomIO());
    }

    protected Object autoUpdateDescriptor(DescriptorNode descriptorNode) throws IOException {
        return null;
    }

    protected String getContentSetKey() {
        return PathsConfiguration.JAVA_CONTENT_SET_KEY;
    }

    private URL getDescriptorURL(Project project) {
        if (this._descriptorURL != null) {
            return this._descriptorURL;
        }
        if (project != null) {
            URL uRL;
            URL uRL2 = uRL = this._isForWebInf ? J2eeSettings.getInstance(project).getHtmlRootDirectory() : DescriptorNodeFactory.getSourceDir(project);
            if (uRL != null) {
                return URLFactory.newURL((URL)uRL, (String)this._relativePath);
            }
        }
        return null;
    }

    private static URL getSourceDir(Project project) {
        URLPath uRLPath = PathsConfiguration.getInstance(project).getProjectSourcePath();
        if (uRLPath != null) {
            return uRLPath.getFirstEntry();
        }
        return null;
    }

    private Object newDescriptorImpl(DescriptorNode descriptorNode, String string) throws IOException {
        Object object = this.newDescriptor(descriptorNode, string);
        if (object instanceof Dirtyable) {
            ((Dirtyable)object).markDirty(true);
        }
        return object;
    }

    private void flushAndSave(DescriptorNode descriptorNode) throws DeployException {
        try {
            descriptorNode.commit();
            descriptorNode.save();
        }
        catch (IOException iOException) {
            throw new DeployException(DtArb.format((int)82, (Object)(this._descriptorURL != null ? this._descriptorURL.toExternalForm() : this._relativePath), (Object)iOException.getLocalizedMessage()));
        }
    }
}

