/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.util.Iterator;
import javax.swing.AbstractListModel;
import javax.swing.JList;
import oracle.javatools.xml.bind.ElementList;
import oracle.javatools.xml.bind.ElementListEvent;
import oracle.javatools.xml.bind.ElementListListener;

public class ElementListModel
extends AbstractListModel
implements ElementListListener {
    private final JList _jList;
    private ElementList _elementList;

    public ElementListModel(JList jList) {
        this(null, jList);
    }

    public ElementListModel(ElementList elementList, JList jList) {
        if (jList == null) {
            throw new IllegalArgumentException();
        }
        this._jList = jList;
        this._elementList = elementList != null ? elementList : new NullElementList(null);
    }

    public void setElementList(ElementList elementList) {
        if (elementList == null) {
            elementList = new NullElementList(null);
        }
        int n = this._jList.getSelectedIndex();
        int n2 = this._elementList.size() - 1;
        if (n2 >= 0) {
            this.fireIntervalRemoved(this, 0, n2);
        }
        this._elementList = elementList;
        int n3 = elementList.size() - 1;
        if (n3 >= 0) {
            this.fireIntervalAdded(this, 0, n3);
        }
        if (n > 0 && n <= n3) {
            this._jList.setSelectedIndex(n);
        }
    }

    public Object getElementAt(int n) {
        return this._elementList.get(n);
    }

    public int getSize() {
        return this._elementList.size();
    }

    public void elementsAdded(ElementListEvent elementListEvent) {
        int n = elementListEvent.getStartIndex();
        this.fireIntervalAdded(this, n, elementListEvent.getEndIndex());
        this._jList.setSelectedIndex(n);
    }

    public void elementsRemoved(ElementListEvent elementListEvent) {
        this.fireIntervalRemoved(this, elementListEvent.getStartIndex(), elementListEvent.getEndIndex());
    }

    public void elementsChanged(ElementListEvent elementListEvent) {
        this.fireContentsChanged(this, elementListEvent.getStartIndex(), elementListEvent.getEndIndex());
    }

    private static class NullElementList
    implements ElementList {
        public void add(int n, Object object) {
        }

        public void add(Object object) {
        }

        public void addElementListListener(ElementListListener elementListListener) {
        }

        public void clear() {
        }

        public Object createElement() {
            return null;
        }

        public Class elementType() {
            return null;
        }

        public Object get(int n) {
            return null;
        }

        public boolean isEmpty() {
            return true;
        }

        public Iterator iterator() {
            return null;
        }

        public Object remove(int n) {
            return null;
        }

        public void removeElementListListener(ElementListListener elementListListener) {
        }

        public Object set(int n, Object object) {
            return null;
        }

        public int size() {
            return 0;
        }

        private NullElementList() {
        }

        NullElementList(1 var1_1) {
            this();
        }

        public final class 1 {
        }
    }
}

