/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.awt.Component;
import java.util.Arrays;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.javatools.util.Copyable;
import oracle.javatools.xml.bind.ElementList;
import oracle.javatools.xml.bind.ElementListListener;
import oracle.jdevimpl.xml.DetailPanel;
import oracle.jdevimpl.xml.TwoColumnPanel;

abstract class ElementListPanel
extends TwoColumnPanel {
    private transient ElementList _elementList;
    private transient TraversableContext _tc;

    public ElementListPanel() {
    }

    protected ElementListPanel(boolean bl) {
        super(bl);
    }

    protected ElementListPanel(int n) {
        super(n);
    }

    protected ElementListPanel(int n, boolean bl) {
        super(n, bl);
    }

    public void onEntry(TraversableContext traversableContext) {
        this._tc = traversableContext;
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
    }

    protected abstract ElementListListener newElementListListener();

    protected abstract int[] getSelectedIndexes();

    protected abstract void setSelectedIndexes(int[] var1);

    protected abstract String getElementListItemKey();

    protected abstract DetailPanel newCreatePanel();

    public Object create(TraversableContext traversableContext) {
        DetailPanel detailPanel = this.newCreatePanel();
        if (detailPanel != null) {
            return this.createImpl(detailPanel, traversableContext);
        }
        return null;
    }

    public Object[] delete(TraversableContext traversableContext) {
        int[] nArray = this.getSelectedIndexes();
        Arrays.sort(nArray);
        int n = nArray.length;
        Object[] objectArray = new Object[n];
        ElementList elementList = this.getElementList();
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            n2 = nArray[n3];
            objectArray[n3] = elementList.remove(n2);
            --n3;
        }
        this.postDelete(objectArray, traversableContext);
        this.setSelectedIndexes(new int[]{n2});
        return objectArray;
    }

    protected void postDelete(Object[] objectArray, TraversableContext traversableContext) {
    }

    public void moveUp(TraversableContext traversableContext) {
        int n = this.getAndAssertMoveIndex("moveUp()");
        if (n <= 0) {
            throw new IllegalStateException("moveUp() called when element can't move up");
        }
        ElementList elementList = this.getElementList();
        Object object = elementList.remove(n);
        elementList.add(n - 1, object);
    }

    public void moveDown(TraversableContext traversableContext) {
        ElementList elementList;
        int n = this.getAndAssertMoveIndex("moveDown()");
        if (n >= (elementList = this.getElementList()).size()) {
            throw new IllegalStateException("moveDown() called when element can't move down");
        }
        Object object = elementList.remove(n);
        elementList.add(n + 1, object);
    }

    protected final TraversableContext getTraversableContext() {
        return this._tc;
    }

    protected final ElementList getElementList() {
        return this._elementList;
    }

    protected void setElementList(ElementList elementList) {
        this._elementList = elementList;
        ElementListListener elementListListener = this.newElementListListener();
        if (this._elementList != null) {
            this._elementList.addElementListListener(elementListListener);
        }
    }

    protected TraversableContext newTraversableContext(TraversableContext traversableContext, Object object) {
        Namespace namespace = new Namespace((Namespace)traversableContext);
        String string = this.getElementListItemKey();
        namespace.put(string, object);
        TraversableContext traversableContext2 = new TraversableContext(namespace, 0);
        traversableContext2.putDesignTimeObject("DetailPanel.detail-data", (Object)string);
        return traversableContext2;
    }

    protected boolean shouldSortData() {
        return true;
    }

    protected boolean prependNewItems() {
        return false;
    }

    private Object createImpl(DetailPanel detailPanel, TraversableContext traversableContext) {
        ElementList elementList = this.getElementList();
        Class clazz = elementList.elementType();
        Object object = clazz != null && (clazz.isInterface() || Copyable.class.isAssignableFrom(clazz)) ? elementList.createElement() : "";
        TraversableContext traversableContext2 = this.newTraversableContext(traversableContext, object);
        TDialogLauncher tDialogLauncher = detailPanel.getTDialogLauncher((Component)((Object)this), (Namespace)traversableContext2);
        boolean bl = tDialogLauncher.showDialog();
        if (bl) {
            Object object2 = traversableContext2.find(this.getElementListItemKey());
            if (this.prependNewItems()) {
                elementList.add(0, object2);
            } else {
                elementList.add(object2);
            }
            return object2;
        }
        return null;
    }

    private int getAndAssertMoveIndex(String string) {
        int[] nArray = this.getSelectedIndexes();
        int n = nArray.length;
        if (n == 0) {
            throw new IllegalStateException(string + " called when no element selected");
        }
        if (n > 1) {
            throw new IllegalStateException(string + " called when there are multiple selections");
        }
        return nArray[0];
    }
}

