/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.xml.bind.ElementList;
import oracle.javatools.xml.bind.ElementListEvent;
import oracle.javatools.xml.bind.ElementListListener;
import oracle.jdeveloper.deploy.res.DeployArb;
import oracle.jdevimpl.deploy.common.UpdateListModel;
import oracle.jdevimpl.deploy.res.J2eeArb;
import oracle.jdevimpl.xml.ElementListPanel;
import oracle.jdevimpl.xml.XmlArb;

public abstract class MasterPanel
extends ElementListPanel {
    public static final String MASTER_LIST = "MasterPanel.masterList";
    private final L _listener;
    private final UpdateListModel _listModel;
    private final JLabel _lblList;
    private final JScrollPane _spMaster;
    private final JList _listMaster;
    private final JButton _btnAdd;
    private final JButton _btnDelete;
    private final boolean _showUpDownButtons;
    private final JButton _btnMoveUp;
    private final JButton _btnMoveDown;
    private final Traversable _detailPanel;
    private transient ListModelImpl _listModelImpl;
    transient int _curIndex;
    protected transient Object _curData;

    void $init$() {
        this._listener = new L(null);
        this._listModel = new UpdateListModel();
        this._lblList = new JLabel();
        this._spMaster = new JScrollPane();
        this._listMaster = new JList(this._listModel);
        this._btnAdd = new JButton();
        this._btnDelete = new JButton();
        this._curIndex = -1;
    }

    protected MasterPanel(String string, String string2) {
        this(string, string2, false);
    }

    protected MasterPanel(String string, String string2, boolean bl) {
        this.$init$();
        this._showUpDownButtons = bl;
        ResourceUtils.resLabel((JLabel)this._lblList, (Component)this._listMaster, (String)string);
        Dimension dimension = new Dimension(10, 10);
        this._listMaster.setMinimumSize(dimension);
        this._listMaster.setSelectionMode(0);
        this._listMaster.addListSelectionListener(this._listener);
        this._listMaster.setCellRenderer(this._listener);
        this._spMaster.setMinimumSize(dimension);
        this._spMaster.setPreferredSize(dimension);
        this._spMaster.getViewport().add((Component)this._listMaster, null);
        this.initButton(this._btnAdd, this.getAddButtonLabel());
        this.initButton(this._btnDelete, this.getDeleteButtonLabel());
        if (this._showUpDownButtons) {
            this._btnMoveUp = new JButton();
            this._btnMoveDown = new JButton();
            this.initButton(this._btnMoveUp, J2eeArb.getString((int)55));
            this.initButton(this._btnMoveDown, J2eeArb.getString((int)56));
        } else {
            this._btnMoveUp = null;
            this._btnMoveDown = null;
        }
        this._detailPanel = this.newDetailPanel();
        this.layoutComponents(0, 0);
        this.setHelpID(string2);
    }

    protected void layoutComponents(int n, int n2) {
        Insets insets = new Insets(5, 5, 3, 0);
        Insets insets2 = new Insets(0, 5, 0, 5);
        Insets insets3 = new Insets(3, 3, 5, 5);
        this.add(this._lblList, this.gbc(n, n2, 1, 1, 0.0, 0.0, 18, 2, insets));
        this.add(this._spMaster, this.gbc(n, n2 + 1, 1, 10, 1.0, 1.0, 18, 1, insets2));
        this.add(this._btnAdd, this.gbc(n + 1, n2 + 1, 1, 1, 0.0, 0.0, 18, 2, insets3));
        this.add(this._btnDelete, this.gbc(n + 1, n2 + 2, 1, 1, 0.0, 0.0, 18, 2, insets3));
        if (this._showUpDownButtons) {
            this.add(this._btnMoveUp, this.gbc(n + 1, n2 + 3, 1, 1, 0.0, 0.0, 18, 2, insets3));
            this.add(this._btnMoveDown, this.gbc(n + 1, n2 + 4, 1, 1, 0.0, 0.0, 18, 2, insets3));
        }
        if (this._detailPanel != null) {
            Component component = this._detailPanel.getComponent();
            if (this.isDetailBorderDrawn() && component instanceof JComponent) {
                ((JComponent)component).setBorder(BorderFactory.createEtchedBorder());
            }
            this.add(component, this.gbc(n, n2 + 11, 2, 1, 0.0, 0.0, 18, 1, insets));
        }
    }

    private void initButton(JButton jButton, String string) {
        ResourceUtils.resButton((AbstractButton)jButton, (String)string);
        jButton.addActionListener(this._listener);
    }

    protected String getAddButtonLabel() {
        return DeployArb.getString((int)28);
    }

    protected String getDeleteButtonLabel() {
        return DeployArb.getString((int)30);
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            bl = this.isReadOnly() ^ true;
        }
        if (this._listMaster != null) {
            this._listMaster.removeAll();
            this._listMaster.setEnabled(bl);
        }
        if (this._btnAdd != null) {
            this._btnAdd.setEnabled(bl);
        }
        if (this._btnDelete != null) {
            this._btnDelete.setEnabled(bl);
        }
        if (this._btnMoveUp != null) {
            this._btnMoveUp.setEnabled(bl);
        }
        if (this._btnMoveDown != null) {
            this._btnMoveDown.setEnabled(bl);
        }
        super.setEnabled(bl);
    }

    public final void onEntry(TraversableContext traversableContext) {
        super.onEntry(traversableContext);
        this.onEntryImpl(traversableContext);
        this._curIndex = -1;
        this._curData = this.getSelectedMasterValue();
        this.enterDetailPanel(traversableContext);
    }

    protected abstract void onEntryImpl(TraversableContext var1);

    public final void onExit(TraversableContext traversableContext) throws TraversalException {
        super.onExit(traversableContext);
        this.exitDetailPanel(traversableContext);
        this.onExitImpl(traversableContext);
    }

    protected void onExitImpl(TraversableContext traversableContext) throws TraversalException {
    }

    public String getHelpID() {
        String string;
        if (this._detailPanel != null && (string = this._detailPanel.getHelpID()) != null) {
            return string;
        }
        return super.getHelpID();
    }

    protected ElementListListener newElementListListener() {
        this._listModelImpl = new ListModelImpl(null);
        return this._listModelImpl;
    }

    protected final int[] getSelectedIndexes() {
        return new int[]{this._listMaster.getSelectedIndex()};
    }

    protected final void setSelectedIndexes(int[] nArray) {
        int n;
        if (nArray != null && nArray.length > 0 && (n = this.getElementList().size() - 1) >= 0) {
            int n2 = nArray.length;
            int n3 = 0;
            while (n3 < n2) {
                nArray[n3] = Math.min(nArray[n3], n);
                ++n3;
            }
            this._listMaster.setSelectedIndices(nArray);
        }
    }

    protected final void setElementList(ElementList elementList) {
        super.setElementList(elementList);
        this.setAddButtonEnabled(this.getElementList() != null);
        this._listMaster.setModel(this._listModelImpl);
    }

    protected final int getElementListSize() {
        return this._listMaster.getModel().getSize();
    }

    protected TraversableContext newTraversableContext(TraversableContext traversableContext, Object object) {
        TraversableContext traversableContext2 = super.newTraversableContext(traversableContext, object);
        traversableContext2.putDesignTimeObject(MASTER_LIST, (Object)this._listMaster);
        return traversableContext2;
    }

    protected abstract Traversable newDetailPanel();

    protected abstract String getDisplayName(Object var1);

    protected boolean isDetailBorderDrawn() {
        return false;
    }

    protected final void clearSelectedMaster() {
        this._listMaster.clearSelection();
    }

    protected final void setSelectedMasterIndex(int n) {
        this._listMaster.setSelectedIndex(n);
    }

    protected final Object getSelectedMasterValue() {
        Object[] objectArray = this._listMaster.getSelectedValues();
        return objectArray.length == 1 ? objectArray[0] : null;
    }

    protected void enterDetailPanel(TraversableContext traversableContext) {
        if (this._detailPanel != null) {
            this._detailPanel.onEntry(this.newTraversableContext(traversableContext, this._curData));
        }
        this.updateButtons();
    }

    protected void exitDetailPanel(TraversableContext traversableContext) throws TraversalException {
        if (this._detailPanel != null && this._curData != null) {
            this._detailPanel.onExit(this.newTraversableContext(traversableContext, this._curData));
        }
    }

    protected void setAddButtonEnabled(boolean bl) {
        this._btnAdd.setEnabled(bl && !this.isReadOnly());
    }

    protected void setDeleteButtonEnabled(boolean bl) {
        this._btnDelete.setEnabled(bl && !this.isReadOnly());
    }

    protected void setListFont(Font font) {
        this._listMaster.setFont(font);
    }

    private void updateButtons() {
        boolean bl = this.getSelectedMasterValue() != null;
        this.setDeleteButtonEnabled(bl);
        if (this._showUpDownButtons) {
            int[] nArray = this.getSelectedIndexes();
            if (nArray.length == 1) {
                int n = nArray[0];
                this._btnMoveUp.setEnabled(bl && n > 0 && !this.isReadOnly());
                this._btnMoveDown.setEnabled(bl && n < this.getElementList().size() - 1 && !this.isReadOnly());
            } else {
                this._btnMoveUp.setEnabled(false);
                this._btnMoveDown.setEnabled(false);
            }
        }
    }

    private void loadNewDetails() {
        int n;
        int[] nArray = this.getSelectedIndexes();
        int n2 = n = nArray.length == 1 ? nArray[0] : -1;
        if (n != this._curIndex) {
            try {
                TraversableContext traversableContext = this.getTraversableContext();
                this.exitDetailPanel(traversableContext);
                this._curIndex = n;
                this._curData = this.getSelectedMasterValue();
                this.enterDetailPanel(traversableContext);
            }
            catch (TraversalException traversalException) {
                traversalException.showMessageDialog((Component)((Object)this));
                this._listMaster.setSelectedValue(this._curData, true);
            }
        }
    }

    private void handleButtonEvent(Object object) {
        TraversableContext traversableContext = this.getTraversableContext();
        if (object == this._btnAdd) {
            try {
                this.exitDetailPanel(traversableContext);
                this.create(traversableContext);
            }
            catch (TraversalException traversalException) {
                traversalException.showMessageDialog((Component)((Object)this));
            }
        } else if (object == this._btnDelete) {
            this.delete(traversableContext);
        } else if (this._showUpDownButtons) {
            if (object == this._btnMoveUp) {
                this.moveUp(traversableContext);
            } else if (object == this._btnMoveDown) {
                this.moveDown(traversableContext);
            }
        }
    }

    static JList ra$_listMaster(MasterPanel masterPanel) {
        return masterPanel._listMaster;
    }

    static void mav$handleButtonEvent(MasterPanel masterPanel, Object object) {
        masterPanel.handleButtonEvent(object);
    }

    static void mav$loadNewDetails(MasterPanel masterPanel) {
        masterPanel.loadNewDetails();
    }

    private class ListModelImpl
    extends AbstractListModel
    implements ElementListListener {
        public Object getElementAt(int n) {
            return MasterPanel.this.getElementList().get(n);
        }

        public int getSize() {
            ElementList elementList = MasterPanel.this.getElementList();
            return elementList != null ? elementList.size() : 0;
        }

        public void elementsAdded(ElementListEvent elementListEvent) {
            int n = elementListEvent.getStartIndex();
            this.fireIntervalAdded(this, n, elementListEvent.getEndIndex());
            MasterPanel.ra$_listMaster(MasterPanel.this).setSelectedIndex(n);
        }

        public void elementsRemoved(ElementListEvent elementListEvent) {
            this.fireIntervalRemoved(this, elementListEvent.getStartIndex(), elementListEvent.getEndIndex());
        }

        public void elementsChanged(ElementListEvent elementListEvent) {
            this.fireContentsChanged(this, elementListEvent.getStartIndex(), elementListEvent.getEndIndex());
        }

        private ListModelImpl() {
        }

        ListModelImpl(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class L
    extends DefaultListCellRenderer
    implements ActionListener,
    ListSelectionListener {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            String string2 = string = object != null ? MasterPanel.this.getDisplayName(object) : XmlArb.getString(0);
            if (!ModelUtil.hasLength((String)string)) {
                string = XmlArb.getString(1);
            }
            return super.getListCellRendererComponent((JList<?>)jList, string, n, bl, bl2);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            MasterPanel.mav$loadNewDetails(MasterPanel.this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MasterPanel.mav$handleButtonEvent(MasterPanel.this, actionEvent.getSource());
        }

        private L() {
        }

        L(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

