/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import oracle.ide.controls.VerticalFlowLayout;
import oracle.ide.model.Dirtyable;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.ide.panels.MDDAdapter;
import oracle.ide.panels.MDDEvent;
import oracle.ide.panels.MDDListener;
import oracle.ide.panels.MDDPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.resource.IdeIcons;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.SwingUtils;
import oracle.jdevimpl.xml.CreateSupport;
import oracle.jdevimpl.xml.DeleteSupport;
import oracle.jdevimpl.xml.ReorderSupport;
import oracle.jdevimpl.xml.XmlArb;

public abstract class ModalEditor {
    private final Object _data;
    private final boolean _isCopyable;
    private final boolean _showNewDeleteButtons;
    private final boolean _showUpDownButtons;

    public ModalEditor(Object object) {
        this(object, false, false);
    }

    public ModalEditor(Copyable copyable) {
        this(copyable, false, false);
    }

    public ModalEditor(Object object, boolean bl, boolean bl2) {
        this(object, false, bl, bl2);
    }

    public ModalEditor(Copyable copyable, boolean bl, boolean bl2) {
        this(copyable, true, bl, bl2);
    }

    private ModalEditor(Object object, boolean bl, boolean bl2, boolean bl3) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
        this._data = object;
        this._isCopyable = bl;
        this._showNewDeleteButtons = bl2;
        this._showUpDownButtons = bl3;
    }

    public boolean showDialog() {
        return this.showDialog(SwingUtils.getMainWindow());
    }

    public boolean showDialog(Component component) {
        String string = this.getTitle();
        MDDPanel mDDPanel = this.createMDDPanel();
        Namespace namespace = new Namespace();
        String string2 = this.getDataKey();
        Object object = this._isCopyable ? (this._data != null ? ((Copyable)this._data).copyTo(null) : null) : this._data;
        namespace.put(string2, object);
        this.scatterData(namespace);
        TDialogLauncher tDialogLauncher = new TDialogLauncher(component, string, (Traversable)mDDPanel, namespace, null, this.getSources(namespace));
        this.initMDDPanel(mDDPanel);
        this.initNDRButtons(mDDPanel);
        this.initLauncher(tDialogLauncher);
        boolean bl = tDialogLauncher.showDialog();
        if (bl) {
            this.gatherData(namespace);
            this.committingChanges(namespace);
            Object object2 = namespace.get(string2);
            if (this._isCopyable && ModelUtil.areDifferent((Object)this._data, (Object)object2)) {
                ((Copyable)object2).copyTo(this._data);
                if (this._data instanceof Dirtyable) {
                    ((Dirtyable)this._data).markDirty(true);
                }
                if (this._data instanceof Subject) {
                    UpdateMessage.fireStructureChanged((Subject)((Subject)this._data));
                }
            }
            return true;
        }
        return false;
    }

    protected static Navigable setHelpID(String string, Navigable navigable) {
        navigable.setHelpID(string);
        return navigable;
    }

    protected MDDPanel createMDDPanel() {
        return new MDDPanel(this.getNavigables(), this.isUseDetailTree());
    }

    protected abstract String getTitle();

    protected abstract Navigable[] getNavigables();

    protected boolean isUseDetailTree() {
        return false;
    }

    protected boolean isShowNewDeleteButtons() {
        return this._showNewDeleteButtons;
    }

    protected boolean isShowUpDownButtons() {
        return this._showUpDownButtons;
    }

    protected Object getData() {
        return this._data;
    }

    protected abstract String getDataKey();

    protected void scatterData(Namespace namespace) {
    }

    protected void gatherData(Namespace namespace) {
    }

    protected int getInitialTreeExpansionDepth() {
        return 3;
    }

    protected void initMDDPanel(MDDPanel mDDPanel) {
        int n = this.getInitialTreeExpansionDepth();
        if (n > 0) {
            mDDPanel.expandTree1ToDepth(n);
        }
    }

    protected void initLauncher(TDialogLauncher tDialogLauncher) {
        tDialogLauncher.setInitialSize(700, 500);
    }

    protected void committingChanges(Namespace namespace) {
    }

    protected Node[] getSources(Namespace namespace) {
        return null;
    }

    private static JComponent createPanel(String string, boolean bl, boolean bl2) {
        boolean bl3 = "North".equals(string) || "South".equals(string);
        int n = bl2 ? 5 : 0;
        int n2 = bl2 ? 5 : 0;
        FlowLayout flowLayout = bl3 ^ bl ? new FlowLayout(1, n, n2) : new VerticalFlowLayout(1, n, n2, true, false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(flowLayout);
        return jPanel;
    }

    private void initNDRButtons(MDDPanel mDDPanel) {
        String string = "South";
        String string2 = "East";
        String string3 = "West";
        boolean bl = false;
        int n = 0;
        JComponent jComponent = null;
        JComponent jComponent2 = null;
        if (this.isShowUpDownButtons()) {
            JComponent jComponent3;
            jComponent = jComponent3 = ModalEditor.createPanel("East", false, true);
            MDDAdapter mDDAdapter = this.initUpDownButtons(jComponent3);
            mDDPanel.addMDDListener((MDDListener)mDDAdapter);
            ++n;
        }
        if (this.isShowNewDeleteButtons()) {
            JComponent jComponent4;
            jComponent2 = jComponent4 = ModalEditor.createPanel("South", false, true);
            MDDAdapter mDDAdapter = this.initNewDeleteButtons(jComponent4);
            mDDPanel.addMDDListener((MDDListener)mDDAdapter);
            ++n;
        }
        if (n == 2 && "East" == "South") {
            JComponent jComponent5 = ModalEditor.createPanel("West", true, false);
            jComponent5.add(jComponent);
            if ("West".equals("West") || "North".equals("West")) {
                jComponent5.add((Component)jComponent2, 0);
            } else {
                jComponent5.add(jComponent2);
            }
            mDDPanel.addTreePanelComponent((Component)jComponent5, (Object)"South");
        } else {
            if (jComponent != null) {
                mDDPanel.addTreePanelComponent((Component)jComponent, (Object)"East");
            }
            if (jComponent2 != null) {
                mDDPanel.addTreePanelComponent((Component)jComponent2, (Object)"South");
            }
        }
    }

    private MDDAdapter initUpDownButtons(JComponent jComponent) {
        JButton jButton = ModalEditor.createButton(IdeIcons.getIcon((int)15), IdeIcons.getIcon((int)18), XmlArb.getString(2));
        JButton jButton2 = ModalEditor.createButton(IdeIcons.getIcon((int)16), IdeIcons.getIcon((int)17), XmlArb.getString(3));
        jComponent.add(jButton);
        jComponent.add(jButton2);
        2L l = new 2L(this, jButton, jButton2);
        jButton.addActionListener(l);
        jButton2.addActionListener(l);
        return l;
    }

    private MDDAdapter initNewDeleteButtons(JComponent jComponent) {
        JButton jButton = ModalEditor.createButton(XmlArb.getString(4));
        JButton jButton2 = ModalEditor.createButton(XmlArb.getString(5));
        jComponent.add(jButton);
        jComponent.add(jButton2);
        1L l = new 1L(this, jButton, jButton2);
        jButton.addActionListener(l);
        jButton2.addActionListener(l);
        return l;
    }

    private static JButton createButton(String string) {
        JButton jButton = new JButton();
        ResourceUtils.resButton((AbstractButton)jButton, (String)string);
        jButton.setEnabled(false);
        return jButton;
    }

    private static JButton createButton(Icon icon, Icon icon2, String string) {
        JButton jButton = new JButton();
        jButton.setIcon(icon);
        jButton.setDisabledIcon(icon2);
        jButton.getAccessibleContext().setAccessibleName(string);
        jButton.setEnabled(false);
        jButton.setMargin(new Insets(2, 0, 2, 0));
        return jButton;
    }

    public class 2L
    extends MDDAdapter
    implements ActionListener {
        private transient TraversableContext _curTC;
        private transient Traversable _curTrav;
        private final /* synthetic */ JButton v$btnUp;
        private final /* synthetic */ JButton v$btnDown;
        final /* synthetic */ ModalEditor this$0;

        public void traversableEntered(MDDEvent mDDEvent) {
            this._curTC = mDDEvent.getTraversableContext();
            this._curTrav = mDDEvent.getTraversable();
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this._curTC.getDesignTimeObject("MDDPanel.CURRENT_TREE1_NODE");
            TreeNode treeNode = defaultMutableTreeNode.getParent();
            int n = treeNode.getIndex(defaultMutableTreeNode);
            int n2 = treeNode.getChildCount() - 1;
            this.v$btnUp.setEnabled(n > 0 && n <= n2 && this._curTrav instanceof ReorderSupport);
            this.v$btnDown.setEnabled(n >= 0 && n < n2 && this._curTrav instanceof ReorderSupport);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.v$btnUp) {
                ((ReorderSupport)this._curTrav).moveUp(this._curTC);
            } else if (object == this.v$btnDown) {
                ((ReorderSupport)this._curTrav).moveDown(this._curTC);
            }
        }

        2L(ModalEditor modalEditor, JButton jButton, JButton jButton2) {
            this.v$btnDown = jButton2;
            this.v$btnUp = jButton;
            this.this$0 = modalEditor;
        }
    }

    public class 1L
    extends MDDAdapter
    implements ActionListener {
        private transient TraversableContext _curTC;
        private transient Traversable _curTrav;
        private final /* synthetic */ JButton v$btnNew;
        private final /* synthetic */ JButton v$btnDelete;
        final /* synthetic */ ModalEditor this$0;

        public void traversableEntered(MDDEvent mDDEvent) {
            this._curTC = mDDEvent.getTraversableContext();
            this._curTrav = mDDEvent.getTraversable();
            this.v$btnNew.setEnabled(this._curTrav instanceof CreateSupport);
            this.v$btnDelete.setEnabled(this._curTrav instanceof DeleteSupport);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.v$btnNew) {
                ((CreateSupport)this._curTrav).create(this._curTC);
            } else if (object == this.v$btnDelete) {
                ((DeleteSupport)this._curTrav).delete(this._curTC);
            }
        }

        1L(ModalEditor modalEditor, JButton jButton, JButton jButton2) {
            this.v$btnDelete = jButton2;
            this.v$btnNew = jButton;
            this.this$0 = modalEditor;
        }
    }
}

