/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableCellRenderer;
import oracle.javatools.xml.bind.ElementList;
import oracle.javatools.xml.bind.ElementListEvent;
import oracle.javatools.xml.bind.ElementListListener;
import oracle.jdevimpl.deploy.res.J2eeArb;
import oracle.jdevimpl.xml.ElementListPanel;
import oracle.jdevimpl.xml.XmlArb;

public abstract class TablePanel
extends ElementListPanel {
    public static final int TOP_RIGHT = 0;
    public static final int RIGHT_TOP = 1;
    private final L _listener;
    private final NiceTable _table;
    private final JButton _btnAdd;
    private final JButton _btnRemove;
    private final boolean _showUpDownButtons;
    private final JButton _btnMoveUp;
    private final JButton _btnMoveDown;
    private transient TableModelImpl _tableModelImpl;

    void $init$() {
        this._listener = new L(null);
        this._table = new NiceTable();
        this._btnAdd = new JButton();
        this._btnRemove = new JButton();
        this._tableModelImpl = new TableModelImpl(null);
    }

    public TablePanel(String string, String string2) {
        this(string, string2, 0);
    }

    public TablePanel(String string, String string2, int n) {
        this(string, string2, n, false);
    }

    public TablePanel(String string, String string2, int n, boolean bl) {
        int n2;
        this.$init$();
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        this._showUpDownButtons = bl;
        this.initButton(this._btnAdd, this.getAddButtonLabel());
        this.initButton(this._btnRemove, this.getRemoveButtonLabel());
        if (this._showUpDownButtons) {
            this._btnMoveUp = new JButton();
            this._btnMoveDown = new JButton();
            this.initButton(this._btnMoveUp, J2eeArb.getString((int)55));
            this.initButton(this._btnMoveDown, J2eeArb.getString((int)56));
        } else {
            this._btnMoveUp = null;
            this._btnMoveDown = null;
        }
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add((Component)this._table, null);
        jScrollPane.setPreferredSize(new Dimension(1, 120));
        JLabel jLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._table, (String)string);
        ListSelectionModel listSelectionModel = this._table.getSelectionModel();
        listSelectionModel.addListSelectionListener(this._listener);
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 5, 5);
        int n3 = n2 = this._showUpDownButtons ? 2 : 0;
        if (n == 0) {
            this.add(jLabel, this.gbc(0, 0, 1, 1, 1.0, 0.0, 17, 0, insets));
            this.add(this._btnAdd, this.gbc(1, 0, 1, 1, 0.0, 0.0, 13, 0, insets));
            this.add(this._btnRemove, this.gbc(2, 0, 1, 1, 0.0, 0.0, 13, 0, insets));
            if (this._showUpDownButtons) {
                this.add(this._btnMoveUp, this.gbc(3, 0, 1, 1, 0.0, 0.0, 13, 0, insets));
                this.add(this._btnMoveDown, this.gbc(4, 0, 1, 1, 0.0, 0.0, 13, 0, insets));
            }
            this.add(jScrollPane, this.gbc(0, 1, 3 + n2, 1, 0.0, 1.0, 18, 1, new Insets(0, 5, 5, 5)));
            this._lastY = 2;
        } else if (n == 1) {
            this.add(jLabel, this.gbc(0, 0, 1, 1, 0.0, 0.0, 17, 0, insets));
            this.add(this._btnAdd, this.gbc(1, 1, 1, 1, 0.0, 0.0, 11, 2, insets));
            this.add(this._btnRemove, this.gbc(1, 2, 1, 1, 0.0, this._showUpDownButtons ? 0.0 : 1.0, 11, 2, insets));
            if (this._showUpDownButtons) {
                this.add(this._btnMoveUp, this.gbc(1, 3, 1, 1, 0.0, 0.0, 11, 2, insets));
                this.add(this._btnMoveDown, this.gbc(1, 4, 1, 1, 0.0, 1.0, 11, 2, insets));
            }
            this.add(jScrollPane, this.gbc(0, 1, 1, 2 + n2, 1.0, 0.0, 18, 1, new Insets(5, 5, 5, 0)));
            this._lastY = 3;
        }
        this.setHelpID(string2);
        this.initTable((JTable)this._table);
    }

    private void initButton(JButton jButton, String string) {
        ResourceUtils.resButton((AbstractButton)jButton, (String)string);
        jButton.addActionListener(this._listener);
    }

    protected String getAddButtonLabel() {
        return XmlArb.getString(7);
    }

    protected String getRemoveButtonLabel() {
        return XmlArb.getString(8);
    }

    public final void onEntry(TraversableContext traversableContext) {
        super.onEntry(traversableContext);
        this.onEntryImpl(traversableContext);
    }

    protected abstract void onEntryImpl(TraversableContext var1);

    public final void onExit(TraversableContext traversableContext) throws TraversalException {
        super.onExit(traversableContext);
        this.forceTableEditorCommit();
        this.onExitImpl(traversableContext);
    }

    protected void onExitImpl(TraversableContext traversableContext) throws TraversalException {
    }

    protected ElementListListener newElementListListener() {
        this._tableModelImpl = new TableModelImpl(null);
        return this._tableModelImpl;
    }

    protected final int[] getSelectedIndexes() {
        return this._table.getSelectedRows();
    }

    protected final void setSelectedIndexes(int[] nArray) {
        int n;
        if (nArray != null && nArray.length > 0 && (n = this.getElementList().size() - 1) >= 0) {
            int n2 = Math.min(nArray[0], n);
            ListSelectionModel listSelectionModel = this._table.getSelectionModel();
            listSelectionModel.setSelectionInterval(n2, n2);
        }
    }

    protected final void setElementList(ElementList elementList) {
        super.setElementList(elementList);
        this._table.setModel((TableModel)this._tableModelImpl);
        this.updateButtons();
    }

    public Object[] delete(TraversableContext traversableContext) {
        this.forceTableEditorCancel();
        return super.delete(traversableContext);
    }

    protected void initTable(JTable jTable) {
    }

    protected int getTableRowCount() {
        ElementList elementList = this.getElementList();
        return elementList != null ? elementList.size() : 0;
    }

    protected abstract int getTableColumnCount();

    protected abstract String getTableColumnName(int var1);

    protected abstract Object getTableValueAt(Object var1, int var2, int var3);

    protected boolean isTableCellEditable(int n, int n2) {
        return true;
    }

    protected boolean isTableRowRemoveable(int n) {
        return this.isTableCellEditable(n, 0);
    }

    protected abstract void setTableValueAt(Object var1, Object var2, int var3, int var4);

    protected void setColumnCellRenderer(int n, TableCellRenderer tableCellRenderer) {
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        tableColumn.setCellRenderer(tableCellRenderer);
    }

    protected void setDisablingCellRenderer(int n) {
        this.setColumnCellRenderer(0, (TableCellRenderer)((Object)new 1()));
    }

    protected void setCellEditor(int n, TableCellEditor tableCellEditor) {
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        tableColumn.setCellEditor(tableCellEditor);
    }

    protected static TableCellEditor monospacedTextCellEditor() {
        JTextField jTextField = new JTextField();
        jTextField.setFont(new Font("Monospaced", 0, 12));
        return new DefaultCellEditor(jTextField);
    }

    protected void forceTableEditorCommit() {
        TableCellEditor tableCellEditor;
        if (this._table.isEditing() && (tableCellEditor = this._table.getCellEditor()) != null) {
            tableCellEditor.stopCellEditing();
        }
    }

    protected void forceTableEditorCancel() {
        TableCellEditor tableCellEditor;
        if (this._table.isEditing() && (tableCellEditor = this._table.getCellEditor()) != null) {
            tableCellEditor.cancelCellEditing();
        }
    }

    protected void enableAddButton(boolean bl) {
        this._btnAdd.setEnabled(bl);
    }

    protected void enableRemoveButton(boolean bl) {
        this._btnRemove.setEnabled(bl);
    }

    private void updateButtons() {
        this.enableAddButton(this.getElementList() != null);
        boolean bl = false;
        int[] nArray = this._table.getSelectedRows();
        int n = nArray.length;
        if (n > 0) {
            bl = true;
            int n2 = 0;
            while (n2 < n) {
                if (!this.isTableRowRemoveable(nArray[n2])) {
                    bl = false;
                    break;
                }
                ++n2;
            }
        }
        this.enableRemoveButton(bl);
        if (this._showUpDownButtons) {
            int[] nArray2 = this.getSelectedIndexes();
            int n3 = nArray2.length;
            if (n3 <= 0 || n3 > 1) {
                this._btnMoveUp.setEnabled(false);
                this._btnMoveDown.setEnabled(false);
            } else {
                int n4 = nArray2[0];
                this._btnMoveUp.setEnabled(n4 > 0);
                this._btnMoveDown.setEnabled(n4 < this.getElementList().size() - 1);
            }
        }
    }

    static NiceTable ra$_table(TablePanel tablePanel) {
        return tablePanel._table;
    }

    static void mav$updateButtons(TablePanel tablePanel) {
        tablePanel.updateButtons();
    }

    static JButton ra$_btnAdd(TablePanel tablePanel) {
        return tablePanel._btnAdd;
    }

    static JButton ra$_btnRemove(TablePanel tablePanel) {
        return tablePanel._btnRemove;
    }

    static boolean ra$_showUpDownButtons(TablePanel tablePanel) {
        return tablePanel._showUpDownButtons;
    }

    static JButton ra$_btnMoveUp(TablePanel tablePanel) {
        return tablePanel._btnMoveUp;
    }

    static JButton ra$_btnMoveDown(TablePanel tablePanel) {
        return tablePanel._btnMoveDown;
    }

    public final class 1
    extends NiceTableCellRenderer {
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            boolean bl3 = TablePanel.this.isTableCellEditable(n, n2);
            jLabel.setEnabled(bl3);
            return jLabel;
        }
    }

    private class TableModelImpl
    extends AbstractTableModel
    implements ElementListListener {
        public int getRowCount() {
            return TablePanel.this.getTableRowCount();
        }

        public int getColumnCount() {
            return TablePanel.this.getTableColumnCount();
        }

        public String getColumnName(int n) {
            return TablePanel.this.getTableColumnName(n);
        }

        public Object getValueAt(int n, int n2) {
            Object object = TablePanel.this.getElementList().get(n);
            return TablePanel.this.getTableValueAt(object, n, n2);
        }

        public boolean isCellEditable(int n, int n2) {
            return TablePanel.this.isTableCellEditable(n, n2);
        }

        public void setValueAt(Object object, int n, int n2) {
            Object object2 = TablePanel.this.getElementList().get(n);
            TablePanel.this.setTableValueAt(object2, object, n, n2);
        }

        public void elementsAdded(ElementListEvent elementListEvent) {
            int n = elementListEvent.getStartIndex();
            this.fireTableRowsInserted(n, elementListEvent.getEndIndex());
            TablePanel.ra$_table(TablePanel.this).getSelectionModel().setSelectionInterval(n, n);
        }

        public void elementsRemoved(ElementListEvent elementListEvent) {
            this.fireTableRowsDeleted(elementListEvent.getStartIndex(), elementListEvent.getEndIndex());
        }

        public void elementsChanged(ElementListEvent elementListEvent) {
            this.fireTableRowsUpdated(elementListEvent.getStartIndex(), elementListEvent.getEndIndex());
        }

        private TableModelImpl() {
        }

        TableModelImpl(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class L
    implements ListSelectionListener,
    ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            TraversableContext traversableContext = TablePanel.this.getTraversableContext();
            if (object == TablePanel.ra$_btnAdd(TablePanel.this)) {
                TablePanel.this.create(traversableContext);
            } else if (object == TablePanel.ra$_btnRemove(TablePanel.this)) {
                TablePanel.this.delete(traversableContext);
            } else if (TablePanel.ra$_showUpDownButtons(TablePanel.this)) {
                if (object == TablePanel.ra$_btnMoveUp(TablePanel.this)) {
                    TablePanel.this.moveUp(traversableContext);
                } else if (object == TablePanel.ra$_btnMoveDown(TablePanel.this)) {
                    TablePanel.this.moveDown(traversableContext);
                }
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            TablePanel.mav$updateButtons(TablePanel.this);
        }

        private L() {
        }

        L(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

