/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.util.DefaultPrefixLookup;
import oracle.bali.xml.util.NamespaceUtils;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnnotationPanel
extends JPanel {
    private XmlModel model;
    private Node annotation;
    private Node documentation;
    private JTextArea text;

    public AnnotationPanel(XmlModel xmlModel, Node node) {
        this.model = xmlModel;
        this.annotation = node;
        this.initialize();
    }

    public void dispose(boolean bl) {
        if (bl) {
            Document document = this.documentation.getOwnerDocument();
            this.removeAllText(this.documentation);
            String string = this.text.getText();
            String[] stringArray = string.split("\n");
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].trim().length() > 0) {
                    this.documentation.appendChild(document.createTextNode(stringArray[n]));
                }
                ++n;
            }
            if (this.documentation.getParentNode() == null) {
                DefaultPrefixLookup defaultPrefixLookup = this.model.getDefaultPrefixLookup();
                NamespaceUtils.fixPrefixes((Node)this.annotation, (Node)this.documentation, (DefaultPrefixLookup)defaultPrefixLookup);
                this.annotation.appendChild(this.documentation);
            }
        }
        this.annotation = null;
        this.documentation = null;
        this.text = null;
    }

    public Component getInitialFocus() {
        return this.text;
    }

    private void initialize() {
        this.documentation = ModelUtils.getChild(this.annotation, "documentation");
        if (this.documentation == null) {
            Document document = this.annotation.getOwnerDocument();
            this.documentation = document.createElementNS("http://www.w3.org/2001/XMLSchema", "documentation");
        }
        this.setLayout(new BorderLayout(5, 5));
        this.text = new JTextArea(this.getText(this.documentation), 5, 5);
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(true);
        JLabel jLabel = new JLabel(XmlSchemaArb.getString(32));
        jLabel.setDisplayedMnemonic(XmlSchemaArb.getInteger(33));
        jLabel.setLabelFor(this.text);
        this.add((Component)jLabel, "North");
        this.add((Component)new JScrollPane(this.text), "Center");
    }

    private String getText(Node node) {
        StringBuffer stringBuffer = new StringBuffer();
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            String string;
            if (node2.getNodeType() == 3 && (string = node2.getNodeValue().trim()).length() > 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("\n");
                }
                stringBuffer.append(string);
            }
            node2 = node2.getNextSibling();
        }
        return ModelUtils.translateXmlMarkup(stringBuffer.toString());
    }

    private void removeAllText(Node node) {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        int n2 = n - 1;
        while (n2 >= 0) {
            Node node2 = nodeList.item(n2);
            if (node2.getNodeType() == 3) {
                node.removeChild(node2);
            }
            --n2;
        }
    }
}

