/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema;

import oracle.jdevimpl.xml.schema.ModelManager;
import org.w3c.dom.Attr;

public class GlobalReference {
    public static final int GLOBAL_TYPE_UNKNOWN = 0;
    public static final int GLOBAL_TYPE_ELEMENT = 1;
    public static final int GLOBAL_TYPE_COMPLEX_TYPE = 2;
    public static final int GLOBAL_TYPE_SIMPLE_TYPE = 3;
    public static final int GLOBAL_TYPE_SIMPLE_OR_COMPLEX_TYPE = 4;
    public static final int GLOBAL_TYPE_MODEL_GROUP = 5;
    public static final int GLOBAL_TYPE_ATTRIBUTE = 6;
    public static final int GLOBAL_TYPE_ATTRIBUTE_GROUP = 7;
    public static final int REFERENCE_TYPE_UNKNOWN = 0;
    public static final int REFERENCE_TYPE_REF = 1;
    public static final int REFERENCE_TYPE_RESTRICTION_BASE = 2;
    public static final int REFERENCE_TYPE_EXTENSION_BASE = 3;
    public static final int REFERENCE_TYPE_ELEMENT_TYPE = 4;
    public static final int REFERENCE_TYPE_LIST_TYPE = 5;
    public static final int REFERENCE_TYPE_UNION_TYPE = 6;
    public static final String EMPTY_NAMESPACE = "%empty%";
    public static final String UKNOWN_NAMESPACE = "%unknown%";
    public String namespace;
    public String name;
    public int type;
    public int referenceType;
    public Attr attr;

    public GlobalReference(String string, String string2, int n) {
        this(string, string2, n, 0);
    }

    public GlobalReference(String string, String string2, int n, int n2) {
        this(string, string2, n, n2, null);
    }

    public GlobalReference(String string, String string2, int n, int n2, Attr attr) {
        this.namespace = string;
        this.name = string2;
        this.type = n;
        this.referenceType = n2;
        this.attr = attr;
    }

    public int hashCode() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.namespace == null ? EMPTY_NAMESPACE : this.namespace);
        stringBuffer.append(this.name);
        if (this.type == 2 || this.type == 3) {
            stringBuffer.append(4);
        } else {
            stringBuffer.append(this.type);
        }
        return stringBuffer.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof GlobalReference) {
            GlobalReference globalReference = (GlobalReference)object;
            return GlobalReference.areTypesEqual(this.type, globalReference.type) && this.namespace.equals(globalReference.namespace) && this.name.equals(globalReference.name);
        }
        return false;
    }

    public static boolean areTypesEqual(int n, int n2) {
        return n == n2 || n == 4 && (n2 == 2 || n2 == 3) || n2 == 4 && (n == 2 || n == 3);
    }

    public int getReferenceType() {
        return this.referenceType;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Attr getAttr() {
        return this.attr;
    }

    public boolean isBuiltInType() {
        return ModelManager.isBuiltInType(this);
    }
}

