/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlModelListener;
import oracle.bali.xml.model.event.XmlModelAdapter;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.jdevimpl.xml.schema.GlobalReference;
import oracle.jdevimpl.xml.schema.NodeListener;
import oracle.jdevimpl.xml.schema.ProxyNode;
import oracle.jdevimpl.xml.schema.SelectionListener;
import oracle.jdevimpl.xml.schema.XmlSchemaMetadataResolver;
import oracle.jdevimpl.xml.schema.XmlSchemaModel;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ModelManager {
    private XmlSchemaModel baseModel;
    private ModelReference baseModelReference;
    private HashMap nodeHandlers;
    private HashMap referenceMap;
    private HashMap globalMap;
    private HashMap globalNodeMap;
    private HashMap modelHandlers;
    private HashMap documentMap;
    private LinkedList listeners;
    private LinkedList selectionListeners;
    private HashMap proxyMap;
    private static final String[] BUILT_IN_TYPES = new String[]{"anySimpleType", "anyType", "anyURI", "base64Binary", "boolean", "byte", "date", "dateTime", "decimal", "double", "duration", "ENTITIES", "ENTITY", "float", "gDay", "gMonth", "gMonthDay", "gYear", "gYearMonth", "hexBinary", "ID", "IDREF", "IDREFS", "int", "integer", "language", "long", "Name", "NCName", "negativeInteger", "NMTOKEN", "NMTOKENS", "nonNegativeInteger", "nonPositiveInteger", "normalizedString", "NOTATION", "positiveInteger", "QName", "short", "string", "time", "token", "unsignedByte", "unsignedInt", "unsignedLong", "unsignedShort"};

    void $init$() {
        this.nodeHandlers = new HashMap();
        this.referenceMap = new HashMap();
        this.globalMap = new HashMap();
        this.globalNodeMap = new HashMap();
        this.modelHandlers = new HashMap();
        this.documentMap = new HashMap();
        this.listeners = new LinkedList();
        this.selectionListeners = new LinkedList();
        this.proxyMap = new HashMap();
    }

    public ModelManager(XmlSchemaModel xmlSchemaModel) {
        this.$init$();
        this.baseModel = xmlSchemaModel;
        this.loadBaseModel();
    }

    protected void addProxyNode(ProxyNode proxyNode) {
        LinkedList<ProxyNode> linkedList = (LinkedList<ProxyNode>)this.proxyMap.get(proxyNode.getReferee());
        if (linkedList == null) {
            linkedList = new LinkedList<ProxyNode>();
            this.proxyMap.put(proxyNode.getReferee(), linkedList);
        }
        linkedList.add(proxyNode);
    }

    protected void removeProxyNode(ProxyNode proxyNode) {
        List list = (List)this.proxyMap.get(proxyNode.getReferee());
        if (list != null) {
            list.remove(proxyNode);
            if (list.isEmpty()) {
                this.proxyMap.remove(proxyNode.getReferee());
            }
        }
    }

    public static boolean isBuiltInType(GlobalReference globalReference) {
        if ("http://www.w3.org/2001/XMLSchema".equals(globalReference.getNamespace())) {
            String string = globalReference.getName();
            int n = 0;
            while (n < BUILT_IN_TYPES.length) {
                if (BUILT_IN_TYPES[n].equals(string)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    public void loadBaseModel() {
        this.baseModel.acquireReadLock();
        try {
            Document document;
            if (this.baseModel.isDocumentValid() && (document = this.baseModel.getDocument()) != null) {
                this.baseModelReference = new ModelReference(document.getDocumentElement());
            }
        }
        finally {
            this.baseModel.releaseReadLock();
        }
        this.baseModel.addModelListener((XmlModelListener)new 1());
    }

    public List getGlobals(Node node, int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = GlobalReference.areTypesEqual(n, 3);
        if (bl) {
            String string = this.getPrefixForNamespace(node, "http://www.w3.org/2001/XMLSchema");
            int n2 = 0;
            while (n2 < BUILT_IN_TYPES.length) {
                if (string != null) {
                    arrayList.add(string + ":" + BUILT_IN_TYPES[n2]);
                } else {
                    arrayList.add(BUILT_IN_TYPES[n2]);
                }
                ++n2;
            }
        }
        for (GlobalReference globalReference : this.globalMap.keySet()) {
            if (!GlobalReference.areTypesEqual(globalReference.getType(), n)) continue;
            String string = this.getPrefixForNamespace(node, globalReference.getNamespace());
            if (string != null) {
                arrayList.add(string + ":" + globalReference.getName());
                continue;
            }
            if (!this.getDefaultNamespace(node).equals(globalReference.getNamespace())) continue;
            arrayList.add(globalReference.getName());
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public void addNodeListener(NodeListener nodeListener) {
        this.listeners.add(nodeListener);
    }

    public void removeNodeListener(NodeListener nodeListener) {
        this.listeners.remove(nodeListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.add(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.remove(selectionListener);
    }

    public void addNodeListener(Node node, NodeListener nodeListener) {
        NodeHandler nodeHandler = (NodeHandler)this.nodeHandlers.get(node);
        if (nodeHandler == null) {
            nodeHandler = new NodeHandler(node);
            this.nodeHandlers.put(node, nodeHandler);
        }
        nodeHandler.getListeners().add(nodeListener);
    }

    public void removeNodeListener(Node node, NodeListener nodeListener) {
        NodeHandler nodeHandler = (NodeHandler)this.nodeHandlers.get(node);
        if (nodeHandler != null) {
            List list = nodeHandler.getListeners();
            list.remove(nodeListener);
            if (list.isEmpty()) {
                nodeHandler.destroy();
                this.nodeHandlers.remove(node);
            }
        }
    }

    public GlobalReference getReference(Node node) {
        GlobalReference globalReference = null;
        if ("http://www.w3.org/2001/XMLSchema".equals(node.getNamespaceURI()) && node.getNodeType() == 1) {
            Element element = (Element)node;
            String string = node.getLocalName();
            if (string != null) {
                Attr attr;
                if ("element".equals(string)) {
                    Attr attr2 = element.getAttributeNodeNS(null, "ref");
                    if (attr2 != null) {
                        globalReference = new GlobalReference(this.getNamespace(node, attr2.getValue()), ModelUtils.getName(attr2.getValue()), 1, 1, attr2);
                    } else {
                        Attr attr3 = element.getAttributeNodeNS(null, "type");
                        if (attr3 != null) {
                            globalReference = new GlobalReference(this.getNamespace(node, attr3.getValue()), ModelUtils.getName(attr3.getValue()), 4, 4, attr3);
                        } else {
                            Node node2 = DomUtils.getNamedChild((Node)node, (String)"http://www.w3.org/2001/XMLSchema", (String)"complexType");
                            if (node2 != null) {
                                globalReference = this.getComplexTypeReference(node2);
                            } else {
                                Node node3 = DomUtils.getNamedChild((Node)node, (String)"http://www.w3.org/2001/XMLSchema", (String)"simpleType");
                                if (node3 != null) {
                                    globalReference = this.getSimpleTypeReference(node3);
                                }
                            }
                        }
                    }
                } else if ("group".equals(string)) {
                    Attr attr4 = element.getAttributeNodeNS(null, "ref");
                    if (attr4 != null) {
                        globalReference = new GlobalReference(this.getNamespace(node, attr4.getValue()), ModelUtils.getName(attr4.getValue()), 5, 1, attr4);
                    }
                } else if ("complexType".equals(string) && ModelUtils.getName(node) != null) {
                    globalReference = this.getComplexTypeReference(node);
                } else if ("simpleType".equals(string)) {
                    globalReference = this.getSimpleTypeReference(node);
                } else if ("attribute".equals(string)) {
                    Attr attr5 = element.getAttributeNodeNS(null, "ref");
                    if (attr5 != null) {
                        globalReference = new GlobalReference(this.getNamespace(node, attr5.getValue()), ModelUtils.getName(attr5.getValue()), 6, 1, attr5);
                    }
                } else if ("attributeGroup".equals(string) && (attr = element.getAttributeNodeNS(null, "ref")) != null) {
                    globalReference = new GlobalReference(this.getNamespace(node, attr.getValue()), ModelUtils.getName(attr.getValue()), 7, 1, attr);
                }
            }
        }
        return globalReference;
    }

    private GlobalReference getComplexTypeReference(Node node) {
        GlobalReference globalReference = null;
        Node node2 = DomUtils.getNamedChild((Node)node, (String)"http://www.w3.org/2001/XMLSchema", (String)"complexContent");
        if (node2 == null) {
            node2 = DomUtils.getNamedChild((Node)node, (String)"http://www.w3.org/2001/XMLSchema", (String)"simpleContent");
        }
        if (node2 != null) {
            globalReference = this.getExtensionOrRestrictionBase(node2);
        }
        return globalReference;
    }

    private GlobalReference getSimpleTypeReference(Node node) {
        return this.getExtensionOrRestrictionBase(node);
    }

    private GlobalReference getExtensionOrRestrictionBase(Node node) {
        boolean bl = true;
        Element element = (Element)DomUtils.getNamedChild((Node)node, (String)"http://www.w3.org/2001/XMLSchema", (String)"extension");
        if (element == null) {
            bl = false;
            element = (Element)DomUtils.getNamedChild((Node)node, (String)"http://www.w3.org/2001/XMLSchema", (String)"restriction");
        }
        if (element != null) {
            Node node2;
            Attr attr = element.getAttributeNodeNS(null, "base");
            if (attr != null) {
                return new GlobalReference(this.getNamespace(node, attr.getValue()), ModelUtils.getName(attr.getValue()), 4, bl ? 3 : 2, attr);
            }
            if (!bl && (node2 = DomUtils.getNamedChild((Node)element, (String)"http://www.w3.org/2001/XMLSchema", (String)"simpleType")) != null) {
                return this.getExtensionOrRestrictionBase(node2);
            }
        }
        return null;
    }

    public Node resolveReference(GlobalReference globalReference) {
        return (Node)this.globalMap.get(globalReference);
    }

    public void addGlobalComponent(GlobalComponent globalComponent) {
        this.globalMap.put(globalComponent.getReference(), globalComponent.getNode());
        this.globalNodeMap.put(globalComponent.getNode(), globalComponent);
        this.fireGlobalChanged(globalComponent);
    }

    public void removeGlobalComponent(GlobalComponent globalComponent) {
        this.globalMap.remove(globalComponent.getReference());
        this.globalNodeMap.remove(globalComponent.getNode());
        this.fireGlobalChanged(globalComponent);
    }

    protected final String getNamespace(Node node, String string) {
        String string2 = null;
        String string3 = ModelUtils.getPrefix(string);
        if (string3 != null) {
            string2 = this.getNamespaceForPrefix(node, string3);
            if (string2 == null) {
                string2 = "%unknown%";
            }
        } else {
            string2 = this.getDefaultNamespace(node);
        }
        return string2;
    }

    private ModelHandler getModelHandler(Node node) {
        Document document = this.getOwnerDocument(node);
        return (ModelHandler)this.documentMap.get(document);
    }

    protected final String getNamespaceForPrefix(Node node, String string) {
        Element element = this.getOwnerDocument(node).getDocumentElement();
        Attr attr = element.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", string);
        return attr == null ? null : attr.getValue();
    }

    protected final String getPrefixForNamespace(Node node, String string) {
        ModelHandler modelHandler = this.getModelHandler(node);
        if (modelHandler != null) {
            return modelHandler.getPrefixForNamespace(string);
        }
        return null;
    }

    private Document getOwnerDocument(Node node) {
        return node instanceof ProxyNode ? ((ProxyNode)node).getRefereeDocument() : node.getOwnerDocument();
    }

    private void fireNodeChanged(Node node) {
        Node node2;
        List list = (List)this.proxyMap.get(node);
        if (list != null) {
            for (ProxyNode proxyNode : list) {
                proxyNode.resetChildren();
            }
        }
        for (NodeListener nodeListener : (List)this.listeners.clone()) {
            nodeListener.nodeChanged(node);
        }
        NodeHandler nodeHandler = (NodeHandler)this.nodeHandlers.get(node);
        if (nodeHandler != null) {
            nodeHandler.fireNodeChanged();
            GlobalComponent globalComponent = (GlobalComponent)this.globalNodeMap.get(node);
            if (globalComponent != null) {
                String string = ModelUtils.getName(node);
                GlobalReference globalReference = globalComponent.getReference();
                if (ModelUtils.areDifferent(globalReference.name, string)) {
                    this.removeGlobalComponent(globalComponent);
                    globalReference.name = string;
                    this.addGlobalComponent(globalComponent);
                } else {
                    this.fireGlobalChanged(globalComponent);
                }
            }
        }
        if ((node2 = this.getContainerOwner(node)) != null) {
            this.fireNodeChanged(node2);
        }
    }

    private void fireSelectionChanged() {
        for (SelectionListener selectionListener : (List)this.selectionListeners.clone()) {
            selectionListener.selectionChanged();
        }
    }

    private Node getContainerOwner(Node node) {
        Node node2 = null;
        XmlSchemaMetadataResolver xmlSchemaMetadataResolver = (XmlSchemaMetadataResolver)this.baseModel.getXmlMetadataResolver();
        Node node3 = node;
        int n = xmlSchemaMetadataResolver.getSchemaRole(node3);
        String string = ModelUtils.getName(node3);
        while (ModelUtils.isContainerRole(n) || (n == 20 || n == 8) && string == null) {
            if ((node3 = node3.getParentNode()) == null) break;
            n = xmlSchemaMetadataResolver.getSchemaRole(node3);
            string = ModelUtils.getName(node3);
        }
        if (node3 != node) {
            node2 = node3;
        }
        return node2;
    }

    private void fireGlobalChanged(GlobalComponent globalComponent) {
        GlobalComponent globalComponent2 = globalComponent;
        Stack<GlobalComponent> stack = new Stack<GlobalComponent>();
        stack.push(globalComponent);
        while (!stack.isEmpty()) {
            GlobalComponent globalComponent3 = (GlobalComponent)stack.pop();
            GlobalReference globalReference = globalComponent3.getReference();
            LinkedList linkedList = (LinkedList)this.referenceMap.get(globalReference);
            if (linkedList == null) continue;
            for (NodeHandler nodeHandler : (List)linkedList.clone()) {
                nodeHandler.fireNodeChanged();
                globalComponent = (GlobalComponent)this.globalNodeMap.get(nodeHandler.getNode());
                if (globalComponent == null || globalComponent == globalComponent2) continue;
                stack.push(globalComponent);
            }
        }
    }

    private void addReference(GlobalReference globalReference, NodeHandler nodeHandler) {
        LinkedList<NodeHandler> linkedList = (LinkedList<NodeHandler>)this.referenceMap.get(globalReference);
        if (linkedList == null) {
            linkedList = new LinkedList<NodeHandler>();
            this.referenceMap.put(globalReference, linkedList);
        }
        linkedList.add(nodeHandler);
    }

    private void removeReference(GlobalReference globalReference, NodeHandler nodeHandler) {
        List list = (List)this.referenceMap.get(globalReference);
        if (list != null) {
            list.remove(nodeHandler);
            if (list.isEmpty()) {
                this.referenceMap.remove(globalReference);
            }
        }
    }

    protected String getDefaultNamespace(Node node) {
        Element element = this.getOwnerDocument(node).getDocumentElement();
        Attr attr = element.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "xmlns");
        return attr == null ? "%empty%" : attr.getValue();
    }

    private int getGlobalType(Node node) {
        if (node.getNodeType() == 1 && "http://www.w3.org/2001/XMLSchema".equals(node.getNamespaceURI())) {
            String string = node.getLocalName();
            if ("element".equals(string)) {
                return 1;
            }
            if ("complexType".equals(string)) {
                return 2;
            }
            if ("simpleType".equals(string)) {
                return 3;
            }
            if ("group".equals(string)) {
                return 5;
            }
            if ("attribute".equals(string)) {
                return 6;
            }
            if ("attributeGroup".equals(string)) {
                return 7;
            }
        }
        return 0;
    }

    protected ModelHandler getModelHandler(String string, String string2) {
        XmlModel xmlModel;
        ModelHandler modelHandler = null;
        URL uRL = this.locateSchema(string);
        if (uRL != null && (modelHandler = (ModelHandler)this.modelHandlers.get(uRL)) == null && (xmlModel = this.baseModel.getContext().getRelatedXmlModel(uRL)) != null) {
            modelHandler = new ModelHandler(uRL, xmlModel, string2);
        }
        if (modelHandler != null) {
            modelHandler.aquire();
        }
        return modelHandler;
    }

    private URL locateSchema(String string) {
        URL uRL;
        block3: {
            uRL = null;
            try {
                uRL = new URL(string);
                if (!this.isLocalURL(uRL)) {
                    uRL = null;
                }
            }
            catch (MalformedURLException malformedURLException) {
                uRL = this.baseModel.getContext().getURLForRelativePath(string);
                if (URLFileSystem.exists((URL)uRL) || URLFileSystem.exists((URL)(uRL = URLFactory.newFileURL((String)string)))) break block3;
                uRL = null;
            }
        }
        return uRL;
    }

    private boolean isLocalURL(URL uRL) {
        URL uRL2 = ((JDevXmlContext)this.baseModel.getContext()).getIdeDocument().getURL();
        return "file".equals(uRL.getProtocol()) || uRL.getProtocol().equals(uRL2.getProtocol()) && uRL.getHost().equals(uRL2.getHost());
    }

    private boolean isDocumentChangedEvent(XmlModelEvent xmlModelEvent) {
        Node node;
        if (xmlModelEvent.isPropertyChanged() && xmlModelEvent.containsPropertyChange("documentChanged")) {
            return true;
        }
        return xmlModelEvent.isDomTreeChanged() && (node = xmlModelEvent.getChangeRoot()) != null && node.getNodeType() == 9;
    }

    static boolean mav$isDocumentChangedEvent(ModelManager modelManager, XmlModelEvent xmlModelEvent) {
        return modelManager.isDocumentChangedEvent(xmlModelEvent);
    }

    static ModelReference ra$baseModelReference(ModelManager modelManager) {
        return modelManager.baseModelReference;
    }

    static XmlSchemaModel ra$baseModel(ModelManager modelManager) {
        return modelManager.baseModel;
    }

    static void wa$baseModelReference(ModelManager modelManager, ModelReference modelReference) {
        modelManager.baseModelReference = modelReference;
    }

    static int mav$getGlobalType(ModelManager modelManager, Node node) {
        return modelManager.getGlobalType(node);
    }

    static HashMap ra$proxyMap(ModelManager modelManager) {
        return modelManager.proxyMap;
    }

    static void mav$fireNodeChanged(ModelManager modelManager, Node node) {
        modelManager.fireNodeChanged(node);
    }

    static void mav$fireSelectionChanged(ModelManager modelManager) {
        modelManager.fireSelectionChanged();
    }

    static HashMap ra$modelHandlers(ModelManager modelManager) {
        return modelManager.modelHandlers;
    }

    static HashMap ra$documentMap(ModelManager modelManager) {
        return modelManager.documentMap;
    }

    static void mav$removeReference(ModelManager modelManager, GlobalReference globalReference, NodeHandler nodeHandler) {
        modelManager.removeReference(globalReference, nodeHandler);
    }

    static void mav$addReference(ModelManager modelManager, GlobalReference globalReference, NodeHandler nodeHandler) {
        modelManager.addReference(globalReference, nodeHandler);
    }

    public final class 1
    extends XmlModelAdapter {
        public void modelChanged(XmlModelEvent xmlModelEvent) {
            if (ModelManager.mav$isDocumentChangedEvent(ModelManager.this, xmlModelEvent)) {
                Document document;
                if (ModelManager.ra$baseModelReference(ModelManager.this) != null) {
                    ModelManager.ra$baseModelReference(ModelManager.this).destroy();
                }
                if (ModelManager.ra$baseModel(ModelManager.this).isDocumentValid() && (document = ModelManager.ra$baseModel(ModelManager.this).getDocument()) != null) {
                    ModelManager.wa$baseModelReference(ModelManager.this, new ModelReference(document.getDocumentElement()));
                }
            }
        }
    }

    private class ModelHandler
    extends XmlModelAdapter
    implements NodeListener {
        private URL location;
        private XmlModel model;
        private Element schema;
        private String targetNamespace;
        private LinkedList globals;
        private LinkedList references;
        private HashMap namespaceMap;
        private int refCount;

        void $init$() {
            this.globals = new LinkedList();
            this.references = new LinkedList();
            this.namespaceMap = new HashMap();
        }

        public ModelHandler(URL uRL, XmlModel xmlModel, String string) {
            this.$init$();
            this.location = uRL;
            this.model = xmlModel;
            this.targetNamespace = string;
            xmlModel.addModelListener((XmlModelListener)this);
            ModelManager.ra$modelHandlers(ModelManager.this).put(uRL, this);
            xmlModel.acquireReadLock();
            try {
                Document document = xmlModel.getDocument();
                if (document != null) {
                    ModelManager.ra$documentMap(ModelManager.this).put(document, this);
                }
            }
            finally {
                xmlModel.releaseReadLock();
            }
            this.reload();
        }

        public void aquire() {
            ++this.refCount;
        }

        public void release() {
            --this.refCount;
            if (this.refCount == 0) {
                this.destroy();
            }
        }

        public void setTargetNamespace(String string) {
            this.targetNamespace = string;
            this.unloadGlobals();
            this.loadGlobals();
        }

        public String getTargetNamespace() {
            return this.targetNamespace;
        }

        public String getPrefixForNamespace(String string) {
            return (String)this.namespaceMap.get(string);
        }

        public void destroy() {
            this.model.removeModelListener((XmlModelListener)this);
            if (this.schema != null) {
                ModelManager.this.removeNodeListener(this.schema, this);
            }
            this.unloadGlobals();
            this.unloadLoaders();
            ModelManager.ra$modelHandlers(ModelManager.this).remove(this.location);
            this.model.acquireReadLock();
            try {
                Document document = this.model.getDocument();
                if (document != null) {
                    ModelManager.ra$documentMap(ModelManager.this).remove(document);
                }
            }
            finally {
                this.model.releaseReadLock();
            }
        }

        public void modelChanged(XmlModelEvent xmlModelEvent) {
            Node node;
            if (ModelManager.mav$isDocumentChangedEvent(ModelManager.this, xmlModelEvent)) {
                this.reload();
            } else if (xmlModelEvent.isDomTreeChanged() && (node = xmlModelEvent.getChangeRoot()) != null) {
                ModelManager.mav$fireNodeChanged(ModelManager.this, node);
            }
            if ((xmlModelEvent.isSelectionChanged() || xmlModelEvent.isPropertyChanged() && xmlModelEvent.containsPropertyChange("cursorLocation")) && this.model == ModelManager.ra$baseModel(ModelManager.this)) {
                ModelManager.mav$fireSelectionChanged(ModelManager.this);
            }
        }

        public void nodeChanged(Node node) {
            this.reload();
        }

        private void reload() {
            this.unloadGlobals();
            this.unloadLoaders();
            this.unloadNamespaces();
            ModelManager.ra$proxyMap(ModelManager.this).clear();
            if (this.schema != null) {
                ModelManager.this.removeNodeListener(this.schema, this);
            }
            this.model.acquireReadLock();
            try {
                Document document = this.model.getDocument();
                if (document != null) {
                    this.schema = document.getDocumentElement();
                    ModelManager.this.addNodeListener(this.schema, this);
                    this.loadNamespaces();
                    this.loadGlobals();
                }
            }
            finally {
                this.model.releaseReadLock();
            }
        }

        private void loadNamespaces() {
            NamedNodeMap namedNodeMap = this.schema.getAttributes();
            int n = 0;
            while (n < namedNodeMap.getLength()) {
                int n2;
                Attr attr = (Attr)namedNodeMap.item(n);
                String string = attr.getName();
                if (string != null && string.startsWith("xmlns") && (n2 = string.indexOf(58)) != -1) {
                    String string2 = string.substring(n2 + 1);
                    String string3 = attr.getValue();
                    this.namespaceMap.put(string3, string2);
                }
                ++n;
            }
        }

        private void unloadNamespaces() {
            this.namespaceMap.clear();
        }

        private void loadGlobals() {
            if (this.schema != null) {
                Node node = this.schema.getFirstChild();
                while (node != null) {
                    int n = ModelManager.mav$getGlobalType(ModelManager.this, node);
                    if (n != 0) {
                        GlobalReference globalReference = new GlobalReference(this.targetNamespace, ModelUtils.getName(node), n);
                        GlobalComponent globalComponent = new GlobalComponent(globalReference, node);
                        ModelManager.this.addGlobalComponent(globalComponent);
                        this.globals.add(globalComponent);
                    } else if ("include".equals(node.getLocalName()) || "import".equals(node.getLocalName())) {
                        this.references.add(new ModelReference(this, node));
                    }
                    node = node.getNextSibling();
                }
            }
        }

        private void unloadGlobals() {
            for (GlobalComponent globalComponent : this.globals) {
                ModelManager.this.removeGlobalComponent(globalComponent);
                globalComponent.destroy();
            }
            this.globals.clear();
        }

        private void unloadLoaders() {
            for (ModelReference modelReference : this.references) {
                modelReference.destroy();
            }
            this.references.clear();
        }
    }

    private class NodeHandler {
        private Node node;
        private LinkedList listeners;
        private GlobalReference reference;

        void $init$() {
            this.listeners = new LinkedList();
        }

        public NodeHandler(Node node) {
            this.$init$();
            this.node = node;
            this.updateReference();
        }

        public Node getNode() {
            return this.node;
        }

        public void destroy() {
            if (this.reference != null) {
                ModelManager.mav$removeReference(ModelManager.this, this.reference, this);
            }
        }

        public List getListeners() {
            return this.listeners;
        }

        public void fireNodeChanged() {
            this.updateReference();
            for (NodeListener nodeListener : (List)this.listeners.clone()) {
                nodeListener.nodeChanged(this.node);
            }
        }

        private void updateReference() {
            GlobalReference globalReference = this.reference;
            this.reference = ModelManager.this.getReference(this.node);
            if (this.reference != null && !this.reference.equals(globalReference)) {
                if (globalReference != null) {
                    ModelManager.mav$removeReference(ModelManager.this, globalReference, this);
                }
                if (this.reference != null) {
                    ModelManager.mav$addReference(ModelManager.this, this.reference, this);
                }
            }
        }
    }

    private class GlobalComponent
    implements NodeListener {
        private GlobalReference reference;
        private Node node;

        public GlobalComponent(GlobalReference globalReference, Node node) {
            this.reference = globalReference;
            this.node = node;
            if (node != null) {
                ModelManager.this.addNodeListener(node, this);
            }
        }

        public void destroy() {
            if (this.node != null) {
                ModelManager.this.removeNodeListener(this.node, this);
            }
        }

        public GlobalReference getReference() {
            return this.reference;
        }

        public Node getNode() {
            return this.node;
        }

        public void nodeChanged(Node node) {
        }
    }

    private class ModelReference
    implements NodeListener {
        protected ModelHandler parent;
        protected ModelHandler modelHandler;
        protected Node node;
        private String namespace;
        private String location;

        public ModelReference(Node node) {
            this(null, node);
        }

        public ModelReference(ModelHandler modelHandler, Node node) {
            this.parent = modelHandler;
            this.node = node;
            ModelManager.this.addNodeListener(node, this);
            this.reload();
        }

        public void destroy() {
            if (this.modelHandler != null) {
                this.modelHandler.release();
            }
            ModelManager.this.removeNodeListener(this.node, this);
        }

        public void nodeChanged(Node node) {
            this.reload();
        }

        private void reload() {
            String string = this.namespace;
            this.namespace = this.getNamespace();
            if (this.modelHandler != null && string != null && !string.equals(this.namespace)) {
                this.modelHandler.setTargetNamespace(this.namespace);
            }
            String string2 = this.location;
            this.location = this.getLocation();
            if (this.modelHandler == null || ModelUtils.areDifferent(string2, this.location)) {
                if (this.modelHandler != null) {
                    this.modelHandler.release();
                }
                if (this.parent == null) {
                    URL uRL = ((JDevXmlContext)ModelManager.ra$baseModel(ModelManager.this).getContext()).getIdeDocument().getURL();
                    this.modelHandler = new ModelHandler(uRL, ModelManager.ra$baseModel(ModelManager.this), this.getNamespace());
                    this.modelHandler.aquire();
                } else if (this.location != null) {
                    this.modelHandler = ModelManager.this.getModelHandler(this.location, this.namespace);
                }
            }
        }

        protected String getNamespace() {
            Element element = (Element)this.node;
            String string = this.node.getLocalName();
            if ("schema".equals(string)) {
                this.namespace = ModelUtils.getAttribute(element, "targetNamespace");
                if (this.namespace == null) {
                    this.namespace = ModelManager.this.getDefaultNamespace(element);
                }
            } else {
                if ("include".equals(string)) {
                    return this.parent.getTargetNamespace();
                }
                this.namespace = ModelUtils.getAttribute(element, "namespace");
                if (this.namespace == null) {
                    this.namespace = "%empty%";
                }
            }
            return this.namespace;
        }

        protected String getLocation() {
            return ModelUtils.getAttribute((Element)this.node, "schemaLocation");
        }
    }
}

