/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import oracle.bali.ewt.button.ButtonBar;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.XmlSchemaModel;
import oracle.jdevimpl.xml.schema.XmlSchemaTreeTraversal;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NamespacePanel
extends JPanel {
    private Element schema;
    private JTextField targetNamespace;
    private JTextField defaultNamespace;
    private JTable prefixTable;
    private DefaultTableModel prefixModel;
    private JButton removeButton;
    private XmlSchemaModel model;
    private static final int PREFIX_INDEX = 0;
    private static final int NAMESPACE_INDEX = 1;

    public NamespacePanel(XmlSchemaModel xmlSchemaModel, Element element) {
        this.model = xmlSchemaModel;
        this.schema = element;
        this.createUI();
        this.loadData();
    }

    public boolean validateData() {
        TableCellEditor tableCellEditor = this.prefixTable.getCellEditor();
        if (tableCellEditor != null) {
            tableCellEditor.stopCellEditing();
        }
        String string = this.targetNamespace.getText().trim();
        String string2 = this.defaultNamespace.getText().trim();
        boolean bl = string.length() == 0 || string2.equals(string);
        boolean bl2 = string2.equals("http://www.w3.org/2001/XMLSchema");
        int n = this.prefixModel.getRowCount();
        HashSet<String> hashSet = new HashSet<String>(n);
        int n2 = 0;
        while (n2 < n) {
            String string3 = ((String)this.prefixModel.getValueAt(n2, 0)).trim();
            String string4 = ((String)this.prefixModel.getValueAt(n2, 1)).trim();
            if (string3.length() > 0) {
                if (!bl && string4.equals(string)) {
                    bl = true;
                }
                if (!bl2 && string4.equals("http://www.w3.org/2001/XMLSchema")) {
                    bl2 = true;
                }
            }
            if (string3.length() > 0) {
                if (hashSet.contains(string3)) {
                    String string5 = XmlSchemaArb.getString(53);
                    MessageFormat messageFormat = new MessageFormat(string5);
                    JOptionPane.showMessageDialog(this.getTopLevelAncestor(), messageFormat.format(new Object[]{string3}), XmlSchemaArb.getString(48), 0);
                    return false;
                }
                hashSet.add(string3);
            }
            if (string3.length() == 0 && string4.length() > 0) {
                String string6 = XmlSchemaArb.getString(51);
                MessageFormat messageFormat = new MessageFormat(string6);
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), messageFormat.format(new Object[]{string4}), XmlSchemaArb.getString(48), 0);
                return false;
            }
            if (string3.length() > 0 && string4.length() == 0) {
                String string7 = XmlSchemaArb.getString(52);
                MessageFormat messageFormat = new MessageFormat(string7);
                JOptionPane.showMessageDialog(this.getTopLevelAncestor(), messageFormat.format(new Object[]{string3}), XmlSchemaArb.getString(48), 0);
                return false;
            }
            ++n2;
        }
        hashSet.clear();
        if (!bl) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), XmlSchemaArb.getString(49), XmlSchemaArb.getString(48), 0);
            return false;
        }
        if (!bl2) {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), XmlSchemaArb.getString(50), XmlSchemaArb.getString(48), 0);
            return false;
        }
        return true;
    }

    public void commitData() {
        Attr attr = this.schema.getAttributeNodeNS(null, "targetNamespace");
        String string = attr == null ? null : attr.getValue();
        attr = this.schema.getAttributeNodeNS("http://www.w3.org/2000/xmlns/", "xmlns");
        String string2 = attr == null ? null : attr.getValue();
        String string3 = this.targetNamespace.getText().trim();
        String string4 = string3.length() == 0 ? null : string3;
        string3 = this.defaultNamespace.getText().trim();
        String string5 = string3.length() == 0 ? null : string3;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = this.prefixModel.getRowCount();
        int n2 = 0;
        while (n2 < n) {
            String string6 = ((String)this.prefixModel.getValueAt(n2, 0)).trim();
            String string7 = ((String)this.prefixModel.getValueAt(n2, 1)).trim();
            if (string6.trim().length() > 0 && string7.trim().length() > 0) {
                hashMap.put(string7, string6);
            }
            ++n2;
        }
        boolean bl = false;
        Stack<Node> stack = new Stack<Node>();
        stack.push(this.schema);
        while (!stack.isEmpty()) {
            Node node = (Node)stack.pop();
            String string8 = node.getNamespaceURI();
            if (string8 != null && !"http://www.w3.org/2000/xmlns/".equals(string8) && !"http://www.w3.org/XML/1998/namespace".equals(string8)) {
                String string9 = (String)hashMap.get(string8);
                String string10 = node.getPrefix();
                if (string10 != null && !string10.equals(string9) || string10 == null && string9 != null) {
                    node.setPrefix(string9);
                    bl = true;
                }
            }
            NodeList nodeList = node.getChildNodes();
            int n3 = 0;
            while (n3 < nodeList.getLength()) {
                Node node2 = nodeList.item(n3);
                if (node2.getNodeType() == 1) {
                    stack.push(nodeList.item(n3));
                }
                ++n3;
            }
            NamedNodeMap namedNodeMap = node.getAttributes();
            if (namedNodeMap == null) continue;
            int n4 = 0;
            while (n4 < namedNodeMap.getLength()) {
                stack.push(namedNodeMap.item(n4));
                ++n4;
            }
        }
        XmlSchemaTreeTraversal xmlSchemaTreeTraversal = this.model.getSchemaTraversal();
        stack.push(this.schema);
        while (!stack.isEmpty()) {
            Node node = (Node)stack.pop();
            if (node instanceof ReferenceNode) {
                ReferenceNode referenceNode = (ReferenceNode)((Object)node);
                Attr attr2 = referenceNode.getReference().getAttr();
                if (attr2 == null) continue;
                String string11 = referenceNode.getReference().getNamespace();
                String string12 = null;
                if ("%unknown%".equals(string11)) continue;
                if ("%empty%".equals(string11)) {
                    if (string2 == null) continue;
                    string12 = (String)hashMap.get(string2);
                    if (string12 == null && string2.equals(string)) {
                        string12 = (String)hashMap.get(string4);
                    }
                } else {
                    string12 = (String)hashMap.get(string11);
                }
                String string13 = attr2.getValue();
                int n5 = string13.indexOf(58);
                String string14 = n5 > 0 ? string13.substring(n5 + 1) : string13;
                String string15 = string12 != null && string12.length() > 0 ? string12 + ":" + string14 : string14;
                attr2.setValue(string15);
                continue;
            }
            Node node3 = xmlSchemaTreeTraversal.getFirstChild(node);
            while (node3 != null) {
                stack.push(node3);
                node3 = xmlSchemaTreeTraversal.getNextSibling(node3);
            }
        }
        if (string4 == null) {
            this.schema.removeAttributeNS(null, "targetNamespace");
        } else {
            this.schema.setAttributeNS(null, "targetNamespace", string4);
        }
        if (string5 == null) {
            this.schema.removeAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns");
        } else {
            this.schema.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", string5);
        }
        NamedNodeMap namedNodeMap = this.schema.getAttributes();
        HashSet<String> hashSet = new HashSet<String>();
        for (String string16 : hashMap.keySet()) {
            String string17 = (String)hashMap.get(string16);
            String string18 = "xmlns:" + string17;
            attr = (Attr)namedNodeMap.getNamedItemNS("http://www.w3.org/2000/xmlns/", string17);
            if (attr != null) {
                if (!string16.equals(attr.getValue())) {
                    attr.setValue(string16);
                }
            } else {
                this.schema.setAttributeNS("http://www.w3.org/2000/xmlns/", string18, string16);
            }
            hashSet.add(string18);
        }
        int n6 = 0;
        while (n6 < namedNodeMap.getLength()) {
            attr = (Attr)namedNodeMap.item(n6);
            if ("http://www.w3.org/2000/xmlns/".equals(attr.getNamespaceURI()) && !"xmlns".equals(attr.getName()) && !hashSet.contains(attr.getName())) {
                this.schema.removeAttributeNode(attr);
            }
            ++n6;
        }
        if (bl) {
            Document document = this.schema.getOwnerDocument();
            document.removeChild(this.schema);
            document.appendChild(this.schema);
        }
    }

    public Component getInitialFocus() {
        return this.targetNamespace;
    }

    private void createUI() {
        this.setLayout(new BorderLayout(10, 10));
        JLabel jLabel = new JLabel();
        jLabel.setText(XmlSchemaArb.getString(35));
        this.add((Component)jLabel, "North");
        this.targetNamespace = new JTextField(20);
        JLabel jLabel2 = new JLabel(XmlSchemaArb.getString(36));
        jLabel2.setDisplayedMnemonic(XmlSchemaArb.getInteger(37));
        jLabel2.setLabelFor(this.targetNamespace);
        this.defaultNamespace = new JTextField(20);
        JLabel jLabel3 = new JLabel(XmlSchemaArb.getString(38));
        jLabel3.setDisplayedMnemonic(XmlSchemaArb.getInteger(39));
        jLabel3.setLabelFor(this.defaultNamespace);
        JPanel jPanel = new JPanel(new BorderLayout(0, 5));
        this.prefixTable = new JTable();
        this.prefixTable.setAutoResizeMode(3);
        Object[] objectArray = new String[]{XmlSchemaArb.getString(42), XmlSchemaArb.getString(43)};
        this.prefixModel = new DefaultTableModel(objectArray, 0);
        this.prefixTable.setModel(this.prefixModel);
        this.prefixTable.getTableHeader().setReorderingAllowed(false);
        this.prefixTable.setSelectionMode(2);
        this.prefixTable.setColumnSelectionAllowed(false);
        this.prefixTable.setPreferredScrollableViewportSize(new Dimension(0, 0));
        this.prefixTable.getSelectionModel().addListSelectionListener(new 3());
        TableColumn tableColumn = this.prefixTable.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(15);
        tableColumn = this.prefixTable.getColumnModel().getColumn(1);
        tableColumn.setPreferredWidth(200);
        JLabel jLabel4 = new JLabel(XmlSchemaArb.getString(40));
        jLabel4.setDisplayedMnemonic(XmlSchemaArb.getInteger(41));
        jLabel4.setLabelFor(this.prefixTable);
        jPanel.add("North", jLabel4);
        JScrollPane jScrollPane = new JScrollPane(this.prefixTable);
        jPanel.add("Center", jScrollPane);
        ButtonBar buttonBar = new ButtonBar();
        JButton jButton = new JButton(XmlSchemaArb.getString(44));
        jButton.setMnemonic(XmlSchemaArb.getInteger(45));
        this.removeButton = new JButton(XmlSchemaArb.getString(46));
        this.removeButton.setMnemonic(XmlSchemaArb.getInteger(47));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new 2());
        jButton.addActionListener(new 1());
        buttonBar.add((Component)jButton);
        buttonBar.add((Component)this.removeButton);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add("East", (Component)buttonBar);
        jPanel.add("South", jPanel2);
        JPanel jPanel3 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 12);
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel3.add(jLabel2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 5, 0);
        gridBagLayout.setConstraints(this.targetNamespace, gridBagConstraints);
        jPanel3.add(this.targetNamespace);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 12);
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel3.add(jLabel3);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        gridBagLayout.setConstraints(this.defaultNamespace, gridBagConstraints);
        jPanel3.add(this.defaultNamespace);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        gridBagConstraints.gridheight = 0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        jPanel3.add(jPanel);
        this.add((Component)jPanel3, "Center");
    }

    private void loadData() {
        this.targetNamespace.setText(this.schema.getAttributeNS(null, "targetNamespace"));
        this.defaultNamespace.setText(this.schema.getAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns"));
        NamedNodeMap namedNodeMap = this.schema.getAttributes();
        Object[] objectArray = new Object[2];
        int n = 0;
        while (n < namedNodeMap.getLength()) {
            int n2;
            Attr attr = (Attr)namedNodeMap.item(n);
            String string = attr.getName();
            if (string != null && string.startsWith("xmlns") && (n2 = string.indexOf(58)) != -1) {
                String string2 = string.substring(n2 + 1);
                String string3 = attr.getValue();
                objectArray[0] = string2;
                objectArray[1] = string3;
                this.prefixModel.addRow(objectArray);
            }
            ++n;
        }
    }

    private void removeSelectedPrefixes() {
        int[] nArray = this.prefixTable.getSelectedRows();
        Arrays.sort(nArray);
        int n = nArray.length - 1;
        while (n >= 0) {
            TableCellEditor tableCellEditor;
            if (this.prefixTable.getEditingRow() == nArray[n] && (tableCellEditor = this.prefixTable.getCellEditor()) != null) {
                tableCellEditor.stopCellEditing();
            }
            this.prefixModel.removeRow(nArray[n]);
            --n;
        }
    }

    private void addPrefix() {
        this.prefixModel.addRow(new String[]{"", ""});
        int n = this.prefixModel.getRowCount() - 1;
        this.prefixTable.setRowSelectionInterval(n, n);
        this.prefixTable.setColumnSelectionInterval(0, 0);
        Rectangle rectangle = this.prefixTable.getCellRect(n, 0, true);
        this.prefixTable.scrollRectToVisible(rectangle);
        this.prefixTable.editCellAt(n, 0);
        Component component = this.prefixTable.getEditorComponent();
        if (component != null) {
            component.requestFocus();
        }
    }

    static JButton ra$removeButton(NamespacePanel namespacePanel) {
        return namespacePanel.removeButton;
    }

    static JTable ra$prefixTable(NamespacePanel namespacePanel) {
        return namespacePanel.prefixTable;
    }

    static void mav$removeSelectedPrefixes(NamespacePanel namespacePanel) {
        namespacePanel.removeSelectedPrefixes();
    }

    static void mav$addPrefix(NamespacePanel namespacePanel) {
        namespacePanel.addPrefix();
    }

    public final class 3
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            NamespacePanel.ra$removeButton(NamespacePanel.this).setEnabled(NamespacePanel.ra$prefixTable(NamespacePanel.this).getSelectedRowCount() > 0);
        }
    }

    public final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            NamespacePanel.mav$removeSelectedPrefixes(NamespacePanel.this);
        }
    }

    public final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            NamespacePanel.mav$addPrefix(NamespacePanel.this);
        }
    }
}

