/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema;

import oracle.bali.xml.dom.AbstractNode;
import oracle.jdevimpl.xml.schema.ModelManager;
import oracle.jdevimpl.xml.schema.ProxyAttr;
import oracle.jdevimpl.xml.schema.ProxyElement;
import oracle.jdevimpl.xml.schema.ProxyNamedNodeMap;
import oracle.jdevimpl.xml.schema.ProxyNodeList;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ProxyNode
extends AbstractNode
implements Node {
    protected ModelManager manager;
    protected Document owner;
    protected Node parent;
    protected Node referee;
    private ProxyNode firstChild;
    private ProxyNode lastChild;
    private ProxyNode previousSibling;
    private ProxyNode nextSibling;

    protected ProxyNode(ModelManager modelManager, Document document, Node node, Node node2) {
        this.manager = modelManager;
        this.owner = document;
        this.parent = node;
        this.referee = node2;
    }

    public Node getReferee() {
        return this.referee;
    }

    public Document getRefereeDocument() {
        return this.referee.getOwnerDocument();
    }

    public String getNodeName() {
        return this.referee.getNodeName();
    }

    public String getNodeValue() throws DOMException {
        return this.referee.getNodeValue();
    }

    public void setNodeValue(String string) throws DOMException {
        if (this.isExternal()) {
            throw new DOMException(7, null);
        }
        this.referee.setNodeValue(string);
    }

    public short getNodeType() {
        return this.referee.getNodeType();
    }

    public Node getParentNode() {
        return this.parent;
    }

    public NodeList getChildNodes() {
        return new ProxyNodeList(this.manager, this.owner, this, this.referee.getChildNodes());
    }

    public Node getFirstChild() {
        if (this.firstChild == null) {
            this.firstChild = this.createChildProxyNode(this.referee.getFirstChild());
        }
        return this.firstChild;
    }

    public Node getLastChild() {
        if (this.lastChild == null) {
            this.lastChild = this.createChildProxyNode(this.referee.getLastChild());
        }
        return this.lastChild;
    }

    public Node getPreviousSibling() {
        if (this.previousSibling == null) {
            this.previousSibling = this.createSiblingProxyNode(this.referee.getPreviousSibling());
        }
        return this.previousSibling;
    }

    public Node getNextSibling() {
        if (this.nextSibling == null) {
            this.nextSibling = this.createSiblingProxyNode(this.referee.getNextSibling());
        }
        return this.nextSibling;
    }

    public NamedNodeMap getAttributes() {
        return new ProxyNamedNodeMap(this.manager, this.owner, this, this.referee.getAttributes());
    }

    public Document getOwnerDocument() {
        return this.owner;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        if (this.isExternal()) {
            throw new DOMException(7, null);
        }
        if (node instanceof ProxyNode) {
            node = ((ProxyNode)node).getReferee();
        }
        if (node2 instanceof ProxyNode) {
            node2 = ((ProxyNode)node2).getReferee();
        }
        return this.referee.insertBefore(node, node2);
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        if (this.isExternal()) {
            throw new DOMException(7, null);
        }
        if (node2 instanceof ProxyNode) {
            node2 = ((ProxyNode)node2).getReferee();
        }
        if (node instanceof ProxyNode) {
            node = ((ProxyNode)node).getReferee();
        }
        return this.referee.replaceChild(node, node2);
    }

    public Node removeChild(Node node) throws DOMException {
        if (this.isExternal()) {
            throw new DOMException(7, null);
        }
        if (node instanceof ProxyNode) {
            node = ((ProxyNode)node).getReferee();
        }
        return this.referee.removeChild(node);
    }

    public Node appendChild(Node node) throws DOMException {
        if (this.isExternal()) {
            throw new DOMException(7, null);
        }
        if (node instanceof ProxyNode) {
            node = ((ProxyNode)node).getReferee();
        }
        return this.referee.appendChild(node);
    }

    public boolean hasChildNodes() {
        return this.referee.hasChildNodes();
    }

    public Node cloneNode(boolean bl) {
        return new ProxyNode(this.manager, this.owner, this.parent, this.referee.cloneNode(bl));
    }

    public void normalize() {
        this.referee.normalize();
    }

    public boolean isSupported(String string, String string2) {
        return this.referee.isSupported(string, string2);
    }

    public String getNamespaceURI() {
        return this.referee.getNamespaceURI();
    }

    public String getPrefix() {
        return this.referee.getPrefix();
    }

    public void setPrefix(String string) throws DOMException {
        if (this.isExternal()) {
            throw new DOMException(7, null);
        }
        this.referee.setPrefix(string);
    }

    public String getLocalName() {
        return this.referee.getLocalName();
    }

    public boolean hasAttributes() {
        return this.referee.hasAttributes();
    }

    protected ProxyNode createSiblingProxyNode(Node node) {
        return ProxyNode.createProxyNode(this.manager, this.owner, this.parent, node);
    }

    protected ProxyNode createChildProxyNode(Node node) {
        return ProxyNode.createProxyNode(this.manager, this.owner, this, node);
    }

    public static ProxyNode createProxyNode(ModelManager modelManager, Document document, Node node, Node node2) {
        if (node2 == null) {
            return null;
        }
        ProxyNode proxyNode = node2.getNodeType() == 1 ? new ProxyElement(modelManager, document, node, (Element)node2) : (node2.getNodeType() == 2 ? new ProxyAttr(modelManager, document, node, (Attr)node2) : new ProxyNode(modelManager, document, node, node2));
        modelManager.addProxyNode(proxyNode);
        return proxyNode;
    }

    public boolean isExternal() {
        return this.owner != this.referee.getOwnerDocument();
    }

    public void resetChildren() {
        if (this.firstChild != null) {
            this.manager.removeProxyNode(this.firstChild);
            this.firstChild.reset();
            this.firstChild = null;
        }
        if (this.lastChild != null) {
            this.manager.removeProxyNode(this.lastChild);
            this.lastChild.reset();
            this.lastChild = null;
        }
    }

    protected void reset() {
        if (this.firstChild != null) {
            this.manager.removeProxyNode(this.firstChild);
            this.firstChild.reset();
            this.firstChild = null;
        }
        if (this.lastChild != null) {
            this.manager.removeProxyNode(this.lastChild);
            this.lastChild.reset();
            this.lastChild = null;
        }
        if (this.previousSibling != null) {
            this.manager.removeProxyNode(this.previousSibling);
            this.previousSibling.reset();
            this.previousSibling = null;
        }
        if (this.nextSibling != null) {
            this.manager.removeProxyNode(this.nextSibling);
            this.nextSibling.reset();
            this.nextSibling = null;
        }
    }
}

