/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import oracle.bali.xml.gui.XmlGui;
import oracle.bali.xml.gui.jdev.JDevViewHostedGui;
import oracle.bali.xml.gui.jdev.JDevXmlContext;
import oracle.bali.xml.gui.swing.ComponentXmlGui;
import oracle.bali.xml.model.XmlModelEvent;
import oracle.bali.xml.model.XmlView;
import oracle.bali.xml.share.PropertyChange;
import oracle.ide.controller.IdeAction;
import oracle.ide.view.View;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramPanel;
import oracle.jdevimpl.xml.schema.diagram.DiagramSchemaComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlSchemaDesignGui
extends XmlGui
implements ComponentXmlGui,
JDevViewHostedGui {
    private View view;
    private DiagramPanel panel;
    private boolean showing;
    private XmlModelEvent bufferedEvent;

    public XmlSchemaDesignGui(XmlView xmlView) {
        super(xmlView);
    }

    public void dispose() {
        this.panel.dispose();
    }

    public void showPopupMenu(MouseEvent mouseEvent) {
        JDevXmlContext.showContextMenu((JDevViewHostedGui)this, (MouseEvent)mouseEvent);
    }

    public void setOwningJDevView(View view) {
        this.view = view;
    }

    public View getOwningJDevView() {
        return this.view;
    }

    public Component getComponent() {
        if (this.panel == null) {
            this.createUI();
        }
        return this.panel;
    }

    public List getSchemaActions() {
        DiagramSchemaComponent diagramSchemaComponent;
        Diagram diagram;
        if (this.panel != null && (diagram = this.panel.getDiagram()) != null && (diagramSchemaComponent = diagram.getSelectionManager().getActiveComponent()) != null) {
            return diagramSchemaComponent.getActions();
        }
        return Collections.EMPTY_LIST;
    }

    public boolean handleAction(IdeAction ideAction) {
        DiagramSchemaComponent diagramSchemaComponent;
        Diagram diagram;
        if (this.panel != null && (diagram = this.panel.getDiagram()) != null && (diagramSchemaComponent = diagram.getSelectionManager().getActiveComponent()) != null) {
            return diagramSchemaComponent.handleAction(ideAction);
        }
        return false;
    }

    protected void handleShown() {
        super.handleShown();
        this.showing = true;
        if (this.bufferedEvent != null) {
            this.handleModelChangeEvent(this.bufferedEvent);
            this.bufferedEvent = null;
        }
    }

    protected void handleHidden() {
        super.handleHidden();
        this.showing = false;
    }

    protected void handleModelChangeEvent(XmlModelEvent xmlModelEvent) {
        Node node;
        Node node2;
        super.handleModelChangeEvent(xmlModelEvent);
        if (!this.showing) {
            if (this.bufferedEvent == null) {
                this.bufferedEvent = (XmlModelEvent)xmlModelEvent.clone();
            } else {
                this.bufferedEvent.addModelEvent(xmlModelEvent);
            }
            return;
        }
        if (this.panel == null) {
            return;
        }
        PropertyChange propertyChange = xmlModelEvent.getDomDocumentValidPropertyChange();
        if (propertyChange != null) {
            boolean bl = propertyChange.getNewBooleanValue();
            this.panel.setValid(bl);
        }
        if (xmlModelEvent.isDomTreeChanged() && (node2 = xmlModelEvent.getChangeRoot()) instanceof Node && (node = node2).getNodeType() == 9) {
            this.documentChanged();
        }
        if (xmlModelEvent.isPropertyChanged() && xmlModelEvent.containsPropertyChange("dropLocation")) {
            this.panel.getGlassPane().repaint();
        }
    }

    private void createUI() {
        this.panel = new DiagramPanel(this);
        this.documentChanged();
    }

    private void documentChanged() {
        if (this.panel != null) {
            this.getView().acquireReadLock();
            try {
                Document document;
                Element element = null;
                if (this.getView().getBaseModel().isDocumentValid() && (document = this.getView().getDocument()) != null) {
                    element = document.getDocumentElement();
                }
                this.panel.setDiagramRoot(element);
                this.panel.setSupported(this.isSupported(element));
            }
            finally {
                this.getView().releaseReadLock();
            }
        }
    }

    private boolean isSupported(Node node) {
        return node == null || "http://www.w3.org/2001/XMLSchema".equals(node.getNamespaceURI());
    }
}

