/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.grammar.AttributeDef;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarComponent;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.QualifiedName;
import oracle.bali.xml.grammar.resolver.GrammarResolver;
import oracle.bali.xml.metadata.DerivedXmlKey;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.jdevimpl.xml.schema.GlobalReference;
import oracle.jdevimpl.xml.schema.ModelManager;
import oracle.jdevimpl.xml.schema.ProxyNode;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.XmlSchemaModel;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlSchemaMetadataResolver
extends XmlMetadataResolver {
    private static final String XDB_NAMESPACE = "http://xmlns.oracle.com/xdb";
    public static final String XDB_METADATA_NAMESPACE = "http://xmlns.oracle.com/xdb/metadata";
    public static final QualifiedName XDB_ATTRIBUTE_USAGE = QualifiedName.getQualifiedName((String)"http://xmlns.oracle.com/xdb/metadata", (String)"usage");
    private static final String XDB_USAGE_SCHEMA = "schema";
    private static final String XDB_USAGE_ELEMENT = "element";
    private static final String XDB_USAGE_COMPLEXTYPE = "complexType";
    private static final String XDB_USAGE_ATTRIBUTE = "attribute";
    private HashMap xdbAttributeMap;

    void $init$() {
        this.xdbAttributeMap = new HashMap();
    }

    public XmlSchemaMetadataResolver(MetadataEvaluator metadataEvaluator, AbstractModel abstractModel) {
        super(metadataEvaluator, abstractModel);
        this.$init$();
        this.createXdbMappings();
    }

    protected XmlMetadataResolver createResolver(MetadataEvaluator metadataEvaluator, AbstractModel abstractModel) {
        return new XmlSchemaMetadataResolver(metadataEvaluator, abstractModel);
    }

    public int getSchemaRole(XmlKey xmlKey) {
        QualifiedName qualifiedName;
        if (xmlKey != null && (qualifiedName = xmlKey.getElementQName()) != null) {
            return ModelUtils.getSchemaRole(xmlKey.getNamespace(), qualifiedName.getName());
        }
        return -1;
    }

    public int getSchemaRole(Node node) {
        return node instanceof ReferenceNode ? -1 : this.getSchemaRole(this.getNodeXmlKey(node));
    }

    public int getSchemaRole(QualifiedName qualifiedName) {
        return ModelUtils.getSchemaRole(qualifiedName.getNamespace(), qualifiedName.getName());
    }

    protected String getHelpTopicImpl(Node node, XmlKey xmlKey) {
        QualifiedName qualifiedName;
        List list;
        int n;
        String string = super.getHelpTopicImpl(node, xmlKey);
        if (string == null && xmlKey.getNodeType() == 1 && (n = (list = xmlKey.getElementQNamePath()).size()) > 0 && "http://www.w3.org/2001/XMLSchema".equals((qualifiedName = (QualifiedName)list.get(n - 1)).getNamespace())) {
            String string2 = qualifiedName.getName();
            string = "f1_xsd" + string2.toLowerCase(Locale.US) + "_html";
        }
        return string;
    }

    protected List createAttributeKeys(XmlKey xmlKey) {
        ArrayList arrayList = super.createAttributeKeys(xmlKey);
        List list = this.createXdbAttributeKeys(xmlKey);
        if (list != null && !list.isEmpty()) {
            if (arrayList.isEmpty()) {
                arrayList = list;
            } else {
                arrayList = new ArrayList(arrayList);
                arrayList.addAll(list);
            }
        }
        return arrayList;
    }

    protected boolean isHiddenImpl(Node node, XmlKey xmlKey) {
        if (xmlKey.getNodeType() == 2 && "http://www.w3.org/2000/xmlns/".equals(xmlKey.getNamespace())) {
            return true;
        }
        return super.isHiddenImpl(node, xmlKey);
    }

    public boolean isConvertible(Node node) {
        return false;
    }

    protected boolean isDeletableImpl(XmlKey xmlKey, Node node) {
        if (node != null) {
            Document document = node.getOwnerDocument();
            if (document != null && node == document.getDocumentElement()) {
                return false;
            }
            if (node instanceof ProxyNode && ((ProxyNode)node).isExternal()) {
                return false;
            }
        } else if (xmlKey.getNodeType() == 1 && "http://www.w3.org/2001/XMLSchema".equals(xmlKey.getNamespace()) && XDB_USAGE_SCHEMA.equals(xmlKey.getLocalName())) {
            return false;
        }
        return super.isDeletableImpl(xmlKey, node);
    }

    protected boolean isImmutableImpl(XmlKey xmlKey, Node node) {
        if (node != null && node instanceof ProxyNode && ((ProxyNode)node).isExternal()) {
            return true;
        }
        return super.isImmutableImpl(xmlKey, node);
    }

    public boolean isSurroundable(Node[] nodeArray) {
        if (nodeArray != null) {
            int n = 0;
            while (n < nodeArray.length) {
                if (nodeArray[n] instanceof ProxyNode && ((ProxyNode)nodeArray[n]).isExternal()) {
                    return false;
                }
                ++n;
            }
        }
        return super.isSurroundable(nodeArray);
    }

    protected boolean isValidInsertionImpl(Node node, XmlKey xmlKey, Node node2, XmlKey xmlKey2, int n) {
        if (xmlKey2 == null && node2 != null) {
            xmlKey2 = this.getNodeXmlKey(node2);
        }
        if (node != null && xmlKey2 != null) {
            boolean bl;
            Node node3 = this.getInsertionTarget(node, xmlKey2);
            if (node3 != node) {
                n = 0;
            }
            if (bl = super.isValidInsertionImpl(node3, this.getNodeXmlKey(node3), node2, xmlKey2, n)) {
                bl = this.checkOccuranceConstraints(node3, xmlKey2);
                if (bl && this.getSchemaRole(xmlKey2) == 11) {
                    bl = this.checkFacets(node3, xmlKey2);
                }
                if (bl && node2 != null) {
                    bl = this.checkRequiredAttributes(node2, node, xmlKey2);
                }
                return bl;
            }
            return this.canCreateInsertionTarget(node3, xmlKey2);
        }
        return super.isValidInsertionImpl(node, xmlKey, node2, xmlKey2, n);
    }

    private boolean checkRequiredAttributes(Node node, Node node2, XmlKey xmlKey) {
        if (node.getNodeType() == 1) {
            QualifiedName qualifiedName;
            ElementDef elementDef;
            ElementDef elementDef2;
            Element element = (Element)node;
            GrammarComponent grammarComponent = this.getGrammarComponent(node2);
            if (grammarComponent instanceof ElementDef && (elementDef2 = (elementDef = (ElementDef)grammarComponent).getElementDefByName(qualifiedName = xmlKey.getElementQName())) != null) {
                Collection collection = elementDef2.getAttributeDefs();
                for (AttributeDef attributeDef : collection) {
                    if (!attributeDef.isRequired() || element.hasAttribute(attributeDef.getName())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean isValidInsertionDirect(DomPosition domPosition, XmlKey xmlKey) {
        Node node = domPosition.getContainerNode();
        return super.isValidInsertionImpl(node, this.getNodeXmlKey(node), null, xmlKey, domPosition.getRelativePosition());
    }

    protected Node getInsertionTarget(Node node, XmlKey xmlKey) {
        Node node2;
        Node node3;
        Node node4;
        Attr attr;
        int n = this.getSchemaRole(node);
        int n2 = this.getSchemaRole(xmlKey);
        if ((n == 9 || n == 12 || n == 5) && (attr = ((Element)node).getAttributeNodeNS(null, "ref")) != null) {
            String string = attr.getValue();
            ModelManager modelManager = this.getModelManager();
            int n3 = n == 9 ? 1 : (n == 12 ? 5 : 7);
            GlobalReference globalReference = new GlobalReference(modelManager.getNamespace(node, string), ModelUtils.getName(string), n3);
            Node node5 = modelManager.resolveReference(globalReference);
            if (node5 != null) {
                return this.getInsertionTarget(node5, xmlKey);
            }
            return node;
        }
        if (n == 20 && n2 == 11 && (node4 = this.getRestrictionWithBase(node)) != null) {
            return node4;
        }
        if ((n == 15 || n == 21) && n2 == 11 && ModelUtils.getSchemaRole(node3 = (node2 = node.getParentNode()).getParentNode()) == 16) {
            return node3;
        }
        if (n == 9 && (n2 == 15 || n2 == 21 || n2 == 11 || ModelUtils.isAttributeRole(n2) || ModelUtils.isModelGroupRole(n2))) {
            Element element = ModelUtils.getChild(node, "simpleType");
            if (element != null) {
                return this.getInsertionTarget(element, xmlKey);
            }
            Element element2 = ModelUtils.getChild(node, XDB_USAGE_COMPLEXTYPE);
            if (element2 != null) {
                return this.getInsertionTarget(element2, xmlKey);
            }
        }
        if (n == 8 && (n2 == 15 || n2 == 21 || n2 == 11 || ModelUtils.isAttributeRole(n2) || ModelUtils.isModelGroupRole(n2))) {
            Element element = ModelUtils.getChild(node, "simpleContent");
            if (element != null) {
                Node node6 = this.getRestrictionWithBase(element);
                if (node6 == null) {
                    node6 = ModelUtils.getChild(element, "extension");
                }
                if (node6 != null) {
                    return node6;
                }
            } else {
                element = ModelUtils.getChild(node, "complexContent");
                if (element != null) {
                    Element element3 = ModelUtils.getChild(element, "restriction");
                    if (element3 == null) {
                        element3 = ModelUtils.getChild(element, "extension");
                    }
                    if (element3 != null) {
                        return element3;
                    }
                }
            }
        }
        return node;
    }

    protected boolean canCreateInsertionTarget(Node node, XmlKey xmlKey) {
        Attr attr;
        int n = this.getSchemaRole(node);
        int n2 = this.getSchemaRole(xmlKey);
        if ((n == 15 || n == 21) && n2 == 11) {
            return this.checkFacets(node, xmlKey);
        }
        if (n == 9 && (ModelUtils.isAttributeRole(n2) || ModelUtils.isModelGroupRole(n2)) && ModelUtils.getAnonymousType(node) == null && ((Element)node).getAttributeNodeNS(null, "ref") == null) {
            Attr attr2 = ((Element)node).getAttributeNodeNS(null, "type");
            if (attr2 != null) {
                Node node2;
                String string = attr2.getValue();
                ModelManager modelManager = this.getModelManager();
                GlobalReference globalReference = new GlobalReference(modelManager.getNamespace(node, string), ModelUtils.getName(string), 4);
                if (ModelUtils.isModelGroupRole(n2) ? !globalReference.isBuiltInType() && (node2 = this.getModelManager().resolveReference(globalReference)) != null && !ModelUtils.hasSimpleContent(node2) : this.getModelManager().resolveReference(globalReference) != null || globalReference.isBuiltInType()) {
                    return true;
                }
            } else {
                return true;
            }
        }
        if (n == 9 && (n2 == 15 || n2 == 21) && ModelUtils.getAnonymousType(node) == null && ((Element)node).getAttributeNodeNS(null, "ref") == null) {
            Attr attr3 = ((Element)node).getAttributeNodeNS(null, "type");
            Node node3 = ModelUtils.getAnonymousType(node);
            if (attr3 == null && node3 == null) {
                return true;
            }
        }
        if (n == 9 && n2 == 11 && ModelUtils.getAnonymousType(node) == null && ((Element)node).getAttributeNodeNS(null, "ref") == null && (attr = ((Element)node).getAttributeNodeNS(null, "type")) != null) {
            String string = attr.getValue();
            ModelManager modelManager = this.getModelManager();
            GlobalReference globalReference = new GlobalReference(modelManager.getNamespace(node, string), ModelUtils.getName(string), 4);
            if (globalReference.isBuiltInType()) {
                return true;
            }
            Node node4 = this.getModelManager().resolveReference(globalReference);
            if (node4 != null && ModelUtils.hasSimpleContent(node4)) {
                return true;
            }
        }
        return false;
    }

    private boolean checkOccuranceConstraints(Node node, XmlKey xmlKey) {
        int n = this.getSchemaRole(node);
        int n2 = this.getSchemaRole(xmlKey);
        if (n2 == 1 && n != 17 && ModelUtils.getChild(node, "annotation") != null) {
            return false;
        }
        if (n == 20 && (ModelUtils.isContainerRole(n2) || n2 == 15 || n2 == 21)) {
            Element element = ModelUtils.getChild(node, "restriction");
            if (element != null) {
                return false;
            }
            element = ModelUtils.getChild(node, "list");
            if (element != null) {
                return false;
            }
            element = ModelUtils.getChild(node, "union");
            if (element != null) {
                return false;
            }
        }
        if (n == 15 && n2 == 20) {
            Element element = ModelUtils.getChild(node, "simpleType");
            if (element != null) {
                return false;
            }
            Attr attr = ((Element)node).getAttributeNodeNS(null, "itemType");
            if (attr != null) {
                return false;
            }
        }
        if (n2 == 3 && ModelUtils.getChild(node, "anyAttribute") != null) {
            return false;
        }
        if (n == 8 && (n2 == 7 || n2 == 19 || ModelUtils.isModelGroupRole(n2))) {
            NodeList nodeList = node.getChildNodes();
            int n3 = 0;
            while (n3 < nodeList.getLength()) {
                int n4 = this.getSchemaRole(nodeList.item(n3));
                if (n4 == 7 || n4 == 19 || ModelUtils.isModelGroupRole(n4)) {
                    return false;
                }
                ++n3;
            }
        }
        if ((n == 12 || n == 10 || n == 16) && ModelUtils.isModelGroupRole(n2)) {
            NodeList nodeList = node.getChildNodes();
            int n5 = 0;
            while (n5 < nodeList.getLength()) {
                if (ModelUtils.isModelGroupRole(this.getSchemaRole(nodeList.item(n5)))) {
                    return false;
                }
                ++n5;
            }
        }
        if (n == 16 && n2 == 20) {
            Element element = ModelUtils.getChild(node, "simpleType");
            if (element != null) {
                return false;
            }
            Attr attr = ((Element)node).getAttributeNodeNS(null, "base");
            if (attr != null) {
                return false;
            }
        }
        if (!(n != 19 && n != 7 || n2 != 10 && n2 != 16 || ModelUtils.getChild(node, "extension") == null && ModelUtils.getChild(node, "restriction") == null)) {
            return false;
        }
        if (n == 9 && (n2 == 20 || n2 == 8)) {
            Attr attr = ((Element)node).getAttributeNodeNS(null, "type");
            if (attr != null) {
                return false;
            }
            if (ModelUtils.getChild(node, "simpleType") != null || ModelUtils.getChild(node, XDB_USAGE_COMPLEXTYPE) != null) {
                return false;
            }
        }
        return true;
    }

    public boolean checkFacets(Node node, XmlKey xmlKey) {
        Element element;
        Attr attr;
        boolean bl;
        int n = this.getSchemaRole(node);
        String string = xmlKey.getLocalName();
        boolean bl2 = n == 15;
        boolean bl3 = bl = n == 21;
        if (n == 16 && (attr = ((Element)node).getAttributeNodeNS(null, "base")) == null && (element = ModelUtils.getChild(node, "simpleType")) != null) {
            if (ModelUtils.getChild(element, "list") != null) {
                bl2 = true;
            } else if (ModelUtils.getChild(element, "union") != null) {
                bl = true;
            }
        }
        if (bl2) {
            return "length".equals(string) || "maxLength".equals(string) || "minLength".equals(string) || "enumeration".equals(string) || "pattern".equals(string) || "whiteSpace".equals(string);
        }
        if (bl) {
            return "enumeration".equals(string) || "pattern".equals(string);
        }
        return true;
    }

    public Collection getPotentialInsertionPositions(DomPosition domPosition) {
        Node node = domPosition.getTargetNode();
        if (node instanceof ProxyNode && ((ProxyNode)node).isExternal()) {
            return Collections.EMPTY_LIST;
        }
        return super.getPotentialInsertionPositions(domPosition);
    }

    protected Collection getCreateableChildrenXmlKeysImpl(DomPosition domPosition, XmlKey xmlKey) {
        Collection collection = super.getCreateableChildrenXmlKeysImpl(domPosition, xmlKey);
        ArrayList arrayList = new ArrayList(collection.size() + 10);
        arrayList.addAll(collection);
        int n = this.getSchemaRole(xmlKey);
        switch (n) {
            case 9: {
                this.addKey(arrayList, xmlKey, "all");
                this.addKey(arrayList, xmlKey, "choice");
                this.addKey(arrayList, xmlKey, "sequence");
                this.addKey(arrayList, xmlKey, "group");
                this.addKey(arrayList, xmlKey, XDB_USAGE_ATTRIBUTE);
                this.addKey(arrayList, xmlKey, "attributeGroup");
                this.addKey(arrayList, xmlKey, "anyAttribute");
                this.addKey(arrayList, xmlKey, "list");
                this.addKey(arrayList, xmlKey, "union");
                this.addKey(arrayList, xmlKey, "enumeration");
                this.addKey(arrayList, xmlKey, "fractionDigits");
                this.addKey(arrayList, xmlKey, "length");
                this.addKey(arrayList, xmlKey, "maxExclusive");
                this.addKey(arrayList, xmlKey, "maxInclusive");
                this.addKey(arrayList, xmlKey, "maxLength");
                this.addKey(arrayList, xmlKey, "minExclusive");
                this.addKey(arrayList, xmlKey, "minInclusive");
                this.addKey(arrayList, xmlKey, "minLength");
                this.addKey(arrayList, xmlKey, "pattern");
                this.addKey(arrayList, xmlKey, "totalDigits");
                this.addKey(arrayList, xmlKey, "whiteSpace");
                break;
            }
            case 15: {
                this.addKey(arrayList, xmlKey, "length");
                this.addKey(arrayList, xmlKey, "maxLength");
                this.addKey(arrayList, xmlKey, "minLength");
                this.addKey(arrayList, xmlKey, "enumeration");
                this.addKey(arrayList, xmlKey, "pattern");
                this.addKey(arrayList, xmlKey, "whiteSpace");
                break;
            }
            case 21: {
                this.addKey(arrayList, xmlKey, "enumeration");
                this.addKey(arrayList, xmlKey, "pattern");
                break;
            }
            case 8: {
                this.addKey(arrayList, xmlKey, "list");
                this.addKey(arrayList, xmlKey, "union");
                this.addKey(arrayList, xmlKey, "enumeration");
                this.addKey(arrayList, xmlKey, "fractionDigits");
                this.addKey(arrayList, xmlKey, "length");
                this.addKey(arrayList, xmlKey, "maxExclusive");
                this.addKey(arrayList, xmlKey, "maxInclusive");
                this.addKey(arrayList, xmlKey, "maxLength");
                this.addKey(arrayList, xmlKey, "minExclusive");
                this.addKey(arrayList, xmlKey, "minInclusive");
                this.addKey(arrayList, xmlKey, "minLength");
                this.addKey(arrayList, xmlKey, "pattern");
                this.addKey(arrayList, xmlKey, "totalDigits");
                this.addKey(arrayList, xmlKey, "whiteSpace");
                break;
            }
            case 20: {
                this.addKey(arrayList, xmlKey, "enumeration");
                this.addKey(arrayList, xmlKey, "fractionDigits");
                this.addKey(arrayList, xmlKey, "length");
                this.addKey(arrayList, xmlKey, "maxExclusive");
                this.addKey(arrayList, xmlKey, "maxInclusive");
                this.addKey(arrayList, xmlKey, "maxLength");
                this.addKey(arrayList, xmlKey, "minExclusive");
                this.addKey(arrayList, xmlKey, "minInclusive");
                this.addKey(arrayList, xmlKey, "minLength");
                this.addKey(arrayList, xmlKey, "pattern");
                this.addKey(arrayList, xmlKey, "totalDigits");
                this.addKey(arrayList, xmlKey, "whiteSpace");
                break;
            }
        }
        if (domPosition != null) {
            int n2 = arrayList.size() - 1;
            while (n2 >= 0) {
                boolean bl = this.isValidInsertion(domPosition, Collections.singletonList((XmlKey)arrayList.get(n2)));
                if (!bl) {
                    arrayList.remove(n2);
                }
                --n2;
            }
        }
        arrayList.trimToSize();
        return arrayList;
    }

    public boolean isValidInsertion(DomPosition domPosition, List list) {
        if (!domPosition.isInside()) {
            Node node = domPosition.getTargetNode();
            for (XmlKey xmlKey : list) {
                if (this.isValidInsertion(domPosition, node, xmlKey)) continue;
                return false;
            }
        }
        return super.isValidInsertion(domPosition, list);
    }

    public boolean isValidInsertion(DomPosition domPosition, NodeList nodeList) {
        if (!domPosition.isInside()) {
            Node node = domPosition.getTargetNode();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                XmlKey xmlKey = this.getNodeXmlKey(nodeList.item(n2));
                if (!this.isValidInsertion(domPosition, node, xmlKey)) {
                    return false;
                }
                ++n2;
            }
        }
        return super.isValidInsertion(domPosition, nodeList);
    }

    public XmlKey getXmlKeyForInsertion(XmlKey xmlKey, QualifiedName qualifiedName) {
        ArrayList<QualifiedName> arrayList = new ArrayList<QualifiedName>();
        int n = this.getSchemaRole(xmlKey);
        int n2 = this.getSchemaRole(qualifiedName);
        if (n == 9) {
            if (ModelUtils.isAttributeRole(n2) || ModelUtils.isModelGroupRole(n2)) {
                arrayList.add(QualifiedName.getQualifiedName((String)"http://www.w3.org/2001/XMLSchema", (String)XDB_USAGE_COMPLEXTYPE));
            } else if (n2 == 15 || n2 == 21 || n2 == 11) {
                arrayList.add(QualifiedName.getQualifiedName((String)"http://www.w3.org/2001/XMLSchema", (String)"simpleType"));
            }
        } else if ((n == 15 || n == 21) && n2 == 11) {
            arrayList.add(QualifiedName.getQualifiedName((String)"http://www.w3.org/2001/XMLSchema", (String)"simpleType"));
            arrayList.add(QualifiedName.getQualifiedName((String)"http://www.w3.org/2001/XMLSchema", (String)"restriction"));
        }
        arrayList.add(qualifiedName);
        GrammarResolver grammarResolver = this.getContext().getGrammarResolver();
        return DerivedXmlKey.createElementKey((GrammarResolver)grammarResolver, (XmlKey)xmlKey, arrayList).intern();
    }

    protected String getPropertyDisplayNameImpl(Node node, XmlKey xmlKey, Node node2, XmlKey xmlKey2) {
        String string;
        if (xmlKey.getNodeType() == 2 && (string = xmlKey.getNamespace()) != null && XDB_NAMESPACE.equals(string)) {
            return this.getShortDisplayNameImpl(node, xmlKey);
        }
        return super.getPropertyDisplayNameImpl(node, xmlKey, node2, xmlKey2);
    }

    private boolean isValidInsertion(DomPosition domPosition, Node node, XmlKey xmlKey) {
        boolean bl = true;
        if (domPosition.isBefore() || domPosition.isAfter()) {
            Node node2 = domPosition.getContainerNode();
            int n = this.getSchemaRole(xmlKey);
            int n2 = this.getSchemaRole(node2);
            HashSet<Integer> hashSet = new HashSet<Integer>();
            HashSet hashSet2 = new HashSet();
            HashSet<Integer> hashSet3 = new HashSet<Integer>();
            HashSet<Integer> hashSet4 = new HashSet<Integer>();
            if (n2 == 17) {
                if (n == 14) {
                    hashSet.add(new Integer(14));
                    hashSet.add(new Integer(1));
                    hashSet.add(new Integer(-1));
                } else if (n != 1 && n != -1) {
                    hashSet4.add(new Integer(14));
                }
            }
            if (n2 != 17 && n2 != 14) {
                if (n == 1) {
                    hashSet.add(new Integer(1));
                    hashSet.add(new Integer(-1));
                } else if (n != -1) {
                    hashSet4.add(new Integer(1));
                }
            }
            if (n2 != 17) {
                if (ModelUtils.isAttributeRole(n)) {
                    hashSet4.add(new Integer(7));
                    hashSet4.add(new Integer(19));
                    hashSet4.add(new Integer(0));
                    hashSet4.add(new Integer(6));
                    hashSet4.add(new Integer(12));
                    hashSet4.add(new Integer(18));
                } else if (ModelUtils.isModelGroupRole(n) || n == 7 || n == 19) {
                    hashSet3.add(new Integer(4));
                    hashSet3.add(new Integer(3));
                    hashSet3.add(new Integer(5));
                }
            }
            if (!hashSet.isEmpty() || !hashSet3.isEmpty()) {
                Node node3 = domPosition.isAfter() ? node : node.getPreviousSibling();
                while (bl && node3 != null) {
                    Integer n3 = new Integer(this.getSchemaRole(node3));
                    if (!hashSet.isEmpty() && !hashSet.contains(n3) || hashSet3.contains(n3)) {
                        bl = false;
                    }
                    node3 = node3.getPreviousSibling();
                }
            }
            if (!(!bl || hashSet2.isEmpty() && hashSet4.isEmpty())) {
                Node node4 = domPosition.isBefore() ? node : node.getNextSibling();
                while (bl && node4 != null) {
                    Integer n4 = new Integer(this.getSchemaRole(node4));
                    if (!hashSet2.isEmpty() && !hashSet2.contains(n4) || hashSet4.contains(n4)) {
                        bl = false;
                    }
                    node4 = node4.getNextSibling();
                }
            }
        }
        return bl;
    }

    private Node getRestrictionWithBase(Node node) {
        int n = this.getSchemaRole(node);
        Element element = null;
        element = n == 16 ? (Element)node : ModelUtils.getChild(node, "restriction");
        while (element != null) {
            if (element.getAttributeNodeNS(null, "base") != null) break;
            Element element2 = ModelUtils.getChild(element, "simpleType");
            if (element2 != null) {
                if (ModelUtils.getChild(element2, "list") != null || ModelUtils.getChild(element2, "union") != null) break;
                element = ModelUtils.getChild(element2, "restriction");
                continue;
            }
            element = null;
        }
        return element;
    }

    private ModelManager getModelManager() {
        return ((XmlSchemaModel)this.getModel()).getModelManager();
    }

    private void addKey(List list, XmlKey xmlKey, String string) {
        QualifiedName qualifiedName = QualifiedName.getQualifiedName((String)"http://www.w3.org/2001/XMLSchema", (String)string);
        list.add(this.getXmlKeyForInsertion(xmlKey, qualifiedName));
    }

    private List createXdbAttributeKeys(XmlKey xmlKey) {
        List list = xmlKey.getElementQNamePath();
        if (list.size() > 0) {
            QualifiedName qualifiedName = (QualifiedName)list.get(list.size() - 1);
            return (List)this.xdbAttributeMap.get(qualifiedName);
        }
        return null;
    }

    private void createXdbMappings() {
        GrammarProvider grammarProvider = this.getContext().getGrammarProvider();
        Grammar grammar = grammarProvider.getGrammarForNamespace(XDB_NAMESPACE);
        if (grammar != null) {
            ArrayList<XmlKey> arrayList = new ArrayList<XmlKey>();
            ArrayList<XmlKey> arrayList2 = new ArrayList<XmlKey>();
            ArrayList<XmlKey> arrayList3 = new ArrayList<XmlKey>();
            ArrayList<XmlKey> arrayList4 = new ArrayList<XmlKey>();
            for (AttributeDef attributeDef : grammar.getAttributeDefs()) {
                XmlKey xmlKey = ImmutableXmlKey.createAttributeKey((QualifiedName)attributeDef.getQualifiedName());
                String string = (String)this.getMetadataEvaluator().getMetadataItem((Object)xmlKey, (Object)XDB_ATTRIBUTE_USAGE, null);
                if (string == null) continue;
                String[] stringArray = string.split(" ");
                int n = 0;
                while (n < stringArray.length) {
                    if (XDB_USAGE_SCHEMA.equals(stringArray[n])) {
                        arrayList.add(xmlKey);
                    } else if (XDB_USAGE_ELEMENT.equals(stringArray[n])) {
                        arrayList2.add(xmlKey);
                    } else if (XDB_USAGE_COMPLEXTYPE.equals(stringArray[n])) {
                        arrayList3.add(xmlKey);
                    } else if (XDB_USAGE_ATTRIBUTE.equals(stringArray[n])) {
                        arrayList4.add(xmlKey);
                    }
                    ++n;
                }
            }
            arrayList.trimToSize();
            arrayList2.trimToSize();
            arrayList3.trimToSize();
            arrayList4.trimToSize();
            this.addXdbMapping(XDB_USAGE_SCHEMA, arrayList);
            this.addXdbMapping(XDB_USAGE_ELEMENT, arrayList2);
            this.addXdbMapping(XDB_USAGE_COMPLEXTYPE, arrayList3);
            this.addXdbMapping(XDB_USAGE_ATTRIBUTE, arrayList4);
        }
    }

    private void addXdbMapping(String string, List list) {
        QualifiedName qualifiedName = QualifiedName.getQualifiedName((String)"http://www.w3.org/2001/XMLSchema", (String)string);
        this.xdbAttributeMap.put(qualifiedName, list);
    }
}

