/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema;

import java.util.List;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.metadata.MetadataEvaluator;
import oracle.bali.xml.metadata.MetadataProvider;
import oracle.bali.xml.metadata.MetadataRegistry;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.model.XmlMetadataEvaluator;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.datatransfer.operation.OperationFactory;
import oracle.bali.xml.util.DefaultPrefixLookup;
import oracle.bali.xml.util.NamespaceUtils;
import oracle.javatools.datatransfer.DataTransferPluginFactory;
import oracle.jdevimpl.xml.schema.GlobalReference;
import oracle.jdevimpl.xml.schema.ModelManager;
import oracle.jdevimpl.xml.schema.XmlSchemaDataTransferPluginFactory;
import oracle.jdevimpl.xml.schema.XmlSchemaMetadataResolver;
import oracle.jdevimpl.xml.schema.XmlSchemaOperationFactory;
import oracle.jdevimpl.xml.schema.XmlSchemaTreeTraversal;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlSchemaModel
extends XmlModel {
    private ModelManager modelManager;
    private XmlSchemaTreeTraversal schemaTraversal;

    public XmlSchemaModel() {
        super(MetadataRegistry.getInstance().getMetadataProvider("xml schema metadata"));
    }

    public XmlSchemaTreeTraversal getSchemaTraversal() {
        return this.schemaTraversal;
    }

    protected void contextAttached() {
        super.contextAttached();
        this.modelManager = new ModelManager(this);
        this.schemaTraversal = new XmlSchemaTreeTraversal(this);
        this.getContext().getDataTransferPluginRegistry().registerFactory((DataTransferPluginFactory)new XmlSchemaDataTransferPluginFactory());
        this.getContext().getOperationManager().registerOperationFactory((OperationFactory)new XmlSchemaOperationFactory());
    }

    public Node resolveReference(GlobalReference globalReference) {
        return this.modelManager.resolveReference(globalReference);
    }

    public String getNamespace(Node node, String string) {
        return this.modelManager.getNamespace(node, string);
    }

    public List getGlobals(Node node, int n) {
        return this.modelManager.getGlobals(node, n);
    }

    public ModelManager getModelManager() {
        return this.modelManager;
    }

    protected XmlMetadataResolver createMetadataResolver(MetadataProvider metadataProvider) {
        XmlContext xmlContext = this.getContext();
        XmlMetadataEvaluator xmlMetadataEvaluator = new XmlMetadataEvaluator(metadataProvider, xmlContext.getGrammarProvider(), xmlContext.getGrammarResolver(), (AbstractModel)this);
        return new XmlSchemaMetadataResolver((MetadataEvaluator)xmlMetadataEvaluator, (AbstractModel)this);
    }

    public DomPosition findValidInsertionPosition(XmlKey xmlKey, Node node, DomPosition domPosition, XmlKey xmlKey2) {
        if (xmlKey == null) {
            xmlKey = this.getNodeXmlKey(node);
        }
        return this.getImportLocation(xmlKey, domPosition);
    }

    private DomPosition getImportLocation(XmlKey xmlKey, DomPosition domPosition) {
        boolean bl;
        DomPosition domPosition2 = domPosition;
        Node node = domPosition.getContainerNode();
        XmlSchemaMetadataResolver xmlSchemaMetadataResolver = this.getXmlSchemaMetadataResolver();
        Node node2 = xmlSchemaMetadataResolver.getInsertionTarget(node, xmlKey);
        if (node2 != node) {
            domPosition2 = DomPositionFactory.createDomPosition((Node)node2, (int)0);
        }
        if (!(bl = xmlSchemaMetadataResolver.isValidInsertionDirect(domPosition2, xmlKey)) && (node2 = this.createImportLocation(node2, xmlKey)) != null) {
            domPosition2 = DomPositionFactory.createDomPosition((Node)node2, (int)0);
        }
        if (domPosition2.getRelativePosition() == 0) {
            domPosition2 = this.ensureCorrectOrdering(domPosition2, xmlKey);
        }
        return domPosition2;
    }

    private DomPosition ensureCorrectOrdering(DomPosition domPosition, XmlKey xmlKey) {
        DomPosition domPosition2 = domPosition;
        XmlSchemaMetadataResolver xmlSchemaMetadataResolver = this.getXmlSchemaMetadataResolver();
        Node node = domPosition.getContainerNode();
        int n = xmlSchemaMetadataResolver.getSchemaRole(node);
        int n2 = xmlSchemaMetadataResolver.getSchemaRole(xmlKey);
        if (n2 == 1) {
            domPosition2 = ModelUtils.getAnnotationInsertionPosition(node);
        } else if (n2 == 14) {
            Node node2 = node.getFirstChild();
            while (node2 != null) {
                int n3 = xmlSchemaMetadataResolver.getSchemaRole(node2);
                if (n3 != 1 && n3 != 14 && n3 != -1) break;
                node2 = node2.getNextSibling();
            }
            if (node2 != null) {
                domPosition2 = DomPositionFactory.createDomPosition((Node)node2, (int)1);
            }
        } else if (n != 17 && (ModelUtils.isModelGroupRole(n2) || ModelUtils.isContainerRole(n2))) {
            Node node3 = node.getFirstChild();
            while (node3 != null && !ModelUtils.isAttributeRole(xmlSchemaMetadataResolver.getSchemaRole(node3))) {
                node3 = node3.getNextSibling();
            }
            if (node3 != null) {
                domPosition2 = DomPositionFactory.createDomPosition((Node)node3, (int)1);
            }
        }
        return domPosition2;
    }

    private Node createImportLocation(Node node, XmlKey xmlKey) {
        Attr attr;
        XmlSchemaMetadataResolver xmlSchemaMetadataResolver = this.getXmlSchemaMetadataResolver();
        int n = xmlSchemaMetadataResolver.getSchemaRole(node);
        int n2 = xmlSchemaMetadataResolver.getSchemaRole(xmlKey);
        if ((n == 15 || n == 21) && n2 == 11) {
            return this.createListOrUnionRestriction(node);
        }
        if (n == 9 && (ModelUtils.isAttributeRole(n2) || ModelUtils.isModelGroupRole(n2))) {
            return ModelUtils.createAnonymousComplexTypeWithExtension(this, (Element)node);
        }
        if (n == 9 && (n2 == 15 || n2 == 21)) {
            return ModelUtils.createAnonymousSimpleType(this, (Element)node);
        }
        if (n == 9 && n2 == 11 && (attr = ((Element)node).getAttributeNodeNS(null, "type")) != null) {
            if (ModelUtils.isSimpleType(this, node, attr.getValue())) {
                return ModelUtils.createAnonymousSimpleType(this, (Element)node);
            }
            return ModelUtils.createAnonymousComplexTypeWithRestriction(this, (Element)node);
        }
        return null;
    }

    private Node createListOrUnionRestriction(Node node) {
        Node node2 = node.getParentNode();
        Document document = node.getOwnerDocument();
        DefaultPrefixLookup defaultPrefixLookup = this.getDefaultPrefixLookup();
        Element element = document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
        NamespaceUtils.fixPrefixes((Node)node2, (Node)element, (DefaultPrefixLookup)defaultPrefixLookup);
        node2.appendChild(element);
        Element element2 = document.createElementNS("http://www.w3.org/2001/XMLSchema", "simpleType");
        NamespaceUtils.fixPrefixes((Node)element, (Node)element2, (DefaultPrefixLookup)defaultPrefixLookup);
        element.appendChild(element2);
        node2.removeChild(node);
        NamespaceUtils.fixPrefixes((Node)element2, (Node)node, (DefaultPrefixLookup)defaultPrefixLookup);
        element2.appendChild(node);
        return element;
    }

    private XmlSchemaMetadataResolver getXmlSchemaMetadataResolver() {
        return (XmlSchemaMetadataResolver)this.getXmlMetadataResolver();
    }
}

