/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema;

import oracle.bali.xml.dom.traversal.DocumentTreeTraversal;
import oracle.bali.xml.dom.traversal.FilteredTreeTraversal;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.jdevimpl.xml.schema.GlobalReference;
import oracle.jdevimpl.xml.schema.ModelManager;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.XmlSchemaMetadataResolver;
import oracle.jdevimpl.xml.schema.XmlSchemaModel;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import org.w3c.dom.Node;

public class XmlSchemaTreeTraversal
extends FilteredTreeTraversal {
    private XmlSchemaModel model;
    private XmlSchemaMetadataResolver resolver;
    private ModelManager manager;
    private TreeTraversal beforeTraversal;

    public XmlSchemaTreeTraversal(XmlSchemaModel xmlSchemaModel) {
        this.model = xmlSchemaModel;
        this.manager = xmlSchemaModel.getModelManager();
        this.resolver = (XmlSchemaMetadataResolver)xmlSchemaModel.getXmlMetadataResolver();
    }

    protected short acceptNode(Node node) {
        int n = this.resolver.getSchemaRole(node);
        switch (n) {
            case 7: 
            case 10: 
            case 16: 
            case 19: {
                return 3;
            }
            case 20: {
                int n2;
                if (ModelUtils.getName(node) != null) {
                    return 1;
                }
                Node node2 = node.getParentNode();
                if (node2 != null && ((n2 = this.resolver.getSchemaRole(node2)) == 15 || n2 == 21)) {
                    return 1;
                }
                return 3;
            }
            case 8: {
                if (ModelUtils.getName(node) != null) {
                    return 1;
                }
                return 3;
            }
        }
        return 1;
    }

    protected TreeTraversal getBeforeTraversal() {
        if (this.beforeTraversal == null) {
            this.beforeTraversal = new InsertingTraversal(null);
        }
        return this.beforeTraversal;
    }

    static ModelManager ra$manager(XmlSchemaTreeTraversal xmlSchemaTreeTraversal) {
        return xmlSchemaTreeTraversal.manager;
    }

    private class InsertingTraversal
    extends TreeTraversal {
        public Node getParentNode(Node node) {
            return DocumentTreeTraversal.INSTANCE.getParentNode(node);
        }

        public Node getFirstChild(Node node) {
            GlobalReference globalReference;
            if (!(node instanceof ReferenceNode) && (globalReference = XmlSchemaTreeTraversal.ra$manager(XmlSchemaTreeTraversal.this).getReference(node)) != null) {
                return new ReferenceNode(XmlSchemaTreeTraversal.ra$manager(XmlSchemaTreeTraversal.this), node, globalReference);
            }
            return DocumentTreeTraversal.INSTANCE.getFirstChild(node);
        }

        public Node getLastChild(Node node) {
            return DocumentTreeTraversal.INSTANCE.getLastChild(node);
        }

        public Node getNextSibling(Node node) {
            if (node instanceof ReferenceNode) {
                return node.getParentNode().getFirstChild();
            }
            return DocumentTreeTraversal.INSTANCE.getNextSibling(node);
        }

        public Node getPreviousSibling(Node node) {
            return DocumentTreeTraversal.INSTANCE.getPreviousSibling(node);
        }

        private InsertingTraversal() {
        }

        InsertingTraversal(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

