/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Component;
import java.text.MessageFormat;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.XmlMetadataResolver;
import oracle.bali.xml.model.XmlModel;
import oracle.bali.xml.model.XmlView;
import oracle.ide.Ide;
import oracle.jdevimpl.xml.schema.ProxyAttr;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.DiagramSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.EditableTextComponent;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class AttrEditor
extends EditableTextComponent {
    private Attr attr;
    private boolean editing;

    public AttrEditor(Diagram diagram) {
        this(diagram, null);
    }

    public AttrEditor(Diagram diagram, Attr attr) {
        super(diagram);
        this.setAttr(attr);
    }

    public void setAttr(Attr attr) {
        this.attr = attr;
        if (attr != null) {
            this.setText(attr.getValue());
        }
    }

    protected void startEditing() {
        if (!(this.editing || this.attr instanceof ProxyAttr && ((ProxyAttr)this.attr).isExternal())) {
            if (!this.diagram.getSelectionManager().isSelected(this)) {
                DiagramComponent diagramComponent = this.getParent();
                while (diagramComponent != null) {
                    if (diagramComponent instanceof DiagramSchemaComponent) break;
                    diagramComponent = diagramComponent.getParent();
                }
                if (diagramComponent != null) {
                    this.diagram.getSelectionManager().select((DiagramSchemaComponent)diagramComponent);
                }
                this.diagram.scrollToVisible(diagramComponent != null ? diagramComponent : this);
            }
            super.startEditing();
            this.editing = true;
        }
    }

    protected void stopEditing() {
        super.stopEditing();
        if (this.editing) {
            this.editing = false;
            String string = this.text;
            if (this.attr != null && !string.equals(this.attr.getValue()) && this.validate(string)) {
                this.commit(string);
            }
        }
    }

    protected void cancelEditing() {
        this.editing = false;
        super.cancelEditing();
        if (this.attr != null) {
            this.setText(this.attr.getValue());
            this.invalidate();
            this.diagram.revalidate();
            this.fireTextChanged();
        }
    }

    private boolean validate(String string) {
        XmlView xmlView = this.diagram.getGui().getView();
        XmlMetadataResolver xmlMetadataResolver = xmlView.getXmlMetadataResolver();
        Node node = xmlView.viewToModel((Node)this.attr.getOwnerElement());
        XmlKey xmlKey = xmlView.getNodeXmlKey((Node)this.attr);
        try {
            xmlMetadataResolver.validateValue(xmlKey, node, (Object)string);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            this.showError(xmlKey, this.text, exception);
            SwingUtilities.invokeLater(new 1());
            return false;
        }
    }

    private void commit(String string) {
        XmlModel xmlModel = this.diagram.getGui().getView().getBaseModel();
        xmlModel.startTransaction(XmlSchemaArb.getString(10));
        try {
            if (string.trim().length() == 0) {
                this.attr.getOwnerElement().removeAttributeNode(this.attr);
            } else {
                this.attr.setNodeValue(string);
            }
            xmlModel.commitTransaction();
        }
        catch (ThreadDeath threadDeath) {
            xmlModel.rollbackTransaction();
            throw threadDeath;
        }
        catch (Throwable throwable) {
            xmlModel.rollbackTransaction();
        }
    }

    private void showError(XmlKey xmlKey, String string, Throwable throwable) {
        String string2 = throwable.getLocalizedMessage();
        if (string2 == null && (string2 = throwable.getMessage()) == null) {
            string2 = throwable.toString();
        }
        MessageFormat messageFormat = new MessageFormat(XmlSchemaArb.getString(62));
        String string3 = xmlKey.getLocalName();
        String string4 = messageFormat.format(new Object[]{string3});
        MessageFormat messageFormat2 = new MessageFormat(XmlSchemaArb.getString(63));
        String string5 = String.valueOf(string.trim().length() > 0 ? string : null);
        String string6 = messageFormat2.format(new Object[]{string3, string5, string2});
        JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), string6, string4, 0);
    }

    public final class 1
    implements Runnable {
        public void run() {
            AttrEditor.this.startEditing();
        }
    }
}

