/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.jdevimpl.xml.schema.GlobalReference;
import oracle.jdevimpl.xml.schema.NodeListener;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.diagram.AttributeDeclaration;
import oracle.jdevimpl.xml.schema.diagram.AttributeGroup;
import oracle.jdevimpl.xml.schema.diagram.ComponentFactory;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.DiagramSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeContainer
extends DiagramComponent
implements NodeListener {
    private Element element;
    private ArrayList attributeGroups;

    void $init$() {
        this.attributeGroups = new ArrayList();
    }

    public AttributeContainer(Diagram diagram, Element element) {
        super(diagram);
        this.$init$();
        this.element = element;
        diagram.getView().addNodeListener(element, this);
        this.update();
    }

    public void nodeChanged(Node node) {
        this.update();
    }

    public void update() {
        if (this.element != null) {
            this.destroyAll();
            this.diagram.getView().acquireReadLock();
            try {
                this.addAttributes();
            }
            finally {
                this.diagram.getView().releaseReadLock();
            }
            this.invalidate();
        }
    }

    public void destroy() {
        this.diagram.getView().removeNodeListener(this.element, this);
        this.element = null;
        this.destroyAll();
        super.destroy();
    }

    public int getPreferredWidth() {
        if (this.numChildren > 0) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.numChildren) {
                n = Math.max(n, this.children[n2].getPreferredWidth());
                ++n2;
            }
            return n + this.insets.left + this.insets.right;
        }
        return 0;
    }

    public int getPreferredHeight() {
        if (this.numChildren > 0) {
            int n = this.insets.top + this.insets.bottom;
            if (this.children != null) {
                int n2 = 0;
                while (n2 < this.numChildren) {
                    n += this.children[n2].getPreferredHeight();
                    if (n2 > 0 && this.children[n2] instanceof AttributeGroup && !(this.children[n2 - 1] instanceof AttributeGroup)) {
                        ++n;
                    }
                    if (n2 < this.numChildren - 1 && this.children[n2] instanceof AttributeGroup) {
                        ++n;
                    }
                    ++n2;
                }
            }
            return n;
        }
        return 0;
    }

    public void layout() {
        if (this.children != null) {
            int n = this.insets.top;
            int n2 = 0;
            while (n2 < this.numChildren) {
                if (n2 > 0 && this.children[n2] instanceof AttributeGroup && !(this.children[n2 - 1] instanceof AttributeGroup)) {
                    ++n;
                }
                this.children[n2].setBounds(this.insets.left, n, this.width - this.insets.left - this.insets.right, this.children[n2].getPreferredHeight());
                n += this.children[n2].getHeight();
                if (n2 < this.numChildren - 1 && this.children[n2] instanceof AttributeGroup) {
                    ++n;
                }
                ++n2;
            }
        }
    }

    public DomPosition getDomPosition(Point point) {
        DomPosition domPosition = null;
        Rectangle rectangle = new Rectangle();
        int n = 0;
        while (domPosition == null && n < this.numChildren) {
            if ((rectangle = this.children[n].getBounds(rectangle)).contains(point) && this.children[n] instanceof AttributeGroup) {
                point.translate(-this.children[n].x, -this.children[n].y);
                domPosition = this.children[n].getDomPosition(point);
                point.translate(this.children[n].x, this.children[n].y);
            } else if (point.getY() < rectangle.getY() + rectangle.getHeight() / 2.0) {
                if (!(this.children[n] instanceof AttributeDeclaration) || !((AttributeDeclaration)this.children[n]).isInherited()) {
                    domPosition = DomPositionFactory.createDomPosition((Node)((DiagramSchemaComponent)this.children[n]).getDomElement(), (int)1);
                }
            } else if (!(!(point.getY() < rectangle.getY() + rectangle.getHeight()) || this.children[n] instanceof AttributeDeclaration && ((AttributeDeclaration)this.children[n]).isInherited())) {
                domPosition = DomPositionFactory.createDomPosition((Node)((DiagramSchemaComponent)this.children[n]).getDomElement(), (int)2);
            }
            ++n;
        }
        return domPosition;
    }

    public Shape getDomPositionShape(DiagramComponent diagramComponent, int n) {
        Shape shape = null;
        if (n == 1) {
            Rectangle rectangle = diagramComponent.getBounds(null);
            return new Line2D.Double(rectangle.getX(), rectangle.getY(), rectangle.getX() + rectangle.getWidth(), rectangle.getY());
        }
        if (n == 2) {
            Rectangle rectangle = diagramComponent.getBounds(null);
            return new Line2D.Double(rectangle.getX(), rectangle.getY() + rectangle.getHeight(), rectangle.getX() + rectangle.getWidth(), rectangle.getY() + rectangle.getHeight());
        }
        shape = super.getDomPositionShape(diagramComponent, n);
        return shape;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Color color = graphics.getColor();
        graphics.setColor(Color.BLACK);
        int n = 0;
        while (n < this.numChildren) {
            if (n > 0 && this.children[n] instanceof AttributeGroup && !(this.children[n - 1] instanceof AttributeGroup)) {
                int n2 = this.children[n].getY() - 1;
                graphics.drawLine(this.insets.left, n2, this.width - this.insets.right, n2);
            }
            if (n < this.numChildren - 1 && this.children[n] instanceof AttributeGroup) {
                int n3 = this.children[n].getY() + this.children[n].getHeight();
                graphics.drawLine(this.insets.left, n3, this.width - this.insets.right, n3);
            }
            ++n;
        }
        graphics.setColor(color);
    }

    private void addAttributes() {
        ArrayList arrayList = new ArrayList();
        ArrayList<Node> arrayList2 = new ArrayList<Node>();
        boolean bl = false;
        TreeTraversal treeTraversal = this.diagram.getView().getTreeTraversal();
        Node node = treeTraversal.getFirstChild((Node)this.element);
        while (node != null) {
            if (node instanceof ReferenceNode) {
                ReferenceNode referenceNode = (ReferenceNode)((Object)node);
                GlobalReference globalReference = referenceNode.getReference();
                int n = globalReference.getReferenceType();
                Node node2 = referenceNode.getReferee();
                if (n == 2) {
                    bl = true;
                }
                if (!referenceNode.isCyclicReference()) {
                    if (n == 1 && globalReference.getType() == 7) {
                        this.diagram.getView().addNodeListener(node, this);
                        this.attributeGroups.add(node);
                        this.getAttributes(node2, arrayList2);
                    } else {
                        this.getAttributes(node2, arrayList);
                    }
                }
            } else if (ModelUtils.isAttributeRole(ModelUtils.getSchemaRole(node))) {
                if (bl) {
                    this.overrideAttribute(node, arrayList);
                }
                arrayList2.add(node);
            }
            node = treeTraversal.getNextSibling(node);
        }
        this.createAttributeComponents(arrayList, true);
        this.createAttributeComponents(arrayList2, false);
    }

    private void getAttributes(Node node, List list) {
        boolean bl = false;
        TreeTraversal treeTraversal = this.diagram.getView().getTreeTraversal();
        Node node2 = treeTraversal.getFirstChild(node);
        while (node2 != null) {
            if (node2 instanceof ReferenceNode) {
                ReferenceNode referenceNode = (ReferenceNode)((Object)node2);
                GlobalReference globalReference = referenceNode.getReference();
                int n = globalReference.getReferenceType();
                Node node3 = referenceNode.getReferee();
                if (n == 2) {
                    bl = true;
                }
                if (!referenceNode.isCyclicReference()) {
                    this.getAttributes(node3, list);
                }
            } else if ("attributeGroup".equals(node2.getLocalName())) {
                this.diagram.getView().addNodeListener(node2, this);
                this.attributeGroups.add(node2);
                this.getAttributes(node2, list);
            } else if (ModelUtils.isAttributeRole(ModelUtils.getSchemaRole(node2))) {
                if (bl) {
                    this.overrideAttribute(node2, list);
                }
                list.add(node2);
            }
            node2 = treeTraversal.getNextSibling(node2);
        }
    }

    private void overrideAttribute(Node node, List list) {
        block5: {
            String string;
            block6: {
                string = node.getLocalName();
                if (!"anyAttribute".equals(string)) break block6;
                int n = 0;
                while (n < list.size()) {
                    Node node2 = (Node)list.get(n);
                    if ("anyAttribute".equals(node2.getLocalName())) {
                        list.remove(n);
                        break block5;
                    }
                    ++n;
                }
                break block5;
            }
            if (!"attribute".equals(string)) break block5;
            String string2 = ModelUtils.getName(node);
            if (string2 == null) {
                string2 = ModelUtils.getAttribute((Element)node, "ref");
            }
            int n = 0;
            while (n < list.size()) {
                Node node3 = (Node)list.get(n);
                if (string2.equals(ModelUtils.getName(node3))) {
                    list.remove(n);
                    break;
                }
                ++n;
            }
        }
    }

    private void createAttributeComponents(Collection collection, boolean bl) {
        ComponentFactory componentFactory = this.diagram.getComponentFactory();
        for (Node node : collection) {
            HierarchalSchemaComponent hierarchalSchemaComponent = componentFactory.createSchemaComponent(node);
            if (hierarchalSchemaComponent == null) continue;
            this.diagram.getView().addNodeListener(node, this);
            hierarchalSchemaComponent.setShowBorder(false);
            if (hierarchalSchemaComponent instanceof AttributeDeclaration) {
                hierarchalSchemaComponent.setInsets(new Insets(0, 0, 0, 5));
                ((AttributeDeclaration)hierarchalSchemaComponent).setInherited(bl);
            } else {
                hierarchalSchemaComponent.setInsets(GraphicsUtils.ZERO_INSETS);
            }
            this.add(hierarchalSchemaComponent);
        }
    }

    private void destroyAll() {
        for (Node node : this.attributeGroups) {
            this.diagram.getView().removeNodeListener(node, this);
        }
        this.attributeGroups.clear();
        int n = 0;
        while (n < this.numChildren) {
            Element element = ((DiagramSchemaComponent)this.children[n]).getDomElement();
            this.diagram.getView().removeNodeListener(element, this);
            this.children[n].setParent(null);
            this.children[n].destroy();
            ++n;
        }
        this.numChildren = 0;
    }
}

