/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import oracle.jdevimpl.xml.schema.diagram.AttrEditor;
import oracle.jdevimpl.xml.schema.diagram.AttributeContainer;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class AttributeGroup
extends HierarchalSchemaComponent {
    private AttrEditor name;
    private AttributeContainer container;
    private static final int MINIMUM_WIDTH = 60;
    private static final int MAXIMUM_WIDTH = 200;
    private static final Color COLOR = new Color(234, 234, 234);

    public AttributeGroup(Diagram diagram, Element element) {
        super(diagram, element);
        this.setBackground(COLOR);
        this.setForeground(Color.BLACK);
        this.name = new AttrEditor(diagram);
        this.name.setFont(GraphicsUtils.getDiagramFont().deriveFont(1));
        this.name.setInsets(new Insets(3, 10, 3, 10));
        this.add(this.name);
        this.container = new AttributeContainer(diagram, element);
        this.add(this.container);
        this.update();
    }

    public int getPreferredWidth() {
        int n = Math.max(this.name.getPreferredWidth(), this.container.getPreferredWidth() + 10);
        n += this.insets.left + this.insets.right;
        n = Math.max(n, 60);
        n = Math.min(n, 200);
        return n;
    }

    public int getPreferredHeight() {
        int n = this.container.getPreferredHeight();
        return this.container.getPreferredHeight() + this.name.getPreferredHeight() + this.insets.top + this.insets.bottom + (n > 0 ? 1 : 0);
    }

    public void layout() {
        this.name.setBounds(this.insets.left, this.insets.top, this.width - this.insets.left - this.insets.right, this.name.getPreferredHeight());
        this.container.setBounds(this.insets.left + 10, this.insets.top + this.name.getHeight() + 1, this.width - 10 - this.insets.left - this.insets.right, this.height - this.name.getHeight() - this.insets.top - this.insets.bottom - 1);
    }

    public void update() {
        if (this.name != null) {
            Attr attr = this.element.getAttributeNodeNS(null, "name");
            if (attr == null) {
                attr = this.element.getAttributeNodeNS(null, "ref");
            }
            this.name.setAttr(attr);
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.container.getHeight() > 0) {
            int n = this.insets.left + 9;
            int n2 = this.insets.top + this.name.getHeight();
            graphics.drawLine(n, n2, this.width - 1, n2);
            graphics.drawLine(n, n2, n, this.height - 1);
        }
    }

    public Shape getDomPositionShape(DiagramComponent diagramComponent, int n) {
        return diagramComponent == this.container ? null : super.getDomPositionShape(diagramComponent, n);
    }
}

