/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import oracle.ide.util.ArrayResourceBundle;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.ImageComponent;

public class BitmapComponent
extends ImageComponent {
    public BitmapComponent(Diagram diagram) {
        super(diagram);
    }

    public BitmapComponent(Diagram diagram, ArrayResourceBundle arrayResourceBundle, int n) {
        super(diagram, arrayResourceBundle, n);
    }

    protected void paintImage(Graphics graphics, int n, int n2) {
        Image image = this.createBitmap();
        if (image != null) {
            graphics.drawImage(image, n, n2, null);
            image.flush();
        }
    }

    private Image createBitmap() {
        Image image = null;
        FilteredImageSource filteredImageSource = new FilteredImageSource(this.image.getSource(), new BitmapFilter(this.getForeground(), this.getBackground()));
        image = this.diagram.createImage(filteredImageSource);
        MediaTracker mediaTracker = new MediaTracker(this.diagram);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return image;
    }

    private class BitmapFilter
    extends RGBImageFilter {
        private int fg;
        private int bg;
        private final int WHITE;

        void $init$() {
            this.WHITE = Color.WHITE.getRGB();
        }

        public BitmapFilter(Color color, Color color2) {
            this.$init$();
            this.fg = color.getRGB();
            this.bg = color2.getRGB();
        }

        public int filterRGB(int n, int n2, int n3) {
            return n3 == this.WHITE ? this.bg : this.fg;
        }
    }
}

