/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.dom.util.DomUtils;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.util.DefaultPrefixLookup;
import oracle.bali.xml.util.NamespaceUtils;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdevimpl.xml.schema.GlobalReference;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.XmlSchemaEditorController;
import oracle.jdevimpl.xml.schema.XmlSchemaMetadataResolver;
import oracle.jdevimpl.xml.schema.diagram.AttrEditor;
import oracle.jdevimpl.xml.schema.diagram.AttributeContainer;
import oracle.jdevimpl.xml.schema.diagram.DerivationEditor;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.ListChangeListener;
import oracle.jdevimpl.xml.schema.diagram.ListComponent;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import oracle.jdevimpl.xml.schema.diagram.TypeEditor;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ComplexTypeDefinition
extends HierarchalSchemaComponent
implements ListChangeListener {
    private AttrEditor name;
    private AttributeContainer attributes;
    private DerivationEditor derivation;
    private TypeEditor type;
    private static final int MINIMUM_WIDTH = 60;
    private static final int MAXIMUM_WIDTH = 300;
    private static final Color COLOR = new Color(251, 166, 115);

    public ComplexTypeDefinition(Diagram diagram, Element element) {
        super(diagram, element);
        this.setBackground(COLOR);
        Attr attr = element.getAttributeNodeNS(null, "name");
        this.name = new AttrEditor(diagram, attr);
        this.name.setFont(GraphicsUtils.getDiagramFont().deriveFont(1));
        this.name.setInsets(new Insets(3, 5, 0, 5));
        this.add(this.name);
        this.attributes = new AttributeContainer(diagram, element);
        this.add(this.attributes);
        this.derivation = new DerivationEditor(diagram);
        this.derivation.addListChangeListener(this);
        this.derivation.setInsets(new Insets(0, 10, 2, 5));
        this.add(this.derivation);
        this.type = new TypeEditor(diagram, 4);
        this.type.setInsets(new Insets(0, 0, 2, 0));
        this.type.addListChangeListener(this);
        this.add(this.type);
        this.update();
    }

    public void destroy() {
        super.destroy();
        this.derivation.removeListChangeListener(this);
        this.type.removeListChangeListener(this);
    }

    public int getPreferredWidth() {
        int n = this.name.getPreferredWidth() + 10;
        n = Math.max(n, this.attributes.getPreferredWidth());
        n = Math.max(n, this.derivation.getPreferredWidth() + this.type.getPreferredWidth() + 10);
        n += this.insets.left + this.insets.right;
        n = Math.max(n, 60);
        n = Math.min(n, 300);
        return n;
    }

    public int getPreferredHeight() {
        int n = this.attributes.getPreferredHeight();
        int n2 = this.name.getPreferredHeight();
        int n3 = this.type.getPreferredHeight();
        if (n3 == 0) {
            n3 = 2;
        }
        int n4 = this.derivation.getPreferredHeight();
        return n2 + n + Math.max(n3, n4) + this.insets.top + this.insets.bottom + (n > 0 ? 1 : 0);
    }

    public Shape getShape() {
        int n = this.getWidth();
        int[] nArray = new int[]{0, 5, n - 6, n - 1, n - 1, n - 2, 1, 0, 0};
        int[] nArray2 = new int[]{5, 0, 0, 5, this.height - 2, this.height - 1, this.height - 1, this.height - 2, 5};
        return new Polygon(nArray, nArray2, nArray.length);
    }

    public void layout() {
        int n = this.width - this.insets.left - this.insets.right;
        int n2 = n - 10;
        this.name.setBounds(this.insets.left + 5, this.insets.top, n2, this.name.getPreferredHeight());
        int n3 = this.name.getHeight();
        this.derivation.setBounds(this.insets.left, this.insets.top + n3, this.derivation.getPreferredWidth(), this.derivation.getPreferredHeight());
        this.type.setBounds(this.insets.left + this.derivation.getWidth(), this.insets.top + n3, n - this.derivation.getWidth(), this.type.getPreferredHeight());
        int n4 = Math.max(this.type.getHeight(), this.derivation.getHeight());
        if (n4 == 0) {
            n4 = 2;
        }
        this.attributes.setBounds(this.insets.left, this.insets.top + n3 + n4 + 1, n, this.attributes.getPreferredHeight());
    }

    public void update() {
        super.update();
        this.diagram.getView().acquireReadLock();
        try {
            if (this.name != null) {
                Attr attr = this.element.getAttributeNodeNS(null, "name");
                this.name.setAttr(attr);
            }
            Node node = this.diagram.getView().getTreeTraversal().getFirstChild((Node)this.element);
            Object var3_3 = null;
            if (node instanceof ReferenceNode) {
                ReferenceNode referenceNode = (ReferenceNode)((Object)node);
                Node node2 = referenceNode.getReferee();
                int n = referenceNode.getReference().getReferenceType();
                this.derivation.setValueFromReferenceType(n);
                if (node2 == null && referenceNode.getReference().isBuiltInType() || node2 != null && ModelUtils.isSimpleTypeDefinition(node2)) {
                    this.derivation.setPossibleValues(2);
                } else {
                    this.derivation.setPossibleValues(6);
                }
                this.type.setReference(referenceNode);
            } else {
                this.derivation.setValue(0);
                this.type.setReference(null);
            }
        }
        finally {
            this.diagram.getView().releaseReadLock();
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.attributes.getHeight() > 0) {
            int n = this.insets.top + this.name.getHeight() + Math.max(this.type.getHeight(), this.derivation.getHeight());
            if (this.type.getHeight() == 0) {
                n += 2;
            }
            graphics.drawLine(this.insets.left, n, this.width - 1, n);
        }
    }

    public void valueChanged(ListComponent listComponent) {
        if (listComponent == this.derivation) {
            this.handleDerivationChange();
        } else if (listComponent == this.type) {
            this.handleBaseTypeChange();
        }
    }

    private void handleDerivationChange() {
        block14: {
            int n = this.derivation.getValue();
            this.diagram.getView().acquireReadLock();
            try {
                Node node = DomUtils.getNamedChild((Node)this.element, (String)"http://www.w3.org/2001/XMLSchema", (String)"simpleContent");
                if (node == null) {
                    node = DomUtils.getNamedChild((Node)this.element, (String)"http://www.w3.org/2001/XMLSchema", (String)"complexContent");
                }
                Document document = this.diagram.getView().getDocument();
                DefaultPrefixLookup defaultPrefixLookup = this.diagram.getModel().getDefaultPrefixLookup();
                if (node == null) break block14;
                if (n == 2) {
                    Element element = (Element)DomUtils.getNamedChild((Node)node, (String)"http://www.w3.org/2001/XMLSchema", (String)"restriction");
                    if (element == null) break block14;
                    this.diagram.getModel().startTransaction(XmlSchemaArb.getString(13));
                    try {
                        Element element2 = document.createElementNS("http://www.w3.org/2001/XMLSchema", "extension");
                        ModelUtils.copyAttr(element, element2, null, "base");
                        NamespaceUtils.fixPrefixes((Node)node, (Node)element2, (DefaultPrefixLookup)defaultPrefixLookup);
                        node.removeChild(element);
                        node.appendChild(element2);
                        this.diagram.getModel().commitTransaction();
                        break block14;
                    }
                    catch (XmlCommitException xmlCommitException) {
                        this.diagram.getModel().rollbackTransaction();
                        ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xmlCommitException));
                        break block14;
                    }
                    catch (ThreadDeath threadDeath) {
                        this.diagram.getModel().rollbackTransaction();
                        throw threadDeath;
                    }
                    catch (Throwable throwable) {
                        this.diagram.getModel().rollbackTransaction();
                        break block14;
                    }
                }
                Element element = (Element)DomUtils.getNamedChild((Node)node, (String)"http://www.w3.org/2001/XMLSchema", (String)"extension");
                if (element == null) break block14;
                this.diagram.getModel().startTransaction(XmlSchemaArb.getString(13));
                try {
                    Element element3 = document.createElementNS("http://www.w3.org/2001/XMLSchema", "restriction");
                    ModelUtils.copyAttr(element, element3, null, "base");
                    NamespaceUtils.fixPrefixes((Node)node, (Node)element3, (DefaultPrefixLookup)defaultPrefixLookup);
                    node.removeChild(element);
                    node.appendChild(element3);
                    String string = element3.getAttributeNS(null, "base");
                    GlobalReference globalReference = new GlobalReference(this.diagram.getView().getNamespace(this.element, string), ModelUtils.getName(string), 4);
                    Node node2 = this.diagram.getView().resolveReference(globalReference);
                    if (node2 != null) {
                        ModelUtils.copyContent(node2, element3, this.diagram.getView().getTreeTraversal(), defaultPrefixLookup);
                    }
                    this.diagram.getModel().commitTransaction();
                }
                catch (XmlCommitException xmlCommitException) {
                    this.diagram.getModel().rollbackTransaction();
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xmlCommitException));
                }
                catch (ThreadDeath threadDeath) {
                    this.diagram.getModel().rollbackTransaction();
                    throw threadDeath;
                }
                catch (Throwable throwable) {
                    this.diagram.getModel().rollbackTransaction();
                }
            }
            finally {
                this.diagram.getView().releaseReadLock();
            }
        }
    }

    public void handleBaseTypeChange() {
        String string = this.type.getText().trim();
        if (string.length() == 0) {
            this.removeBaseType();
        } else {
            ModelUtils.setBaseType(this.diagram.getView(), this.element, string);
        }
    }

    private void removeBaseType() {
        Attr attr = this.type.getAttr();
        Element element = attr.getOwnerElement();
        if (element != null) {
            this.diagram.getModel().startTransaction(XmlSchemaArb.getString(11));
            try {
                element.removeAttributeNode(attr);
                this.moveContent(element, this.element);
                ModelUtils.removePath(this.element, element);
                this.diagram.getModel().commitTransaction();
            }
            catch (XmlCommitException xmlCommitException) {
                this.diagram.getModel().rollbackTransaction();
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xmlCommitException));
            }
            catch (ThreadDeath threadDeath) {
                this.diagram.getModel().rollbackTransaction();
                throw threadDeath;
            }
            catch (Throwable throwable) {
                this.diagram.getModel().rollbackTransaction();
            }
        } else {
            this.type.setAttr(null);
        }
    }

    public List getActions() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(3);
        arrayList.addAll(super.getActions());
        this.diagram.getView().acquireReadLock();
        try {
            TreeTraversal treeTraversal = this.diagram.getView().getTreeTraversal();
            Node node = treeTraversal.getFirstChild((Node)this.element);
            if (!(node instanceof ReferenceNode)) {
                arrayList.add(new Integer(XmlSchemaEditorController.SET_BASE_TYPE_CMD_ID));
            }
            ArrayList<Integer> arrayList2 = arrayList;
            this.diagram.getView().releaseReadLock();
            return arrayList2;
        }
        catch (Throwable throwable) {
            this.diagram.getView().releaseReadLock();
            throw throwable;
        }
    }

    public boolean handleAction(IdeAction ideAction) {
        if (ideAction.getCommandId() == XmlSchemaEditorController.SET_BASE_TYPE_CMD_ID) {
            this.setBaseType();
            return true;
        }
        return super.handleAction(ideAction);
    }

    private void setBaseType() {
        this.diagram.getView().acquireReadLock();
        try {
            Attr attr = this.diagram.getView().getDocument().createAttributeNS(null, "base");
            this.type.setAttr(attr);
            this.type.startEditing();
        }
        finally {
            this.diagram.getView().releaseReadLock();
        }
    }

    private void moveContent(Node node, Node node2) {
        XmlSchemaMetadataResolver xmlSchemaMetadataResolver = (XmlSchemaMetadataResolver)this.diagram.getView().getXmlMetadataResolver();
        Node node3 = node.getFirstChild();
        while (node3 != null) {
            int n = xmlSchemaMetadataResolver.getSchemaRole(node3);
            Node node4 = node3.getNextSibling();
            if (ModelUtils.isAttributeRole(n) || ModelUtils.isModelGroupRole(n)) {
                node.removeChild(node3);
                node2.appendChild(node3);
            }
            node3 = node4;
        }
    }

    private void removeComplexContent(Node node) {
        XmlSchemaMetadataResolver xmlSchemaMetadataResolver = (XmlSchemaMetadataResolver)this.diagram.getView().getXmlMetadataResolver();
        Node node2 = node.getFirstChild();
        while (node2 != null) {
            int n = xmlSchemaMetadataResolver.getSchemaRole(node2);
            Node node3 = node2.getNextSibling();
            if (ModelUtils.isModelGroupRole(n)) {
                node.removeChild(node2);
            }
            node2 = node3;
        }
    }
}

