/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import oracle.bali.xml.dom.util.DomUtils;
import oracle.jdevimpl.xml.schema.diagram.AnyAttribute;
import oracle.jdevimpl.xml.schema.diagram.AnyModelGroup;
import oracle.jdevimpl.xml.schema.diagram.AttributeDeclaration;
import oracle.jdevimpl.xml.schema.diagram.AttributeGroup;
import oracle.jdevimpl.xml.schema.diagram.ComplexTypeDefinition;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.ElementDeclaration;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.IconicModelGroup;
import oracle.jdevimpl.xml.schema.diagram.Import;
import oracle.jdevimpl.xml.schema.diagram.Include;
import oracle.jdevimpl.xml.schema.diagram.List;
import oracle.jdevimpl.xml.schema.diagram.NamedModelGroup;
import oracle.jdevimpl.xml.schema.diagram.SchemaRootComponent;
import oracle.jdevimpl.xml.schema.diagram.SimpleTypeDefinition;
import oracle.jdevimpl.xml.schema.diagram.Union;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ComponentFactory {
    private Diagram diagram;

    public ComponentFactory(Diagram diagram) {
        this.diagram = diagram;
    }

    public HierarchalSchemaComponent createSchemaComponent(Node node) {
        Element element;
        HierarchalSchemaComponent hierarchalSchemaComponent = null;
        if (DomUtils.isElement((Node)node) && "http://www.w3.org/2001/XMLSchema".equals((element = (Element)node).getNamespaceURI())) {
            String string = element.getLocalName();
            if ("element".equals(string)) {
                hierarchalSchemaComponent = new ElementDeclaration(this.diagram, element);
            } else if ("complexType".equals(string)) {
                hierarchalSchemaComponent = new ComplexTypeDefinition(this.diagram, element);
            } else if ("simpleType".equals(string)) {
                hierarchalSchemaComponent = new SimpleTypeDefinition(this.diagram, element);
            } else if ("sequence".equals(string) || "choice".equals(string) || "all".equals(string)) {
                hierarchalSchemaComponent = new IconicModelGroup(this.diagram, element);
            } else if ("group".equals(string)) {
                hierarchalSchemaComponent = new NamedModelGroup(this.diagram, element);
            } else if ("any".equals(string)) {
                hierarchalSchemaComponent = new AnyModelGroup(this.diagram, element);
            } else if ("schema".equals(string)) {
                hierarchalSchemaComponent = new SchemaRootComponent(this.diagram, element);
            } else if ("attribute".equals(string)) {
                hierarchalSchemaComponent = new AttributeDeclaration(this.diagram, element);
            } else if ("attributeGroup".equals(string)) {
                hierarchalSchemaComponent = new AttributeGroup(this.diagram, element);
            } else if ("include".equals(string)) {
                hierarchalSchemaComponent = new Include(this.diagram, element);
            } else if ("import".equals(string)) {
                hierarchalSchemaComponent = new Import(this.diagram, element);
            } else if ("anyAttribute".equals(string)) {
                hierarchalSchemaComponent = new AnyAttribute(this.diagram, element);
            } else if ("list".equals(string)) {
                hierarchalSchemaComponent = new List(this.diagram, element);
            } else if ("union".equals(string)) {
                hierarchalSchemaComponent = new Union(this.diagram, element);
            }
        }
        return hierarchalSchemaComponent;
    }
}

