/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.util.ArrayList;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.ListComponent;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;

public class DerivationEditor
extends ListComponent {
    public static final int DERIVATION_UNKNOWN = 0;
    public static final int DERIVATION_TYPE = 1;
    public static final int DERIVATION_EXTENSION = 2;
    public static final int DERIVATION_RESTRICTION = 4;
    private int value;
    private boolean editable;

    void $init$() {
        this.editable = true;
    }

    public DerivationEditor(Diagram diagram) {
        this(diagram, 6);
    }

    public DerivationEditor(Diagram diagram, int n) {
        this(diagram, n, 0);
    }

    public DerivationEditor(Diagram diagram, int n, int n2) {
        super(diagram, false);
        this.$init$();
        this.setPossibleValues(n);
        this.setValue(n2);
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public int getPreferredWidth() {
        if (this.value != 0) {
            return super.getPreferredWidth();
        }
        return 0;
    }

    public int getPreferredHeight() {
        if (this.value != 0) {
            return super.getPreferredHeight();
        }
        return 0;
    }

    public void setValue(int n) {
        this.value = n;
        this.setText(this.getTextForValue(n));
    }

    public int getValue() {
        return this.value;
    }

    public void startEditing() {
        if (this.editable) {
            super.startEditing();
        }
    }

    public void setPossibleValues(int n) {
        ArrayList<String> arrayList = new ArrayList<String>(3);
        if ((n & 1) == 1) {
            arrayList.add(this.getTextForValue(1));
        }
        if ((n & 2) == 2) {
            arrayList.add(this.getTextForValue(2));
        }
        if ((n & 4) == 4) {
            arrayList.add(this.getTextForValue(4));
        }
        this.setItems(arrayList.toArray(new String[0]));
    }

    protected String getEditorValue() {
        String string = super.getEditorValue();
        this.value = this.getValueFromText(string);
        return string;
    }

    public void setValueFromReferenceType(int n) {
        switch (n) {
            case 4: {
                this.setValue(1);
                break;
            }
            case 3: {
                this.setValue(2);
                break;
            }
            case 2: {
                this.setValue(4);
                break;
            }
            default: {
                this.setValue(0);
            }
        }
    }

    private String getTextForValue(int n) {
        switch (n) {
            case 1: {
                return XmlSchemaArb.getString(25);
            }
            case 2: {
                return XmlSchemaArb.getString(26);
            }
            case 4: {
                return XmlSchemaArb.getString(27);
            }
        }
        return null;
    }

    private int getValueFromText(String string) {
        if (XmlSchemaArb.getString(25).equals(string)) {
            return 1;
        }
        if (XmlSchemaArb.getString(26).equals(string)) {
            return 2;
        }
        if (XmlSchemaArb.getString(27).equals(string)) {
            return 4;
        }
        return 0;
    }
}

