/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.Scrollable;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.gui.XmlGui;
import oracle.jdevimpl.xml.schema.XmlSchemaDesignGui;
import oracle.jdevimpl.xml.schema.XmlSchemaLayoutView;
import oracle.jdevimpl.xml.schema.XmlSchemaModel;
import oracle.jdevimpl.xml.schema.diagram.ComponentFactory;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.DiagramDropHandler;
import oracle.jdevimpl.xml.schema.diagram.DiagramSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.DiagramSelectionManager;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.Subtree;
import oracle.jdevimpl.xml.schema.diagram.VerticalTree;
import org.w3c.dom.Node;

public class Diagram
extends JPanel
implements Scrollable {
    private float zoomFactor;
    private int zoomLevel;
    private HierarchalSchemaComponent root;
    private ComponentFactory factory;
    private XmlSchemaDesignGui gui;
    private Subtree tree;
    private DiagramSelectionManager selectionManager;
    private boolean focused;
    private HashMap nodeMap;

    void $init$() {
        this.zoomFactor = 1.0f;
        this.nodeMap = new HashMap();
    }

    public Diagram(Node node, XmlSchemaDesignGui xmlSchemaDesignGui) {
        super(false);
        this.$init$();
        this.gui = xmlSchemaDesignGui;
        this.setBackground(GraphicsUtils.DIAGRAM_BACKGROUND_COLOR);
        DiagramDropHandler diagramDropHandler = new DiagramDropHandler(this);
        DropTarget dropTarget = new DropTarget(this, 3, (DropTargetListener)((Object)diagramDropHandler), true);
        this.setDropTarget(dropTarget);
        this.selectionManager = new DiagramSelectionManager(this);
        this.factory = new ComponentFactory(this);
        this.setRoot(node);
    }

    public void dispose() {
        this.selectionManager.dispose();
        this.removeAll();
        this.setDropTarget(null);
        this.nodeMap.clear();
        if (this.tree != null) {
            this.tree.destroy();
        }
        this.tree = null;
        if (this.root != null) {
            this.root.destroy();
        }
        this.root = null;
        this.gui = null;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return 10;
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return n == 1 ? (int)rectangle.getHeight() - 10 : (int)rectangle.getWidth() - 10;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public float getMinimumZoom() {
        return 0.1f;
    }

    public float getMaximumZoom() {
        return 10.0f;
    }

    public float getZoomMultiplier() {
        return 1.5f;
    }

    public void setZoomFactor(float f) {
        this.zoomFactor = f;
    }

    public float getZoomFactor() {
        return this.zoomFactor;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.tree != null ? new Dimension((int)((float)this.tree.getPreferredWidth() * this.zoomFactor), (int)((float)this.tree.getPreferredHeight() * this.zoomFactor)) : new Dimension(0, 0);
        return dimension;
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.scale(this.zoomFactor, this.zoomFactor);
        graphics.translate(this.tree.getX(), this.tree.getY());
        this.tree.paint(graphics);
        graphics.translate(-this.tree.getX(), -this.tree.getY());
        graphics2D.setTransform(affineTransform);
    }

    public XmlSchemaLayoutView getView() {
        return (XmlSchemaLayoutView)this.getGui().getView();
    }

    public void setRoot(Node node) {
        this.root = this.factory.createSchemaComponent(node);
        if (this.root != null) {
            this.tree = new VerticalTree(this, this.root);
            this.tree.setInsets(new Insets(10, 10, 10, 10));
            this.tree.setExpanded(true);
        } else {
            this.tree = null;
        }
        this.revalidate();
    }

    public DiagramSelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public ComponentFactory getComponentFactory() {
        return this.factory;
    }

    public DiagramSchemaComponent getRootComponent() {
        return this.root;
    }

    public Subtree getTree() {
        return this.tree;
    }

    public XmlGui getGui() {
        return this.gui;
    }

    public void layout() {
        if (this.tree != null) {
            this.tree.setBounds(0, 0, this.getWidth(), this.getHeight());
            this.tree.validate();
        }
    }

    public void zoomIn(Point point) {
        float f = this.getMaximumZoom();
        float f2 = this.getZoomMultiplier();
        float f3 = (float)Math.pow(f2, this.zoomLevel + 1);
        if (f3 <= f) {
            if (point != null) {
                this.centerPoint(point);
            }
            ++this.zoomLevel;
            this.setZoomFactor(f3);
            this.revalidate();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void zoomOut(Point point) {
        float f = this.getMinimumZoom();
        float f2 = this.getZoomMultiplier();
        float f3 = (float)Math.pow(f2, this.zoomLevel - 1);
        if (f3 >= f) {
            if (point != null) {
                this.centerPoint(point);
            }
            --this.zoomLevel;
            this.setZoomFactor(f3);
            this.revalidate();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void add(Node node, DiagramComponent diagramComponent) {
        LinkedList<DiagramComponent> linkedList = (LinkedList<DiagramComponent>)this.nodeMap.get(node);
        if (linkedList == null) {
            linkedList = new LinkedList<DiagramComponent>();
            this.nodeMap.put(node, linkedList);
        }
        linkedList.add(diagramComponent);
    }

    public void remove(Node node, DiagramComponent diagramComponent) {
        List list = (List)this.nodeMap.get(node);
        if (list != null) {
            list.remove(diagramComponent);
            if (list.isEmpty()) {
                this.nodeMap.remove(node);
            }
        }
    }

    public List getDiagramComponentsForNode(Node node) {
        return (List)this.nodeMap.get(node);
    }

    public DiagramComponent getDiagramComponentAt(Point point) {
        Point point2 = new Point((int)((float)point.x / this.zoomFactor), (int)((float)point.y / this.zoomFactor));
        return this.tree != null ? this.tree.getComponentAt(point2) : null;
    }

    public DiagramSchemaComponent getSchemaComponentAt(Point point) {
        DiagramComponent diagramComponent = this.getDiagramComponentAt(point);
        while (diagramComponent != null && !(diagramComponent instanceof DiagramSchemaComponent)) {
            diagramComponent = diagramComponent.getParent();
        }
        return (DiagramSchemaComponent)diagramComponent;
    }

    public DomPosition getDomPosition(Point point) {
        Point point2 = new Point((int)((float)point.x / this.zoomFactor), (int)((float)point.y / this.zoomFactor));
        return this.tree.getDomPosition(point2);
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean bl) {
        if (this.focused != bl) {
            this.focused = bl;
            if (bl) {
                this.gui.activate();
            } else {
                this.gui.deactivate();
            }
            DiagramSchemaComponent diagramSchemaComponent = this.selectionManager.getActiveComponent();
            if (diagramSchemaComponent != null) {
                diagramSchemaComponent.repaint();
            }
            Iterator iterator = this.selectionManager.getSelectedComponents().iterator();
            while (iterator.hasNext()) {
                ((DiagramComponent)iterator.next()).repaint();
            }
        }
    }

    public void scrollToVisible(DiagramComponent diagramComponent) {
        if (!diagramComponent.valid) {
            this.layout();
        }
        Rectangle rectangle = diagramComponent.getBounds(null);
        DiagramComponent diagramComponent2 = diagramComponent.getParent();
        while (diagramComponent2 != null) {
            rectangle.x += diagramComponent2.getX();
            rectangle.y += diagramComponent2.getY();
            diagramComponent2 = diagramComponent2.getParent();
        }
        rectangle.x = (int)((float)rectangle.x * this.zoomFactor);
        rectangle.y = (int)((float)rectangle.y * this.zoomFactor);
        rectangle.width = (int)((float)rectangle.width * this.zoomFactor);
        rectangle.height = (int)((float)rectangle.height * this.zoomFactor);
        this.scrollRectToVisible(rectangle);
    }

    public final XmlSchemaModel getModel() {
        return (XmlSchemaModel)this.getGui().getView().getBaseModel();
    }

    private void centerPoint(Point point) {
    }

    public void scaledRepaint(int n, int n2, int n3, int n4) {
        this.repaint((int)((float)n * this.zoomFactor), (int)((float)n2 * this.zoomFactor), (int)((float)(n3 + 1) * this.zoomFactor), (int)((float)(n4 + 1) * this.zoomFactor));
    }

    private Rectangle getZoomRectangle(Rectangle rectangle) {
        rectangle.setBounds((int)((float)rectangle.x * this.zoomFactor), (int)((float)rectangle.y * this.zoomFactor), (int)((float)(rectangle.width + 1) * this.zoomFactor), (int)((float)(rectangle.height + 1) * this.zoomFactor));
        return rectangle;
    }
}

