/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;

public abstract class DiagramComponent {
    protected Diagram diagram;
    protected DiagramComponent parent;
    protected int numChildren;
    protected DiagramComponent[] children;
    protected boolean valid;
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected boolean visible;
    protected Insets insets;
    protected Color background;
    protected Color foreground;
    protected boolean showBorder;
    protected Stroke stroke;

    void $init$() {
        this.children = new DiagramComponent[0];
        this.visible = true;
        this.insets = GraphicsUtils.ZERO_INSETS;
    }

    public DiagramComponent(Diagram diagram) {
        this.$init$();
        this.diagram = diagram;
        this.parent = this.parent;
    }

    public void setParent(DiagramComponent diagramComponent) {
        this.parent = diagramComponent;
    }

    public DiagramComponent getParent() {
        return this.parent;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
        this.invalidate();
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setBackground(Color color) {
        this.background = color;
    }

    public Color getBackground() {
        if (this.background != null) {
            return this.background;
        }
        if (this.parent != null) {
            return this.parent.getBackground();
        }
        return this.diagram.getBackground();
    }

    public void setForeground(Color color) {
        this.foreground = color;
    }

    public Color getForeground() {
        if (this.foreground != null) {
            return this.foreground;
        }
        if (this.parent != null) {
            return this.parent.getForeground();
        }
        return this.diagram.getForeground();
    }

    public Color getBorderColor() {
        return Color.BLACK;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public void setShowBorder(boolean bl) {
        this.showBorder = bl;
    }

    public boolean getShowBorder() {
        return this.showBorder;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void insert(DiagramComponent diagramComponent, int n) {
        DiagramComponent diagramComponent2 = diagramComponent.getParent();
        if (diagramComponent2 != null) {
            diagramComponent2.remove(diagramComponent);
        }
        diagramComponent.setParent(this);
        int n2 = this.children.length;
        if (this.numChildren == this.children.length) {
            n2 = this.children.length * 2 + 1;
        }
        DiagramComponent[] diagramComponentArray = new DiagramComponent[n2];
        if (n > 0) {
            System.arraycopy(this.children, 0, diagramComponentArray, 0, n - 1);
        }
        System.arraycopy(this.children, n, diagramComponentArray, n + 1, this.numChildren - n);
        this.children = diagramComponentArray;
        this.children[n] = diagramComponent;
        ++this.numChildren;
        this.invalidate();
    }

    public void add(DiagramComponent diagramComponent) {
        DiagramComponent diagramComponent2 = diagramComponent.getParent();
        if (diagramComponent2 != null) {
            diagramComponent2.remove(diagramComponent);
        }
        diagramComponent.setParent(this);
        if (this.numChildren == this.children.length) {
            DiagramComponent[] diagramComponentArray = new DiagramComponent[this.children.length * 2 + 1];
            System.arraycopy(this.children, 0, diagramComponentArray, 0, this.numChildren);
            this.children = diagramComponentArray;
        }
        this.children[this.numChildren++] = diagramComponent;
        this.invalidate();
    }

    public void remove(DiagramComponent diagramComponent) {
        int n = 0;
        while (n < this.numChildren) {
            if (this.children[n] == diagramComponent) {
                System.arraycopy(this.children, n + 1, this.children, n, this.numChildren - n - 1);
                this.children[--this.numChildren] = null;
            }
            ++n;
        }
        diagramComponent.setParent(null);
        this.invalidate();
    }

    public void removeAll() {
        int n = 0;
        while (n < this.numChildren) {
            this.children[n].setParent(null);
            ++n;
        }
        this.numChildren = 0;
        this.invalidate();
    }

    public int getChildCount() {
        return this.numChildren;
    }

    public DiagramComponent getChild(int n) {
        return this.children[n];
    }

    public void invalidate() {
        this.valid = false;
        if (this.parent != null) {
            this.parent.invalidate();
        } else {
            this.diagram.revalidate();
        }
    }

    public void validate() {
        if (!this.valid) {
            this.layout();
            int n = 0;
            while (n < this.numChildren) {
                this.children[n].validate();
                ++n;
            }
            this.valid = true;
        }
    }

    public void layout() {
    }

    public void paint(Graphics graphics) {
        this.paintBackground(graphics);
        this.paintComponent(graphics);
        this.paintChildren(graphics);
    }

    public void paintBackground(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = this.getShape();
        Color color = graphics.getColor();
        graphics.setColor(this.diagram.getBackground());
        graphics2D.fill(shape);
        graphics.setColor(this.getBackground());
        graphics2D.fill(shape);
        if (this.showBorder) {
            graphics.setColor(this.parent != null ? this.parent.getBackground() : Color.WHITE);
            graphics2D.draw(shape);
            graphics.setColor(this.getBorderColor());
            Stroke stroke = null;
            if (this.stroke != null) {
                stroke = graphics2D.getStroke();
                graphics2D.setStroke(this.stroke);
            }
            graphics2D.draw(shape);
            if (stroke != null) {
                graphics2D.setStroke(stroke);
            }
        } else {
            graphics2D.draw(shape);
        }
        graphics.setColor(color);
    }

    public void paintComponent(Graphics graphics) {
    }

    public void paintChildren(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        Rectangle rectangle2 = new Rectangle();
        int n = this.numChildren - 1;
        while (n >= 0) {
            if (this.children[n].isVisible()) {
                rectangle2 = this.children[n].getBounds(rectangle2);
                rectangle2.grow(5, 5);
                if (rectangle2.intersects(rectangle)) {
                    graphics.translate(this.children[n].x, this.children[n].y);
                    this.children[n].paint(graphics);
                    graphics.translate(-this.children[n].x, -this.children[n].y);
                }
            }
            --n;
        }
    }

    public Shape getShape() {
        return new Rectangle(0, 0, this.getWidth() - 1, this.getHeight() - 1);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public abstract int getPreferredWidth();

    public abstract int getPreferredHeight();

    public void setBounds(int n, int n2, int n3, int n4) {
        int n5 = this.x;
        int n6 = this.y;
        int n7 = this.width;
        int n8 = this.height;
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        if (this.x != n5 || this.y != n6 || this.width != n7 || this.height != n8) {
            this.repaint(n5 - this.x, n6 - this.y, n7, n8);
            this.repaint();
            this.invalidate();
        }
    }

    public Rectangle getBounds(Rectangle rectangle) {
        if (rectangle == null) {
            return new Rectangle(this.x, this.y, this.width, this.height);
        }
        rectangle.setBounds(this.x, this.y, this.width, this.height);
        return rectangle;
    }

    public DiagramComponent getComponentAt(Point point) {
        Rectangle rectangle = new Rectangle();
        int n = 0;
        while (n < this.numChildren) {
            if (this.children[n].isVisible() && this.children[n].getBounds(rectangle).contains(point)) {
                point.translate(-this.children[n].x, -this.children[n].y);
                return this.children[n].getComponentAt(point);
            }
            ++n;
        }
        if (this.getShape().contains(point)) {
            return this;
        }
        return null;
    }

    public DomPosition getDomPosition(Point point) {
        DomPosition domPosition = null;
        Rectangle rectangle = new Rectangle();
        int n = 0;
        while (domPosition == null && n < this.numChildren) {
            if (this.children[n].isVisible() && this.children[n].getBounds(rectangle).contains(point)) {
                point.translate(-this.children[n].x, -this.children[n].y);
                domPosition = this.children[n].getDomPosition(point);
                point.translate(this.children[n].x, this.children[n].y);
            }
            ++n;
        }
        return domPosition;
    }

    public Shape getDomPositionShape(DiagramComponent diagramComponent, int n) {
        Rectangle rectangle = null;
        if (n == 0) {
            rectangle = diagramComponent.getBounds(null);
        }
        return rectangle;
    }

    public void repaint(int n, int n2, int n3, int n4) {
        if (this.parent != null) {
            this.parent.repaint(this.getX() + n, this.getY() + n2, n3, n4);
        } else {
            this.diagram.scaledRepaint(this.getX() + n, this.getY() + n2, n3, n4);
        }
    }

    public void repaint() {
        if (this.visible) {
            this.repaint(0, 0, this.width, this.height);
        }
    }

    public void destroy() {
        int n = 0;
        while (n < this.numChildren) {
            this.children[n].destroy();
            this.children[n] = null;
            ++n;
        }
        this.numChildren = 0;
    }
}

