/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.MouseInputAdapter;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.gui.swing.dnd.DefaultDragGestureRecognizer;
import oracle.bali.xml.gui.swing.dnd.DragGestureIdentifier;
import oracle.bali.xml.gui.swing.dnd.ModelDragHandler;
import oracle.bali.xml.model.Selection;
import oracle.javatools.util.PlatformUtils;
import oracle.jdevimpl.xml.schema.XmlSchemaDesignGui;
import oracle.jdevimpl.xml.schema.diagram.AttributeDeclaration;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.DiagramSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.DiagramSelectionManager;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import oracle.jdevimpl.xml.schema.diagram.MouseAware;
import oracle.jdevimpl.xml.schema.diagram.ReferenceSubtree;
import oracle.jdevimpl.xml.schema.diagram.SchemaToolTip;
import oracle.jdevimpl.xml.schema.diagram.Subtree;
import oracle.jdevimpl.xml.schema.diagram.TopLevelComponent;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DiagramGlassPane
extends JPanel {
    private Diagram diagram;
    private boolean valid;
    private boolean supported;
    private MultiLineLabel error;
    private int mode;
    public static final int MODE_NORMAL = 0;
    public static final int MODE_GRAB = 1;
    public static final int MODE_GRABBING = 2;
    public static final int MODE_ZOOM_IN = 3;
    public static final int MODE_ZOOM_OUT = 4;
    private static Cursor GRAB_CURSOR;
    private static Cursor GRABBING_CURSOR;
    private static Cursor ZOOM_IN_CURSOR;
    private static Cursor ZOOM_OUT_CURSOR;
    private Point grabStart;

    static {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getBestCursorSize(32, 32);
        if (dimension.getWidth() == 0.0 && dimension.getHeight() == 0.0) {
            GRABBING_CURSOR = GRAB_CURSOR = Cursor.getPredefinedCursor(12);
            ZOOM_OUT_CURSOR = ZOOM_IN_CURSOR = Cursor.getDefaultCursor();
        } else {
            URL uRL = DiagramGlassPane.class.getResource("/oracle/jdevimpl/xml/schema/resource/images/grab.gif");
            URL uRL2 = DiagramGlassPane.class.getResource("/oracle/jdevimpl/xml/schema/resource/images/grabbing.gif");
            URL uRL3 = DiagramGlassPane.class.getResource("/oracle/jdevimpl/xml/schema/resource/images/zoomin.gif");
            URL uRL4 = DiagramGlassPane.class.getResource("/oracle/jdevimpl/xml/schema/resource/images/zoomout.gif");
            GRAB_CURSOR = uRL != null ? toolkit.createCustomCursor(toolkit.createImage(uRL), new Point(0, 0), "jdev.grab") : Cursor.getPredefinedCursor(12);
            GRABBING_CURSOR = uRL2 != null ? toolkit.createCustomCursor(toolkit.createImage(uRL2), new Point(0, 0), "jdev.grabbing") : GRAB_CURSOR;
            ZOOM_IN_CURSOR = uRL3 != null ? toolkit.createCustomCursor(toolkit.createImage(uRL3), new Point(0, 0), "jdev.zoomin") : Cursor.getDefaultCursor();
            ZOOM_OUT_CURSOR = uRL4 != null ? toolkit.createCustomCursor(toolkit.createImage(uRL4), new Point(0, 0), "jdev.zoomout") : ZOOM_IN_CURSOR;
        }
    }

    public DiagramGlassPane() {
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setLayout(null);
        this.setFocusCycleRoot(true);
        this.addKeyListener(new DiagramKeyHandler(null));
        DragIdentifier dragIdentifier = new DragIdentifier(null);
        dragIdentifier.setDelegatee(new DiagramMouseHandler(null));
        dragIdentifier.registerListeners(this);
        this.addFocusListener(new 1());
    }

    public void dispose() {
        this.removeAll();
        if (this.getActionMap() != null) {
            this.getActionMap().clear();
        }
    }

    public void setMode(int n) {
        if (this.mode != n) {
            this.mode = n;
            switch (n) {
                case 0: {
                    this.setCursor(Cursor.getDefaultCursor());
                    break;
                }
                case 1: {
                    this.setCursor(GRAB_CURSOR);
                    break;
                }
                case 2: {
                    this.setCursor(GRABBING_CURSOR);
                    break;
                }
                case 3: {
                    this.setCursor(ZOOM_IN_CURSOR);
                    break;
                }
                case 4: {
                    this.setCursor(ZOOM_OUT_CURSOR);
                }
            }
        }
    }

    public void setValid(boolean bl) {
        this.valid = bl;
        this.updateError();
    }

    public void setSupported(boolean bl) {
        this.supported = bl;
        this.updateError();
    }

    public void layout() {
        if (this.error != null) {
            Dimension dimension = this.error.getPreferredSize();
            Rectangle rectangle = this.getVisibleRect();
            this.error.setBounds(Math.max(0, (int)(rectangle.getWidth() - dimension.getWidth()) / 2), Math.max(0, (int)(rectangle.getHeight() - dimension.getHeight()) / 2), (int)dimension.getWidth(), (int)dimension.getHeight());
        }
    }

    private void updateError() {
        if (!this.supported) {
            this.setError(XmlSchemaArb.getString(56));
        } else if (!this.valid) {
            this.setError(XmlSchemaArb.getString(28));
        } else {
            this.setError(null);
        }
    }

    private void setError(String string) {
        if (string != null) {
            this.error = new MultiLineLabel();
            this.error.setText(string);
            this.error.setOpaque(true);
            this.error.setForeground(GraphicsUtils.ERROR_FOREGROUND);
            this.error.setBackground(GraphicsUtils.ERROR_BACKGROUND);
            this.error.setTextWrapper(WordWrapper.getTextWrapper());
            this.error.setPreferredColumns(60);
            this.error.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK, 1), BorderFactory.createEmptyBorder(3, 5, 3, 5)));
            this.error.setVisible(this.hasFocus());
            this.add((Component)this.error);
        } else if (this.error != null) {
            this.remove((Component)this.error);
            this.error = null;
        }
        this.repaint();
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (!this.valid || !this.supported) {
            Color color = new Color(255, 255, 255, 150);
            Color color2 = graphics.getColor();
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(color2);
            if (this.error != null && this.error.isVisible()) {
                GraphicsUtils.drawDropShadow(graphics, this.error.getBounds());
            }
        } else if (this.diagram != null) {
            Selection selection = this.diagram.getGui().getView().getSelection();
            selection.acquireModelReadLock();
            try {
                List list;
                DomPosition domPosition = selection.getDropLocation();
                if (domPosition != null && (list = this.diagram.getDiagramComponentsForNode(domPosition.getTargetNode())) != null) {
                    Iterator iterator = list.iterator();
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    graphics2D.translate(this.diagram.getX(), this.diagram.getY());
                    AffineTransform affineTransform = graphics2D.getTransform();
                    graphics2D.scale(this.diagram.getZoomFactor(), this.diagram.getZoomFactor());
                    Rectangle rectangle = new Rectangle();
                    while (iterator.hasNext()) {
                        Shape shape;
                        DiagramComponent diagramComponent;
                        DiagramSchemaComponent diagramSchemaComponent = (DiagramSchemaComponent)iterator.next();
                        if (!this.isVisible(diagramSchemaComponent) || (diagramComponent = diagramSchemaComponent.getParent()) == null || (shape = diagramComponent.getDomPositionShape(diagramSchemaComponent, domPosition.getRelativePosition())) == null) continue;
                        AffineTransform affineTransform2 = graphics2D.getTransform();
                        while (diagramComponent != null) {
                            graphics2D.translate(diagramComponent.getX(), diagramComponent.getY());
                            diagramComponent = diagramComponent.getParent();
                        }
                        Stroke stroke = graphics2D.getStroke();
                        graphics2D.setStroke(new BasicStroke(2.0f));
                        graphics2D.setXORMode(Color.GRAY);
                        graphics2D.draw(shape);
                        graphics2D.setXORMode(Color.BLACK);
                        graphics2D.setStroke(stroke);
                        graphics2D.setTransform(affineTransform2);
                    }
                    graphics2D.setTransform(affineTransform);
                    graphics2D.translate(-this.diagram.getX(), -this.diagram.getY());
                }
            }
            finally {
                selection.releaseModelReadLock();
            }
        }
    }

    private boolean isVisible(DiagramComponent diagramComponent) {
        boolean bl = diagramComponent.isVisible();
        DiagramComponent diagramComponent2 = diagramComponent.getParent();
        while (bl && diagramComponent2 != null) {
            bl = diagramComponent2.isVisible();
            diagramComponent2 = diagramComponent2.getParent();
        }
        return bl;
    }

    private Rectangle getBounds(DiagramComponent diagramComponent, Rectangle rectangle) {
        rectangle = diagramComponent.getBounds(rectangle);
        DiagramComponent diagramComponent2 = diagramComponent.getParent();
        while (diagramComponent2 != null) {
            rectangle.x += diagramComponent2.getX();
            rectangle.y += diagramComponent2.getY();
            diagramComponent2 = diagramComponent2.getParent();
        }
        return rectangle;
    }

    private Subtree getSubtree(DiagramComponent diagramComponent) {
        DiagramComponent diagramComponent2 = diagramComponent.getParent();
        while (diagramComponent2 != null && !(diagramComponent2 instanceof Subtree)) {
            diagramComponent2 = diagramComponent2.getParent();
        }
        return (Subtree)diagramComponent2;
    }

    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
        this.setValid(diagram.getView().getBaseModel().isDocumentValid());
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        if (!this.valid || !this.supported) {
            return null;
        }
        mouseEvent.translatePoint(-this.diagram.getX(), -this.diagram.getY());
        DiagramSchemaComponent diagramSchemaComponent = this.diagram.getSchemaComponentAt(mouseEvent.getPoint());
        if (diagramSchemaComponent != null) {
            this.diagram.getView().acquireReadLock();
            try {
                StringBuffer stringBuffer = new StringBuffer();
                String string = ModelUtils.getAnnotation(this.diagram.getGui().getView().getTreeTraversal(), diagramSchemaComponent.getDomElement());
                String string2 = ModelUtils.getName(diagramSchemaComponent.getDomElement());
                if (string2 == null) {
                    string2 = ModelUtils.getAttribute(diagramSchemaComponent.getDomElement(), "ref");
                }
                if (string2 == null) {
                    string2 = diagramSchemaComponent.getDomElement().getLocalName();
                }
                if (string2 != null) {
                    stringBuffer.append("%%%");
                    stringBuffer.append(string2);
                    stringBuffer.append("%%%");
                }
                if (string != null) {
                    stringBuffer.append(string);
                }
                String string3 = stringBuffer.length() > 0 ? stringBuffer.toString() : null;
                this.diagram.getView().releaseReadLock();
                return string3;
            }
            catch (Throwable throwable) {
                this.diagram.getView().releaseReadLock();
                throw throwable;
            }
        }
        mouseEvent.translatePoint(this.diagram.getX(), this.diagram.getY());
        return null;
    }

    public JToolTip createToolTip() {
        return new SchemaToolTip();
    }

    static MultiLineLabel ra$error(DiagramGlassPane diagramGlassPane) {
        return diagramGlassPane.error;
    }

    static boolean ra$valid(DiagramGlassPane diagramGlassPane) {
        return diagramGlassPane.valid;
    }

    static boolean ra$supported(DiagramGlassPane diagramGlassPane) {
        return diagramGlassPane.supported;
    }

    static Diagram ra$diagram(DiagramGlassPane diagramGlassPane) {
        return diagramGlassPane.diagram;
    }

    static int ra$mode(DiagramGlassPane diagramGlassPane) {
        return diagramGlassPane.mode;
    }

    static Point ra$grabStart(DiagramGlassPane diagramGlassPane) {
        return diagramGlassPane.grabStart;
    }

    static void wa$grabStart(DiagramGlassPane diagramGlassPane, Point point) {
        diagramGlassPane.grabStart = point;
    }

    static Subtree mav$getSubtree(DiagramGlassPane diagramGlassPane, DiagramComponent diagramComponent) {
        return diagramGlassPane.getSubtree(diagramComponent);
    }

    public final class 1
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            if (DiagramGlassPane.ra$error(DiagramGlassPane.this) != null) {
                DiagramGlassPane.ra$error(DiagramGlassPane.this).setVisible(true);
                DiagramGlassPane.this.repaint();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            if (DiagramGlassPane.ra$error(DiagramGlassPane.this) != null) {
                DiagramGlassPane.ra$error(DiagramGlassPane.this).setVisible(false);
                DiagramGlassPane.this.repaint();
            }
        }
    }

    private class DragIdentifier
    extends DragGestureIdentifier {
        protected boolean isDragPossible(MouseEvent mouseEvent) {
            if (DiagramGlassPane.ra$valid(DiagramGlassPane.this) && DiagramGlassPane.ra$supported(DiagramGlassPane.this) && DiagramGlassPane.ra$mode(DiagramGlassPane.this) == 0 && DiagramGlassPane.ra$diagram(DiagramGlassPane.this) != null) {
                mouseEvent.translatePoint(-DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getX(), -DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getY());
                DiagramSchemaComponent diagramSchemaComponent = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSchemaComponentAt(mouseEvent.getPoint());
                mouseEvent.translatePoint(DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getX(), DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getY());
                if (diagramSchemaComponent != null) {
                    if (diagramSchemaComponent instanceof AttributeDeclaration && ((AttributeDeclaration)diagramSchemaComponent).isInherited()) {
                        return false;
                    }
                    Element element = diagramSchemaComponent.getDomElement();
                    Selection selection = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getGui().getView().getSelection();
                    selection.acquireModelReadLock();
                    try {
                        boolean bl = selection.contains((Node)element);
                        selection.releaseModelReadLock();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        selection.releaseModelReadLock();
                        throw throwable;
                    }
                }
            }
            return false;
        }

        protected void startDrag(MouseEvent mouseEvent, MouseEvent mouseEvent2) {
            if (DiagramGlassPane.ra$valid(DiagramGlassPane.this) && DiagramGlassPane.ra$supported(DiagramGlassPane.this)) {
                ModelDragHandler modelDragHandler = new ModelDragHandler(DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getGui(), null, null);
                new DefaultDragGestureRecognizer((DragGestureListener)modelDragHandler).requestDragStart((Component)DiagramGlassPane.this, mouseEvent, 3, 2);
            }
        }

        private DragIdentifier() {
        }

        DragIdentifier(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DiagramMouseHandler
    extends MouseInputAdapter {
        private boolean selectedOnPress;

        public void mousePressed(MouseEvent mouseEvent) {
            this.selectedOnPress = false;
            if (!mouseEvent.isConsumed()) {
                DiagramGlassPane.this.requestFocus();
                if (DiagramGlassPane.ra$valid(DiagramGlassPane.this) && DiagramGlassPane.ra$supported(DiagramGlassPane.this) && !this.handlePopup(mouseEvent)) {
                    if (DiagramGlassPane.ra$mode(DiagramGlassPane.this) == 1) {
                        DiagramGlassPane.this.setMode(2);
                        DiagramGlassPane.wa$grabStart(DiagramGlassPane.this, mouseEvent.getPoint());
                        mouseEvent.consume();
                    } else if (DiagramGlassPane.ra$mode(DiagramGlassPane.this) == 0) {
                        this.selectedOnPress = this.handleSelection(mouseEvent);
                        if (!this.selectedOnPress) {
                            DiagramComponent diagramComponent = this.getComponentForEvent(mouseEvent);
                            boolean bl = false;
                            while (!bl && diagramComponent != null) {
                                if (diagramComponent instanceof MouseAware) {
                                    bl = ((MouseAware)((Object)diagramComponent)).mousePressed(mouseEvent);
                                }
                                diagramComponent = diagramComponent.getParent();
                            }
                            if (bl) {
                                mouseEvent.consume();
                            }
                        }
                    }
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!mouseEvent.isConsumed() && DiagramGlassPane.ra$valid(DiagramGlassPane.this) && DiagramGlassPane.ra$supported(DiagramGlassPane.this) && !this.selectedOnPress && DiagramGlassPane.ra$mode(DiagramGlassPane.this) == 0) {
                DiagramComponent diagramComponent = this.getComponentForEvent(mouseEvent);
                boolean bl = false;
                while (!bl && diagramComponent != null) {
                    if (diagramComponent instanceof MouseAware) {
                        bl = ((MouseAware)((Object)diagramComponent)).mouseClicked(mouseEvent);
                    }
                    diagramComponent = diagramComponent.getParent();
                }
                if (bl) {
                    mouseEvent.consume();
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (DiagramGlassPane.ra$valid(DiagramGlassPane.this) && DiagramGlassPane.ra$supported(DiagramGlassPane.this) && !mouseEvent.isConsumed() && !this.handlePopup(mouseEvent)) {
                if (DiagramGlassPane.ra$mode(DiagramGlassPane.this) == 2) {
                    DiagramGlassPane.this.setMode(1);
                    mouseEvent.consume();
                } else if (DiagramGlassPane.ra$mode(DiagramGlassPane.this) == 3) {
                    DiagramGlassPane.ra$diagram(DiagramGlassPane.this).zoomIn(mouseEvent.getPoint());
                    mouseEvent.consume();
                } else if (DiagramGlassPane.ra$mode(DiagramGlassPane.this) == 4) {
                    DiagramGlassPane.ra$diagram(DiagramGlassPane.this).zoomOut(mouseEvent.getPoint());
                    mouseEvent.consume();
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (DiagramGlassPane.ra$valid(DiagramGlassPane.this) && DiagramGlassPane.ra$supported(DiagramGlassPane.this) && !mouseEvent.isConsumed() && DiagramGlassPane.ra$mode(DiagramGlassPane.this) == 2) {
                Point point = mouseEvent.getPoint();
                Rectangle rectangle = DiagramGlassPane.this.getVisibleRect();
                rectangle.x += DiagramGlassPane.ra$grabStart((DiagramGlassPane)DiagramGlassPane.this).x - point.x;
                rectangle.y += DiagramGlassPane.ra$grabStart((DiagramGlassPane)DiagramGlassPane.this).y - point.y;
                DiagramGlassPane.this.scrollRectToVisible(rectangle);
            }
        }

        private boolean handlePopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                mouseEvent.translatePoint(-DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getX(), -DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getY());
                DiagramSchemaComponent diagramSchemaComponent = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSchemaComponentAt(mouseEvent.getPoint());
                mouseEvent.translatePoint(DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getX(), DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getY());
                DiagramSelectionManager diagramSelectionManager = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSelectionManager();
                if (diagramSchemaComponent != null && !diagramSelectionManager.isActive(diagramSchemaComponent) && !diagramSelectionManager.isSelected(diagramSchemaComponent)) {
                    diagramSelectionManager.select(diagramSchemaComponent);
                }
                ((XmlSchemaDesignGui)DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getGui()).showPopupMenu(mouseEvent);
                mouseEvent.consume();
                return true;
            }
            return false;
        }

        private boolean handleSelection(MouseEvent mouseEvent) {
            DiagramSelectionManager diagramSelectionManager = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSelectionManager();
            if (this.isToggleSelectionEvent(mouseEvent)) {
                mouseEvent.translatePoint(-DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getX(), -DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getY());
                DiagramSchemaComponent diagramSchemaComponent = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSchemaComponentAt(mouseEvent.getPoint());
                mouseEvent.translatePoint(DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getX(), DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getY());
                if (diagramSchemaComponent != null) {
                    if (diagramSelectionManager.isSelected(diagramSchemaComponent)) {
                        diagramSelectionManager.remove(diagramSchemaComponent);
                    } else {
                        diagramSelectionManager.add(diagramSchemaComponent);
                    }
                    DiagramGlassPane.ra$diagram(DiagramGlassPane.this).scrollToVisible(diagramSchemaComponent);
                    return true;
                }
            } else if (!this.isExtendSelectionEvent(mouseEvent) && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                List list;
                mouseEvent.translatePoint(-DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getX(), -DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getY());
                DiagramSchemaComponent diagramSchemaComponent = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSchemaComponentAt(mouseEvent.getPoint());
                mouseEvent.translatePoint(DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getX(), DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getY());
                if (diagramSchemaComponent != null && ((list = diagramSelectionManager.getSelectedComponents()).size() != 1 || list.get(0) != diagramSchemaComponent)) {
                    diagramSelectionManager.select(diagramSchemaComponent);
                    DiagramGlassPane.ra$diagram(DiagramGlassPane.this).scrollToVisible(diagramSchemaComponent);
                    return true;
                }
            }
            return false;
        }

        private boolean isToggleSelectionEvent(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return PlatformUtils.isMac() ? mouseEvent.isShiftDown() : mouseEvent.isControlDown();
            }
            return false;
        }

        private boolean isExtendSelectionEvent(MouseEvent mouseEvent) {
            return !PlatformUtils.isMac() && SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.isShiftDown();
        }

        private DiagramComponent getComponentForEvent(MouseEvent mouseEvent) {
            mouseEvent.translatePoint(-DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getX(), -DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getY());
            DiagramComponent diagramComponent = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getDiagramComponentAt(mouseEvent.getPoint());
            mouseEvent.translatePoint(DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getX(), DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getY());
            return diagramComponent;
        }

        private DiagramMouseHandler() {
        }

        DiagramMouseHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }

    private class DiagramKeyHandler
    extends KeyAdapter {
        private boolean isZoomEvent(KeyEvent keyEvent) {
            return PlatformUtils.isMac() ? keyEvent.isShiftDown() : keyEvent.isControlDown();
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (!DiagramGlassPane.ra$valid(DiagramGlassPane.this) || !DiagramGlassPane.ra$supported(DiagramGlassPane.this)) {
                return;
            }
            switch (keyEvent.getKeyCode()) {
                case 32: {
                    if (this.isZoomEvent(keyEvent)) {
                        if (keyEvent.isAltDown()) {
                            DiagramGlassPane.this.setMode(4);
                            keyEvent.consume();
                            break;
                        }
                        DiagramGlassPane.this.setMode(3);
                        keyEvent.consume();
                        break;
                    }
                    if (DiagramGlassPane.ra$mode(DiagramGlassPane.this) == 2 || keyEvent.getModifiers() != 0) break;
                    DiagramGlassPane.this.setMode(1);
                    keyEvent.consume();
                    break;
                }
                case 18: {
                    if (DiagramGlassPane.ra$mode(DiagramGlassPane.this) != 3) break;
                    DiagramGlassPane.this.setMode(4);
                    keyEvent.consume();
                    break;
                }
                case 107: {
                    DiagramComponent diagramComponent;
                    if (keyEvent.isControlDown()) {
                        DiagramGlassPane.ra$diagram(DiagramGlassPane.this).zoomIn(null);
                        keyEvent.consume();
                        break;
                    }
                    if (!keyEvent.isShiftDown()) break;
                    DiagramSchemaComponent diagramSchemaComponent = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSelectionManager().getActiveComponent();
                    if (diagramSchemaComponent != null && (diagramComponent = diagramSchemaComponent.getParent()) instanceof TopLevelComponent) {
                        ((TopLevelComponent)diagramComponent).getTree().setExpanded(true);
                    }
                    keyEvent.consume();
                    break;
                }
                case 109: {
                    DiagramComponent diagramComponent;
                    if (keyEvent.isControlDown()) {
                        DiagramGlassPane.ra$diagram(DiagramGlassPane.this).zoomOut(null);
                        keyEvent.consume();
                        break;
                    }
                    if (!keyEvent.isShiftDown()) break;
                    DiagramSchemaComponent diagramSchemaComponent = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSelectionManager().getActiveComponent();
                    if (diagramSchemaComponent != null && (diagramComponent = diagramSchemaComponent.getParent()) instanceof TopLevelComponent) {
                        ((TopLevelComponent)diagramComponent).getTree().setExpanded(false);
                    }
                    keyEvent.consume();
                    break;
                }
                case 106: {
                    DiagramComponent diagramComponent;
                    if (!keyEvent.isShiftDown()) break;
                    DiagramSchemaComponent diagramSchemaComponent = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSelectionManager().getActiveComponent();
                    if (diagramSchemaComponent != null && (diagramComponent = diagramSchemaComponent.getParent()) instanceof TopLevelComponent) {
                        ((TopLevelComponent)diagramComponent).getTree().expandAll();
                    }
                    keyEvent.consume();
                    break;
                }
                case 39: {
                    DiagramSelectionManager diagramSelectionManager = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSelectionManager();
                    DiagramSchemaComponent diagramSchemaComponent = diagramSelectionManager.getActiveComponent();
                    if (diagramSchemaComponent == null || keyEvent.getModifiers() != 0 && !keyEvent.isControlDown() && !keyEvent.isShiftDown()) break;
                    Subtree subtree = DiagramGlassPane.mav$getSubtree(DiagramGlassPane.this, diagramSchemaComponent);
                    if (subtree != null) {
                        Subtree subtree2 = subtree.getFirstSubtree();
                        while (subtree2 != null && subtree2 instanceof ReferenceSubtree) {
                            subtree2 = subtree2.getFirstSubtree();
                        }
                        if (subtree2 != null) {
                            if (!subtree.isExpanded()) {
                                subtree.setExpanded(true);
                            }
                            HierarchalSchemaComponent hierarchalSchemaComponent = subtree2.getRoot().getComponent();
                            if (keyEvent.isControlDown()) {
                                diagramSelectionManager.activate(hierarchalSchemaComponent);
                            } else if (!keyEvent.isShiftDown()) {
                                diagramSelectionManager.select(hierarchalSchemaComponent);
                            }
                            DiagramGlassPane.ra$diagram(DiagramGlassPane.this).scrollToVisible(subtree2.getRoot());
                        }
                    }
                    keyEvent.consume();
                    break;
                }
                case 37: {
                    DiagramSelectionManager diagramSelectionManager = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSelectionManager();
                    DiagramSchemaComponent diagramSchemaComponent = diagramSelectionManager.getActiveComponent();
                    if (diagramSchemaComponent == null || keyEvent.getModifiers() != 0 && !keyEvent.isControlDown() && !keyEvent.isShiftDown()) break;
                    Subtree subtree = DiagramGlassPane.mav$getSubtree(DiagramGlassPane.this, DiagramGlassPane.mav$getSubtree(DiagramGlassPane.this, diagramSchemaComponent));
                    while (subtree != null && subtree instanceof ReferenceSubtree) {
                        subtree = DiagramGlassPane.mav$getSubtree(DiagramGlassPane.this, subtree);
                    }
                    if (subtree != null) {
                        HierarchalSchemaComponent hierarchalSchemaComponent = subtree.getRoot().getComponent();
                        if (keyEvent.isControlDown()) {
                            diagramSelectionManager.activate(hierarchalSchemaComponent);
                        } else if (!keyEvent.isShiftDown()) {
                            diagramSelectionManager.select(hierarchalSchemaComponent);
                        }
                        DiagramGlassPane.ra$diagram(DiagramGlassPane.this).scrollToVisible(subtree.getRoot());
                    }
                    keyEvent.consume();
                    break;
                }
                case 38: {
                    DiagramSelectionManager diagramSelectionManager = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSelectionManager();
                    DiagramSchemaComponent diagramSchemaComponent = diagramSelectionManager.getActiveComponent();
                    if (diagramSchemaComponent == null || keyEvent.getModifiers() != 0 && !keyEvent.isControlDown() && !keyEvent.isShiftDown()) break;
                    Subtree subtree = DiagramGlassPane.mav$getSubtree(DiagramGlassPane.this, diagramSchemaComponent);
                    Subtree subtree3 = DiagramGlassPane.mav$getSubtree(DiagramGlassPane.this, subtree);
                    if (subtree3 != null) {
                        Subtree subtree4 = subtree3.getPreviousSubtree(subtree);
                        while (subtree4 == null && subtree3 instanceof ReferenceSubtree) {
                            subtree = subtree3;
                            subtree3 = DiagramGlassPane.mav$getSubtree(DiagramGlassPane.this, subtree3);
                            subtree4 = subtree3.getNextSubtree(subtree);
                        }
                        while (subtree4 != null && subtree4 instanceof ReferenceSubtree) {
                            subtree4 = subtree4.getFirstSubtree();
                        }
                        if (subtree4 != null) {
                            if (!subtree3.isExpanded()) {
                                subtree3.setExpanded(true);
                            }
                            HierarchalSchemaComponent hierarchalSchemaComponent = subtree4.getRoot().getComponent();
                            if (keyEvent.isControlDown()) {
                                diagramSelectionManager.activate(hierarchalSchemaComponent);
                            } else if (!keyEvent.isShiftDown()) {
                                diagramSelectionManager.select(hierarchalSchemaComponent);
                            }
                            DiagramGlassPane.ra$diagram(DiagramGlassPane.this).scrollToVisible(subtree4.getRoot());
                        }
                    }
                    keyEvent.consume();
                    break;
                }
                case 40: {
                    DiagramSelectionManager diagramSelectionManager = DiagramGlassPane.ra$diagram(DiagramGlassPane.this).getSelectionManager();
                    DiagramSchemaComponent diagramSchemaComponent = diagramSelectionManager.getActiveComponent();
                    if (diagramSchemaComponent == null || keyEvent.getModifiers() != 0 && !keyEvent.isControlDown() && !keyEvent.isShiftDown()) break;
                    Subtree subtree = DiagramGlassPane.mav$getSubtree(DiagramGlassPane.this, diagramSchemaComponent);
                    Subtree subtree5 = DiagramGlassPane.mav$getSubtree(DiagramGlassPane.this, subtree);
                    if (subtree5 != null) {
                        Subtree subtree6 = subtree5.getNextSubtree(subtree);
                        while (subtree6 == null && subtree5 instanceof ReferenceSubtree) {
                            subtree = subtree5;
                            subtree5 = DiagramGlassPane.mav$getSubtree(DiagramGlassPane.this, subtree5);
                            subtree6 = subtree5.getNextSubtree(subtree);
                        }
                        while (subtree6 != null && subtree6 instanceof ReferenceSubtree) {
                            subtree6 = subtree6.getFirstSubtree();
                        }
                        if (subtree6 != null) {
                            if (!subtree5.isExpanded()) {
                                subtree5.setExpanded(true);
                            }
                            HierarchalSchemaComponent hierarchalSchemaComponent = subtree6.getRoot().getComponent();
                            if (keyEvent.isControlDown()) {
                                diagramSelectionManager.activate(hierarchalSchemaComponent);
                            } else if (!keyEvent.isShiftDown()) {
                                diagramSelectionManager.select(hierarchalSchemaComponent);
                            }
                            DiagramGlassPane.ra$diagram(DiagramGlassPane.this).scrollToVisible(subtree6.getRoot());
                        }
                    }
                    keyEvent.consume();
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (!DiagramGlassPane.ra$valid(DiagramGlassPane.this) || !DiagramGlassPane.ra$supported(DiagramGlassPane.this)) {
                return;
            }
            switch (keyEvent.getKeyCode()) {
                case 32: {
                    if (DiagramGlassPane.ra$mode(DiagramGlassPane.this) == 0) break;
                    DiagramGlassPane.this.setMode(0);
                    keyEvent.consume();
                    break;
                }
                case 18: {
                    if (DiagramGlassPane.ra$mode(DiagramGlassPane.this) != 4) break;
                    DiagramGlassPane.this.setMode(3);
                    keyEvent.consume();
                }
            }
        }

        private DiagramKeyHandler() {
        }

        DiagramKeyHandler(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

