/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.metadata.ImmutableXmlKey;
import oracle.bali.xml.metadata.XmlKey;
import oracle.bali.xml.model.AbstractModel;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlContext;
import oracle.bali.xml.util.DefaultPrefixLookup;
import oracle.bali.xml.util.NamespaceUtils;
import oracle.bali.xml.util.NodeCreator;
import oracle.bali.xml.util.NodeCustomizer;
import oracle.bali.xml.util.XmlModelUtils;
import oracle.ide.controller.IdeAction;
import oracle.jdevimpl.xml.schema.NodeListener;
import oracle.jdevimpl.xml.schema.ProxyNode;
import oracle.jdevimpl.xml.schema.XmlSchemaEditorController;
import oracle.jdevimpl.xml.schema.XmlSchemaLayoutView;
import oracle.jdevimpl.xml.schema.XmlSchemaMetadataResolver;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import oracle.jdevimpl.xml.schema.diagram.MouseAware;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class DiagramSchemaComponent
extends DiagramComponent
implements NodeListener,
MouseAware {
    protected Element element;

    public DiagramSchemaComponent(Diagram diagram, Element element) {
        super(diagram);
        this.element = element;
        diagram.getView().addNodeListener(element, this);
        diagram.add(element, this);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.diagram.getSelectionManager().isActive(this) && this.diagram.isFocused()) {
            this.paintActiveBorder(graphics);
        }
    }

    public Color getForeground() {
        if (this.diagram.getSelectionManager().isSelected(this)) {
            return this.diagram.isFocused() ? GraphicsUtils.SELECTION_FOREGROUND_COLOR : GraphicsUtils.INACTIVE_SELECTION_FOREGROUND_COLOR;
        }
        return super.getForeground();
    }

    public Color getBackground() {
        if (this.diagram.getSelectionManager().isSelected(this)) {
            return this.diagram.isFocused() ? GraphicsUtils.SELECTION_BACKGROUND_COLOR : GraphicsUtils.INACTIVE_SELECTION_BACKGROUND_COLOR;
        }
        return super.getBackground();
    }

    public void paintActiveBorder(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = this.getShape();
        Color color = graphics2D.getColor();
        Stroke stroke = graphics2D.getStroke();
        Stroke stroke2 = this.getStroke();
        if (stroke2 != null) {
            graphics2D.setStroke(stroke2);
        }
        graphics2D.setXORMode(Color.GRAY);
        graphics2D.setColor(Color.BLACK);
        graphics2D.draw(shape);
        if (stroke2 != null) {
            graphics2D.setStroke(stroke);
        }
        graphics2D.setPaintMode();
        graphics2D.setColor(color);
    }

    public Element getDomElement() {
        return this.element;
    }

    public void destroy() {
        super.destroy();
        this.diagram.getView().removeNodeListener(this.element, this);
        this.diagram.remove(this.element, this);
    }

    public void nodeChanged(Node node) {
        this.update();
    }

    public void update() {
    }

    public DomPosition getDomPosition(Point point) {
        DomPosition domPosition = super.getDomPosition(point);
        if (domPosition == null) {
            domPosition = DomPositionFactory.createDomPosition((Node)this.element, (int)0);
        }
        return domPosition;
    }

    public List getActions() {
        if (this.element instanceof ProxyNode) {
            return Collections.EMPTY_LIST;
        }
        return Collections.singletonList(new Integer(XmlSchemaEditorController.EDIT_ANNOTATION_CMD_ID));
    }

    public boolean handleAction(IdeAction ideAction) {
        if (ideAction.getCommandId() == XmlSchemaEditorController.EDIT_ANNOTATION_CMD_ID) {
            boolean bl = false;
            XmlSchemaLayoutView xmlSchemaLayoutView = this.diagram.getView();
            xmlSchemaLayoutView.startTransaction(XmlSchemaArb.getString(30));
            try {
                XmlContext xmlContext = xmlSchemaLayoutView.getContext();
                XmlSchemaMetadataResolver xmlSchemaMetadataResolver = (XmlSchemaMetadataResolver)this.diagram.getView().getXmlMetadataResolver();
                Node node = ModelUtils.getChild(this.element, "annotation");
                if (node == null) {
                    XmlKey xmlKey = ImmutableXmlKey.createElementKey((String)"http://www.w3.org/2001/XMLSchema", (String)"annotation");
                    DomPosition domPosition = ModelUtils.getAnnotationInsertionPosition(this.element);
                    NodeCreator nodeCreator = xmlSchemaMetadataResolver.getCreationWizard(xmlKey);
                    if (nodeCreator != null && (node = nodeCreator.createNode(xmlContext, xmlKey, domPosition, null)) != null) {
                        NamespaceUtils.fixPrefixes((Node)domPosition.getContainerNode(), (Node)node, (DefaultPrefixLookup)this.diagram.getModel().getDefaultPrefixLookup());
                        if (domPosition.isBefore()) {
                            this.element.insertBefore(node, domPosition.getTargetNode());
                        } else {
                            this.element.appendChild(node);
                        }
                        bl = true;
                    }
                } else {
                    XmlKey xmlKey = xmlSchemaMetadataResolver.getNodeXmlKey(node);
                    NodeCustomizer nodeCustomizer = XmlModelUtils.getCustomizerOrDefault((AbstractModel)xmlSchemaLayoutView, (XmlKey)xmlKey, (Node)node);
                    if (nodeCustomizer != null && nodeCustomizer.isNodeCustomizable(xmlContext, node, xmlKey)) {
                        bl = nodeCustomizer.customizeNode(xmlContext, node, xmlKey);
                    }
                }
            }
            catch (RuntimeException runtimeException) {
                xmlSchemaLayoutView.rollbackTransaction();
                throw runtimeException;
            }
            catch (ThreadDeath threadDeath) {
                xmlSchemaLayoutView.rollbackTransaction();
                throw threadDeath;
            }
            catch (Throwable throwable) {
                xmlSchemaLayoutView.rollbackTransaction();
                throw new IllegalStateException("unexpected throwable: " + throwable.getMessage());
            }
            if (bl) {
                try {
                    xmlSchemaLayoutView.commitTransaction();
                }
                catch (XmlCommitException xmlCommitException) {
                    xmlSchemaLayoutView.rollbackTransaction();
                }
            } else {
                xmlSchemaLayoutView.rollbackTransaction();
            }
            return true;
        }
        return false;
    }

    public boolean mouseClicked(MouseEvent mouseEvent) {
        return false;
    }

    public boolean mousePressed(MouseEvent mouseEvent) {
        return false;
    }
}

