/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.model.Selection;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlView;
import oracle.jdevimpl.xml.schema.SelectionListener;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.DiagramSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.Expandable;
import oracle.jdevimpl.xml.schema.diagram.Subtree;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DiagramSelectionManager
implements SelectionListener {
    private Diagram diagram;
    private DiagramSchemaComponent active;
    private LinkedList selected;

    void $init$() {
        this.selected = new LinkedList();
    }

    public DiagramSelectionManager(Diagram diagram) {
        this.$init$();
        this.diagram = diagram;
        diagram.getView().addSelectionListener(this);
    }

    public void dispose() {
        this.diagram.getView().removeSelectionListener(this);
    }

    public DiagramSchemaComponent getActiveComponent() {
        return this.active;
    }

    public List getSelectedComponents() {
        return (List)this.selected.clone();
    }

    public DiagramSchemaComponent getFirstSelectedComponent() {
        return (DiagramSchemaComponent)this.selected.get(0);
    }

    public void selectionChanged() {
        List list = (List)this.selected.clone();
        DiagramSchemaComponent diagramSchemaComponent = this.active;
        this.active = null;
        this.selected.clear();
        Selection selection = this.diagram.getGui().getView().getSelection();
        selection.acquireModelReadLock();
        try {
            DomPosition domPosition = selection.getCursorLocation();
            this.active = domPosition != null && domPosition.isInside() ? this.getComponentForNode(domPosition.getTargetNode()) : null;
            Iterator iterator = selection.getSelectedNodes();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                DiagramSchemaComponent diagramSchemaComponent2 = this.getComponentForNode(node);
                if (diagramSchemaComponent2 == null) continue;
                this.selected.add(diagramSchemaComponent2);
            }
            this.repaint(list);
            if (diagramSchemaComponent != this.active) {
                if (diagramSchemaComponent != null) {
                    diagramSchemaComponent.repaint();
                }
                if (this.active != null) {
                    this.active.repaint();
                }
            }
            for (DiagramSchemaComponent diagramSchemaComponent3 : this.selected) {
                Subtree subtree = this.getSubtree(diagramSchemaComponent3);
                if (subtree != null) {
                    this.expand(subtree);
                }
                diagramSchemaComponent3.repaint();
            }
            if (this.active != null) {
                this.diagram.scrollToVisible(this.active);
            }
        }
        finally {
            selection.releaseModelReadLock();
        }
    }

    public void add(DiagramSchemaComponent diagramSchemaComponent) {
        if (diagramSchemaComponent != null && !this.selected.contains(diagramSchemaComponent)) {
            this.selected.add(diagramSchemaComponent);
            diagramSchemaComponent.repaint();
            XmlView xmlView = this.diagram.getGui().getView();
            Selection selection = xmlView.getSelection();
            xmlView.startTransaction("");
            try {
                Element element = diagramSchemaComponent.getDomElement();
                selection.add((Node)element);
                selection.setCursorLocation(DomPositionFactory.createDomPosition((Node)element, (int)0));
                xmlView.commitTransaction();
            }
            catch (XmlCommitException xmlCommitException) {
                xmlView.rollbackTransaction();
            }
            catch (RuntimeException runtimeException) {
                xmlView.rollbackTransaction();
                throw runtimeException;
            }
            catch (ThreadDeath threadDeath) {
                xmlView.rollbackTransaction();
                throw threadDeath;
            }
            catch (Throwable throwable) {
                xmlView.rollbackTransaction();
            }
        }
    }

    public void remove(DiagramSchemaComponent diagramSchemaComponent) {
        if (diagramSchemaComponent != null && this.selected.remove(diagramSchemaComponent)) {
            diagramSchemaComponent.repaint();
            XmlView xmlView = this.diagram.getGui().getView();
            Selection selection = xmlView.getSelection();
            xmlView.startTransaction("");
            try {
                Element element = diagramSchemaComponent.getDomElement();
                if (this.active == diagramSchemaComponent) {
                    selection.setCursorLocation(null);
                }
                selection.remove((Node)element);
                xmlView.commitTransaction();
            }
            catch (XmlCommitException xmlCommitException) {
                xmlView.rollbackTransaction();
            }
            catch (RuntimeException runtimeException) {
                xmlView.rollbackTransaction();
                throw runtimeException;
            }
            catch (ThreadDeath threadDeath) {
                xmlView.rollbackTransaction();
                throw threadDeath;
            }
            catch (Throwable throwable) {
                xmlView.rollbackTransaction();
            }
        }
    }

    public void select(DiagramSchemaComponent diagramSchemaComponent) {
        List list = (List)this.selected.clone();
        DiagramSchemaComponent diagramSchemaComponent2 = this.active;
        this.selected.clear();
        if (diagramSchemaComponent != null) {
            this.selected.add(diagramSchemaComponent);
        }
        this.active = diagramSchemaComponent;
        if (diagramSchemaComponent2 != null) {
            diagramSchemaComponent2.repaint();
        }
        this.repaint(list);
        if (diagramSchemaComponent != null) {
            diagramSchemaComponent.repaint();
            XmlView xmlView = this.diagram.getGui().getView();
            Selection selection = xmlView.getSelection();
            xmlView.startTransaction("");
            try {
                Element element = diagramSchemaComponent.getDomElement();
                selection.set((Node)element);
                selection.setCursorLocation(DomPositionFactory.createDomPosition((Node)element, (int)0));
                xmlView.commitTransaction();
            }
            catch (XmlCommitException xmlCommitException) {
                xmlView.rollbackTransaction();
            }
            catch (RuntimeException runtimeException) {
                xmlView.rollbackTransaction();
                throw runtimeException;
            }
            catch (ThreadDeath threadDeath) {
                xmlView.rollbackTransaction();
                throw threadDeath;
            }
            catch (Throwable throwable) {
                xmlView.rollbackTransaction();
            }
        }
    }

    public void activate(DiagramSchemaComponent diagramSchemaComponent) {
        DiagramSchemaComponent diagramSchemaComponent2 = this.active;
        this.active = diagramSchemaComponent;
        if (diagramSchemaComponent2 != null) {
            diagramSchemaComponent2.repaint();
        }
        if (diagramSchemaComponent != null) {
            diagramSchemaComponent.repaint();
            XmlView xmlView = this.diagram.getGui().getView();
            Selection selection = xmlView.getSelection();
            xmlView.startTransaction("");
            try {
                Element element = diagramSchemaComponent.getDomElement();
                selection.setCursorLocation(DomPositionFactory.createDomPosition((Node)element, (int)0));
                xmlView.commitTransaction();
            }
            catch (XmlCommitException xmlCommitException) {
                xmlView.rollbackTransaction();
            }
            catch (RuntimeException runtimeException) {
                xmlView.rollbackTransaction();
                throw runtimeException;
            }
            catch (ThreadDeath threadDeath) {
                xmlView.rollbackTransaction();
                throw threadDeath;
            }
            catch (Throwable throwable) {
                xmlView.rollbackTransaction();
            }
        }
    }

    public boolean isActive(DiagramComponent diagramComponent) {
        return diagramComponent == this.active;
    }

    public boolean isSelected(DiagramComponent diagramComponent) {
        for (DiagramSchemaComponent diagramSchemaComponent : this.selected) {
            if (!this.isAncestor(diagramSchemaComponent, diagramComponent)) continue;
            return true;
        }
        return false;
    }

    private boolean isAncestor(DiagramComponent diagramComponent, DiagramComponent diagramComponent2) {
        DiagramComponent diagramComponent3 = diagramComponent2;
        while (diagramComponent3 != null) {
            if (diagramComponent3 == diagramComponent) {
                return true;
            }
            diagramComponent3 = diagramComponent3.getParent();
        }
        return false;
    }

    private void expand(DiagramComponent diagramComponent) {
        DiagramComponent diagramComponent2 = diagramComponent.getParent();
        while (diagramComponent2 != null && diagramComponent2 instanceof Expandable) {
            ((Expandable)((Object)diagramComponent2)).setExpanded(true);
            diagramComponent2 = diagramComponent2.getParent();
        }
    }

    private DiagramSchemaComponent getComponentForNode(Node node) {
        List list = this.diagram.getDiagramComponentsForNode(node);
        if (list != null) {
            return (DiagramSchemaComponent)list.get(0);
        }
        Stack<DiagramComponent> stack = new Stack<DiagramComponent>();
        DiagramSchemaComponent diagramSchemaComponent = this.diagram.getRootComponent();
        if (diagramSchemaComponent != null) {
            stack.push(diagramSchemaComponent);
        }
        while (!stack.isEmpty()) {
            DiagramSchemaComponent diagramSchemaComponent2;
            DiagramComponent diagramComponent = (DiagramComponent)stack.pop();
            if (diagramComponent instanceof DiagramSchemaComponent && (diagramSchemaComponent2 = (DiagramSchemaComponent)diagramComponent).getDomElement().equals(node)) {
                return diagramSchemaComponent2;
            }
            int n = diagramComponent.getChildCount() - 1;
            while (n >= 0) {
                stack.push(diagramComponent.getChild(n));
                --n;
            }
        }
        return null;
    }

    private Subtree getSubtree(DiagramComponent diagramComponent) {
        DiagramComponent diagramComponent2 = diagramComponent.getParent();
        while (diagramComponent2 != null) {
            if (diagramComponent2 instanceof Subtree) {
                return (Subtree)diagramComponent2;
            }
            diagramComponent2 = diagramComponent2.getParent();
        }
        return null;
    }

    private void repaint(List list) {
        for (DiagramSchemaComponent diagramSchemaComponent : list) {
            diagramSchemaComponent.repaint();
        }
    }
}

