/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.DiagramGlassPane;
import oracle.jdevimpl.xml.schema.diagram.DiagramPanel;
import oracle.jdevimpl.xml.schema.diagram.DiagramSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.MouseAware;
import oracle.jdevimpl.xml.schema.diagram.TextComponent;

public class EditableTextComponent
extends TextComponent
implements MouseAware {
    private ArrayList listeners;
    protected EditorListener listener;
    protected JComponent editor;

    void $init$() {
        this.listener = new EditorListener(null);
    }

    public EditableTextComponent(Diagram diagram) {
        super(diagram);
        this.$init$();
    }

    public void addTextListener(TextListener textListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(textListener);
    }

    public void removeTextListener(TextListener textListener) {
        if (this.listeners != null) {
            this.listeners.remove(textListener);
        }
    }

    public boolean mouseClicked(MouseEvent mouseEvent) {
        return false;
    }

    public boolean mousePressed(MouseEvent mouseEvent) {
        if (!mouseEvent.isShiftDown() && !mouseEvent.isControlDown() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
            DiagramSchemaComponent diagramSchemaComponent = this.diagram.getSelectionManager().getActiveComponent();
            if (this.diagram.isFocused() && this.isAncestor(diagramSchemaComponent)) {
                this.startEditing();
                return true;
            }
        }
        return false;
    }

    protected void startEditing() {
        DiagramGlassPane diagramGlassPane = this.getGlassPane();
        if (diagramGlassPane != null) {
            this.editor = this.createEditor();
            float f = this.diagram.getZoomFactor();
            AffineTransform affineTransform = AffineTransform.getScaleInstance(f, f);
            this.editor.setFont(this.getFont().deriveFont(affineTransform));
            diagramGlassPane.add(this.editor);
            this.editor.setBounds(this.getEditorBounds());
            this.editor.revalidate();
            this.diagram.setFocused(true);
            this.focusEditor();
        }
    }

    protected JComponent createEditor() {
        JTextField jTextField = new JTextField(this.text);
        jTextField.setBorder(BorderFactory.createEmptyBorder(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right));
        jTextField.addActionListener(this.listener);
        jTextField.addFocusListener(this.listener);
        jTextField.addKeyListener(this.listener);
        jTextField.setBackground(this.getBackground());
        jTextField.setForeground(this.getForeground());
        return jTextField;
    }

    protected void destroyEditor(JComponent jComponent) {
        ((JTextField)jComponent).removeActionListener(this.listener);
        jComponent.removeFocusListener(this.listener);
        jComponent.removeKeyListener(this.listener);
    }

    protected String getEditorValue() {
        return ((JTextField)this.editor).getText();
    }

    protected void focusEditor() {
        this.editor.requestFocus();
    }

    protected void stopEditing() {
        if (this.editor != null) {
            this.destroyEditor(this.editor);
            this.text = this.getEditorValue();
            this.invalidate();
            this.diagram.revalidate();
            DiagramGlassPane diagramGlassPane = this.getGlassPane();
            diagramGlassPane.remove(this.editor);
            diagramGlassPane.repaint();
            this.editor = null;
            this.fireTextChanged();
        }
    }

    protected void cancelEditing() {
        if (this.editor != null) {
            this.destroyEditor(this.editor);
            DiagramGlassPane diagramGlassPane = this.getGlassPane();
            diagramGlassPane.remove(this.editor);
            diagramGlassPane.repaint();
            this.editor = null;
        }
    }

    protected Rectangle getEditorBounds() {
        Rectangle rectangle = this.getBounds(null);
        DiagramComponent diagramComponent = this.getParent();
        while (diagramComponent != null) {
            rectangle.x += diagramComponent.getX();
            rectangle.y += diagramComponent.getY();
            diagramComponent = diagramComponent.getParent();
        }
        float f = this.diagram.getZoomFactor();
        rectangle.x = (int)((float)rectangle.x * f);
        rectangle.y = (int)((float)rectangle.y * f);
        rectangle.width = (int)((float)rectangle.width * f);
        rectangle.height = (int)((float)rectangle.height * f);
        rectangle.x += this.diagram.getX();
        rectangle.y += this.diagram.getY();
        return rectangle;
    }

    protected void fireTextChanged() {
        if (this.listeners != null) {
            for (TextListener textListener : (List)this.listeners.clone()) {
                textListener.textValueChanged(new TextEvent(this, 900));
            }
        }
    }

    protected DiagramGlassPane getGlassPane() {
        DiagramGlassPane diagramGlassPane = null;
        Container container = this.diagram.getParent();
        if (container instanceof DiagramPanel) {
            diagramGlassPane = ((DiagramPanel)container).getGlassPane();
        }
        return diagramGlassPane;
    }

    private boolean isAncestor(DiagramComponent diagramComponent) {
        DiagramComponent diagramComponent2 = this.getParent();
        while (diagramComponent2 != null && !(diagramComponent2 instanceof DiagramSchemaComponent)) {
            diagramComponent2 = diagramComponent2.getParent();
        }
        return diagramComponent2 != null && diagramComponent2 == diagramComponent;
    }

    private class EditorListener
    implements KeyListener,
    FocusListener,
    ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            EditableTextComponent.this.stopEditing();
            if (EditableTextComponent.this.editor == null) {
                EditableTextComponent.this.getGlassPane().requestFocus();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            DiagramGlassPane diagramGlassPane = EditableTextComponent.this.getGlassPane();
            if (diagramGlassPane == null) {
                if (EditableTextComponent.this.editor != null) {
                    EditableTextComponent.this.destroyEditor(EditableTextComponent.this.editor);
                }
            } else {
                EditableTextComponent.this.stopEditing();
                if (EditableTextComponent.this.editor == null && !diagramGlassPane.isAncestorOf(focusEvent.getOppositeComponent())) {
                    EditableTextComponent.this.diagram.setFocused(false);
                }
            }
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                EditableTextComponent.this.cancelEditing();
                EditableTextComponent.this.getGlassPane().requestFocus();
                keyEvent.consume();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        private EditorListener() {
        }

        EditorListener(1 var2_2) {
            this();
        }

        public final class 1 {
        }
    }
}

