/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.bali.xml.model.XmlCommitException;
import oracle.bali.xml.model.XmlModel;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdevimpl.xml.schema.ProxyElement;
import oracle.jdevimpl.xml.schema.ProxyNode;
import oracle.jdevimpl.xml.schema.ReferenceNode;
import oracle.jdevimpl.xml.schema.XmlSchemaEditorController;
import oracle.jdevimpl.xml.schema.XmlSchemaModel;
import oracle.jdevimpl.xml.schema.diagram.AttrEditor;
import oracle.jdevimpl.xml.schema.diagram.AttributeContainer;
import oracle.jdevimpl.xml.schema.diagram.BitmapComponent;
import oracle.jdevimpl.xml.schema.diagram.DerivationEditor;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.EditableTextComponent;
import oracle.jdevimpl.xml.schema.diagram.FacetContainer;
import oracle.jdevimpl.xml.schema.diagram.GraphicsUtils;
import oracle.jdevimpl.xml.schema.diagram.HierarchalSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.ImageComponent;
import oracle.jdevimpl.xml.schema.diagram.ListChangeListener;
import oracle.jdevimpl.xml.schema.diagram.ListComponent;
import oracle.jdevimpl.xml.schema.diagram.ModelUtils;
import oracle.jdevimpl.xml.schema.diagram.TypeEditor;
import oracle.jdevimpl.xml.schema.resource.XmlSchemaArb;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ElementDeclaration
extends HierarchalSchemaComponent
implements ListChangeListener {
    private EditableTextComponent name;
    private DerivationEditor derivation;
    private AttributeContainer attributes;
    private FacetContainer facets;
    private ImageComponent image;
    private TypeEditor type;
    private Element referee;
    private static final int MINIMUM_WIDTH = 60;
    private static final int MAXIMUM_WIDTH = 300;
    private static final Color COLOR = new Color(51, 102, 153);

    public ElementDeclaration(Diagram diagram, Element element) {
        super(diagram, element);
        this.setBackground(COLOR);
        this.setForeground(Color.WHITE);
        this.derivation = new DerivationEditor(diagram, 7);
        this.derivation.addListChangeListener(this);
        this.derivation.setInsets(new Insets(0, 5, 2, 5));
        this.add(this.derivation);
        this.attributes = new AttributeContainer(diagram, element);
        this.add(this.attributes);
        this.facets = new FacetContainer(diagram, element);
        this.facets.setForeground(Color.BLACK);
        this.add(this.facets);
        this.type = new TypeEditor(diagram, 4);
        this.type.setInsets(new Insets(0, 0, 2, 5));
        this.type.addListChangeListener(this);
        this.add(this.type);
        this.update();
    }

    public void destroy() {
        super.destroy();
        this.type.removeListChangeListener(this);
        if (this.name != null && this.name instanceof TypeEditor) {
            ((TypeEditor)this.name).removeListChangeListener(this);
            this.derivation.removeListChangeListener(this);
        }
    }

    public int getPreferredWidth() {
        int n = 0;
        if (this.name != null) {
            n = this.name.getPreferredWidth();
        }
        n = this.image != null ? (n += this.image.getPreferredWidth()) : (n += 5);
        n = Math.max(n, this.derivation.getPreferredWidth() + this.type.getPreferredWidth());
        n = Math.max(n, this.attributes.getPreferredWidth());
        n = Math.max(n, this.facets.getPreferredWidth());
        n += this.insets.left + this.insets.right;
        n = Math.max(n, 60);
        n = Math.min(n, 300);
        return n;
    }

    public int getPreferredHeight() {
        int n;
        int n2;
        int n3 = this.attributes.getPreferredHeight();
        int n4 = this.facets.getPreferredHeight();
        int n5 = n2 = this.name != null ? this.name.getPreferredHeight() : 0;
        if (this.image != null) {
            n2 = Math.max(n2, this.image.getPreferredHeight());
        }
        if ((n = this.type.getPreferredHeight()) == 0) {
            n = 2;
        }
        int n6 = this.derivation.getPreferredHeight();
        return n2 + n3 + n4 + Math.max(n, n6) + this.insets.top + this.insets.bottom + (n3 > 0 || n4 > 0 ? 1 : 0);
    }

    public void layout() {
        int n;
        int n2;
        int n3 = n2 = this.width - this.insets.left - this.insets.right;
        if (this.image != null) {
            this.image.setBounds(this.insets.left + n2 - this.image.getPreferredWidth(), this.insets.top, this.image.getPreferredWidth(), Math.max(this.image.getPreferredHeight(), this.name.getPreferredHeight()));
            n3 -= this.image.getWidth();
        } else {
            n3 -= 5;
        }
        int n4 = this.insets.top;
        if (this.name != null) {
            this.name.setBounds(this.insets.left, this.insets.top, n3, this.name.getPreferredHeight());
        }
        int n5 = n = this.name != null ? this.name.getHeight() : 0;
        if (this.image != null) {
            n = Math.max(n, this.image.getHeight());
        }
        this.derivation.setBounds(this.insets.left, n4 += n, this.derivation.getPreferredWidth(), this.derivation.getPreferredHeight());
        this.type.setBounds(this.insets.left + this.derivation.getWidth(), n4, n2 - this.derivation.getWidth(), this.type.getPreferredHeight());
        int n6 = Math.max(this.type.getHeight(), this.derivation.getHeight());
        n4 += n6 > 0 ? n6 : 2;
        this.attributes.setBounds(this.insets.left, ++n4, n2, this.attributes.getPreferredHeight());
        this.facets.setBounds(this.insets.left, n4 += this.attributes.getHeight(), n2, this.facets.getPreferredHeight());
    }

    public Shape getShape() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        int[] nArray = new int[]{1, n - 2, n - 1, n - 1, n - 2, 1, 0, 0, 1};
        int[] nArray2 = new int[]{0, 0, 1, n2 - 2, n2 - 1, n2 - 1, n2 - 2, 1, 0};
        return new Polygon(nArray, nArray2, nArray.length);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.attributes.getHeight() > 0 || this.facets.getHeight() > 0) {
            int n = this.insets.top + this.type.getHeight();
            n = this.image != null ? (n += Math.max(this.name.getHeight(), this.image.getHeight())) : (n += this.name.getHeight());
            if (this.type.getHeight() == 0) {
                n += 2;
            }
            graphics.drawLine(this.insets.left, n, this.width - 1, n);
        }
    }

    public void update() {
        super.update();
        if (this.name != null) {
            if (this.name instanceof TypeEditor) {
                ((TypeEditor)this.name).removeListChangeListener(this);
            }
            this.remove(this.name);
            this.name = null;
        }
        if (this.image != null) {
            this.remove(this.image);
            this.image = null;
        }
        this.referee = null;
        this.diagram.getView().acquireReadLock();
        try {
            Element element;
            Attr attr;
            TreeTraversal treeTraversal = this.diagram.getView().getTreeTraversal();
            Node node = treeTraversal.getFirstChild((Node)this.element);
            if (node instanceof ReferenceNode) {
                ReferenceNode referenceNode = (ReferenceNode)((Object)node);
                int n = referenceNode.getReference().getReferenceType();
                this.derivation.setValueFromReferenceType(n);
                if (n == 1) {
                    this.name = new TypeEditor(this.diagram, 1);
                    ((TypeEditor)this.name).addListChangeListener(this);
                    ((TypeEditor)this.name).setReference(referenceNode);
                    this.name.setInsets(new Insets(3, 5, 0, 0));
                    this.name.setFont(GraphicsUtils.getDiagramFont().deriveFont(1));
                    this.add(this.name);
                    this.image = new BitmapComponent(this.diagram, XmlSchemaArb.getInstance(), 17);
                    this.image.setInsets(new Insets(2, 3, 0, 5));
                    this.add(this.image);
                    this.referee = (Element)referenceNode.getReferee();
                    referenceNode = null;
                    if (this.referee != null && (node = treeTraversal.getFirstChild((Node)this.referee)) instanceof ReferenceNode) {
                        referenceNode = (ReferenceNode)((Object)node);
                        n = referenceNode.getReference().getReferenceType();
                    }
                }
                this.type.setReference(referenceNode);
                if (referenceNode != null) {
                    n = referenceNode.getReference().getReferenceType();
                    this.derivation.setValueFromReferenceType(n);
                } else {
                    this.derivation.setValue(0);
                }
            } else {
                this.derivation.setValue(0);
                this.type.setReference(null);
            }
            if (this.name == null && (attr = this.element.getAttributeNodeNS(null, "name")) != null) {
                this.name = new AttrEditor(this.diagram, attr);
                this.name.setInsets(new Insets(3, 5, 0, 5));
                this.name.setFont(GraphicsUtils.getDiagramFont().deriveFont(1));
                this.add(this.name);
            }
            Element element2 = element = this.referee != null ? this.referee : this.element;
            if (element instanceof ProxyElement && ((ProxyElement)element).isExternal()) {
                this.derivation.setEditable(false);
            } else {
                this.derivation.setEditable(true);
            }
        }
        finally {
            this.diagram.getView().releaseReadLock();
        }
    }

    public List getActions() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(3);
        arrayList.addAll(super.getActions());
        this.diagram.getView().acquireReadLock();
        try {
            if (!(this.element instanceof ProxyElement) || !((ProxyElement)this.element).isExternal()) {
                TreeTraversal treeTraversal;
                Node node;
                if (!ModelUtils.isGlobal(this.element)) {
                    arrayList.add(new Integer(XmlSchemaEditorController.TOGGLE_REFERENCE_CMD_ID));
                }
                if (!((node = (treeTraversal = this.diagram.getView().getTreeTraversal()).getFirstChild((Node)this.element)) instanceof ReferenceNode) && ModelUtils.getAnonymousType(this.element) == null) {
                    arrayList.add(new Integer(XmlSchemaEditorController.SET_TYPE_CMD_ID));
                }
            }
            ArrayList<Integer> arrayList2 = arrayList;
            this.diagram.getView().releaseReadLock();
            return arrayList2;
        }
        catch (Throwable throwable) {
            this.diagram.getView().releaseReadLock();
            throw throwable;
        }
    }

    public boolean handleAction(IdeAction ideAction) {
        int n = ideAction.getCommandId();
        if (n == XmlSchemaEditorController.TOGGLE_REFERENCE_CMD_ID) {
            this.toggleReference();
            return true;
        }
        if (n == XmlSchemaEditorController.SET_TYPE_CMD_ID) {
            this.setType();
            return true;
        }
        return super.handleAction(ideAction);
    }

    public void valueChanged(ListComponent listComponent) {
        if (listComponent == this.type) {
            this.handleTypeChange();
        } else if (listComponent == this.name) {
            this.handleNameChange();
        } else if (listComponent == this.derivation) {
            this.handleDerivationChange();
        }
    }

    private void handleTypeChange() {
        this.diagram.getModel().startTransaction(XmlSchemaArb.getString(11));
        try {
            if (this.type.getText() == null || this.type.getText().trim().length() == 0) {
                this.removeType();
            } else {
                this.changeType();
            }
            this.diagram.getModel().commitTransaction();
        }
        catch (XmlCommitException xmlCommitException) {
            this.diagram.getModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xmlCommitException));
        }
        catch (ThreadDeath threadDeath) {
            this.diagram.getModel().rollbackTransaction();
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.diagram.getModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable);
        }
    }

    private void handleNameChange() {
        String string = this.name.getText().trim();
        this.diagram.getModel().startTransaction(XmlSchemaArb.getString(10));
        try {
            Attr attr = ((TypeEditor)this.name).getAttr();
            attr.setValue(this.name.getText());
            this.diagram.getModel().commitTransaction();
        }
        catch (XmlCommitException xmlCommitException) {
            this.diagram.getModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xmlCommitException));
        }
        catch (ThreadDeath threadDeath) {
            this.diagram.getModel().rollbackTransaction();
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.diagram.getModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable);
        }
    }

    private void handleDerivationChange() {
        this.diagram.getModel().startTransaction(XmlSchemaArb.getString(13));
        try {
            this.changeType();
            this.diagram.getModel().commitTransaction();
        }
        catch (XmlCommitException xmlCommitException) {
            this.diagram.getModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xmlCommitException));
        }
        catch (ThreadDeath threadDeath) {
            this.diagram.getModel().rollbackTransaction();
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.diagram.getModel().rollbackTransaction();
            ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable);
        }
    }

    private void removeType() {
        Attr attr = this.type.getAttr();
        Element element = attr.getOwnerElement();
        if (element != null) {
            this.diagram.getModel().startTransaction(XmlSchemaArb.getString(11));
            try {
                Element element2;
                element.removeAttributeNode(attr);
                Element element3 = element2 = this.referee != null ? this.referee : this.element;
                if (element != element2) {
                    ModelUtils.removePath(element2, element);
                }
                this.diagram.getModel().commitTransaction();
            }
            catch (XmlCommitException xmlCommitException) {
                this.diagram.getModel().rollbackTransaction();
                ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)((Object)xmlCommitException));
            }
            catch (ThreadDeath threadDeath) {
                this.diagram.getModel().rollbackTransaction();
                throw threadDeath;
            }
            catch (Throwable throwable) {
                this.diagram.getModel().rollbackTransaction();
                ExceptionDialog.showExceptionDialog((Component)Ide.getMainWindow(), (Throwable)throwable);
            }
        } else {
            this.type.setAttr(null);
        }
    }

    private void changeType() {
        XmlSchemaModel xmlSchemaModel = this.diagram.getModel();
        int n = this.derivation.getValue();
        String string = this.type.getText();
        Element element = this.referee != null ? this.referee : this.element;
        ModelUtils.removeContent(element);
        if (n == 1 || n == 0) {
            element.setAttributeNS(null, "type", string);
        } else if (n == 2) {
            ModelUtils.createAnonymousComplexTypeWithExtension(xmlSchemaModel, element, string);
        } else if (n == 4) {
            if (ModelUtils.isSimpleType(xmlSchemaModel, element, string)) {
                ModelUtils.createAnonymousSimpleType(xmlSchemaModel, element, string);
            } else {
                ModelUtils.createAnonymousComplexTypeWithRestriction(xmlSchemaModel, element, string);
            }
        }
    }

    private void toggleReference() {
        Node node = this.element;
        if (node instanceof ProxyNode) {
            node = ((ProxyNode)node).getReferee();
        }
        XmlModel xmlModel = this.diagram.getGui().getView().getBaseModel();
        xmlModel.startTransaction(XmlSchemaArb.getString(19));
        try {
            ModelUtils.toggleReference(node);
            xmlModel.commitTransaction();
        }
        catch (ThreadDeath threadDeath) {
            this.diagram.getModel().rollbackTransaction();
            throw threadDeath;
        }
        catch (Throwable throwable) {
            this.diagram.getModel().rollbackTransaction();
        }
    }

    private void setType() {
        this.diagram.getView().acquireReadLock();
        try {
            Attr attr = this.diagram.getView().getDocument().createAttributeNS(null, "type");
            this.type.setAttr(attr);
            this.type.startEditing();
        }
        finally {
            this.diagram.getView().releaseReadLock();
        }
    }
}

