/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.Expandable;
import oracle.jdevimpl.xml.schema.diagram.MouseAware;

public class Expander
extends DiagramComponent
implements MouseAware {
    private Expandable expandable;

    public Expander(Diagram diagram) {
        this(diagram, null);
        this.setShowBorder(true);
    }

    public Expander(Diagram diagram, Expandable expandable) {
        super(diagram);
        this.setShowBorder(true);
        this.setExpandable(expandable);
    }

    public void setExpandable(Expandable expandable) {
        this.expandable = expandable;
    }

    public int getPreferredWidth() {
        return 11;
    }

    public int getPreferredHeight() {
        return 11;
    }

    public Color getBackground() {
        return Color.WHITE;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        int n = this.getWidth();
        int n2 = this.getHeight();
        Color color = graphics.getColor();
        graphics.setColor(Color.BLACK);
        graphics.drawLine(2, n2 / 2, n - 3, n2 / 2);
        if (!this.expandable.isExpanded()) {
            graphics.drawLine(n / 2, 2, n / 2, n2 - 3);
        }
        graphics.setColor(color);
    }

    public Shape getShape() {
        int[] nArray = new int[]{1, this.width - 2, this.width - 1, this.width - 1, this.width - 2, 1, 0, 0, 1};
        int[] nArray2 = new int[]{0, 0, 1, this.height - 2, this.height - 1, this.height - 1, this.height - 2, 1, 0};
        return new Polygon(nArray, nArray2, nArray.length);
    }

    public boolean mouseClicked(MouseEvent mouseEvent) {
        return false;
    }

    public boolean mousePressed(MouseEvent mouseEvent) {
        if (this.expandable != null) {
            this.expandable.setExpanded(this.expandable.isExpanded() ^ true);
            this.repaint();
            return true;
        }
        return false;
    }
}

