/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import oracle.jdevimpl.xml.schema.diagram.AttrEditor;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.FacetContainer;
import oracle.jdevimpl.xml.schema.diagram.TextComponent;
import org.w3c.dom.Element;

public class Facet
extends DiagramSchemaComponent {
    private Diagram diagram;
    private TextComponent label;
    private AttrEditor value;

    public Facet(Diagram diagram, Element element) {
        super(diagram, element);
        this.diagram = diagram;
        this.setBackground(Color.WHITE);
        this.label = new TextComponent(diagram);
        this.label.setText(element.getLocalName());
        this.label.setInsets(new Insets(1, 5, 1, 3));
        this.add(this.label);
        this.value = new AttrEditor(diagram);
        this.value.setInsets(new Insets(1, 3, 1, 5));
        this.add(this.value);
        this.update();
    }

    public TextComponent getLabel() {
        return this.label;
    }

    public void update() {
        this.value.setAttr(this.element.getAttributeNodeNS(null, "value"));
    }

    public int getPreferredWidth() {
        return this.insets.left + this.insets.right + ((FacetContainer)this.parent).getLabelWidth() + this.value.getPreferredWidth() + 1;
    }

    public int getPreferredHeight() {
        return this.insets.top + this.insets.bottom + Math.max(this.label.getPreferredHeight(), this.value.getPreferredHeight());
    }

    public void layout() {
        int n = this.width - this.insets.left - this.insets.right;
        int n2 = ((FacetContainer)this.parent).getLabelWidth();
        this.label.setBounds(this.insets.left, this.insets.top, n2, this.height);
        this.value.setBounds(this.insets.left + n2 + 1, this.insets.top, n - n2 - 1, this.height);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Color color = graphics.getColor();
        graphics.setColor(Color.BLACK);
        int n = this.insets.left + this.label.getWidth();
        graphics.drawLine(n, 0, n, this.height - 1);
        graphics.setColor(color);
    }
}

