/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Line2D;
import oracle.bali.xml.dom.position.DomPosition;
import oracle.bali.xml.dom.position.DomPositionFactory;
import oracle.bali.xml.dom.traversal.TreeTraversal;
import oracle.jdevimpl.xml.schema.NodeListener;
import oracle.jdevimpl.xml.schema.XmlSchemaMetadataResolver;
import oracle.jdevimpl.xml.schema.diagram.Diagram;
import oracle.jdevimpl.xml.schema.diagram.DiagramComponent;
import oracle.jdevimpl.xml.schema.diagram.DiagramSchemaComponent;
import oracle.jdevimpl.xml.schema.diagram.Facet;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FacetContainer
extends DiagramComponent
implements NodeListener {
    private Element element;
    private Node parentNode;
    private int labelWidth;

    void $init$() {
        this.labelWidth = -1;
    }

    public FacetContainer(Diagram diagram, Element element) {
        super(diagram);
        this.$init$();
        this.element = element;
        diagram.getView().acquireReadLock();
        try {
            XmlSchemaMetadataResolver xmlSchemaMetadataResolver = (XmlSchemaMetadataResolver)diagram.getView().getXmlMetadataResolver();
            int n = xmlSchemaMetadataResolver.getSchemaRole(element);
            if (n == 15 || n == 21) {
                this.parentNode = diagram.getView().getTreeTraversal().getParentNode((Node)element);
                diagram.getView().addNodeListener(this.parentNode, this);
            } else {
                diagram.getView().addNodeListener(element, this);
            }
        }
        finally {
            diagram.getView().releaseReadLock();
        }
        this.update();
    }

    public void nodeChanged(Node node) {
        this.update();
    }

    public void invalidate() {
        super.invalidate();
        this.labelWidth = -1;
    }

    public void update() {
        this.destroyAll();
        if (this.element != null) {
            this.diagram.getView().acquireReadLock();
            try {
                TreeTraversal treeTraversal = this.diagram.getView().getTreeTraversal();
                XmlSchemaMetadataResolver xmlSchemaMetadataResolver = (XmlSchemaMetadataResolver)this.diagram.getView().getXmlMetadataResolver();
                Node node = this.parentNode != null ? treeTraversal.getFirstChild(this.parentNode) : treeTraversal.getFirstChild((Node)this.element);
                while (node != null) {
                    DiagramSchemaComponent diagramSchemaComponent;
                    int n = xmlSchemaMetadataResolver.getSchemaRole(node);
                    if (this.parentNode == null) {
                        if (n == 15) break;
                        if (n == 21) {
                            break;
                        }
                    }
                    if (n == 11 && (diagramSchemaComponent = this.createFacetComponent(node)) != null) {
                        this.add(diagramSchemaComponent);
                    }
                    node = treeTraversal.getNextSibling(node);
                }
            }
            finally {
                this.diagram.getView().releaseReadLock();
            }
        }
    }

    public void destroy() {
        if (this.parentNode != null) {
            this.diagram.getView().removeNodeListener(this.parentNode, this);
        } else {
            this.diagram.getView().removeNodeListener(this.element, this);
        }
        this.element = null;
        super.destroy();
    }

    public int getPreferredWidth() {
        if (this.numChildren > 0) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.numChildren) {
                n = Math.max(n, this.children[n2].getPreferredWidth());
                ++n2;
            }
            return n + this.insets.left + this.insets.right;
        }
        return 0;
    }

    public int getPreferredHeight() {
        if (this.numChildren > 0) {
            int n = this.insets.top + this.insets.bottom;
            if (this.children != null) {
                int n2 = 0;
                while (n2 < this.numChildren) {
                    n += this.children[n2].getPreferredHeight();
                    if (n2 < this.numChildren - 1) {
                        ++n;
                    }
                    ++n2;
                }
            }
            return n;
        }
        return 0;
    }

    public void layout() {
        if (this.children != null) {
            int n = this.insets.top;
            int n2 = 0;
            while (n2 < this.numChildren) {
                this.children[n2].setBounds(this.insets.left, n, this.width - this.insets.left - this.insets.right, this.children[n2].getPreferredHeight());
                n += this.children[n2].getHeight() + 1;
                ++n2;
            }
        }
    }

    public DomPosition getDomPosition(Point point) {
        DomPosition domPosition = null;
        Rectangle rectangle = new Rectangle();
        int n = 0;
        while (domPosition == null && n < this.numChildren) {
            rectangle = this.children[n].getBounds(rectangle);
            if (point.getY() < rectangle.getY() + rectangle.getHeight() / 2.0) {
                domPosition = DomPositionFactory.createDomPosition((Node)((DiagramSchemaComponent)this.children[n]).getDomElement(), (int)1);
            } else if (point.getY() < rectangle.getY() + rectangle.getHeight()) {
                domPosition = DomPositionFactory.createDomPosition((Node)((DiagramSchemaComponent)this.children[n]).getDomElement(), (int)2);
            }
            ++n;
        }
        return domPosition;
    }

    public Shape getDomPositionShape(DiagramComponent diagramComponent, int n) {
        Shape shape = null;
        if (n == 1) {
            Rectangle rectangle = diagramComponent.getBounds(null);
            return new Line2D.Double(rectangle.getX(), rectangle.getY(), rectangle.getX() + rectangle.getWidth(), rectangle.getY());
        }
        if (n == 2) {
            Rectangle rectangle = diagramComponent.getBounds(null);
            return new Line2D.Double(rectangle.getX(), rectangle.getY() + rectangle.getHeight(), rectangle.getX() + rectangle.getWidth(), rectangle.getY() + rectangle.getHeight());
        }
        shape = super.getDomPositionShape(diagramComponent, n);
        return shape;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Color color = graphics.getColor();
        graphics.setColor(Color.BLACK);
        int n = 0;
        while (n < this.numChildren - 1) {
            int n2 = this.children[n].getY() + this.children[n].getHeight();
            graphics.drawLine(this.insets.left, n2, this.width - this.insets.right, n2);
            ++n;
        }
        graphics.setColor(color);
    }

    public int getLabelWidth() {
        if (this.labelWidth == -1) {
            this.computeLabelWidth();
        }
        return this.labelWidth;
    }

    private void computeLabelWidth() {
        this.labelWidth = 0;
        int n = 0;
        while (n < this.numChildren) {
            Facet facet = (Facet)this.children[n];
            this.labelWidth = Math.max(facet.getLabel().getPreferredWidth(), this.labelWidth);
            ++n;
        }
    }

    private DiagramSchemaComponent createFacetComponent(Node node) {
        return new Facet(this.diagram, (Element)node);
    }

    private void destroyAll() {
        int n = 0;
        while (n < this.numChildren) {
            Element element = ((DiagramSchemaComponent)this.children[n]).getDomElement();
            this.children[n].setParent(null);
            this.children[n].destroy();
            ++n;
        }
        this.numChildren = 0;
    }
}

