/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.xml.schema.diagram;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.Stroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class GraphicsUtils {
    public static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    public static final Insets SINGLE_INSETS = new Insets(1, 1, 1, 1);
    public static final Color DIAGRAM_BACKGROUND_COLOR = Color.WHITE;
    public static final Color REFERENCE_COLOR = new Color(250, 250, 215);
    public static final Color REFERENCE_COLOR_DARK = new Color(204, 204, 153);
    public static final Color EXTERNAL_REFERENCE_COLOR = new Color(204, 204, 153);
    public static final Color EXTERNAL_REFERENCE_COLOR_DARK = new Color(179, 179, 102);
    public static final Color SELECTION_FOREGROUND_COLOR = Color.BLACK;
    public static final Color SELECTION_BACKGROUND_COLOR = new Color(-6697729);
    public static final Color SELECTION_BORDER_COLOR = Color.BLACK;
    public static final Color INACTIVE_SELECTION_FOREGROUND_COLOR = SELECTION_FOREGROUND_COLOR;
    public static final Color INACTIVE_SELECTION_BACKGROUND_COLOR = SELECTION_BACKGROUND_COLOR;
    public static final Color COMPONENT_COLOR = Color.WHITE;
    public static final Color SHADOW_COLOR = new Color(100, 100, 100, 100);
    public static final Color ANNOTATION_COLOR = Color.GRAY;
    public static final Color UNRESOLVED_REFERENCE_COLOR = Color.RED;
    public static final Color ERROR_FOREGROUND = Color.BLACK;
    public static final Color ERROR_BACKGROUND = REFERENCE_COLOR;
    public static final Color CARDINALITY_COLOR = Color.BLACK;
    public static final int SHADOW_OFFSET = 5;
    public static final int STACK_OFFSET = 3;
    private static Stroke optionalStroke;
    private static Font diagramFont;
    private static Font cardinalityFont;

    private GraphicsUtils() {
    }

    public static Font getDiagramFont() {
        UIDefaults uIDefaults;
        if (diagramFont == null && (diagramFont = (uIDefaults = UIManager.getLookAndFeelDefaults()).getFont("Panel.font")) == null) {
            diagramFont = new Font("Dialog", 0, 12);
        }
        return diagramFont;
    }

    public static Font getCardinalityFont() {
        if (cardinalityFont == null) {
            cardinalityFont = new Font("Dialog", 0, 10);
        }
        return cardinalityFont;
    }

    public static Stroke getOptionalStroke() {
        if (optionalStroke == null) {
            optionalStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{3.0f, 3.0f}, 0.0f);
        }
        return optionalStroke;
    }

    public static void drawDropShadow(Graphics graphics, Shape shape) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Color color = graphics2D.getColor();
        graphics2D.translate(5, 5);
        int n = 0;
        while (n < 3) {
            graphics2D.setColor(new Color(170, 170, 170, 30 + n * 30));
            graphics2D.fill(shape);
            graphics2D.translate(-1, -1);
            ++n;
        }
        graphics2D.translate(-2, -2);
        graphics2D.setColor(color);
    }
}

